#include "mazetext.inc"
#include "textures.inc"
#include "colors.inc"
#include "stones.inc"

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.5
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       0.1
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.1
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  2
  }
}

light_source {
   <0, 100, -50>, rgb <1, 1, 0.95>
}

camera {
   perspective
   location <5, 9, 5>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <2, 0, 0>
   up <0, 1, 0>
   look_at <10, 6, 10.1>
}


background { color <0.000,0.000,0.000> }

fog {
  fog_type 2    // Ground Fog
  distance     120.0
  //color <0.917647,0.917647,0.94902,0.0,0.0>
  color <0.717647,0.717647,0.74902,0.0,0.0>
  turbulence   <1.0,1.0,1.0>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 0.0
  up           <0,1,0>
  fog_offset   0.0
  fog_alt      10.0
}

sphere { // Sky
  <0,0,0>,1
  material {
    Bright_Sky_2
    rotate <90,0,0>
    scale 0.4
  }
  no_shadow
  hollow
  scale 10000.0
}


union {

  #include "maze.inc"

  material {
    texture { T_Grnt25 }
    scale 0.1
  }
 
}


height_field {
  
  tga "output.tga"
  smooth
  
  texture {
    pigment {
      granite
      color_map {
	[0 rgb <0.2,0.2,0.2> ]
	[0.4 rgb <0.3,0.2,0.2> ]
	[1.0 rgb <0.1,0.1,0.1> ]
      }
      turbulence 1.0
    }
  normal {
    dents 0.2
  }
  scale 0.002
  }

  texture {
    pigment {
      granite
      color_map {
	[0 rgbf <0.0,0.0,0.0,1.0> ]
	[0.7 rgbf <0.3,0.2,0.2,0.9> ]
	[1.0 rgbf <0.2,0.7,0.4> ]
      }
      turbulence 1.4
     }
    scale 0.009
  }

  scale <128.0,5.0,128.0>
 
}


#include "forest.inc"
