#include "colors.inc"
#include "ColossusTex.inc" 
#include "functions.inc"    
#include "Steer1_pov.inc"
#include "Steer2_pov.inc"      
#include "RopeLeaner_pov.inc"  
#include "Soldier.inc"


#macro LumpyBox(X1, Y1, Z1, X2, Y2, Z2)  
  #if ( definition > 0 )
    #declare m = 10;
    #declare s = 0.025;                 
    #declare r = 0.05;
    #declare X = X2-X1;
    #declare Y = Y2-Y1;
    #declare Z = Z2-Z1;
    isosurface {  
        function{   f_rounded_box(x + 2*s*f_noise3d(0, m*y, m*z),y ,z + s*f_noise3d(m*x, 0, m*z), r, X/2, Y/2, Z/2)  }
        max_gradient 4
        contained_by { box {-(X+Y+Z),(X+Y+Z)} }
    }                   
    translate< (X1+X2)/2, (Y1+Y2)/2, (Z1+Z2)/2 > 
  #else
    box{<X1, Y1, Z1><X2, Y2, Z2>} 
  #end
#end


  #declare OarTwist =   20;  


#declare HullLength = 30 * 0.888 / 2; //Half Length mid section
#declare HullWidth  = 1.5;            //Half width mid section          
#declare HullHeight = 1;              //Height of hull above mid section
#declare Shift      = 0.5;            //Cut and shift hull    
#declare SeaLine    = 1.5;            //Drop from midpoint to water-line  
#declare BowHeight  = 2;      
#declare Beam       = 2.25;           //Half full Beam
#declare HullThick  = 0.0625;         //Hull thickness  
#declare Poutrigger = 0.8;            //Proportion outriggers length to hull length 
#declare DeckHeight = 0.5;   

#declare OarWindowWidth = 0.3;
#declare OarWindowHeight = 0.1;
#declare OarWindowFrameWidth = 0.05;

#declare Tier1 = -0.25; 
#declare Tier2 = -0.6;
#declare Tier3 = -0.9;

#declare HullPlusShift = union{

  #declare L = HullLength;
  #declare R = HullWidth + Shift;
  #declare H = HullHeight;       
  #declare B = BowHeight;
  #declare T = HullThick; 
  #declare W = Beam+Shift; 
  #declare P = Poutrigger;

  difference{     
     union{    
       difference{
         union{
           sphere  {<0,0,0>R} 
           sphere  {<0,H,0>R texture{FrameTex} }
           cylinder{<0,0,0><0,H,0>R}
         }
         box{<0,H,-1000><1000,1000,1000>}
       }
       difference{
         cylinder{<0,0,0><0,B,0>R}  
         union{
           box{<-R-1,H,-R-1><0,B+1,R+1>}
           cylinder{<0,-1,0><0,B+1,0>R-T}  
         }  
       }
     }      
     union{
       sphere  {<0,0,0>R-T} 
       cylinder{<0,0,0><0,B,0>R-T} 
       sphere  {<0,H,0>R-T}
     }  
   }
   
   //Now put in the outrigger
   intersection{
     box{<-R*P,-W,-W><R*P,W,W>}
     union{
       cylinder{<0,-T/2,0><0,T/2,0>W scale <.95,1,1> }  
       torus{W,T scale <.95,0.75,1> texture{FrameTex} }
     }
   }
   
   //Extra banding
   difference{
     union{
       torus{ R,HullThick  scale < .97, 0.75, 1> translate (HullHeight/4 - HullThick)*y texture{FrameTex}}
       torus{ R,HullThick  scale < .97, 0.75, 1> translate (3*HullHeight/4  - HullThick)*y texture{FrameTex}}
     }
     box{<-R*P,-W,-W><R*P,W,W>}
   }
       
}
  
  
#declare Hull = union{
  #declare BR = 5;
  #declare FR = 4;
  #declare H = HullHeight;
  
  difference{
    union{              
       intersection{   
         object{HullPlusShift}
         box{<-1000,-R-1,-R-1><1000,R+B+1,-Shift>}
         translate  Shift*z
       }
       intersection{
           object{HullPlusShift}
         box{<-1000,-R-1,Shift><1000,R+B+1,R+1>}
         translate  -Shift*z
       }
      scale<L/Poutrigger/R,1,1>
    }
    union{
      box{<-L,DeckHeight,-R-1><L,1000,R+1>}   
      cylinder{<-L,H+BR,-1000><-L,H+BR,1000>BR texture{FrameTex} }
      cylinder{< L,H+FR,-1000>< L,H+FR,1000>FR}
    }
  }

   #declare H = DeckHeight; 
   
/**********************
 * TOP DECK AND RAIL
 **********************/
    union{              
       intersection{ 
         union{  
            cylinder{<0,H,0><0,H-T,0>R texture{DeckTex}}
            torus{ R,HullThick  scale < .97, 0.75, 1> translate (HullHeight-HullThick)*y texture{FrameTex}}
            torus{ R,HullThick  scale < .97, 0.75, 1> translate (DeckHeight-HullThick)*y texture{FrameTex}}
            torus{ R,HullThick  scale < .97, 0.75, 1> translate -HullThick*y texture{FrameTex} }
         }
         box{<-1000,-R-1,-R-1><1000,R+B+1,-Shift>}
         translate  Shift*z
       }
       intersection{
         union{  
            cylinder{<0,H,0><0,H-T,0>R texture{DeckTex}}
            torus{ R,HullThick  scale < .97, 0.75, 1> translate (HullHeight-HullThick)*y texture{FrameTex}}
            torus{ R,HullThick  scale < .97, 0.75, 1> translate (DeckHeight-HullThick)*y texture{FrameTex}}
            torus{ R,HullThick  scale < .97, 0.75, 1> -HullThick*y texture{FrameTex} }
         }
         box{<-1000,-R-1,Shift><1000,R+B+1,R+1>}
         translate  -Shift*z
       }
      scale<L/Poutrigger/R,1,1>
    } 
      
}

/******************************
 * OAR
 ******************************/

#declare Oar = union{
  
  #declare L =  4;
  #declare R =  0.03;
  #declare BL = 0.25;
  #declare BW = 0.1; 
  #declare BT = 0.0025;
  
  cylinder{<0,0,-.2><0,0,L>R}   
  sphere{ <0,0,0> R scale<1,1,6> translate L*z  } 

  difference{
     cylinder{<-BT,0,0><BT,0,0>BW}
     box{<-100,-100,0><100,100,100>} 
     scale<1,1,10>       
     translate<0,0,L+.6> 
     texture{OarTex rotate 90*y}
  }
  texture{MastTex rotate 90*y} 
}

/***************************
 * OUTRIGGER SUPPORTS
 ***************************/
#declare OutRiggerSupports = union{


  #declare n = 0;
  #declare L = HullLength;    
  #declare R = HullWidth - Shift;   
  
  #declare W = (Beam - HullWidth)*.99;
  #declare H = W*0.4;          
  #declare T = HullThick;
  
  #while  (n < 30)
                   
     #declare X = (n + 0.5) *0.888-L; 
     #declare sX = X/L;
     #declare Y = R*sqrt(1-sX*sX) + Shift;
     
     difference{
        box{<-T,0,0.5><T,-H,-W>}
        cylinder{<-100,0,0><100,0,0>W/3 scale<1,1,2.8> translate<0,-H,-W>} 
        translate<X, 0,-Y> 
     }                      
     
     difference{
        box{<-T,0,0><T,-H,-W>}
        cylinder{<-100,0,0><100,0,0>W/3 scale<1,1,2.8> translate<0,-H,-W>} 
        rotate 180*y
        translate<X, 0, Y> 
     }                                
     #declare n = n + 1;
  #end    
  texture{FrameTex rotate 90*y}
}   
  
  
/*******************************
 * OUTRIGGER ENDS
 *******************************/

#declare OutRiggerEnds = union{
   
   #declare T = HullThick*1.;
   #declare W = Beam - HullWidth + .45;
   #declare H = HullHeight+.05;       
   #declare R = HullWidth;
   #declare L = HullLength;        
   
   #declare End = difference{
       box{<-T,0,0><T,H,-W>}
       cylinder{<-100,H,-W><100,H,-W>W*.8}  
       texture{FrameTex rotate 90*y}
   }
   
   #declare X = L; 
   #declare sX = X/L;      
   #declare Y = R*sqrt(1-sX*sX) + Shift;
   
   object{End  translate<-L,-0.05,-.6> }
   object{End  translate< L,-0.05,-.6> }
   
   object{End  rotate 180*y translate<-L,-0.05,0.6> }
   object{End  rotate 180*y translate< L,-0.05,0.6> }
   
   texture{FrameTex} 
} 
 
/*******************************
 * RAIL SUPPORTS
 *******************************/

#declare RailSupports = union{


  #declare n = 1;
  #declare L = HullLength;    
  #declare R = HullWidth - Shift;     
  #declare H = HullHeight-HullThick;          
 
  #declare bX = .025;
  #declare bY = .04; 
  #while  (n < 30)
                   
     #declare X = n *0.888-L; 
     #declare sX = X/L;
     #declare Y = R*sqrt(1-sX*sX) + Shift;
     
        box{<-bX,0,-bY><bX,H,bY> 
        translate<X, 0,-Y>       }
     
        box{<-bX,0,-bY><bX,H,bY> 
        translate<X, 0, Y>       }
     #declare n = n + 1;
  #end    
  texture{FrameTex rotate 90*y}
}   

/*****************************
 *  OARS
 *****************************/
#macro Oars(OarDrop, OarSweep)

union{


  #declare n = 1;
  #declare L = HullLength;    
  #declare R = HullWidth - Shift;
  
  #while  (n < 30)
                   
     #declare X = n*0.888-L; 
     #declare sX = X/L;
     #declare Y = R*sqrt(1-sX*sX) + Shift;
     
     object{Oar rotate 180*x
                rotate -OarTwist*z 
                rotate -OarDrop*x 
                rotate -OarSweep*y 
                translate<X, Tier1 - 0.03,-Y> 
            }                      
     
     object{Oar rotate OarTwist*z 
                rotate OarDrop*x 
                rotate OarSweep*y 
                translate<X, Tier1 - 0.03, Y> 
           }                                
     #declare n = n + 1;       
  #end       
      
      
     #declare X = 30*0.888-L; 
     #declare sX = X/L;
     #declare Y = R*sqrt(1-sX*sX) + Shift;
     
     object{Oar rotate 180*x
                rotate -OarTwist*z 
                rotate -OarDrop*x 
                rotate -OarSweep*y 
                translate<X-0.0, Tier1 + 0.09,-Y> 
            }                      
     
     object{Oar rotate OarTwist*z 
                rotate OarDrop*x 
                rotate OarSweep*y 
                translate<X-0.0, Tier1 + 0.09, Y> 
           } 
                                          
     #declare X = -L; 
     #declare sX = X/L;
     #declare Y = R*sqrt(1-sX*sX) + Shift;
     
     object{Oar rotate 180*x
                rotate -OarTwist*z 
                rotate -OarDrop*x 
                rotate -OarSweep*y 
                translate<X-0.0, Tier1 + 0.09,-Y> 
            }                      
     
     object{Oar rotate OarTwist*z 
                rotate OarDrop*x 
                rotate OarSweep*y 
                translate<X-0.0, Tier1 + 0.09, Y> 
           }                                

   
  #declare n = 0;
  #while  (n < 27)
  
     #declare X = n * 0.888 - L + 2.5 * 0.888;
     #declare sX = X/L;
     #declare Y = R*sqrt(1-sX*sX) + Shift;
     
     object{Oar translate -.75*z
                rotate 180*x
                rotate -OarTwist*z 
                rotate -(OarDrop-1)*x 
                rotate -OarSweep*y 
                translate<X, Tier2-0.1,-Y> 
            }                      
     
     object{Oar translate -.75*z
                rotate OarTwist*z 
                rotate (OarDrop-1)*x 
                rotate OarSweep*y 
                translate<X, Tier2-0.1,Y> 
            }                                
     #declare n = n + 1;
  #end  
  
  #declare n = 0;
  #while  (n < 27)
                
     #declare X = n * 0.888 - L + 2 * 0.888;
     #declare sX = X/L;
     #declare Y = R*sqrt(1-sX*sX) + Shift;

     object{Oar translate -1.5*z
                rotate 180*x
                rotate -OarTwist*z 
                rotate -(OarDrop-2.5)*x 
                rotate -OarSweep*y 
                translate<X, Tier3-0.2,-Y> 
            }                      
     
     object{Oar translate -1.5*z
                rotate OarTwist*z 
                rotate (OarDrop-2.5)*x 
                rotate OarSweep*y 
                translate<X, Tier3-0.2, Y> 
            }                                
     #declare n = n + 1;
  #end  

}

#end

#macro OarsWindowStencil(W,H)  
union{
 
  #declare n = 0;
  #declare L = HullLength;    
  #declare R = HullWidth;
  
  #while  (n < 31)
     #declare X = n*0.888-L; 
     box{<X-W/2, Tier1-H/2, -1000><X+W/2, Tier1+H/2, 1000>}
     #declare n = n + 1;
  #end 
   
  #declare n = 0;
  #while  (n < 27)
     #declare X = n * 0.888 - L + 2.5 * 0.888;
     box{<X-W/2, Tier2-H/2, -1000><X+W/2, Tier2+H/2, 1000>}
     #declare n = n + 1;
  #end  
  
  #declare n = 0;
  #while  (n < 27)
     #declare X = n * 0.888 - L + 2 * 0.888;
     box{<X-W/2, Tier3-H/2, -1000><X+W/2, Tier3+H/2, 1000>}
     #declare n = n + 1;
  #end  
}
#end

#macro WindowStencil(W,H)  
union{
 
  #declare n = 0;
  #declare L = HullLength;    
  #declare R = HullWidth; 
  #declare Y = DeckHeight/2;
  
  #while  (n < 30)
     #declare X = (n+0.5)*0.888-L; 
     box{<X-W/2, Y-H/2, -1000><X+W/2, Y+H/2, 1000>}
     #declare n = n + 1;
  #end 
}
#end

#declare HullBlankerHalf = difference{
  
  #declare L = HullLength;
  #declare R = HullWidth + Shift;
  #declare H = HullHeight;         
  #declare T = 0.025;
  
  union{
    sphere{<0,0,0>R+T}
    cylinder{<0,0,0><0,H,0>R+T}
  }
  union{
    sphere{<0,0,0>R}
    cylinder{<0,0,0><0,1000,0>R}
  }
}  
     

#declare HullBlanker = union{


  #declare L = HullLength;
  #declare R = HullWidth + Shift;
  #declare H = HullHeight;       
  
  intersection{
    object{HullBlankerHalf}
    box{<-1000,-1000,-1000><1000,1000,-Shift>}
    translate  Shift*z
  }
  
  intersection{
    object{HullBlankerHalf}
    box{<-1000,-1000,Shift><1000,1000,1000>}
    translate  -Shift*z
  } 
  
  scale<L/Poutrigger/R,1,1>
    
}

/***************************
 * STERN
 ***************************/
 
#declare Stern = union{

  #declare SternThick = 0.1;
  #declare H = DeckHeight;  
  #declare M = 2;
  
  difference{
    
     #declare w = 1.9;
     #declare s = 3.;
     
     union{
       cylinder{<0,0,-SternThick><0,0,SternThick>w }
       torus{ w, SternThick rotate 90*x} 
       translate<w + SternThick,0,0>
       scale<s,1,1>    
     }
           
     #declare l = 0.5;
     union{
       box{<-10,1.5,-10><10,10,10>} 
       box{<l,-10,-10><100,100,10>} 
       
     }
  }
  
  union{
    difference{
    
      union{
        cylinder{<0,0,-SternThick/4><0,0,SternThick/4> 2 } 
        torus{2,    SternThick rotate 90*x }
        translate 2*x
      }
    
      union{
       
         cylinder{<0,0,-10><0,0,10> 1.25 scale <1.25,1,1> translate 2*x}
         box{<2,-10,-10><10,10,10>}
         box{<-10,-10,-10><10,0,10>}
         cylinder{<0,0,-10><0,0,10>0.1 scale <M,1,1> translate<2,1.4375,0>} 
         cylinder{<0,0,-10><0,0,10>0.1 scale <M,1,1> translate<2,1.8125,0>} 
    
      }
    }
    
     difference{
    
      union{
        torus{1.25, SternThick rotate 90*x scale <1.25,1,1> }
        torus{1.625, SternThick rotate 90*x scale <1.1,1,1> }
        translate 2*x
      }
    
      union{
         box{<2,-10,-10><10,10,10>}
         box{<-10,-10,-10><10,0,10>}
    
      }
    } 
    
    sphere{<0,0,0>SternThick scale <M,1,1> translate<2,1.25,0> }
    sphere{<0,0,0>SternThick scale <M,1,1> translate<2,1.625,0>}
    sphere{<0,0,0>SternThick scale <M,1,1> translate<2,2,0>    }
    
    translate 0.1*x
    scale<1,1.25,1>
    texture{FrameTex}
    
  }
  
  
  translate<-SternThick + .0,H+0.01,0>
 
  texture{FrameTex}
}
       

/***************************
 * RAM
 ***************************/
 
#declare Ram = union{

  #declare RamThick = 0.1;    //Half thickness of bow plate 
  
difference{
union{  
  difference{
     box{<-10,0,0><1,.75,-1.5> }
     cylinder{<-20,0,0><2,0,0>1.2 rotate -5*y translate <3.5,0.75,-0.85>}
     scale <1,1.4,0.5>
     translate<.3,0.1, -RamThick+0.01>
  }
  
  difference{
     box{<-10,0,1.5><1,.75,0> }
     cylinder{<-20,0,0><2,0,0>1.2 rotate  5*y translate <3.5,0.75, 0.85>}
     scale <1,1.4,0.5>
     translate<.3,0.1, RamThick-0.01>
  }
}
    cylinder{<0,0,-10><0,0,10> 1.01  scale<5.2,1.11,1> translate<5,1.07,1> }
}    
  
  cylinder{<-20,0,0><2,0,0> .25 translate 0.1*y  }
  sphere{  <0,0,0> .25 scale<4,1,1> translate<2, 0.1,0> texture{RamTex} }
  
  difference{
    box{<-1,-1,-RamThick><1,1.05,RamThick>}
    cylinder{<0,0,-10><0,0,10> 1.01  scale<5.2,1.11,1> translate<5,1.07,1> }
  }
  
  #declare RamHeight = 4.5;
  difference{   
  
 //   box{<-1,-1,-RamThick><-0.25,RamHeight,RamThick> }
    object{LumpyBox(-1.25,-1,-RamThick,-0.2,RamHeight,RamThick) }  
    cylinder{<0,0,-10><0,0,10> .5 scale<1,2.75,1> translate<-1.25,RamHeight,0>}     
    texture{FrameTex rotate 90*z}
  }
  
//  cylinder{<0,0,-RamThick><0,0,RamThick> 0.2  translate<-0.30625,RamHeight,0> }  
  translate <0.1,-SeaLine,0>
  texture{FrameTex}   
  
  
}    

/************************************
 * BLOCK
 ************************************/
 
#macro Block(BlockW,BlockH,BlockL,InsetH)
   
   #declare W = BlockW;
   #declare H = BlockH;
   #declare L = BlockL;
   
   difference{
      union{
        box{<-L/2,0,-W/2><L/2,H,W/2>}
        cylinder{<0,0,-W/2><0,0,W/2>L/2 translate<0,H,0>}
      }
      
      box{<-L,InsetH,-W/4><L,H+L,W/4>}
   }
   
#end

/***********************************
 * MAIN MAST
 ***********************************/
#declare RopeThick = 0.02;

#declare MainMast = union{

   #declare L = 7;
   #declare W1 = 0.1;
   #declare W2 = 0.075;
   #declare BW = 6;
   #declare BH = 6;

                     
   cone{<0,0.3,0>W1<0,L,0>W2}
   
   #declare R = (W1+W2)/2;
   cylinder{<0,0,-BW/2-0.1><0,0,BW/2+0.1> R translate <W1+R,BH,0> } 
   
   sphere{<0,0,0>W2 scale<1,2,1>translate <0,L,0>}
   sphere{<W1+R,BH,BW/2+0.1> R}
   sphere{<W1+R,BH,-BW/2-0.1> R}
   
   //supporting ropes
   cylinder{<W1+R,BH,-1><0,L,0> RopeThick texture{RopeTex}}
   cylinder{<W1+R,BH, 1><0,L,0> RopeThick texture{RopeTex}}

   torus{R, RopeThick rotate 90*x translate <W1+R,BH, BW/2-0.2> texture{RopeTex}}
   torus{R, RopeThick rotate 90*x translate <W1+R,BH,-BW/2+0.2> texture{RopeTex}}
   
   cylinder{<-10,0,0><W1+R,BH, BW/2-0.2> RopeThick texture{RopeTex}}
   cylinder{<-10,0,0><W1+R,BH,-BW/2+0.2> RopeThick texture{RopeTex}}

   torus{R, RopeThick rotate 90*x translate <W1+R,BH,-0.925> texture{RopeTex}}
   torus{R, RopeThick rotate 90*x translate <W1+R,BH, 0.925> texture{RopeTex}}
   
   torus{W2, RopeThick translate 6.5*y texture{RopeTex}}
   torus{W2, RopeThick translate 6.4*y texture{RopeTex}}
   torus{W2, RopeThick translate 6.35*y texture{RopeTex}}
   torus{W2, RopeThick translate 6.3*y texture{RopeTex}}
   torus{W2, RopeThick-0.0025 translate 6.95*y texture{RopeTex}}
   
   
   //Furled sail
#macro LumpySphere(R, n)
  
  #declare s = 0.125;
  #declare m = 10;
  
  #if ( definition > 0 )
    isosurface {  
        function{   f_sphere(x + s*f_noise3d(0, m*(y + n), m*(z + n)),y + s*f_noise3d(m*(x + n),0, m*(z + n)) ,z + 0.01*f_noise3d(m*(x+n), 0, m*(z+n)), R) }
        max_gradient 4
        contained_by { sphere{<0,0,0>2*R} } 
    }                   
  #else
    sphere{<0,0,0>R} 
  #end
#end
   
   union{
     #declare n = 0;
     #while ( n < 6 )
     
       object{LumpySphere(0.2, n) scale<1,1,3> translate <0.2,5.85,-2.45+n> }
     
       #declare n=n+1;
     #end
     texture{SailTex}
   } 
   
   #declare n = 0;
   #while (n < 7)
      torus{R, RopeThick*0.7 rotate 90*x translate <W1+R,BH,-BW/2+n*1> texture{RopeTex}}
      torus{R+.025, RopeThick*0.7 rotate 90*x scale <1,1.05,1> translate <W1+R+.05,5.8,-BW/2+n*1> texture{RopeTex}}
      #declare n = n+1;
   #end
/**********************************
 * ROPES
 **********************************/
 
#macro RopeMast(X, Z)

cylinder{ <X,0,Z><0,6.5,0>RopeThick texture{RopeTex} }

#end

  
  #declare X = 1.4;
  RopeMast(-1,-X)
  RopeMast(-2,-X)
  RopeMast(-3,-X)
  RopeMast(-1,X)
  RopeMast(-2,X)
  RopeMast(-3,X)
  RopeMast(10,0) 
  

   
   object{Block(0.5,0.5,0.25,.2) }
   
   translate <0, DeckHeight, 0>
   
   
   texture{MastTex}
}

/*********************************
 * STEERING OARS
 *********************************/
 
#declare SteeringOars = union{

  #declare L = HullLength;

//(BlockW,BlockH,BlockL,InsetH)
//  object{ Block(.4,.4,.2,.3) translate<-13,0,1.3>} 
//  object{ Block(.4,.4,.2,.3) translate<-13,0,-1.3>} 
  
  #declare R = 0.03;
  #declare L = 6;
  
  #declare SteerOar = union{
     cylinder{<-L/2,0,0><L/2,0,0>R}
     sphere{<L/2,0,0>R}
     sphere{<0,0,0>R scale<3,1,1>translate<-L/2,0,0>}
     sphere{<0,0,0>0.5 scale<12,1,0.1> translate<-8,0,0>}
  }
  
  object{SteerOar translate<-0,0,0>rotate 30*z  translate<-14,0.3, .8>}
  object{SteerOar translate<-0,0,0>rotate 30*z  translate<-14,0.3,-.8>}
                                                                    
  texture{OarTex}
}   
 
           
#macro Boat(OarDrop, OarSweep)  

union{        

  
  //Add Hull

#if (definition > 0)
  difference{
     union{
#end     
       object{Hull texture{HullTex} }  

#if (definition > 0)

       /********************
        * OARS WINDOWS
        ********************/
       intersection{
         object{OarsWindowStencil(OarWindowWidth + OarWindowFrameWidth, OarWindowHeight + OarWindowFrameWidth)} 
         object{HullBlanker}
         texture{FrameTex}
       }
     }
     union{
       object{WindowStencil(0.6,0.3)}
       object{OarsWindowStencil(OarWindowWidth, OarWindowHeight)}    
     }
  }
  
  
  //Add Oars
  object{Oars(OarDrop, OarSweep)} 

  //Outrigger supports
  object{OutRiggerSupports}
  object{OutRiggerEnds}
  object{RailSupports}    

#end    
  
  #declare L = HullLength;


  //Add Ram mast and stern
  object{Ram translate<L+3,0,0>}   
  object{MainMast translate<3,0,0>}
  object{Stern translate<-L-3,0,0>}    
  
  object{SteeringOars} 
  
  //Add crew   
  object{Steer1 scale 1.8 translate<-12.32,1.16, 0.85>}
  object{Steer2 scale 1.8 translate<-12.27,1.16,-0.355>}   
  
  object{RopeLeaner scale 1.7 translate<1.95,1.14,-0.47>}

  object{Centurian  rotate -90*y scale 1.8 rotate 0*y translate <7.25, 1.16, 0.5>}
  object{Centurian2 rotate -90*y scale 1.8 rotate 0*y translate <8.25, 1.13,-0.5>}
    
  translate<0,SeaLine,0>  
  
}                        
#end        

