#include "ColossusTex.inc"

//The belt
 
#macro Belt(Width, Radius, Height, CornerRad, InsetDepth, InsetHeight) 

#declare End =

difference{

  union{

    cylinder{<0, -Height/2, 0> <0, Height/2, 0> Radius - CornerRad}

    cylinder{<0, -Height/2 + CornerRad, 0><0, Height/2 - CornerRad, 0> Radius }  

    torus{ Radius - CornerRad,  CornerRad translate (Height/2 - CornerRad)*y  }

    torus{ Radius - CornerRad, CornerRad translate (-Height/2 + CornerRad)*y }

  }

  torus { Radius, InsetDepth scale <1, (InsetHeight/InsetDepth), 1> }

}

union{ 

object{End translate -Width/2 * x}

object{End translate  Width/2 * x}

 

difference{

  union{

    box{ <-Width/2, -Height/2 + CornerRad, -Radius> <Width/2, Height/2 - CornerRad, Radius>}

    box{ <-Width/2, -Height/2, -Radius + CornerRad> <Width/2, Height/2, Radius - CornerRad>}

    cylinder{ <-Width/2,0,0>  <Width/2,0,0> CornerRad translate<0, Height/2 - CornerRad, Radius - CornerRad> }

    cylinder{ <-Width/2,0,0>  <Width/2,0,0> CornerRad translate<0, -Height/2+ CornerRad, Radius - CornerRad> }

    cylinder{ <-Width/2,0,0>  <Width/2,0,0> CornerRad translate<0, Height/2- CornerRad, -Radius + CornerRad> }

    cylinder{ <-Width/2,0,0>  <Width/2,0,0> CornerRad translate<0, -Height/2+ CornerRad, -Radius + CornerRad> }

  }

  union{

    cylinder{ <-Width,0,0>  <Width,0,0> InsetDepth scale<1,(InsetHeight/InsetDepth),1> translate<0, 0, Radius> }

    cylinder{ <-Width,0,0>  <Width,0,0> InsetDepth scale<1, (InsetHeight/InsetDepth),1> translate<0, 0, -Radius> }

  }

}

} 

#end

//The quiver
 
#declare botR = 8;
#declare topR = 10;
#declare cornerRad = 1.5;
#declare quivL= 140;

#declare flight =

intersection{

   union{
   
   #declare n = 0;
   #while ( n < 30 )
   
       cylinder{<-100,-1,0><100,-1,0> 0.3 rotate -40 * z translate 0.5 * n * y}
       
       #declare n = n + 1;
   #end
   
   }
   
   difference{
       sphere{<0,5,0> 5}
       box{<0,-10,-10><10,10,10>} 
       
       scale <1,3,1>
   }
} 


#declare arrow =

union{

   union{
   
      object{flight}
      object{flight rotate 90*y}
      object{flight rotate 180*y}
      object{flight rotate 270*y}
      
      translate 20*y
      
   }
   
   cylinder{ <0,0,0><0,40,0>1 }
} 


#macro Band(y1, y2)

#declare bandThick = 1;
#declare r1 = topR + ( botR - topR ) * y1 / quivL;
#declare r2 = topR + ( botR - topR ) * y2 / quivL;

union{
   cone{ < 0, -y1, 0 > r1 + bandThick < 0, -y2, 0> r2 + bandThick}
   torus{r1, bandThick translate -y1 * y }    
   torus{r2, bandThick translate -y2 * y }    
}

#end

#declare Quiver = 

union{

  cone{<0,-quivL,0> botR-cornerRad <0,0,0> topR-cornerRad}
  cone{<0,-quivL+cornerRad,0> botR <0,-cornerRad,0> topR}    
  
  object{ Band(quivL/10, 3*quivL/20) }
  object{ Band(17*quivL/20, 9*quivL/10) }
  
  torus{ botR-cornerRad, cornerRad translate (cornerRad-quivL) * y }
  torus{ topR-cornerRad, cornerRad translate -cornerRad * y }
  
  object{ arrow rotate 1*z rotate 32*y translate<-5,0,1> }    
  object{ arrow rotate 1*z rotate 132*y translate<7,0,-1> }    
  object{ arrow rotate 1*z rotate -132*y translate<2,0,4> }  
  
  
  
  scale 0.3   
  
}
 
//The bow

#declare T = 0.5;

#declare BowBit =    

difference{

union{
   
   difference{
      
      cylinder{<0,0,-1><0,0,1>10}
      
      union{
         box{ <-100,-100,-100> <100,  0,100> }
         box{ <-100,   0,-100> <100,100,100> rotate -50*z } 
         cylinder{<0,0,-100><0,0,100>10-T scale<1,1.01,1> }
         
      } 
      
      translate (10-T/2)*x
   }
   
   
   difference{
      
      cylinder{<0,0,-1><0,0,1>10}
      
      union{
         box{ <-100,-100,-100> <100,  0,100> }
         box{ <-100,   0,-100> <100,100,100> rotate -50*z } 
         cylinder{<0,0,-100><0,0,100>10-T scale<1,.9,1> }
         
      } 
      translate (10-T/2)*x
      rotate 180*z
   }
   
   rotate 50*z
}         
           
union{
    cylinder{<-100,0,-100><100,0,-100>99.7}
    cylinder{<-100,0, 100><100,0, 100>99.7} 
    scale <1,1.2,1>
    translate 4*y
}
    
}               

#declare Bow =

union{
    
    union{
       object{BowBit rotate 180*x}
       object{BowBit translate 18*y}  
       #declare L=1.85;
       object{cylinder{<0,-L,0><0,L,0>.6} translate<3.25,8.5,0>} 
       scale <0.6,1,1>
    }
    
    #declare L=15.5;   
    object{cylinder{<0,-L,0><0,L,0>.1} translate<-2.1,8.5,0>}
    
    scale <1,1.1,0.5>
    
}

//The torch       

#declare Torch =

union{          

#declare R1 = 0.6;
#declare R2 = 0.9;
#declare R3 = 2.25;
#declare H1 = 4;
#declare H2 = 1.5;
#declare cornerRad = 0.25; 
#declare RR = 0.08;

   sphere{<0,0,0> R1}   
   
   #declare N = 0;
   #while ( N < 360 )
       cylinder{<0,0,R1><0,H1,R2> RR rotate N*y}
       #declare N = N + 15;
   #end
   
 //     cone{<0,0,0>R1<0,H1,0>R2}
   
   
   cylinder{<0,H1,0><0,H1+0.1,0>R3}
   cylinder{<0,H1,0><0,H1+H2,0>R3 open texture{bronze} normal{bumps bump_size 100 scale 0.1} }
   torus{R1, cornerRad}
   torus{R3, cornerRad translate H1*y}
   torus{R3, cornerRad translate (H1 + H2)*y}
}   