// Persistence Of Vision raytracer version 3.5 Pisc.pov
// ====================================================
// Include file of Pisc.pov
// Copyright Thomas Lieven 2002 
// http://www.webkenya.com  
// -----------------------
#include "textures.inc"
#include "colors.inc"
#include "woods.inc" 
#include "skies.inc" 
#include "finish.inc"

  
// ------
// Values
// ------   

#declare Tile = 
superellipsoid
{<0.5,0.1> scale <2,0.05,2>}// Type de dalle
#declare SD1 = seed (1); // random pour le bois
#declare TxtWh = pigment { color rgb <1,1,1>} // couleur de la dalle 1
#declare TxtBl = pigment { color rgb <0,0.2,0.91>} // couleur de la dalle 2
#declare offs = 4.1;  // offset des dalles
#declare xTile = 10;  // nombre de dalles sur l'axe x
#declare zTile = 100; // nombre de dalles sur l'axe z
#declare nTile1 = 4;  // nombre d'ensemble vers -x
#declare nTile2 = 2; // nombre d'ensemble vers +x

 
#declare Planche = 
box {<-2,-0.25,-15>,<2,0.25,15>} // Type de planche
#declare TxtWood1 = texture { wood texture_map {
[0 T_Wood5]
[0.4 T_Wood6]
[0.6 T_Wood5]
[1 T_Wood8]} rotate y*90 scale <1,1,80>}  // texture des planches
#declare xoffs2 = 4.1; // offset sur l'axe x
#declare zoffs2 = 30.1;//offser sur l'axe z
#declare xPlanche = 30;  // nombre de planches sur l'axe x
#declare zPlanche = 1; // nombre de planches sur l'axe z
#declare ht = 15;  // hauteur des planches par rapport aux dalles
#declare PgtGround = pigment {color rgb <1,0,0>} // couleur du sol sous les planches      
 
// ----
// Tile
// ----
// Centrer origine et long de offs*xTile

#local Row = union {
#if (xTile>0)
#local xCount=0;
#while (xCount<=xTile)
#if (xCount=5)
object {Tile pigment {TxtBl scale rand(SD1)*0.25} finish {phong 0.5 phong_size 10 diffuse 0.65}
translate x*(xCount+1)*offs}
#else
object {Tile pigment {TxtWh scale rand(SD1)*0.25} finish {phong 0.5 phong_size 10 diffuse 0.85} 
translate x*(xCount+1)*offs} 
#end   
#local xCount = xCount+1;
#end  translate <-(xTile*offs)/2,0,0>}
#end


#declare Tiles = union {
object {Row}
#if (zTile>0) 
#local zCount = 0;
#while (zCount<=zTile)
object {Row pigment {TxtWh scale rand(SD1)*5}translate z*(zCount+1)*offs} 
#local zCount = zCount+1;
#end translate <0,0,-(zTile*offs)/2>}
#end 

#declare Ens1 = union {
object {Tiles}
#if (nTile1>0)
#local nCount = 0;
#while (nCount<=nTile1)
object {Tiles translate <-((xTile*offs)-offs/2)*(nCount+1),0,0>}
#local nCount = nCount+1;
#end }
#end 

#declare Ens2 = union {
object {Tiles}
#if (nTile2>0)
#local nCount = 0;
#while (nCount<=nTile2)
object {Tiles translate <((xTile*offs)-offs/2)*(nCount+1),0,0>}
#local nCount = nCount+1;
#end }
#end 

 
// -----
// Plane
// -----
// Sol blanc sous les dalles

#declare Blanc = plane
{ y,-0.5 
texture { pigment { color White } finish {phong 0.5 phong_size 10 diffuse 0.65} } }

// ----
// Bois
// ----
// Centrer origine et long de offs*xTile

#local WoodRow = union {
#if (xPlanche>0)
#local xCount=0;
#while (xCount<=xPlanche)
object {Planche texture {TxtWood1 translate <0,0,-rand(SD1)*10> rotate y*rand(SD1)} translate x*(xCount+1)*xoffs2} 
#local xCount = xCount+1;
#end  translate <-(xPlanche*(xoffs2+1))/2,0.25,0>}
#end

#declare Planches = union {
object {WoodRow}
#if (zPlanche>0) 
#local zCount = 0;
#while (zCount<=zPlanche)
object {WoodRow texture {TxtWood1} translate z*(zCount+1)*zoffs2} 
#local zCount = zCount+1;
#end translate <0,0.25,-(zPlanche*zoffs2)/2>}
#end 


// -------
// Bordure
// -------
#declare TxtBlack = texture { pigment { color Gray40}}
#declare TxtBord = texture { gradient x texture_map {
[0 T_Wood2]
[0.475 TxtBlack]
[0.525 TxtBlack]
[1 T_Wood2]    } }
#local def = 0.01; 
#declare Bord = box {<-(xPlanche*(xoffs2)),ht-(def*20),1.5>,<(xPlanche*(xoffs2)),ht,3.5> texture {TxtBord }} 


// -----
// Plane
// -----
// Mer a une hauteur de y=3

#declare Mer = plane
{ y,3.0 texture { 
  pigment{ gradient z turbulence 0.85 color_map{
    [0 color rgbf <0.61, 0.9, 0.94, 0.7>]  
    [0.15 color rgbf <0.78,0.95,1.3,1>]
    [0.25  color rgbf <0.61,0.91,0.91,1>]
    [0.27 color rgbf <0.5,0.8,1.3,0.65>]
    [0.5 color rgbf <0.62,0.714,0.9,0.75>]
    [1 color rgbf <0.61,0.9,0.94,0.7>] } scale 35 rotate <0,7,0>}
    
  normal {gradient z turbulence 0.81 normal_map {
    [0 waves 15.75 scale <50,5,12>]
    [0.6 waves 13.15 scale <57,5,12>]
    [0.8 waves 15 scale <20,5,15>]
    [1 waves 15.75 scale <50,5,12>]}
    rotate <0,7,0>   
    frequency 0.11 }   }
interior {ior 1.12 caustics 1.0 }
  hollow on }


// ---------
// Plongeoir
// ---------
// Centre a l'origine

#declare TxtWood2 = texture  {T_Wood1}  // texture du tremplin
#declare TxtWood3 = texture { gradient x turbulence 0.01 texture_map {
[0 T_Wood5]
[0.4 T_Wood6]
[0.5 T_Wood8]
[0.6 T_Wood6]
[1 T_Wood5]} rotate y*180 scale <0.5,1,1>} // texture du tremplin
#declare def = 0.01; 
#declare lgTr = 4; //largeur du tremplin
#declare epTr = 1; // epaisseur du tremplin
#declare LgTr = 22.5; //Longueur du tremplin
#declare beta = 0.5; //difference entre deux textures 
#declare htTremplin = 25; // hauteur du tremplin par rapport a 0 

#declare TxtCh = texture {Polished_Chrome}
#declare Ray = 0.5; //Rayon du cylindre et tore

#declare Tremplin = union { 
difference {
box {<-lgTr/2,0-def,-LgTr/3>,<lgTr,epTr+def,LgTr*2/3> texture {TxtWood3}}
box {<-(lgTr/2)-beta,0,-(LgTr/3)-beta>,<lgTr+beta,epTr,(LgTr*2/3)+beta> texture {TxtWood2}}} 
box {<-(lgTr/2)-beta,0,-(LgTr/3)-beta>,<lgTr+beta,epTr,(LgTr*2/3)+beta> texture {TxtWood2}} 
translate <0,htTremplin,0>} 

#declare Pied_Tore = union {
cylinder {<0,0,0>,<0,(htTremplin-ht)/2,0>,Ray}
difference {
torus {1,0.5 rotate x*90}
box {<0,-2,-5>,<2,2,5>} 
box {<-5,0,5>,<5,-5,-5>} translate <1,5,0>}translate <-4,19,0>}

#declare Base =
union {
object {Pied_Tore}
cylinder {<1,6,0>,<9,6,0>,0.5 translate <-4,19,0>}
object {Pied_Tore translate <4,-25,0> rotate y*180 translate <6,25,0> } texture {TxtCh} translate <-1,0,0>}

#declare Plongeoir =union {
object {Tremplin translate <-1,0,2>}
object {Base}
object {Base translate <0,0,-5>}}   
   
   
// --------
// Fauteuil
// --------
#declare lgrSeat = 10; // largeur du cadre du fauteuil
#declare LgrSeat = 25; // Longueur du cadre du fauteuil 
#declare htSeat = 2.5; // Hauteur du cadre du fauteuil par rapport a 0
#declare epsSeat = 0.85; // Epaisseur du cote du cadre du fauteuil 
#declare Beta2 = 0.5; // Epaisseur du plat du cadre du fauteuil  
#declare TxtFaut = texture { pigment {bozo turbulence 3 pigment_map {
[0 rgb <0.15,0.15,0.15>]
[0.3 rgb <0.12,0.10,0.15>*2]
[0.5 rgb <0.1,0.2,0.2>]
[0.7 rgb <0.12,0.1,0.15>]
[0.85 rgb <0.1,0.17,0.18>]
[1 rgb <0.15,0.15,0.15>]} rotate y*90 scale <12,12,12>} finish { Metallic_Finish }}
#declare TxtFaut2 = texture { pigment { bozo color_map { [0 White*0.85] [0.5 White*0.45] [1 White*0.65] } turbulence 0.5 scale <1,1,3>}}
texture { pigment { bozo color_map {
        [0 color rgbf<0.832, 0.812, 0.888, 0.698>]
        [0.5 color rgbf <0.720,0.759,0.820,0.850>]
        [1 color rgbf<0.620, 0.659, 0.620, 0.953>]}
        turbulence 5.500
        scale <0.251, 0.2500, 0.251>}} 
texture { pigment { spotted color_map {
          [ 0.000  color rgb<0.61, 0.8165, 0.9165> ]
          [ 0.329  color rgbf<1.000, 1.000, 1.000, 0.95000> ]
          [ 0.734  color rgbf<1.000, 1.000, 0.9810, 1.000> ]
          [ 1.000  color rgb<0.61, 0.7165, 0.9165> ]}
        scale <8,8,15> translate <-2.5,0,3> turbulence 1.5 frequency 1 } 
        normal {wrinkles 5.0000}}  //texture du cuir du fauteuil 
#declare FinFaut2 = finish {ambient .1 diffuse 0.5 reflection .5 specular 1 roughness .001
         irid {0.35 thickness .5 turbulence .5}}   // finish du cuir du fauteuil
#declare RayCyl = 0.20; // Rayon du Cylindre du dossier
#declare HtStick = 5; // Hauteur du levier du dossier   
#declare Teta = 45;  // Angle d'inclinaison du levier du dossier (defaut = 45 car erreur dans formule) 
#declare RCouss = 0.10; //Rayon du pourtour des coussins
#declare htCoussin = 2; // Hauteur du coussin   
#declare Angle = 35; // Angle de la position du fauteuil


#declare FrameSeat = difference {
box {<-lgrSeat/2,0,-LgrSeat/2>,<lgrSeat/2,epsSeat,LgrSeat/2>}
box {<-lgrSeat/2+Beta2,0-def,-LgrSeat/2+Beta2>,<lgrSeat/2-Beta2,epsSeat+def,LgrSeat/2-Beta2>}
translate <0,htSeat,0> texture {TxtFaut rotate y*rand(SD1)*30}}

#declare Foot = 
box {<-Beta2/2,0,-LgrSeat/3>,<Beta2,htSeat+def,-LgrSeat/3+epsSeat> texture {TxtFaut rotate y*rand(SD1)*30}}

#declare Feet = union {
object {Foot}
object {Foot translate <0,0,LgrSeat/1.5>}
box {<-Beta2,0,-LgrSeat/3>,<Beta2,epsSeat,-LgrSeat/3+LgrSeat/1.5>}}  

#declare Dossier_FauteuilA=
box {<-Beta2,-(-epsSeat/2-HtStick)/2,0>,<Beta2,(-epsSeat/2-HtStick)/2,epsSeat> 
translate <0,0,-epsSeat/2> rotate x*(45+Teta)*90 
translate <0,0,epsSeat/2> translate <-lgrSeat/2+2*Beta2,htSeat+2*epsSeat,-LgrSeat/2.35> }

#declare Dossier_FauteuilA2 = union {
cylinder {<-lgrSeat/2,htSeat+epsSeat/2,-LgrSeat/2.35+epsSeat/2>,<lgrSeat/2,htSeat+epsSeat/2,-LgrSeat/2.35>,RayCyl}   
object {Dossier_FauteuilA}
object {Dossier_FauteuilA translate <lgrSeat-4*Beta2,0,0>} texture {TxtFaut rotate y*rand(SD1)*30}}  

#declare Dossier_FauteuilB=
box {<-lgrSeat/2,-epsSeat/2,-LgrSeat/2+LgrSeat/3.5>,<lgrSeat/2,epsSeat/2,0> 
rotate x*(90-Teta) 
 translate <0,htSeat+epsSeat,-LgrSeat/3.5> texture {TxtFaut rotate y*rand(SD1)*30}}

#declare Fauteuil1 = union { 
box {<-lgrSeat/2,htSeat+epsSeat,-LgrSeat/4.5>,<lgrSeat/2,htSeat+epsSeat+htCoussin,LgrSeat/2> } 
cylinder {<-lgrSeat/2,htSeat+epsSeat,-LgrSeat/4.5>,<lgrSeat/2,htSeat+epsSeat,-LgrSeat/4.5>,RCouss}
cylinder {<-lgrSeat/2,htSeat+epsSeat+htCoussin,-LgrSeat/4.5>,<lgrSeat/2,htSeat+epsSeat+htCoussin,-LgrSeat/4.5>,RCouss}
cylinder {<-lgrSeat/2,htSeat+epsSeat,-LgrSeat/4.5>,<-lgrSeat/2,htSeat+epsSeat,LgrSeat/2>,RCouss}
cylinder {<lgrSeat/2,htSeat+epsSeat,-LgrSeat/4.5>,<lgrSeat/2,htSeat+epsSeat,LgrSeat/2>,RCouss} 
cylinder {<-lgrSeat/2,htSeat+epsSeat+htCoussin,-LgrSeat/4.5>,<-lgrSeat/2,htSeat+epsSeat+htCoussin,LgrSeat/2>,RCouss}
cylinder {<lgrSeat/2,htSeat+epsSeat+htCoussin,-LgrSeat/4.5>,<lgrSeat/2,htSeat+epsSeat+htCoussin,LgrSeat/2>,RCouss}
cylinder {<-lgrSeat/2,htSeat+epsSeat,LgrSeat/2>,<lgrSeat/2,htSeat+epsSeat,LgrSeat/2>,RCouss}
cylinder {<-lgrSeat/2,htSeat+epsSeat+htCoussin,LgrSeat/2>,<lgrSeat/2,htSeat+epsSeat+htCoussin,LgrSeat/2>,RCouss}
cylinder {<lgrSeat/2,htSeat+epsSeat+htCoussin/2,-LgrSeat/4.5>,<lgrSeat/2,htSeat+epsSeat+htCoussin/2,LgrSeat/2>,htCoussin/2 translate <-htCoussin/2.5,0,0>} 
cylinder {<-lgrSeat/2,htSeat+epsSeat+htCoussin/2,-LgrSeat/4.5>,<-lgrSeat/2,htSeat+epsSeat+htCoussin/2,LgrSeat/2>,htCoussin/2 translate <htCoussin/2.5,0,0>}
union {
box {<-lgrSeat/2,-htCoussin/2,-LgrSeat/2+LgrSeat/3.5>,<lgrSeat/2,htCoussin/2,0> }
cylinder {<-lgrSeat/2,-htCoussin/2,-LgrSeat/2+LgrSeat/3.5>,<lgrSeat/2,-htCoussin/2,-LgrSeat/2+LgrSeat/3.5>,RCouss} 
cylinder {<-lgrSeat/2,htCoussin/2,-LgrSeat/2+LgrSeat/3.5>,<lgrSeat/2,htCoussin/2,-LgrSeat/2+LgrSeat/3.5>,RCouss} 
cylinder {<-lgrSeat/2,-htCoussin/2,0>,<lgrSeat/2,-htCoussin/2,0>,RCouss}
cylinder {<-lgrSeat/2,htCoussin/2,0>,<lgrSeat/2,htCoussin/2,0>,RCouss}
cylinder {<-lgrSeat/2,-htCoussin/2,-LgrSeat/2+LgrSeat/3.5>,<-lgrSeat/2,-htCoussin/2,0>,RCouss}
cylinder {<-lgrSeat/2,htCoussin/2,-LgrSeat/2+LgrSeat/3.5>,<-lgrSeat/2,htCoussin/2,0>,RCouss}
cylinder {<lgrSeat/2,-htCoussin/2,-LgrSeat/2+LgrSeat/3.5>,<lgrSeat/2,-htCoussin/2,0>,RCouss}
cylinder {<lgrSeat/2,htCoussin/2,-LgrSeat/2+LgrSeat/3.5>,<lgrSeat/2,htCoussin/2,0>,RCouss}
rotate x*(90-Teta) 
translate <0,htSeat+2*epsSeat,-LgrSeat/4> }
texture {TxtFaut2} 
finish {FinFaut2}
}

#declare Fauteuil_Base = union {
object {FrameSeat}
object {Feet translate <-lgrSeat/2,0,0>}
object {Feet translate <lgrSeat/2-Beta2,0,0>}
object {Dossier_FauteuilA2} 
object {Fauteuil1}
object {Dossier_FauteuilB} texture {TxtFaut rotate y*rand(SD1)*30} rotate y*Angle translate <0,ht+epsSeat,0>}


// ----------------
// Palmier ou arbre
// ----------------  
#macro flight_spline(_p1,_p2,_p3,_p4,_sc,_ec,_cc)
  #if (_cc<=_sc)
    (_p1)
  #else
    #if (_cc>=_ec)
      (_p4)
    #else
      #local _ci=(_cc-_sc)/(_ec-_sc);
      #local _co=(1-_ci);
      //  p = (p1*co^3)+(3*p2*co^2*ci)+(3*p3*ci^2*co)+(p4*ci^3) 
         ( ( _p1*pow(_co,3) ) + ( _p2*3*pow(_co,2)*_ci ) + ( _p3*3*pow(_ci,2)*_co ) + ( _p4*pow(_ci,3) ) )
    #end
  #end
#end  

#declare light_pos=<-1000,1500,-1500>;
#declare pen_light=.2;
#declare amb_light=.15;

#declare sp_leaf_tex=
  texture {
    pigment {
      color rgb<.2,.5,.1>
    }
    finish {
      ambient amb_light
      diffuse .8
      roughness .1
      specular .4
    }
  }
  
#macro v_spline_leaf(_lp1,_lp2,_lp3,_lp4, //  curve of leaf - base to tip
                     _vc1,_vc2,_vc3,_vc4, //  'v' cross section of leaf
                     _lw1,_lw2,_lw3,_lw4) //  leaf width - base to tip   
                      
                     
  // n.b. build the leaf with base at origin, and tip in the +z direction                     

  union {
    bicubic_patch {
      type 0 flatness 0.0100 u_steps 3 v_steps 3,
      _lp1+_vc1*_lw1,_lp1+_vc2*_lw1,_lp1+_vc3*_lw1,_lp1+_vc4*_lw1,
      _lp2+_vc1*_lw2,_lp2+_vc2*_lw2,_lp2+_vc3*_lw2,_lp2+_vc4*_lw2,
      _lp3+_vc1*_lw3,_lp3+_vc2*_lw3,_lp3+_vc3*_lw3,_lp3+_vc4*_lw3,
      _lp4+_vc1*_lw4,_lp4+_vc2*_lw4,_lp4+_vc3*_lw4,_lp4+_vc4*_lw4  
    }
    bicubic_patch {
      type 0 flatness 0.0100 u_steps 3 v_steps 3,
      _lp1+_vc1*_lw1,_lp1+_vc2*_lw1,_lp1+_vc3*_lw1,_lp1+_vc4*_lw1,
      _lp2+_vc1*_lw2,_lp2+_vc2*_lw2,_lp2+_vc3*_lw2,_lp2+_vc4*_lw2,
      _lp3+_vc1*_lw3,_lp3+_vc2*_lw3,_lp3+_vc3*_lw3,_lp3+_vc4*_lw3,
      _lp4+_vc1*_lw4,_lp4+_vc2*_lw4,_lp4+_vc3*_lw4,_lp4+_vc4*_lw4  
      scale <-1,1,1>
    } 
  }                                              
#end

#local bsp_layers=5;      
#local bsp_leaves=5;
#local bsp_leaf=array[bsp_layers]
#local _spl=0;
#while (_spl<bsp_layers)
  #local _ang=(flight_spline(40,70,85,90,0,bsp_layers,_spl));
  #local _len=(flight_spline(3,4,4.25,4.5,0,bsp_layers,_spl));
  #local bsp_leaf[_spl]=object { v_spline_leaf(<0,0,0>,<0,_len/6,0>,vrotate(<0,_len/1.8,-_len/4>,<_ang,0,0>),vrotate(<0,_len,0>,<_ang,0,0>),
                                       <0,0,0>,<.1,.3,0>,<.3,.3,0>,<.5,.1,0>,
                                       .1,.5,.7,.01) }
  #local _spl=_spl+1;
#end

#declare bspike_plant=
  union {
  #local j_rnd=seed(10);
  #local _spl=0;                 
  #while (_spl<bsp_layers)
    union {
    #local _rot=0;
    #while (_rot<1)
      object { bsp_leaf[_spl] rotate <0,_rot*360,0> }
      #local _rot=_rot+1/bsp_leaves;
    #end
      rotate <0,rand(j_rnd)*360/bsp_leaves,0>
    }
    #local _spl=_spl+1;
  #end
  texture { sp_leaf_tex }
  scale .75
  }
  
#local ssp_layers=3;      
#local ssp_leaves=5;
#local ssp_leaf=array[ssp_layers]
#local _spl=0;
#while (_spl<ssp_layers)
  #local _ang=(flight_spline(20,50,80,88,0,ssp_layers,_spl));
  #local _len=(flight_spline(1.5,1.5,2,2,0,ssp_layers,_spl));
  #local ssp_leaf[_spl]=object { v_spline_leaf(<0,0,0>,<0,_len/6,0>,vrotate(<0,_len/1.8,-_len/4>,<_ang,0,0>),vrotate(<0,_len,0>,<_ang,0,0>),
                                       <0,0,0>,<.1,.3,0>,<.3,.3,0>,<.5,.1,0>,
                                       .1,.5,.7,.01) }
  #local _spl=_spl+1;
#end

#declare sspike_plant=
  union {
  #local j_rnd=seed(10);
  #local _spl=0;                 
  #while (_spl<ssp_layers)
    union {
    #local _rot=0;
    #while (_rot<1)
      object { ssp_leaf[_spl] rotate <0,_rot*360,0> }
      #local _rot=_rot+1/ssp_leaves;
    #end
      rotate <0,rand(j_rnd)*360/ssp_leaves,0>
    }
    #local _spl=_spl+1;
  #end
  texture { sp_leaf_tex }
  scale .75
  }




#declare trunk_tex=
  texture {
    pigment {
      color rgb<.3,.25,.05>
    }
    finish {
      ambient amb_light
      diffuse .8
      roughness .8
      specular .05
    }
    normal {
      bumps .2
      scale .1
    }
  }
#declare palm_leaf_tex=
  texture {
    pigment {
      color rgb<.2,.4,.15>
    }
    finish {
      ambient amb_light
      diffuse .8
      roughness .1
      specular .2
    }
  }
#declare transparent_tex=
  texture {
    pigment {
      color rgbf<1,1,1,1>
    }
    finish { ambient 0 diffuse 0 }
  }
#declare palm_leaf_strips=
  texture {
    wood
    sine_wave
    frequency 2
    rotate <90,0,0>
    texture_map {
      [ .0 palm_leaf_tex ]
      [ .15 palm_leaf_tex ]
      [ .15 transparent_tex ]
      [ .85 transparent_tex ]
      [ .85 palm_leaf_tex ]
      [ 1. palm_leaf_tex ]
    }
  }                            
  
#macro trunk_bit(_pos,_ang,_rad,_len,_diff)
  union {
    cone { <0,-.1,0>,_rad,<0,_len+_diff,0>,_rad+_diff }
    torus { _rad,_diff translate <0,_len+_diff,0> }    
    texture { trunk_tex }
    scale <.75,1,.75>
    rotate _ang translate _pos 
  }
#end

#macro v_spline_stalk(_lp1,_lp2,_lp3,_lp4)
  union {  
    #local _stp=1/10;
    #local _ss=_stp;
    #local _lp=_lp1;
    #while (_ss<=1+1/20)
      #local _tp=(flight_spline(_lp1,_lp2,_lp3,_lp4,0,1,_ss));
      #local _rd=(flight_spline(1,1,.6,.5,0,1,_ss));
      cylinder { _lp,_tp,.07*_rd }
      sphere { _tp,.07*_rd }
      #local _lp=_tp;
      #local _ss=_ss+1/10;
    #end
  }
#end
#macro v_spline_palm(_lp1,_lp2,_lp3,_lp4, //  curve of leaf - base to tip
                     _vc1,_vc2,_vc3,_vc4, //  'v' cross section of leaf
                     _lw1,_lw2,_lw3,_lw4) //  leaf width - base to tip   
                      
                     
  // n.b. build the leaf with base at origin, and tip in the +z direction                     

    union {
      bicubic_patch {
        type 0 flatness 0.0100 u_steps 3 v_steps 3,
        _lp1+_vc1*_lw1,_lp1+_vc2*_lw1,_lp1+_vc3*_lw1,_lp1+_vc4*_lw1,
        _lp2+_vc1*_lw2,_lp2+_vc2*_lw2,_lp2+_vc3*_lw2,_lp2+_vc4*_lw2,
        _lp3+_vc1*_lw3,_lp3+_vc2*_lw3,_lp3+_vc3*_lw3,_lp3+_vc4*_lw3,
        _lp4+_vc1*_lw4,_lp4+_vc2*_lw4,_lp4+_vc3*_lw4,_lp4+_vc4*_lw4  
      }
      bicubic_patch {
        type 0 flatness 0.0100 u_steps 3 v_steps 3,
        _lp1+_vc1*_lw1,_lp1+_vc2*_lw1,_lp1+_vc3*_lw1,_lp1+_vc4*_lw1,
        _lp2+_vc1*_lw2,_lp2+_vc2*_lw2,_lp2+_vc3*_lw2,_lp2+_vc4*_lw2,
        _lp3+_vc1*_lw3,_lp3+_vc2*_lw3,_lp3+_vc3*_lw3,_lp3+_vc4*_lw3,
        _lp4+_vc1*_lw4,_lp4+_vc2*_lw4,_lp4+_vc3*_lw4,_lp4+_vc4*_lw4  
        scale <-1,1,1>
      } 
    }                                              
#end

#local pl_layers=5;
#local pl_leaves=9;
#local pl_leaf=array[pl_layers]
#local pl_stalk=array[pl_layers]
#local _pl=0;
#while (_pl<pl_layers)
  #local _ang=(flight_spline(30,60,90,110,0,pl_layers,_pl));
  #local _len=(flight_spline(6,7,8,7,0,pl_layers,_pl));
  #local pl_leaf[_pl]=object { v_spline_palm(<0,0,0>,<0,_len/4,0>,vrotate(<0,_len/1.5,-_len/3>,<_ang,0,0>),vrotate(<0,_len,0>,<_ang,0,0>),
                                       <0,0,0>,<.1,.2,0>,<.65,0,-.1>,<.75,-1.25,-.2>,
                                       .01,.01,1,.25) }
  #local pl_stalk[_pl]=object { v_spline_stalk(<0,0,0>,<0,_len/4,0>,vrotate(<0,_len/1.5,-_len/3>,<_ang,0,0>),vrotate(<0,_len,0>,<_ang,0,0>)) }
  #local _pl=_pl+1;
#end

#declare bpalm_crest=
  union {
  #local j_rnd=seed(10);
  #local _pl=0;                 
  #while (_pl<pl_layers)
    union {
    #local _rot=0;
    #while (_rot<1)
      object { pl_leaf[_pl] rotate <10*rand(j_rnd),0,0> translate <0,0,_pl*.1> rotate<0,_rot*360,0> }
      #local _rot=_rot+1/pl_leaves;
    #end
      texture { palm_leaf_strips }
      rotate <0,rand(j_rnd)*360/pl_leaves,0>
    }
    #local _pl=_pl+1;
  #end
  
  #local j_rnd=seed(10);
  #local _pl=0;                 
  #while (_pl<pl_layers)
    union {
    #local _rot=0;
    #while (_rot<1)
      object { pl_stalk[_pl] rotate <10*rand(j_rnd),0,0> translate <0,0,_pl*.1> rotate<0,_rot*360,0> }
      #local _rot=_rot+1/pl_leaves;
    #end
      texture { palm_leaf_tex }
      rotate <0,rand(j_rnd)*360/pl_leaves,0>
    }
    #local _pl=_pl+1;
  #end
  
  scale 2
  }

#macro palm_crest(_pos,_ang,_siz)
  object { bpalm_crest scale _siz rotate _ang translate _pos }
#end

#macro palm_tree(_pos,_a1,_a2,_a3,_a4,_ns,_sr,_sh,_df)
// position, angle of trunk at key poits a1, a2, a3 &a4
// _ns (number of segments), segment radius, segment length
  union {           
  #render "Building Palm-Tree\n"
  #local _cp=_pos;           
  #local _sc=0;
  #while (_sc<=_ns)
  
    #local _ca=(flight_spline(_a1,_a2,_a3,_a4,0,_ns,_sc));
    #local _sz=(flight_spline(1,.9,.8,.7,0,_ns,_sc));
    trunk_bit(_cp,_ca,_sr*_sz,_sh*_sz,_df*_sz)
    #local _cp=_cp+vrotate(<0,_sh*_sz,0>,_ca);
  
    #local _sc=_sc+1;
  #end
  palm_crest(_cp,_ca,_sr*_sz)
  }
#end
                                      
#ifndef(main_render)

// --------------------------
// Verre cocktail, bouteille,
// --------------------------

#declare TxtVerre = texture{ pigment{rgbft<1, 1, 1,1,0.6>} finish{reflection 0.1 ambient 0 diffuse 0 phong 1 phong_size 150 }}     
#declare TxtBout =  texture{ pigment{rgbft<0.6, 1, 0.8, 0.6,0.6>} finish{reflection 0.1 ambient 0 diffuse 0 phong 1 phong_size 250 }}     
#declare IntVerre = interior{ior 1.5 fade_distance 5 fade_power 0 caustics 4}  
#declare IntBout =  interior{ior 1.65 fade_distance 4 fade_power 1 caustics 4} 
                          
#declare Verre =  union {
lathe { cubic_spline 13,
  <0.000000, 0.000000>,
  <0.000000, 0.000000>,
  <0.213050, 0.003861>,
  <0.213050, 0.019305>,
  <0.083359, 0.038610>,
  <0.047027, 0.135135>,
  <0.048166, 0.559846>,
  <0.100386, 0.679537>,
  <0.359073, 0.996139>,
  <0.335907, 1.000000>,
  <0.096525, 0.725869>,
  <0.000000, 0.691120>,
  <0.000000, 0.691120>
  texture {TxtVerre} interior {IntVerre}}
sphere { <0.335907,1,0.335907>,0.08 pigment {Red} finish {diffuse 0.5 phong 1 phong_size 50}}
cylinder { <0,0.679537,0>,<-0.40,1.45,-0.40>,0.05 pigment {DarkBrown*1.3}}    scale 2.5}

#declare Bouteille =
sor {11,
  <0.150754, 0.000000>
  <0.150754, 0.000000>
  <0.150754, 0.155779>
  <0.150754, 0.391960>
  <0.140704, 0.449749>
  <0.140829, 0.489950>
  <0.125628, 0.530151>
  <0.140704, 0.582915>
  <0.047739, 0.919598>
  <0.047739, 1.000000>
  <0.000000, 1.035176>
  texture {TxtBout} scale 6 interior {IntBout}}

// -----------
// Table basse
// -----------
#declare lgrTable = 8; //largeur de la table
#declare LgrTable = 8; //Longueur de la table
#declare epsTop = 0.5; //epaisseur du haut de la table
#declare epsTable = 0.75; //epaisseur du cote du pied de la table
#declare Beta3 = 0.5; //epaisseur du deuxieme cote du pied de la table
#declare htFoot = 2.5; //hauteur des pieds de la table
#declare TxtTable = texture { pigment {bozo turbulence 3 pigment_map {
[0 rgb <0.15,0.15,0.15>]
[0.3 rgb <0.12,0.10,0.15>*2]
[0.5 rgb <0.1,0.2,0.2>]
[0.7 rgb <0.12,0.1,0.15>]
[0.85 rgb <0.1,0.17,0.18>]
[1 rgb <0.15,0.15,0.15>]} rotate y*90 scale <12,12,12>} finish { Metallic_Finish }}

#declare FootTable = 
box { <0,0,0>,<Beta3,htFoot,epsTable> texture {TxtTable}}

#declare Top = box { <0,htFoot,0>,<lgrTable,htFoot+epsTop,LgrTable>
 texture {TxtTable}}

#declare Table = union {
object {FootTable}
object {FootTable translate <lgrTable-Beta3,0,0>}
object {FootTable translate <0,0,LgrTable-epsTable>}
object {FootTable translate <lgrTable-Beta3,0,LgrTable-epsTable>}
object {Top}  
translate <0,ht,0>}


// ----------
// Sky_sphere
// ----------   
#declare S_Cloud2 =
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.00 rgb <0.22, 0.669, 0.87> ] // horizon
            [0.10 SkyBlue ]                   // horizon
            [0.20 P_Cloud4 ]
        }
    }
}









