/*
	spaceElevator.pov
	An earthlike planet (~8,000 mi diameter), with several elevators rising from the equator
	toward massive space stations. Camera is positioned right next to one elevator just
	below the space station, looking down to the planet. 1 unit= 1000 miles should be a
	good scale, or perhaps 1 unit=100 miles. The elevators will be tiny compared to the
	planet, and the space stations realistically should be no more than 100 miles or so
	in diameter, so they will be sorta tiny also... but they will look big!
*/

#declare landAndSea=texture{
	pigment{
		bozo scale .5
		turbulence 0.5
		color_map
		{
			[  0  color <0,0,.8>]
			[  0.61  color <0,0,1>]
			[  0.65  color <.5,.8,.35>]
			[  0.5  color <.5,.8,.35>]
			[  0.95  color <.4,.5,.15>]
			[  0.985  color <.99,.99,1>]
			[  1.0  color <.9,.9,1>]
		}
	}
	normal{
		bozo scale .5 turbulence 0.5
		normal_map
		{
			[ .61 bumps scale 1000 ]
			[ .61 granite scale 20 ]
			[ .99 granite ]
		}
	}
	translate <0,0,-3>
}

#declare iceCaps=texture{
	pigment{
		bozo turbulence .75
		color_map
		{
			[ .2 color<.8,.8,1> ]
			[ .3 color<1,1,1> ]
		}
	}
	normal{
		bozo turbulence 0.75
		normal_map
		{
			[ .2 bumps scale 1000 ]
			[ .2 granite scale 20 ]
			[ .99 granite ]
		}
	}
}

#declare planetSurface=texture{
	gradient y scale 8 turbulence .7
	texture_map
	{
		[ .5 landAndSea ]
		[ .6 iceCaps ]
	}
	rotate<15,0,0>
}

#declare cloudLayer=texture{
	pigment{
		spotted turbulence 1
		color_map
		{
			[ .6 color rgbt<0,0,0,1>]
			[ .9 color<1,1,1> ]
		}
	}
}

#declare cloudLayer2=texture{
	pigment{
		spotted turbulence 1
		color_map
		{
			[ .6 color rgbt<0,0,0,1>]
			[ .9 color<1,1,1> ]
		}
		translate<1,1,2>
	}
}

#declare elTex3=texture{
	pigment{
		bozo turbulence 1 scale .004
		color_map
		{
			[ .1 color<.9,.9,.9>]
		/*	[ .103 color<1,.2,.2>]
			[ .106 color<.9,.9,.9>]
			[ .5 color<.9,.9,.9>]
			[ .503 color<.6,.9,.4>]
		*/	[ .506 color<.9,.9,.9>]
		}
	}
}

#declare elTex4=texture{
	pigment{color<1,1,1>}
	finish{ ambient 1}
}

#declare elTex2=texture{
	radial
	texture_map{
		[.1 elTex3 ]
		[.11 elTex4 ]
		[.19 elTex4 ]
		[.2 elTex3 ]
		
		[.3 elTex3 ]
		[.31 elTex4 ]
		[.39 elTex4 ]
		[.4 elTex3 ]
		
		[.5 elTex3 ]
		[.51 elTex4 ]
		[.59 elTex4 ]
		[.6 elTex3 ]
		
		[.7 elTex3 ]
		[.71 elTex4 ]
		[.79 elTex4 ]
		[.8 elTex3 ]
		
		[.9 elTex3 ]
		[.91 elTex4 ]
		[.99 elTex4 ]
		[1 elTex3 ]
	}
	rotate<-90,0,0>
}

#declare elTex=texture{
	onion scale .001
	texture_map{
		[.5 elTex3]
		[.55 elTex2]
		[.9 elTex2]
		[.95 elTex3]
	}
}

#declare planet1=sphere{0,4 texture{planetSurface}}
#declare atmosphere=sphere{0,4.05 texture{cloudLayer}}
#declare atmosphere2=sphere{0,4.25
	texture{pigment{
		gradient y scale 4.5 turbulence .2
		color_map
		{
			[0 color rgbt<0,0,0,1>]
			[.7 color rgbt<.8,.6,.9,.9>]
			[1 color rgbt<.8,.6,.9,.75>]
		}
	}}
	translate<0,0,0>
}

#declare planet=union{object{planet1} object{atmosphere} object{atmosphere2}}

#declare elevator=union{
	cylinder{0,<0,0,-12>,.001 texture{elTex}}//texture{pigment{color<0,1,0>}}}
	#local i=4.04;
	#while (i<12)
		#local i=i+.05;
//		torus{.002,.0003 rotate<90,0,0> translate<0,0,-i> texture{pigment{color<0,0,1>}}}
	#end
}

//#declare planet=sphere{0,4 texture{pigment{color<1,1,1>}}}

#declare station=union{
	torus{1,.1}
	cylinder{<-1,0,0>,<1,0,0>,.05}
	cylinder{<-1,0,0>,<0,0,0>,.05 rotate<0,120,0>}
	cylinder{<-1,0,0>,<0,0,0>,.05 rotate<0,240,0>}
	rotate<90,0,0>
	rotate<0,0,30>
//	texture{pigment{color<1,0,0>}}
	texture {elTex}
}

#declare elStat=union{object{elevator}
	object{station translate<0,0,-12>}
	object{station translate<0,0,-12.2> rotate<0,0,180>}
	object{station translate<0,0,-12.4>}
}

#declare elStat2=union{object{elevator scale<13,13,1>}
	object{station translate<0,0,-12>}
	object{station translate<0,0,-12.2> rotate<0,0,180>}
	object{station translate<0,0,-12.4>}
}

camera{
//	location<.0011,0.0001,-11.8>
	location<.0015,0.0001,-11.8>
	look_at<0,0,0>
}

light_source{<5,.1,-20> color<1,1,1>*2}

plane{-z,-10 texture{pigment{granite color_map{[.9 color<0,0,0>][.92 color<1,1,1>]}} finish{ambient 1}}}

object{planet}
object{elStat}
//object{elStat2 rotate<0,-60,0>}
object{elStat2 rotate<0,-120,0>}
