#include "colors.inc"
#include "transforms.inc"

/* --------------------------------------------
**  Bamboo.inc
**          by Karima
**
**  creates bamboosticks
**  
**  macro bamboostick(thresh, segs, seglaenge, segdicke, rotation)
**    creates a controlled Bamboostick:
**    thresh     -> threshold 0.0001 to 1 
**    segs       -> number of segments
**    seglaenge  -> length per segment
**    segdicke   -> thickness of each segment
**    rotation   -> angle the stick describes in degrees

** macro bamboostick_b(thresh, segs, seglaenge, segdicke, rotation)
**    creates a controlles Bamboostick with leaves on it
**    parameters: same as bamboostick

** macro bamboostick_rand(thresh, segs)
**    creates a random Bamboostick with:
**    rotation  : 1.25 to -.75 per segment... random each segment
**    length    : 3 to 8 per segment
**    thickness : 2 - 2.4      

** macro bamboostick_rand_b(thresh, segs)
**  creates a random Bamboostick with leaves on it.

** macro segment(laenge, thresh, dicke, rotation)
**  creates a single segment at the origin
**  laenge      -> length of segment
**  thresh      -> threshold of segment
**  dicke       -> thickness of segment
**  rotation    -> angle the segment is bowed in x direction

** macro blatt()
**  creates a leaf at origin, looking along x, open to -y, about 1 unit long

** macro aderblatt(adern)
**  creates a leaf at origin, looking along x, open to -y with 'venes' on it
**  adern     -> number of 'venes'

** macro bueschel(blaetterzahl)
**  creates a small 'bueschel' of grass
**  blaetterzahl -> number of grass-leaves

** macro d_bueschel(blaetterzahl)
**  same as above, but in a detailed version with nicer texture

** macro wiese(groessex, groessez, dichte)
**  a rectangle with grass.
**  groessex  -> length-units in x-direction
**  groessez  -> length_units in z_direction
**  dichte    -> leaves per squareunit.... number of leaves = groessex*groessez*dichte


------------------------------------------------*/





// Ein Blatt : Ursprung in x Richtung.. gewoelbt in y richtung, offen nach -y

  // normals, die Adern darstellen.. laufen vom 'scheitel' nach aussen
#macro adernnormal(adern)
  normal {
    radial .05 
    frequency adern
    slope_map {
      [0 <0, 0>]
      [.475 <0, 0>]
      [.475 <0, 1>]
      [.49 <1, 1>]
      [.49 <1, 0>]
      [.51 <1, 0>]
      [.51 <1, -1>]
      [.525 <0, -1>]
      [.525 <0, 0>]
      [1 <0, 0>]
    }
  }
#end

  // Grundblatt
#declare _blatt = difference {
    union {
      torus { 1, .2 }                              
      torus { 1.2, .01} 
    }
    torus { 1, .2 scale <1, 2, 1> translate z*.12 }
    box { <-1, -.4, -.4> <1, .4, 1> }
}
                  
  //Grundblatt Hohl
  
#declare _blatt_hohl = difference {
    union {
      difference { torus { 1, .2 } torus { 1, .190 } }
      torus { 1.2, .01 pigment { LimeGreen } } 
    }
    torus { 1, .2 scale <1, 2, 1> translate z*.12 }
    box { <-1, -.4, -.4> <1, .4, 1> }
}              

// Alternatives Grundblatt

#declare _blatt2 = intersection {
  union {
    difference {
      torus { 10, 6 }
      torus { 10, 5.99 } 
      scale <1, .25, 1>
    }
    torus {4, .01 }//pigment {LimeGreen } }
  }
  sphere {
    0, 8
    scale <2.5, .05, 1>
    translate z*-11
  }
  box { <-3, -.5, -4.5> <3, .5, -2.5> }          
}


 // Ein einfaches Blatt, an den Ursprung gebracht
#macro blatt()
  object {
    _blatt
    Align_Trans(_blatt, <-1, -1, -1>, <-.01, -.2, -1.4>)
    rotate x*90 
  }
#end                                             

  // Ein Blatt mit Adern am Ursprung
#macro aderblatt(adern)
  object {       
    _blatt_hohl
    adernnormal(adern)
    Align_Trans(_blatt, <-1, -1, -1>, <-.01, -.2, -1.35>)
    rotate x*90 
  }
#end
  
  //Alternatives Blatt am Ursprung

#macro blatt2()
  object {
    _blatt2
  Align_Trans(_blatt2, <-1, -1, -1>, <-.42, -.4, -1.45> )
  rotate <90, 0, 45>
  }                                     
#end

  // Alternatives Blatt am Ursprung mit Adern

#macro aderblatt2(adern)
  object {
    _blatt2                           
    adernnormal(adern)
  Align_Trans(_blatt2, <-1, -1, -1>, <-.42, -.4, -1.45> )
  rotate <90, 0, 45>
  }                                     
#end


// Grasbueschel

#declare grasrand = seed(41907);

#macro bueschel(blaetterzahl)  
  #local laufvar = 0;
   
  merge {
    #while (laufvar<blaetterzahl )
      object { 
        blatt2()
        scale <1, 1, .3>        
        rotate z*(rand(grasrand)*20-15)
        rotate y*(rand(grasrand)*360)
        pigment { ForestGreen }
      }                        
      object {
        blatt()    
        scale <1, 1, .3>
        rotate z*(rand(grasrand)*20-5)
        rotate y*(rand(grasrand)*360)
        pigment { ForestGreen }
      }
    
    #declare laufvar = laufvar+1;
    #end
  }
#end   


// Detailed Grasbueschel

#macro d_bueschel(blaetterzahl)  
  #local laufvar = 0;
   
  merge {
    #while (laufvar<blaetterzahl )
      object { 
        aderblatt2(150)
        scale <1, 1, .3>        
        rotate z*(rand(grasrand)*20-15)
        rotate y*(rand(grasrand)*360)
        pigment { 
          bozo
          frequency 10
          turbulence .75
          color_map {
            [0.0 DarkGreen]
            [0.5 ForestGreen ]
            [1.0 DarkGreen ]
          }
        }
      }                        
      object {
        aderblatt(90)    
        scale <1, 1, .3>
        rotate z*(rand(grasrand)*20-5)
        rotate y*(rand(grasrand)*360)
        pigment { 
          bozo
          frequency 10
          turbulence .75
          color_map {
            [0.0 DarkGreen]
            [0.5 ForestGreen ]
            [1.0 DarkGreen ]
          }
        }
      }
    
    #declare laufvar = laufvar+1;
    #end
  }
#end     


// Eine Wiese aus Grashalmen

#macro wiese(groessex, groessez, dichte)
  union {
  #local laufvar = 0;
  #local r2 = seed(9127);
  #local halme = groessex*groessez*dichte;

  #while (laufvar < halme)     
    object {
      blatt2()                                           
      scale rand(r2)+.5                                  
      rotate y*rand(r2)*360
      translate <(rand(r2)*groessex), 0, (rand(r2)*groessez)>
      pigment { LimeGreen }
    }
  #declare laufvar = laufvar+1;
  #end  
}
                            
#end                            

// Wiese mit detailierten Texturen

#macro d_wiese(groessex, groessez, dichte)
  union {
  #local laufvar = 0;
  #local r2 = seed(9127);
  #local halme = groessex*groessez*dichte;

  #while (laufvar < halme)     
    object {
      blatt2()                                           
      scale <1, 1, .3>
      scale rand(r2)+.5                                  
      rotate y*rand(r2)*360
      translate <(rand(r2)*groessex), 0, (rand(r2)*groessez)>
      pigment { 
        bozo
        frequency 10
        turbulence .75
        color_map {
          [0.0 DarkGreen]
          [0.5 ForestGreen ]
          [1.0 DarkGreen ]
        }
      }
    }
  #declare laufvar = laufvar+1;
  #end  
}
                            
#end                            
                   



// Ab hier: Bambus!                                  
                                  
                                  
#declare segcyltex = texture {
  pigment {
    bozo            
    turbulence 5
    color_map {
      [0.00 color LimeGreen ]
      [0.65 color LimeGreen *.75 ]
      [0.75 color DarkBrown ]
      [0.95 color VeryDarkBrown ]
      [1.00 color Black ]
    }
    scale <.2, 10, 1>
  } 
  normal {
    dents 1
    turbulence .5    
  }
}
                                                                         
#declare segsphtex = texture {
  pigment { Brown } 
}                                                                         
                
                
#declare rotrand= seed (412);                

#macro segment(laenge, thresh, dicke, rotation) blob {
  threshold thresh
  sphere { 0, dicke*1.025, strength 1 scale <1, .5, 1> translate y*(laenge+.05) texture { segsphtex } }
  cylinder { 0, <0, laenge, 0>, dicke , strength 1 texture { segcyltex } }
  rotate y*rotation  
}                                            
#end


// kontrollierter Bambusstab:
// thresh     -> threshold 0.0001 bis 1 klein: gleichmaessig dick -  gross: gelenke stechen heraus
// segs       -> anzahl der Segmente
// seglaenge  -> Laenge pro Segment
// segdicke   -> dicke pro Segment
// rotation   -> Gesamtwinkel, um den sich der Stab biegt.  

#macro bamboostick(thresh, segs, seglaenge, segdicke, rotation)  merge {
  #local geswinkel = 0;    
  #local segnr = 1;
  #local xpos = 0;
  #local ypos = 0;
  #local zpos = 0;                                
  
  object { segment ( seglaenge, thresh, segdicke, 0)}
  
  #while (segnr<=segs) 
 
      #local zwinkel = -(rotation/segs);
      #local xpos = xpos - sin(radians(geswinkel))*seglaenge+.1;
      #local ypos = ypos + cos(radians(geswinkel))*seglaenge+.1;
      #local geswinkel = geswinkel + zwinkel;
      #local segnr = segnr + 1;
      
      object { 
        segment(seglaenge, thresh, segdicke, rotation)
        rotate <0, 0, geswinkel> 
        translate <xpos, ypos, zpos>
      }
  #end
}
#end           

// Bambusstab mit Blaettern dran

#macro bamboostick_b(thresh, segs, seglaenge, segdicke, rotation, blattgr)  merge {
  #local geswinkel = 0;    
  #local segnr = 1;
  #local xpos = 0;
  #local ypos = 0;
  #local zpos = 0;                                
  
  #local r1 = seed (419);
  
  object { segment ( seglaenge, thresh, segdicke, 0)}
  
  #while (segnr<=segs) 
 
      #local zwinkel = -(rotation/segs);
      #local xpos = xpos - sin(radians(geswinkel))*seglaenge+.1;
      #local ypos = ypos + cos(radians(geswinkel))*seglaenge+.1;
      #local geswinkel = geswinkel + zwinkel;
      #local segnr = segnr + 1;
      
      union {
        object { segment(seglaenge, thresh, segdicke, rotation) }
        #switch (ceil(rand(r1)*4))
          #range (0, .999) #break
          #range (1, 1.999)
            object { 
              aderblatt(rand(r1)*20+20)  // 20 - 40 adern
              scale (blattgr)     // 10 - 15 scalen
              rotate z*(rand(r1)*80-60)   // -60 - 20 nach oben / unten drehen
              translate x*(segdicke-1+thresh) // an aeusseres von stab setzen
              rotate y*(rand(r1)*360)     // 0 - 360 rotiere um y 
              translate <0, (seglaenge-1), 0> // an knubbel nach oben setzen
              pigment { LimeGreen }
            }
          #break
          #range (2, 2.999)
            #local rota = rand(r1)*360;
            union {
              object {
                aderblatt(rand(r1)*20+20)  // 20 - 40 adern
                scale (blattgr)     // 10 - 15 scale nach x
                rotate z*(rand(r1)*80-60)   // -60 - 20 nach oben / unten drehen
                translate x*(segdicke-1+thresh) // an aeusseres von stab setzen
                rotate y*(rota)             // 0 - 360 rotiere um y 
                pigment { LimeGreen }
              }
              object {
                aderblatt(rand(r1)*20+20)  // 20 - 40 adern
                scale (blattgr)     // 10 - 15 scale nach x
                rotate z*(rand(r1)*80-60)   // -60 - 20 nach oben / unten drehen
                translate x*(segdicke-1+thresh) // an aeusseres von stab setzen
                rotate y*(rota+rand(r1)*180+90) // (0 - 360) + (90 - 270) rotiere um y 
                pigment { LimeGreen }
              }
              translate <0, (seglaenge-1), 0>   // an knubbel nach oben setzen
            }
          #break
          #range (3, 4)
            #local rota = rand(r1)*360;
            union {
              object {
                aderblatt(rand(r1)*20+20)  // 20 - 40 adern
                scale (blattgr)     // 10 - 15 scale nach x
                rotate z*(rand(r1)*80-60)   // -60 - 20 nach oben / unten drehen
                translate x*(segdicke-1+thresh) // an aeusseres von stab setzen
                rotate y*(rota)             // 0 - 360 rotiere um y      
                pigment { LimeGreen }
              }                                                          
              object {
                aderblatt(rand(r1)*20+20)  // 20 - 40 adern
                scale (blattgr)     // 10 - 15 scale nach x
                rotate z*(rand(r1)*80-60)   // -60 - 20 nach oben / unten drehen
                translate x*(segdicke-1+thresh) // an aeusseres von stab setzen
                rotate y*(rota+rand(r1)*60+90)  // (0 - 360) + (90 - 150) rotiere um y 
                pigment { LimeGreen }
              }
              object {
                aderblatt(rand(r1)*20+20)  // 20 - 40 adern
                scale (blattgr)     // 10 - 15 scale nach x
                rotate z*(rand(r1)*80-60)   // -60 - 20 nach oben / unten drehen
                translate x*(segdicke-1+thresh) // an aeusseres von stab setzen
                rotate y*(rota+rand(r1)*60+210) // (0 - 360) + (210 - 270) rotiere um y 
                pigment { LimeGreen }
              }                    
              translate <0, (seglaenge-1), 0>   // an knubbel nach oben setzen
            }
          #break
        #end 
        rotate <0, 0, geswinkel> 
        translate <xpos, ypos, zpos>
      }
  #end
}
#end           


// Erzeugt einen zufaelligen Bambusstab... 
// winkel: 1.25 bis -.75
// Laenge : 3 - 8  pro segment
// dicke: 2 - 2.4

#macro bamboostick_rand(thresh, segs)
 merge {
  #local r1 = seed(1412);
  #local seglaenge = rand(r1)*5+3;
  #local segdicke = rand(r1)*.4+2;
  #local rotation = rand(rotrand)*360;
  #local geswinkel = 0;    
  #local segnr = 1;
  #local xpos = 0;
  #local ypos = 0;
  #local zpos = 0;                                
  
  object { segment ( seglaenge, thresh, segdicke, 0)}
  
  #while (segnr<=segs) 
 
      #local zwinkel = rand(r1)*-2+.75;
      #local xpos = xpos - sin(radians(geswinkel))*seglaenge+.1;
      #local ypos = ypos + cos(radians(geswinkel))*seglaenge+.1;
      #local geswinkel = geswinkel + zwinkel;
      #local segnr = segnr + 1;
      
      object { 
        segment(seglaenge, thresh, segdicke, rotation)
        rotate <0, 0, geswinkel> 
        translate <xpos, ypos, zpos>
      }
  #end
}
#end

//  Zufaelliger Bamboostick mit Blaettern!

#macro bamboostick_rand_b(thresh, segs)
 merge {
  #local r1 = seed(1412);
  #local seglaenge = rand(r1)*5+3;      // 3 - 8 laenge pro segment
  #local segdicke = rand(r1)*.4+2;      // 2 - 2.4 dicke                                  
  #local rotation = rand(rotrand)*360;  // 0 - 360  drehung
  #local geswinkel = 0;    
  #local segnr = 1;
  #local xpos = 0;
  #local ypos = 0;
  #local zpos = 0;                                
  
  object { segment ( seglaenge, thresh, segdicke, 0)}
  
  #while (segnr<=segs) 
 
      #local zwinkel = rand(r1)*-2+.75;
      #local xpos = xpos - sin(radians(geswinkel))*seglaenge+.1;
      #local ypos = ypos + cos(radians(geswinkel))*seglaenge+.1;
      #local geswinkel = geswinkel + zwinkel;
      #local segnr = segnr + 1;
      #local blattgr = rand(r1)*5+10;
      
      union {
        object { segment(seglaenge, thresh, segdicke, rotation) }
        #switch (ceil(rand(r1)*4))
          #range (0, .999) #break
          #range (1, 1.999)
            object { 
              aderblatt(rand(r1)*20+20)  // 20 - 40 adern
              scale (blattgr)     // 10 - 15 scalen
              rotate z*(rand(r1)*80-60)   // -60 - 20 nach oben / unten drehen
              translate x*(segdicke-1+thresh) // an aeusseres von stab setzen
              rotate y*(rand(r1)*360)     // 0 - 360 rotiere um y 
              translate <0, (seglaenge-1), 0> // an knubbel nach oben setzen
              pigment { LimeGreen }
            }
          #break
          #range (2, 2.999)
            #local rota = rand(r1)*360;
            union {
              object {
                aderblatt(rand(r1)*20+20)  // 20 - 40 adern
                scale (blattgr)     // 10 - 15 scale nach x
                rotate z*(rand(r1)*80-60)   // -60 - 20 nach oben / unten drehen
                translate x*(segdicke-1+thresh) // an aeusseres von stab setzen
                rotate y*(rota)             // 0 - 360 rotiere um y 
                pigment { LimeGreen }
              }
              object {
                aderblatt(rand(r1)*20+20)  // 20 - 40 adern
                scale (blattgr)     // 10 - 15 scale nach x
                rotate z*(rand(r1)*80-60)   // -60 - 20 nach oben / unten drehen
                translate x*(segdicke-1+thresh) // an aeusseres von stab setzen
                rotate y*(rota+rand(r1)*180+90) // (0 - 360) + (90 - 270) rotiere um y 
                pigment { LimeGreen }
              }
              translate <0, (seglaenge-1), 0>   // an knubbel nach oben setzen
            }
          #break
          #range (3, 4)
            #local rota = rand(r1)*360;
            union {
              object {
                aderblatt(rand(r1)*20+20)  // 20 - 40 adern
                scale (blattgr)     // 10 - 15 scale nach x
                rotate z*(rand(r1)*80-60)   // -60 - 20 nach oben / unten drehen
                translate x*(segdicke-1+thresh) // an aeusseres von stab setzen
                rotate y*(rota)             // 0 - 360 rotiere um y      
                pigment { LimeGreen }
              }                                                          
              object {
                aderblatt(rand(r1)*20+20)  // 20 - 40 adern
                scale (blattgr)     // 10 - 15 scale nach x
                rotate z*(rand(r1)*80-60)   // -60 - 20 nach oben / unten drehen
                translate x*(segdicke-1+thresh) // an aeusseres von stab setzen
                rotate y*(rota+rand(r1)*60+90)  // (0 - 360) + (90 - 150) rotiere um y 
                pigment { LimeGreen }
              }
              object {
                aderblatt(rand(r1)*20+20)  // 20 - 40 adern
                scale (blattgr)     // 10 - 15 scale nach x
                rotate z*(rand(r1)*80-60)   // -60 - 20 nach oben / unten drehen
                translate x*(segdicke-1+thresh) // an aeusseres von stab setzen
                rotate y*(rota+rand(r1)*60+210) // (0 - 360) + (210 - 270) rotiere um y 
                pigment { LimeGreen }
              }                    
              translate <0, (seglaenge-1), 0>   // an knubbel nach oben setzen
            }
          #break
        #end 
        rotate <0, 0, geswinkel> 
        translate <xpos, ypos, zpos>
      }
  #end
}
#end



