#include "colors.inc"
#include "bewuchs.inc"
#include "portal.inc"

#global_settings { max_trace_level 10 }

camera { location <60, 20, -55> look_at <-20, -10, 0> }

//camera { location <25, 25, 25> look_at <0, 25, 0> }


//light_source { <0, 25, -80> White }

#declare r1 = seed (1611 );

sky_sphere {
  pigment {
    leopard    
    color_map {
      [0.87 Black ]
      [0.89 rgb <1.2, 1, 1.1>*5]
      [0.975 rgb 5 ]
    }          
    scale 0.00001
  }
  pigment {
    bozo    
    turbulence .25
    pigment_map {
      [0.0 transmit 1]
      [0.7 transmit 1]
      [0.81 granite turbulence .25 color_map { [0.0 transmit 1 ] [0.2 rgbt <1.3, 1.2, 1.3, .9> ] [1.0 rgbt <.85, .5, .7, .55> ] } scale 2 ]
      [0.85 granite turbulence .25 color_map { [0.0 transmit 1 ] [0.1 rgbt <1.3, 1.2, 1.3, .75> ] [1.0 rgbt <.9, .5, .7, .35> ] } scale 2 ]  
    }
    scale .5
  }
}

#declare klammer = merge {
  difference {
    merge {
      intersection {
        torus { 49.25, 1.5 scale <1, 2, 1> }
        sphere { <50.5, -20, 0> 21.5 scale <1, 1, 2> }        
      }
      intersection {
        torus { 49.25, 1.5 rotate x*90 scale <1, .5, 1> }
        sphere { <50.5, 0, 20> 21.5 scale <1, 4, 1> }
        sphere { <50.5, 0, -20> 21.5 scale <1, 4, 1> } 
      }
    }
    sphere { 0, 50.4501 scale <1, .5, 1> }
    box { <-52, -52, -52> <52, 0, 52> }  
  }
  sphere {
    0, 2      
    hollow
    pigment { transmit 1 }
    interior {
      media {
        emission .5
        density {
          bozo         
          turbulence .25  
          density_map {
            [0.0 rgb .2 ]
            [0.3 rgb .1 ]
            [0.6 rgb 0 ]
            [1.0 rgb 0 ]
          }         
        }
        density {
          spherical 
          scale 2        
        }
      }    
    }
    scale <3, .5, 1>
    translate <57, 1.5, 0>  
  }
}   

#declare plattform = merge {                                                                                    
  merge {
    difference {
      cylinder { <0, -2, 0> <0, 0, 0> 51 } 
      cylinder { <0, -2.1, 0> <0, .1, 0> 45 } 
    }                                   
    torus { 51, 1 scale <1, 1.2, 1> translate y*-1}          
    difference {
      cylinder { <0, -2.2, 0> <0, .2, 0> 52 } 
      cylinder { <0, -2.3, 0> <0, .3, 0> 51 }   
    }                                           
    torus { 52, 1.2 translate y*-1 }
 }
  object { klammer rotate y*00 }
  object { klammer rotate y*60 }
  object { klammer rotate y*120 }
  object { klammer rotate y*180 }
  object { klammer rotate y*240 }
  object { klammer rotate y*300 }

  pigment { Gray20 }
  normal { crackle .3 metric 26 scale 4}
  finish { ambient .1 }
} 

               

#declare kuppel = difference {
  sphere { 0 50.45 }
  sphere { 0 50.4 }
  box { -55 <55, -1, 55> }
  scale <1, .5, 1>
  texture {
    pigment { 
      bozo  
      turbulence .5
      color_map {
        [0.0 White transmit .8 ]
        [0.8 transmit 1 ]
        [1.0 transmit 1 ]
      }      
      scale 20
    }  
    finish { ambient .6 diffuse .4 }             
 }
 texture {
  pigment {
    crackle 
    metric .5
    offset .9
    turbulence .5
    color_map {
      [0.0 NeonBlue transmit .65]
      [0.05 White transmit .85]
      [0.15 transmit 1]
      [1.0 transmit 1]
    }                 
    scale 20
  }        
  finish { ambient .6 diffuse .4 }
 }
 no_shadow 
}


#declare kunstsonne = merge {
  intersection {
    sphere { <0, 0, 0> 5 }
    sphere { 0, 50.4 scale <1, .5, 1> translate y*-24}
    pigment { transmit 1}
    hollow
    interior {
      media {
        emission .2
        density { 
          bozo 
          density_map {
            [0.0 rgb .25 ]
            [1.0 rgb .1 ]            
          }
        }
      }
      media {
        emission .75
        density {
          cylindrical   
          rotate x*90
          translate y*1
        }            
        density {
          spherical
          scale <1, 1, 4.5>
          translate y*1
        }
      }
      media {      
        emission .75
        density {
          cylindrical   
          rotate z*90
          translate y*1
        }            
        density {
          spherical
          scale <4.5, 1, 1>
          translate y*1
        }
      }
      media {
        emission .75
        density { cylindrical scale 2}
        density { 
          spherical             
          scale <1, 4, 1>
          translate y*1
        }
      }                        
    }
  }
}

#declare licht1 = light_source { 
  <0, 24, 0> White 
  spotlight
  point_at 0
  radius 60
  falloff 65
  area_light <2, 0, 0>, <0, 0, 2>, 4, 4 jitter 
//  shadowless 
  looks_like { object { kunstsonne } } 
}



merge {
  light_group {
    merge {
      object { plattform }                  
      difference {
        object { sand }
        prism {
          linear_spline linear_sweep 0, 1, 5
          <0, -10>, <0, 0>, <-dist-.1, -55+(55/60)*(60+dist)>, <-dist-.1, -55+(45/60)*(60+dist)>, <0, -10>
          scale <1, 2, 1>
        }                                                   
      }
    //  cylinder { 0, <0, .5, 0> 50 pigment { Yellow } }
      object { teich }
      object { palmgruppe1 }                             
      object { teichgras }
      object { fels1 rotate y*-15 translate <-5, 0, 30> }
      object { fels2 translate <5, 0, 25> }
      object { fels3 translate <9, 0, 25> }    
      object { geranke1 }   
      object { geranke2 }
      light_group { 
        object { tor } 
        light_source { <20, 10, -10> rgb .5 shadowless } 
      }                    
    }
    light_source { licht1 }
  }                    
  light_group { object { kuppel } global_lights off }
object { effekt1() }
object { effekt1() rotate y*180 translate z*-10 }
}                    

object  { raum1 }

