// Persistence of Vision Ray Tracer Scene Description File
// File: TdG_Textures.inc
// Vers: 3.5
// Desc: Different Materials and Textures by TdG (and some others)
// Date: March 2001; July 2001; May 2003; September 2003;
//       April 2004 (transformation to macro)
// Auth: For all TdG_... textures: Thomas de Groot (t.degroot@inter.nl.net) all rights reserved

/****************************************
CONTENTS:
   VEGETATION TEXTURES
     TdG_AutumnLeaf_01
     TdG_AutumnLeaf_02
     TdG_AutumnLeaf_02a
     TdG_Reed_01
     TdG_GreenLeaf
     SR_Birch
     SR_Poplar
     SR_Pine
     TdG_BrownBark
     CF_EurekaWood
     BH_Trees1
     BH_trees2
     BH_Grass1
     BH_Grass2
   WATER MATERIALS
     TdG_NorthSeaWater macro
     TdG_RipplingWater macro
     NK_WaterMat
     BH_Water
     JRR_ShimmeringWater
   GEOLOGICAL TEXTURES
     TdG_OldRedSandstone
     TdG_Folded_OldRedSandstone
     TdG_RuggedSandstone
     TdG_MouldySandstone
     TdG_RoughStone_dark (material)
     TdG_Gravel
     TdG_LightBandedSandstoneRubble
     TdG_LightBandedSandstone
     TdG_Limestone
     TdG_PavingStone
     NK_Erde
     TdG_LightSand
     TdG_DarkSand
     TdG_RiverBottomSand
   CONSTRUCTION TEXTURES
     TdG_ErodedPlasteredBricks
   METALLIC TEXTURES
     TdG_RustyIron
     TdG_RustyIron2
*****************************************/

#version 3.6;

//#ifndef (Rad); #declare Rad = off; #end  // for the use with radiosity, ambient will be set to 0
//====================================================
//===============  VEGETATION TEXTURES  ==============
//====================================================
//AUTUM LEAF TEXTURES:
#declare TdG_AutumnLeaf_01 = 
      texture
      {      
         pigment
         {
            crackle metric 2.0
            color_map
            {
               [ 0.0       rgbft <0.0, 0.604, 0.007, 0.0, 0.0> ]
               [ 0.160142  rgbft <0.926, 0.798, 0.011, 0.0, 0.0> ]
               [ 0.633     rgbft <0.854, 0.67, 0.0, 0.0, 0.0> ]
               [ 1.0       rgbft <0.875, 0.343733, 0.0104, 0.0, 0.0> ]
            }
            scale  <0.6, 0.2, 0.1>
            warp
            {
               turbulence <1.0, 1.0, 1.0>

            }
         }
         finish
         {
            ambient 0.2
            diffuse 0.5
            phong 0.1
            phong_size 20.0
         }
      }

#declare TdG_AutumnLeaf_02 = 
      texture
      {      
         pigment
         {
            crackle solid
            color_map
            {
               [ 0.0       rgbft <0.0, 0.843733, 0.0104, 0.0, 0.0> ]
               [ 0.160142  rgbft <0.989567, 0.864567, 0.156233, 0.0, 0.0> ]
               [ 0.298932  rgbft <1.0, 0.802067, 0.083317, 0.0, 0.0> ]
               [ 1.0       rgbft <0.875, 0.343733, 0.0104, 0.0, 0.0> ]
            }
            scale  <0.6, 0.2, 0.1>
            warp
            {
               turbulence <1.0, 1.0, 1.0>

            }
         }
         finish
         {
            ambient 0.2
            diffuse 0.5
            phong 0.1
            phong_size 20.0
         }
      }

#declare TdG_AutumnLeaf_02a = 
      texture
      {      
         pigment
         {
            crackle solid
            color_map
            {
               [ 0.0       rgb <0.0, 0.843733, 0.0104> ]
               [ 0.160142  rgb <0.989567, 0.864567, 0.156233> ]
               [ 0.298932  rgb <1.0, 0.802067, 0.083317> ]
               [ 1.0       rgb <0.875, 0.343733, 0.0104> ]
            }
            scale  <0.6, 0.2, 0.1>
            warp
            {
               turbulence <1.0, 1.0, 1.0>

            }
         }
      }

//GREEN SPOTTED REED TEXTURE:
#declare TdG_Reed_01 = 
      texture
      {      
         pigment
         {
            crackle form <-1,1,0>
            color_map
            {
               [ 0.0       rgbft <0.0, 0.604, 0.007, 0.0, 0.0> ]
               [ 0.573     rgbft <0.926, 0.798, 0.011, 0.0, 0.0> ]
               [ 0.872     rgbft <0.854, 0.67, 0.0, 0.0, 0.0> ]
               [ 1.0       rgbft <0.875, 0.343733, 0.0104, 0.0, 0.0> ]
            }
            scale  <0.6, 0.2, 0.1>
            warp
            {
               turbulence <1.0, 1.0, 1.0>

            }
         }
      }

//GREEN SPOTTED LEAF TEXTURE:
#declare TdG_GreenLeaf = 
      texture
      {      
         pigment
         {
            gradient x
            color_map
            {
               [ 0.0     rgbft <0.184, 0.31, 0.184, 0.0, 0.0> ]
               [ 0.25    rgbft <0.184, 0.31, 0.184, 0.0, 0.0> ]
               [ 0.5     rgbft <0.184, 0.31, 0.184, 0.0, 0.0> ]
               [ 0.75    rgbft <0.42, 0.557, 0.137, 0.0, 0.0> ]
               [ 1.0     rgbft <0.624, 0.624, 0.373, 0.0, 0.0> ]
            }
            scale  <0.6, 0.2, 0.1>
            turbulence 1.0
            phase 1.0
            ramp_wave
            warp
            {
               turbulence <1.0, 3.0, 1.0>

            }
         }      
         finish
         {
            ambient 0.2
            diffuse 0.5
            phong 0.1
            phong_size 20.0
         }
      }

//BIRCH BARK TEXTURE (by Sonya Roberts):
#declare SR_Birch =
texture {
  pigment {
    agate
    color_map {
	[0.00 color rgb<0.000, 0.000, 0.000>]
	[0.17 color rgb<0.000, 0.000, 0.000>]
	[0.18 color rgb<1.000, 1.000, 1.000>]
	[0.57 color rgb<1.000, 1.000, 1.000>]
	[0.58 color rgb<0.000, 0.000, 0.000>]
	[0.63 color rgb<0.000, 0.000, 0.000>]
	[0.63 color rgb<1.000, 1.000, 1.000>]
	[1.00 color rgb<1.000, 1.000, 1.000>]
    }
    rotate <0.0, 0.0, 90.0>
  }
  finish {
    ambient 0.3
  }
  scale <2.0, 0.1, 2.0>
}

//POPLAR BARK TEXTURE (by Sonya Roberts):
#declare SR_Poplar =
texture {
  pigment {
    granite
    color_map {
	[0.00 color rgb<0.608, 0.596, 0.424>]
	[0.24 color rgb<0.514, 0.588, 0.392>]
	[0.51 color rgb<0.639, 0.651, 0.451>]
	[0.52 color rgb<0.506, 0.408, 0.071>]
	[0.59 color rgb<0.498, 0.396, 0.071>]
	[0.60 color rgb<0.710, 0.698, 0.490>]
	[1.00 color rgb<0.718, 0.706, 0.490>]
    }
    rotate <0.0, 0.0, 90.0>
  }
  finish {
    ambient 0.3
  }
  scale <2.0, 0.1, 2.0>
} 

//PINE BARK TEXTURE (by Sonya Roberts):
#declare SR_Pine =
texture {
  pigment {
    bozo
    turbulence 0.43
    color_map {
	[0.00 color rgb<0.612, 0.612, 0.612>]
	[0.21 color rgb<0.859, 0.859, 0.859>]
	[0.22 color rgb<0.310, 0.310, 0.310>]
	[0.28 color rgb<0.298, 0.298, 0.298>]
	[0.29 color rgb<0.859, 0.859, 0.859>]
	[0.40 color rgb<0.612, 0.612, 0.612>]
	[0.54 color rgb<0.459, 0.620, 0.573>]
	[0.76 color rgb<0.761, 0.761, 0.761>]
	[0.80 color rgb<0.267, 0.267, 0.267>]
	[0.84 color rgb<0.659, 0.659, 0.659>]
	[1.00 color rgb<0.800, 0.800, 0.800>]
    }
  }
  normal {
    wrinkles 0.37
    turbulence 0.27
  }
  finish {
    ambient 0.28
    phong 0.16
  }
  scale <0.1, 0.2, 0.1>
}

//REDDISH-BROWN BARK (based on Cherry_Wood):
#declare TdG_BrownBark =
texture {
  pigment {
    wood
    turbulence 5.0
    ramp_wave
    color_map {
        [0.4 rgb <0.66, 0.31, 0.20>]
        [0.8 rgb <0.40, 0.13, 0.06>]
        [1.0 rgb <0.20, 0.06, 0.03>]
    }
  scale 0.6
  }
  normal {
    wood, 1.0
    normal_map {
        [0.0 bozo, 5.0]
        [1.0 wood, 6.0]
    }
    turbulence 0.4
    ramp_wave
  }
  finish {
    ambient 0.2
  }
  scale <0.1, 2.0, 0.1>
}

/* "Eureka_Wood" texture declaration. 
   A dark, somewhat reddish brown wood with very tiny, delicate grain, augmented by a nearly subliminal 2nd
   layer consisting of faint black speckles elongated along the grain.
   Created by Charles Fusner 12/29/97... donated for use in derivative works. 
*/
#declare CF_EurekaWood =
texture {
  pigment {
    wood
    color_map {
      [ 0.00 color rgb <0.53, 0.23, 0.13> ]
      [ 0.45 color rgb <0.53, 0.23, 0.13> ]
      [ 0.55 color rgb <0.58, 0.28, 0.18> ]
      [ 1.00 color rgb <0.58, 0.28, 0.18> ]
    }
    scallop_wave
    scale .1
    warp { 
      turbulence < .04, .04, 0 > lambda 1.8 omega .375 }
    }
    finish {
      specular .05 
      roughness 1.0
      crand .1
    }
}
texture {
  pigment {
    granite
    color_map {
      [ 0.00 rgbt<0.25, 0.15, 0.15, 0.25> ]
      [ 0.05 rgbt<.58, .23, .13, 0.25> ]
      [ 0.10 rgbt<.58, .23, .13, 1.0> ]
      [ 1.00 rgbt<.58, .23, .13, 1.0> ]
    }
    frequency 6
    scale <1,1,100>
  }
  finish {
    specular .05 
    roughness 1.0
    crand .1
  }
}

// A few vegetation textures created by Bob Hugues.
// To be used as background simulation
#declare BH_Trees1 =
  texture {
    pigment {
      bumps turbulence .6 
      color_map {
        [.3 color rgb <.15,.425,.4>]
        [.5 color rgb <.3,.5,.425>]
      }
    }
    normal {
      bumps 1.3 turbulence .6
    }
    finish {
      ambient .125 diffuse .8 specular .1 roughness .3
    }
    scale .003
  }
#declare BH_Trees2 =
  texture {
    pigment {
      bumps turbulence .7 
      color_map {
        [.3 color rgb <.25,.55,.3>]
        [.5 color rgb <.375,.6,.2>]
      }
    }
    normal {
      bumps 1.2 turbulence .7
    }
    finish {
      ambient .15 diffuse .7 specular .15 roughness .2
    }
    scale .00275
  }
  
// A green grass:
#declare BH_Grass1 =
  texture {
    pigment {
      dents turbulence .3 
      color_map {
        [0 color rgb <.4,.7,.3>]
        [1 color rgb <.45,.55,.25>]
      }
    }
    normal {
      dents .6 turbulence .3
    }
    finish {
      ambient .175 diffuse .8 specular .075 roughness .075
    }
    scale .00225
  }

// A yellowish grass:
#declare BH_Grass2 =
  texture {
    pigment {
      bozo turbulence .3 
      color_map {
        [0 color rgb <.6,.5,.2>*1.3]
        [1 color rgb <.55,.45,.15>*1.2]
      }
    }
    normal {
      bozo .6 turbulence .3
    }
    finish {
      ambient .175 diffuse .8 specular .075 roughness .075
    }
    scale .002
  }


//===================================================
//===============  WATER MATERIALS  =================
//===================================================

#ifndef (Filter)        #declare Filter = 0.6;          #end
#ifndef (Transparency)  #declare Transparency = 0.6;    #end
#ifndef (ScaleX)        #declare ScaleX = 1;            #end
#ifndef (ScaleY)        #declare ScaleY = 1;            #end
#ifndef (ScaleZ)        #declare ScaleZ = 30;           #end
#ifndef (FD)            #declare FD = 10;               #end
#ifndef (FP)            #declare FP = 2.0;              #end

// TdG_NorthSeaWater macro
#macro TdG_NorthSeaWater (Filter,Transparency,ScaleX,ScaleY,ScaleZ,FD,FP) 
 material {   
   texture {      
     pigment {
       color rgbft <0.104167, 0.3125, 0.260417, Filter, Transparency> //Filter=1.0; Transparency=0.1;
     }      
     normal {
       waves , 0.05
       turbulence 0.5
       frequency 100.0
       phase 1.0
       ramp_wave
       scale  <ScaleX, ScaleY, ScaleZ>
     }      
     finish {
       ambient 0.15
       diffuse 0.0
       brilliance 5.0
       phong 1.0
       phong_size 90.0
       specular 0.4
       roughness 0.01
       conserve_energy
       reflection {
         .1,
         .9
         falloff 2
       }
     }      
   }   
   interior {
     ior 1.33
     fade_distance FD
     fade_power FP
     fade_color rgb <0.0, 0.437467, 0.0>
     media {
       samples 2,2
       absorption rgb <1.0, 0.05, 0.05>
     }
   }
 }
#end // end of macro

// TdG_RipplingWater macro
#macro TdG_RipplingWater (Filter,Transparency,ScaleX,ScaleY,ScaleZ,FD,FP)
 material {   
   texture {      
     pigment {
       color rgbft <0.444377, 0.826423, 0.768466, Filter, Transparency>
     }      
     normal {
       waves , 0.05
       turbulence 0.5
       frequency 100.0
       phase 1.0
       ramp_wave
       scale  <ScaleX, ScaleY, ScaleZ>
     }      
     finish {
       ambient 0.15
       diffuse 0.1
       brilliance 5.0
       phong 1.0
       phong_size 90.0
       specular 0.4
       roughness 0.01
       metallic 1.0
       conserve_energy
       reflection {
         .1,
         .9
         falloff 2
       }
     }      
   }   
   interior {
     ior 1.33
     fade_distance FD
     fade_power FP
     fade_color rgb <0.0, 0.437467, 0.0>
     media {
       samples 2,2
       absorption rgb <0.1, 0.05, 0.05>
     }
   }
 }
#end // end of macro

// A water material by Norbert Kern (see IRTC May-June 2001: Insects & Spiders, 1st place winner)
#declare NK_WaterMat =      
  material {     
    texture {
      pigment { rgbt <0.22, 0.22, 0.08, 1.20>/1.5 } 
      finish {
        ambient 0.0 
        diffuse 0.01 
        specular 1.35 
        roughness 0.06 
        //reflection_type 1 
        conserve_energy 
        metallic 0.5 
      }
    }   
    interior { 
      ior 1.43 
      fade_distance 0.03 
      fade_power 1001 
      fade_color <0.6+0.1, 0.8, 0.2>*0.7
    }
  }        

// A water material by Bog Hughes (see: omniVerse http://users.aol.com/persistenceofv/all.htm)
#ifndef (WaterIce)   #declare WaterIce = .9;               #end // water < > ice

#declare W1 =
  texture {
    pigment {
      ripples phase clock turbulence .5-(.25*WaterIce) frequency 3 
      color_map {
        [0 color rgbf <.5,.5+(.25*WaterIce),.5+(.15*WaterIce),.0125+(.775*WaterIce)>*(1.5-(1*WaterIce))]
        [1 color rgbf <.5,.5+(.25*WaterIce),.5+(.15*WaterIce),.0125+(.775*WaterIce)>*(2.5-(2*WaterIce))]
      }
      scale .01
    }
    normal {
      ripples .05-(.033*WaterIce) phase clock turbulence .75-(.25*WaterIce) scale .005-(.00125*WaterIce) scallop_wave
    }
    finish {
      ambient .25-(.2*WaterIce) 
      diffuse 1-(.75*WaterIce) 
      specular .75 
      roughness .005 
      phong .075 
      phong_size 10
      //reflection_type 0 
      reflection {
        .03*(10*WaterIce), 
        .09*(10*WaterIce) 
        falloff 1
        exponent .67
      }
      conserve_energy
    }
    scale .125
    translate <-.05,.015,-5+(.05*clock)>
  }

#declare W2 =
  texture {
    pigment {
      crackle turbulence .5-(.25*WaterIce) 
      color_map {
        [0 color rgbf <.5,.5+(.25*WaterIce),.5+(.15*WaterIce),.0125+(.775*WaterIce)>*(1.5-(1*WaterIce))]
        [1 color rgbf <.5,.5+(.25*WaterIce),.5+(.15*WaterIce),.0125+(.775*WaterIce)>*(2.5-(2*WaterIce))]
      }
      scale .05
    }
    normal {
      bozo .067-(.05*WaterIce) phase clock turbulence .25-(.25*WaterIce) scale .005-(.00125*WaterIce) scallop_wave
    }
    finish {
      ambient .25-(.2*WaterIce) 
      diffuse 1-(.75*WaterIce) 
      specular .75 
      roughness .005 
      phong .075 
      phong_size 10
      //reflection_type 0
      reflection {
        .03*(10*WaterIce), 
        .09*(10*WaterIce) 
        falloff 1
        exponent .67 
      }
      conserve_energy
    }
    scale .25
    // translate <-.05,.015,-5+(.05*clock)>
  }

#declare W3 =
  texture {
    pigment {
      crackle turbulence .5-(.25*WaterIce) 
      color_map {
        [0 color rgbf <.5,.5+(.25*WaterIce),.5+(.15*WaterIce),.0125+(.775*WaterIce)>*(1.5-(1*WaterIce))]
        [1 color rgbf <.5,.5+(.25*WaterIce),.5+(.15*WaterIce),.0125+(.775*WaterIce)>*(2.5-(2*WaterIce))]
      }
      scale .005
    }
    normal {
      wrinkles .075-(.067*WaterIce) phase clock turbulence .25-(.125*WaterIce) scale .0025-(.00125*WaterIce) triangle_wave
    }
    finish {
      ambient .25-(.2*WaterIce) 
      diffuse 1-(.75*WaterIce) 
      specular .75 
      roughness .005 
      phong .075 
      phong_size 10
      //reflection_type 0 
      reflection {
        .03*(10*WaterIce), 
        .07*(10*WaterIce) 
        falloff 1
        exponent .67 
      }
      conserve_energy
    }
    scale .5
    // translate <-.05,.015,-5+(.05*clock)>
  }

#declare BH_Water = 
  material {
    texture {
      bozo turbulence 1.5 frequency 1 
      texture_map {
        [0.15 W1]
        [0.20 W2]
        [0.40 W2]
        [0.45 W3]
        [1.00 W3]
      } 
    scale .125
    }
    interior {
      fade_distance .01 fade_power 1000 fade_color <.5,.6,.8>
    }
  }

// A water material by "Just a random raytracer" (from the POV-Ray newsgroup, 09/05/03)
#declare r_0 = normal { bozo 0.2 scale 1.2 }
#declare r_1 = normal { bozo 0.7 scale 0.5 }
#declare r_2 = normal { bozo 0.8 scale 0.11 }
#declare r_3 = normal { bozo 0.6 scale 0.027 }
#declare r_4 = normal { bozo 0.1 scale 0.0039 }

#declare JRR_ShimmeringWater =
  material{
    texture {
      pigment {
	color rgbf <0.8,0.8,1.0,0.97>
      }
      finish {
	diffuse 0.0
	ambient 0.0
	specular 0.3
	roughness 0.001
	reflection {
	  0.1, 0.8
	  fresnel on
	}
	conserve_energy
      }
      normal {
	average 
	normal_map {
	  [ 1 r_3 ]
	  [ 1 r_2 ]
	  [ 1 r_1 ]
	  [ 1 r_0 ]
	}
	scale 4
      }
    }
    interior { 
      ior 1.33 
      fade_distance 7
      fade_power 1
      fade_color <0.3, 0.25, 0.2>
    }
  }


//========================================================
//===============  CONSTRUCTION MATERIALS  ===============
//========================================================

// Eroded plastered brickwall (TdG 1999):
#declare CementTex_1 = 
   texture
   {   
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <0.499564, 0.499564, 0.499564, 0.0, 0.0> ]
            [ 0.25    rgbft <0.649707, 0.649707, 0.649707, 0.0, 0.0> ]
            [ 0.5     rgbft <0.499858, 0.499858, 0.499858, 0.0, 0.0> ]
            [ 0.75    rgbft <0.699587, 0.699587, 0.699587, 0.0, 0.0> ]
            [ 1.0     rgbft <0.499644, 0.499644, 0.499644, 0.0, 0.0> ]
         }
         frequency 100.0
         ramp_wave
      }   
      normal
      {
         crackle , 1.0
         warp
         {
            turbulence <0.500164, 0.500364, 0.499804>

            omega 0.500404
            lambda 1.999712
         }
      }   
      finish
      {
         ambient 0.2
         diffuse 0.549996
         specular 0.1
         roughness 1.0
      }   

      //  This texture was originally designed by Charles Fusner.

   }

#declare BrickTex_1 = 
   texture  // txt_179_1
   {   
      pigment
      {
         color rgb <0.0, 0.0, 0.0>
      }
   }
   texture  // T_Grnt17a_1
   {   
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <0.027, 0.012, 0.012, 0.0, 0.0> ]
            [ 0.034   rgbft <0.851, 0.812, 0.741, 0.235, 0.0> ]
            [ 0.342   rgbft <0.792, 0.694, 0.69, 0.839, 0.0> ]
            [ 0.462   rgbft <0.631, 0.506, 0.471, 0.608, 0.0> ]
            [ 0.632   rgbft <0.851, 0.812, 0.741, 0.922, 0.0> ]
            [ 0.983   rgbft <0.647, 0.655, 0.655, 0.282, 0.0> ]
            [ 1.0     rgbft <0.027, 0.012, 0.012, 0.0, 0.0> ]
         }
         turbulence 0.6
         ramp_wave
      }
   }
   texture  // T_Grnt3a_1
   {   
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <0.831, 0.631, 0.569, 0.447, 0.0> ]
            [ 0.153   rgbft <0.925, 0.831, 0.714, 0.678, 0.0> ]
            [ 0.297   rgbft <0.871, 0.702, 0.659, 0.475, 0.0> ]
            [ 0.441   rgbft <0.831, 0.631, 0.569, 0.918, 0.0> ]
            [ 0.763   rgbft <0.937, 0.882, 0.82, 0.655, 0.0> ]
            [ 1.0     rgbft <0.831, 0.631, 0.569, 0.447, 0.0> ]
         }
         turbulence 0.6
         ramp_wave
      }   
      finish
      {
         ambient 0.2
         diffuse 0.079133
         phong_size 0.0
         specular 0.1
         roughness 0.503733
      }
   }

#declare PlasterTex_1 = // Crackled Plaster
   texture {   
      pigment {
         granite
         color_map {
            [ 0.0  rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 0.2  rgbft <0.9, 0.9, 0.9, 0.0, 0.0> ]
            [ 0.8  rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
            [ 1.0  rgbft <0.99, 0.99, 0.99, 0.0, 0.0> ]
         }
      }   
      normal {
         bumps , 0.5
         turbulence 0.7
         ramp_wave
         scale  0.5
      }   
      finish {
         ambient 0.1
      }   
      scale  0.5
   }

#declare TdG_ErodedPlasteredBricks = // = TdG_OldPlasteredBricks in Moray
      texture {
         bozo
         texture_map {
            [0.0  brick
                     texture { CementTex_1 }
                     texture { BrickTex_1 }
                     //rotate -90.0 * x
                  brick_size <0.15, 0.1, 0.15>
                  mortar 0.01
            ]
            [0.39 brick
                     texture { CementTex_1 }
                     texture { BrickTex_1 }
                     //rotate -90.0 * x
                  brick_size <0.15, 0.1, 0.15>
                  mortar 0.01
            ]
            [0.4  PlasterTex_1 ]
            [1.0  PlasterTex_1 ]

         }
         //warp {turbulence <1.0, 2.0, 3.0>}
      }

#declare Fungus1 =
  texture { pigment {color rgbt <0.88, 1.0, 0.65,0.5>} finish {ambient 0.1}}

#declare Fungus2 =
  texture { pigment {color rgbt <0.88, 1.0, 0.65,0.2>} finish {ambient 0.1}}

#declare Fungus3 =
  texture { pigment {color rgbt <0.88, 1.0, 0.65,0.0>} finish {ambient 0.1}}

#declare TdG_ErodedFungyPlasteredBricks = // = TdG_OldFungyPlasteredBricks in Moray
      texture {
         bozo
         texture_map {
            [0.0  TdG_ErodedPlasteredBricks]
            [0.5  TdG_ErodedPlasteredBricks]
            [0.8  Fungus1]
            [0.9  Fungus2]
            [1.0  Fungus3]

         }
      }

/*#declare TdG_NewspaperPlaster =
  texture {
    bozo
    texture_map {
      [0.0   brick
             texture { CementTex_1 }
             texture { BrickTex_1 }
             brick_size <0.1, 0.075, 0.1>
             mortar 0.01
      ]
      [0.39  brick
             texture { CementTex_1 }
             texture { BrickTex_1 }
             brick_size <0.1, 0.075, 0.1>
             mortar 0.01
      ]
      [0.4   pigment {
               image_map {
                 png   "C:\VirtualReality\Data files\images\ImageMaps\Newspaper1.png" 
               }
               scale <-1,1,1>
             }                        
             normal {bumps , 0.5 turbulence 0.7 ramp_wave scale  0.5}   
             finish {ambient 0.1}   
             scale  15.0
             translate <-1,-2.0,0>
      ]
      [1.0   pigment {
               image_map {
                 png   "C:\VirtualReality\Data files\images\ImageMaps\Newspaper1.png" 
               }
               scale <-1,1,1>
             }                        
             normal {bumps , 0.5 turbulence 0.7 ramp_wave scale  0.5}   
             finish {ambient 0.1}   
             scale  15.0
             translate <-1,-2.0,0>
      ]
    }
    scale 0.02
  }
  
#declare TdG_OldFungyNewspaperBricks = 
      texture {
         bozo
         texture_map {
            [0.0  TdG_NewspaperPlaster ]
            [0.5  TdG_NewspaperPlaster ]   
            [0.8  Fungus1]
            [0.9  Fungus2]
            [1.0  Fungus3]
         }

      }
*/
//===================================================
//===============  METALLIC TEXTURES  ===============
//===================================================
#declare TdG_RustyIron = 
  texture {      
    pigment {
     granite
     color_map {
      [ 0.0     rgbft <0.42, 0.2, 0.2, 0.0, 0.0> ]
      [ 0.3879  rgbft <0.593733, 0.302067, 0.02, 0.0, 0.0> ]
      [ 0.508897  rgbft <0.5104, 0.2, 0.2, 0.0, 0.0> ]
      [ 0.654804  rgbft <0.3, 0.2, 0.2, 0.0, 0.0> ]
      [ 1.0     rgbft <0.3, 0.2, 0.2, 0.0, 0.0> ]
     }
    }      
    normal {
     bozo , 1.0
     bump_size 0.5
     scale  <0.08, 0.07, 0.06>
    }
  }

#declare TdG_RustyIron2 = 
  texture {
   pigment {
    bumps  
    color_map {
      [0.000 color rgb <1.000, 0.500, 0.000 > ] 
      [0.200 color rgb <1.000, 0.500, 0.250 > ] 
      [0.400 color rgb <0.500, 0.250, 0.000 > ] 
      [0.600 color rgb <0.500, 0.000, 0.000 > ] 
      [0.800 color rgb <0.500, 0.250, 0.250 > ] 
      [1.000 color rgb <0.000, 0.000, 0.000 > ]
    } 
    turbulence 20 
    lambda 2 
    omega 0.5 
    octaves 3 
    frequency 1 
    phase 0 
    scale 1
   } 
   normal {
    bumps 5 
    turbulence 100 
    lambda 2 
    omega 0.5 
    octaves 3 
    frequency 1 
    phase 0 
    scale 1 
   } 
   finish {
    specular 0.3 
    roughness 0.15 
   } 
   scale <20,20,20> 
   rotate <0,0,0>
  }

