//GeDesert.pov for POV-Ray 3.5  (c) 2004 Ch. Gerber 
//you have to render dunes.pov at a resolution of 2048x2048 to get the heightfield before rendering this scene

#include "colors.inc"
#include "functions.inc"

//--- Control ---

#declare clouds     = 1;
#declare sand       = 1;
#declare rocks      = 1;

global_settings {max_trace_level 50 assumed_gamma 2.6}


//--- Camera, sun & sky ---
  
camera {
  location <0,20,0>
  right <16/9,0,0>
  look_at <0,35,100>
}

light_source {
  -1000000*z
  color rgb <1,0.9,0.8>*1.3
  area_light <75000,0,0>,<0,75000,0>,5,5 
  jitter 
  adaptive 1
  circular
  orient
  rotate <30,60,0>
  parallel
  point_at <0,0,0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.5,0.7,0.8>]
      [0.2 rgb <0.5,0.7,0.8>]
      [0.6 rgb <0.2,0.2,0.8>]
    }
  }    
}

fog {
  fog_type 2
  distance 5000
  fog_offset 0
  fog_alt 400
  color rgb <0.8,0.85,0.9>
}

plane {z,0 hollow
  pigment {image_map {tga "moon_alpha.tga" interpolate 2 once} translate <-0.5,-0.5,0>} 
  finish {ambient 1.2 diffuse 0}
  scale 250000
  translate 1400000*z
  rotate <-20,20,0>
}

//--- Clouds ---

#if (clouds = 1)

#declare CloudTex = texture {
  pigment {
    bozo
    turbulence 0.65
    octaves 4
    omega 0.7
    lambda 2
    color_map {
      [0.0, 0.1   color rgbf <1,1,1,0.0> color rgbf <1,1,1,0.5>]
      [0.0, 0.5   color rgbf <1,1,1,0.3> color rgbf 1]
      [0.5, 1.001 color rgbf 1 color rgbf 1]
    }
    scale <6, 1, 6>
  }
  finish {ambient 1 diffuse 0}
}    

#declare nc = 0;

#while (nc < 5)
  plane {
    y, 200-nc hollow
    texture {CloudTex scale (1-0.05*nc)*100 translate 50*y rotate 10*y}
    scale 20
    no_shadow
    photons {collect off}
  }    
  #declare nc = nc + 1;
#end

#end //clouds


//--- sand ---

#if (sand = 1)

#declare SandTex = texture {
  pigment {
    bozo
    turbulence 1
    color_map {
      [ 0.00 color rgb <1.000,0.954,0.800>]
      [ 0.35 color rgb <0.999,0.955,0.814>]
      [ 0.63 color rgb <1.000,0.957,0.823>]
      [ 1.00 color rgb <1.000,0.954,0.800>]
    }
    scale 10
  }
  normal {
    average 
    normal_map {
      [1.0 bumps 0.05 turbulence 0.3 scale <0.2,0.2,1.0>]
      [1.0 ripples 0.4 frequency 2 turbulence 0.2 octaves 10 lambda 1 scale <2,2,10> translate -100*y rotate 60*y]
    } 
  }
  finish {ambient 0.1 diffuse 1.0 specular 0.1 roughness 0.5 brilliance 1}
}
  
#declare Dunes = height_field {tga "dunes.tga" smooth translate <-0.5,0,-0.5>}

object {
  Dunes rotate 180*y
  scale <4000,75,4000>
  translate <0,-50,1950>
  texture {SandTex}
}

object {
  Dunes rotate 90*y
  scale <12000,225,12000>
  translate <0,-150,10000>
  texture {SandTex}
}
  
#end //sand


//--- rocks ---

#if (rocks = 1)

#macro m_strata (freq, amnt)
  function {f_noise3d(y*freq+f_noise3d(y+f_noise3d(x*4,y*4,z*4),z,x)*amnt,0,0)}
#end

#declare RockTex = texture {
  pigment {
    m_strata (5,1) 
    turbulence 0.5 
    color_map {
      [0.00 0.29 color rgb <0.69,0.61,0.65> color rgb <0.97,0.78,0.42>]
      [0.29 0.31 color rgb <0.97,0.78,0.42> color rgb <0.69,0.61,0.65>]
      [0.31 0.43 color rgb <0.69,0.61,0.65> color rgb <0.93,0.96,0.78>]
      [0.43 0.64 color rgb <0.93,0.96,0.78> color rgb <0.65,0.75,0.65>]
      [0.64 0.69 color rgb <0.65,0.75,0.65> color rgb <1.00,0.95,0.95>]
      [0.69 1.00 color rgb <1.00,0.95,0.95> color rgb <0.69,0.61,0.65>]
    }
    scale 10
  }
  normal {granite 0.2 turbulence 0.5 scale 0.01} 
  finish {ambient <0.25,0.15,0.05> diffuse 0.7 specular 0.1 roughness 0.5 brilliance 2}
}

#declare f1_spl = function {
  spline {
  natural_spline
  -4.0,<1.0,0.0,0>,
  -3.8,<1.0,0.0,0>,
  -3.5,<0.1,0.2,0>,
  -3.0,<0.1,0.1,0>,
  -2.2,<0.1,0.3,0>,
  -2.0,<0.1,0.2,0>,
  -1.5,<0.2,0.3,0>,
  -1.0,<0.2,0.2,0>,
  -0.6,<0.1,0.2,0>,
   0.1,<0.2,0.1,0>,
   0.4,<0.1,0.3,0>,
   0.9,<0.2,0.1,0>,
   1.2,<0.1,0.2,0>,
   1.8,<0.0,0.0,0>,
   2.3,<0.1,0.2,0>,
   2.5,<0.1,0.3,0>,
   2.9,<0.0,0.0,0>,
   3.8,<0.1,0.1,0>,
   4,  <0.0,0.0,0>
  }
}

#declare Erode1 = function {pigment {spotted turbulence 0.2 scale <1,0.5,1>}}
#declare Erode2 = function {pigment {dents turbulence 0.5 scale <0.3,0.1,0.3>}}

#declare RockWall = object {
  isosurface {
    function {f_rounded_box(x,y,z, 0.75,3,4,2) - f1_spl(y).y + 0.5*Erode1(x,y,z).gray + 0.05*Erode2(x,y,z).gray}
    max_gradient 2.2
    contained_by {box {<-4,-5,-3>,<4,5,3>}}
  }
}

#declare RockPillar = object {
  isosurface {
    function {f_rounded_box(x,y,z, 0.75,1,4,1) - f1_spl(y).y + 0.5*Erode1(x,y,z).gray + 0.05*Erode2(x,y,z).gray}
    max_gradient 2.2
    contained_by {box {<-2,-5,-2>,<2,5,2>}}
  }
}

#declare RoundRock = object { 
  isosurface {   
    function {f_sphere(x,y,z,2) + 0.5*Erode1(x,y,z).gray}
    max_gradient 2.0
    contained_by {box {<-3,-3,-3>,<3,3,3>}}
  }             
}

object {RockWall   scale 150 rotate <0, 40,170> translate <1550, 200,1550> texture {RockTex}} //right, front
object {RoundRock  scale <2.5,0.5,2>*75         translate <930,    0,1300> texture {RockTex}}
object {RoundRock  scale <3,1.5,2>*5 rotate 90*y translate <775,  65,1300> texture {RockTex}}
object {RockPillar scale 120 rotate <0,  0,180> translate <1100,-300,1500> texture {RockTex}}

object {RockPillar scale 100 rotate <0,  0,180> translate < 900, 150,2000> texture {RockTex}} //middle
object {RoundRock  scale <2,1.5,2>*15 rotate 90*y translate <930,550,2000> texture {RockTex}}
object {RoundRock  scale  50 rotate <0, 90,  0> translate < 750, -50,1800> texture {RockTex}}

object {RockPillar scale 125 rotate <0, 90,  0> translate <1050, 200,3500> texture {RockTex}} //left, back
object {RockPillar scale  75 rotate <0,-90,180> translate < 800, 150,3000> texture {RockTex}}
object {RoundRock  scale  75 rotate <0,-90,  0> translate < 800, -25,2500> texture {RockTex}}

#end //rocks
