//our time is running out, our time is running out, can't put us on the ground, you can't stop us screaming out, how did it come to this?
//+kfi0 +kff1 (remove these to render only pass 2)

//scene switches, these sometimes get overridden later.
#if (1)
	//standard
	#declare glassEnabled = on;
	#declare rad = on;
	#declare useRadFile = on;
	#declare areaLights = on;
	#declare hfMip = 0;
	#declare maxInter = 12;
#else
	//low quality test
	#declare glassEnabled = off;
	#declare rad = off;
	#declare useRadFile = off;
	#declare areaLights = off;
	#declare hfMip = 2;
	#declare maxInter = 8;
#end

#include "rad_def.inc"
#include "shapes.inc"

global_settings {
	max_intersections maxInter
#if (rad)
	radiosity {
		#if (!useRadFile | frame_number<final_frame)
			Rad_Settings(Radiosity_Fast,on,on)
			#declare radRender = on;
			#if (useRadFile)
				save_file "desert_time.rad"
				#declare glassEnabled = off;
			#end
		#end
		#if (useRadFile & frame_number=final_frame)
    	pretrace_start 1 pretrace_end 1 
			load_file "desert_time.rad"
      error_bound 0.4	//the same
      recursion_limit 1
			always_sample off
		#end
		gray_threshold 1
	}
#end
}


#if (rad)
	#default { pigment { rgb 1 } finish { diffuse .7 ambient 0 } }
#else
	#default { pigment { rgb 1 } finish { diffuse .7 ambient .3 } }
#end

#declare hourglassSpline = array[9] {
		<1,-9>,
		<1,-1>,
		<.87,-.5>,
		<.12,-.1>,
		<.007,0>,
		<.12,.1>,
		<.87,.5>,
		<1,1>,
		<1,9>
}
#declare hourglassNumPoints = dimension_size( hourglassSpline, 1 );

#declare hourglassShapeInner =
	sor {
		hourglassNumPoints
		#local i=0;
		#while (i < hourglassNumPoints)
			hourglassSpline[i]
			#local i = i+1;
		#end
		sturm
		scale <1,1.5,1>
	}

#declare hourglassShapeInnerShift = //nudge outwards fractionally
	#local f = .005;
	sor {
		hourglassNumPoints
		#local i=0;
		#while (i < hourglassNumPoints)
			hourglassSpline[i]+f*u
			#local i = i+1;
		#end
		sturm
		scale <1,1.5,1>
	}

#declare hourglassShapeOuter =
	#local f = .01;
	sor {
		hourglassNumPoints
		#local i=0;
		#while (i < hourglassNumPoints)
			hourglassSpline[i]*<.92,.99>+<.08,0>+f*u
			#local i = i+1;
		#end
		sturm
		scale <1,1.5,1>
	}

/*glitchy:
	lathe {
		bezier_spline
		16
		<0,1>,<0,1>,<1,1>,<1,1>,
		<1,1>,
			<1,.2>,
			<.02,.2>,
		<.02,0>,
		<.02,0>,
			<.02,-.2>,
			<1,-.2>,
		<1,-1>
		<1,-1>,<1,-1>,<0,-1>,<0,-1>*/



//hourglass objects, origin = pinch in the glass.
union {
	#declare sand =
		texture {
			pigment {
				//checker rgb 0, rgb 1 scale .3	//surreal!
				crackle
				solid
				scale 0.001
				#local f=1;//.7;	//radiosity tends to multiply the colour by itself (through interreflection) so balance for that. maybe, or could use gray_threshold
				colour_map {
					[0	rgb <pow(.9,f),pow(.8,f),pow(.5,f)>] //.9,.8,.5
					[1	rgb <pow(1,f),pow(1,f),pow(.9,f)>] //1,1,.9
				}
			}
			finish {
				//specular 1 roughness .01
				phong 1 phong_size 100
			}
			normal {
				facets 1
				coords 1
				scale 0.001
			}
		}

	//upper sand
	intersection {
		object { hourglassShapeInner }
		height_field {
			function 512/pow(2,hfMip), 512/pow(2,hfMip) { 
				max(0,.13+.15*sin(pi*20*sqrt((x-.5)*(x-.5)+(y-.5)*(y-.5))))
			}
			translate -.5
			scale <2,.4,2>
			translate .2*y
		}
		plane { -y, -.02 } 
		texture { sand }
		no_shadow
	}
	
	//lower sand
	intersection {
		object { hourglassShapeInner }
		height_field {
			function 2048/pow(2,hfMip), 2048/pow(2,hfMip) { //why do programmers always use power of 2's???! :)
				pigment {
					average
					pigment_map {
						[1 spotted  translate 7/.6 scale .6]
						[.03 spotted scale <.01,.05,.05> rotate 47 warp { turbulence .2 octaves 2 } ]
					}
				}
			}
			smooth
			translate -.5
			scale <2,.8,2>
			translate -.7*y
		}
		texture { sand }
	}
	
	//falling sand
	union {
		cylinder { <0,0,0>, <0,1,0>, .01 }
		//box { -1, 1 scale <.01,.5,.001> translate y/2 }
		//double_illuminate
		hollow on
		texture {
			pigment_pattern {
				slope { -z }
				pigment_map {
					[0 rgb 0]
					[1
						average
						pigment_map {
							[.2 gradient y poly_wave 5]
							[1 crackle solid scale 0.001]
						}
					]
				}
			}
			texture_map {
				[.4 pigment { rgbt 1 }]
				[.4 sand]
			}
		}
		scale .721*y
		translate -.7*y
	}
	
	//pile of sand
	cone { -.7*y, .2, -.5*y, 0 texture { sand } }
	
	//some guy
	#include "time_guy.inc"
//#local test =
	object { time_guy double_illuminate
	//scale .17*<-1,1,1> rotate <5,150,-2> translate <.35,-.62,-.25> }
	//scale .16*<-1,1,1> rotate <5,150,-2> translate <.30,-.60,-.13> } //moved so he's not through the glass
	scale .18*<-1,1,1> rotate <5,150,-2> translate <.25,-.59,-.18> } //scaled up to rebalance the scene
//intersection { object { test } object { hourglassShapeInnerShift inverse } }
	

	//glass
#if (glassEnabled)	
	difference {
		object { hourglassShapeOuter }// scale <1.03,.99,1.03> }
		object { hourglassShapeInnerShift } //avoid coincidence with sand.
		texture {
			pigment { rgbt 1 }
			finish { phong 2 phong_size 600 reflection { 0, 1 fresnel } conserve_energy } // specular 1 roughness 0.001
		}
		interior_texture {
			pigment { rgbt 1 }
			finish { reflection { 0, 1 fresnel } conserve_energy } //no specular
		}
		interior { ior 1.5 }
	}
#end //glassEnabledg


#ifdef (radRender)
	//infinite desert
	plane { y, -1 texture { sand } }
#else
	//background
	plane { -z, -1000 pigment { rgb 0 } no_reflection no_shadow }
#end
	
	translate <-.5,.4,1.5>
	
	scale 1000	//fix some accuracy problems in the mesh. Looks like pov's got a hard coded threshold...
}


sky_sphere {
	pigment {
		gradient y
		scale 2 translate -1
		colour_map {
			[.5 rgb <.1,.05,.0>]
			[.5 rgb <.3,.5,.7>*1.2]// @@@@@@@hi-res had this@@@@@@@@ *1.5]
		}
	}
}


//use a bit of 3 point lighting, but let saved rad be the fill light
light_source { <3,2,-1>*10000, rgb 1  //key
	#if (areaLights) area_light z*2000,y*2000,4,4 adaptive 1 orient jitter #end
}
light_source { <.2,1,3>*10000, rgb 1.2  //highlight
	#if (areaLights) area_light x*10000,y*10000,4,4 adaptive 1 orient jitter #end
}


camera {
	right			x*image_width/image_height
	up				y
	direction	z*1
	
	//location <.3,0,.8>
	
	//location y*2	look_at y+z
	//look_at <.35,-.59,-.33>+<-.5,.4,1.5>
	//look_at <-.3,-.02,1>
	//look_at <-.33,.3,1>
	//look_at <-.5,0,1.5>
	scale 1000
}

