// Persistence of Vision Ray Tracer Scene Description File
// File: Mirage.pov
// Vers: 3.6
// Desc: Mirage in the desert ?
// Date: 18 juillet 2004
// Auth: Philippe BARTKOWIAK
// Nickname : GRAPHIKTO

#version 3.6;

#include "functions.inc"
#include "math.inc"
#include "consts.inc"
#include "colors.inc"
#include "glass.inc"
#include "woods.inc"


#declare Photons=1;
#declare test=0;
#declare RMF = function{ f_ridged_mf(x, y, z, 0.07, 2.2,  7, 0.6, 0.9, 1)}
#declare colChair=rgb<1,0.8,0.6>;      
#declare CoT = 1; // Longueur & Largeur Table
#declare Rp = 0.03; // Rayon pied
#declare HT = 0.3; // Hauteur table
#declare ET = 0.06; // Epaisseur table
#declare EC = 0.04; // Epaisseur chaise
#declare LoC = 1.5; // Longueur chaise
#declare LaC = 0.6; // Largeur chaise
#declare LoCo = LaC-0.1; // Largeur coussin
#declare HC = 0.2; // Hauteur chaise


#default { texture { pigment {rgb <0.7,0.7,0.7>}}}


global_settings {
  assumed_gamma 1.0
  max_trace_level 15
  #if (Photons)          // global photon block
    photons {
      spacing 0.002      // specify the density of photons
      count 2000000      // alternatively use a total number of photons
      jitter 1.0         // jitter phor photon rays
      autostop 0         // photon autostop option
    }
  #end
}


// ----------------------------------------

camera {
 location <4, 8, -15>  look_at <-1,0,3.5>
  direction 2*z                        // which way are we looking <X,Y,Z> & zoom
  sky       y                          // for tilting the camera
  up        y                          // which way is +up <X,Y,Z> (aspect ratio with x)
  right x*image_width/image_height     // which way is +right <X,Y,Z> (aspect ratio with y)
  angle 50                             // overrides "direction" with specific angle
}


sky_sphere {  pigment { gradient y
    color_map {	[0.0 rgb <0.25,0.5,1>]
      				[0.5 rgb <0.1,0.3,1>]    }
} }

light_source { <-300, 300, -300>
  color rgb <3.43/2,2.87/2,1>
  #if (Photons)
  photons { refraction on reflection on }
  #end
}


#declare Eau =
material { texture { pigment { color rgbf 1 } 
                     normal  { bumps 0.07  scale 0.1 }
                     finish  { ambient 0 diffuse 0 specular 0.8 roughness 0.03  reflection { 0.0, 1.0 } } }
                           interior { ior 1.33 
                                      fade_distance 2
                                      fade_power 1001
                                      media { scattering { 2 <0.5, 0.65, 0.4> extinction 1 } }
                                    } }

#declare Bois =  texture {T_Wood4}
#declare Bois2 =  texture {T_Wood22}

#declare CarSwim = material { texture { pigment { color rgb <0.6, 1, 0.7> } 
                                         finish { ambient 0.1  diffuse 0.7 reflection 0.05} } } 

#declare Bord =  texture { pigment { color White } 
                            finish { ambient 0.1  diffuse 0.7 reflection 0.05} } 

#declare Tpar= texture { pigment { gradient y
                			 				color_map{	[0.0 color rgb <0, 0.5, 1>]
                       									[0.5 color rgb <0, 0.5, 1>]
                       									[0.5 color White]
                       									[1 color White]  } }
        						 finish{ambient 0.1 specular 0.01 roughness 0.1} }     

#declare Tcouss= texture { pigment { gradient z
                			 				color_map{	[0.0 color rgb <0, 0.5, 1>]
                       									[0.5 color rgb <0, 0.5, 1>]
                       									[0.5 color White]
                       									[1 color White]  } }
        						 finish{ambient 0.1 specular 0.01 roughness 0.1} }     


// ----------------------------------------
#declare Dunes= 
difference {
	isosurface {
		function {y - RMF(x, y, z)*0.2}
		threshold 0
		max_gradient 1.75
		contained_by {box {<-10,-1,-10>, < 10, 1, 10>}}
		translate <-1.8, -0.01, 1.8> }
	box { <-6, -3, -3.5>, <6, 3, 3.5> 	scale <1/20, 1/10, 1/20> }
}

// La piscine
#declare Swim = difference {
	box { <-6, -3, -3.5>, <6, 0.1, 3.5> }
	box { <-5, -4, -2.5>, <5, 1, 2.5> }
   	texture { pigment {	
  brick      
  color rgb <0.7, 0.7, 0.7>,    // color of mortar
  color rgb <1, 1, 1>           // color of brick
  brick_size <0.1, 0.1, 0.1>
  mortar     0.015
	}
finish { ambient 0.1  diffuse 0.7 reflection 0.05 } }
photons { refraction off  reflection on }
}


#declare Trou = box { <-10.5, -1, -1.5>, <10, 1, 1.5> 
	rotate -10*z
	translate 0*x }

 #declare IntSwim = difference {
	box { <-5, -3, -2.5>, <5, -0.2, 2.5> }
	object { Trou } }

 #declare IntSwimC = union {
	object { IntSwim }
	box { <4.99, -3, -1.6>, <5, -0.2, 1.6> }
		material { CarSwim }
  normal {
    quilted 0.2
	 control0 1/3 control1 2/3
    scale 0.08 }
photons { refraction off  reflection on }
 }

// L'eau
#declare Flotte = box { <-5.1, 0, -2.51>, <5.1, -3, 2.51>  material {Eau }
  photons { target reflection off refraction on  } 
}


// La table + Parasol + Verres
#declare TableH =difference {
 union {
	box { <-CoT/2, HT-ET, -CoT/2+Rp>, <CoT/2, HT, CoT/2-Rp> }
	box { <-CoT/2+Rp, HT-ET, -CoT/2>, <CoT/2-Rp, HT, CoT/2>}
	cylinder { <-CoT/2+Rp, HT-ET, -CoT/2+Rp >, <-CoT/2+Rp, HT, -CoT/2+Rp>, Rp }
	cylinder { <CoT/2-Rp, HT-ET, -CoT/2+Rp >, <CoT/2-Rp, HT, -CoT/2+Rp>, Rp }
	cylinder { <CoT/2-Rp, HT-ET, CoT/2-Rp >, <CoT/2-Rp, HT, CoT/2-Rp>, Rp }
	cylinder { <-CoT/2+Rp, HT-ET, CoT/2-Rp >, <-CoT/2+Rp, HT, CoT/2-Rp>, Rp }
 }
	cylinder { 0, y, 0.025 }
texture { Bois scale 0.2}}

#declare Table = union {
	object { TableH }
	cylinder { <-CoT/2+Rp, 0, -CoT/2+Rp >, <-CoT/2+Rp, HT-ET, -CoT/2+Rp>, Rp }
	cylinder { <CoT/2-Rp, 0, -CoT/2+Rp >, <CoT/2-Rp, HT-ET, -CoT/2+Rp>, Rp }
	cylinder { <CoT/2-Rp, 0, CoT/2-Rp >, <CoT/2-Rp, HT-ET, CoT/2-Rp>, Rp }
	cylinder { <-CoT/2+Rp, 0, CoT/2-Rp >, <-CoT/2+Rp, HT-ET, CoT/2-Rp>, Rp }
texture { Bois rotate 90*x  scale 0.2}
}

#declare Parasol = difference {
	superellipsoid { <1.5, 1.5> scale <0.8, .3, 0.8> translate 1.3*y }
	box { <-2, 1, -2>, <2, 1.3, 2> } 
	texture { Tpar  scale 0.1*y translate 1.3*y}
}

#declare TablePara = union {
	object { Table }
	cylinder { 0, 1.5*y, 0.015 }
	object { Parasol rotate 48*y}
	object { Parasol rotate 3*y}
}


#declare Glass= difference {
	cylinder { <0, 0, 0>, <0, 2, 0>, 0.5 }
	cylinder { <0, 0.6, 0>, <0, 3, 0>, 0.48 }
	sphere { <0, 0.6, 0>  0.48  scale <1,1,1> }
   texture {T_Glass1}
   interior {ior 1.5}
}

#declare Boisson= merge {
	cylinder { <0, 0.6, 0>, <0, 1.6, 0>, 0.479999 }
	sphere { <0, 0.6, 0>  0.479999  scale <1,1,1> }
   pigment {rgbf <0.9, 0.9, 0.1, 0.95>}
   finish {reflection 0.3}
   interior{ior 1.2}
}

#declare Verre= union {
   object { Glass }
   object { Boisson }
   photons { target refraction on reflection on collect off }
}


// La chaise
#declare SupportC = box { <0, 0, -LaC/2>, <LoC, EC, LaC/2> }
#declare Dossier = box { <0,0 ,-LaC/2>, <-LoC/3,EC ,LaC/2> }
#declare Coussin = superellipsoid { <0.1, 0.1> scale <(LoCo)/2, 0.04, (LaC-0.03)/2> texture { Tcouss scale 0.2 }}
#declare PiedD = box { <-0.03, 0, -LaC/2>, <0.03, -HC*2, -LaC/2+0.1> }
#declare PiedG = box { <-0.03, 0, LaC/2>, <0.03, -HC*2, LaC/2-0.1> }
#declare Pieds = union {
	object { PiedD texture { Bois scale 0.2 rotate 90*x } }
	object { PiedG texture { Bois scale 0.2 rotate 90*x } }
	cylinder { <0, -0.18, -LaC/2>, <0, -0.18, LaC/2>, 0.015 texture { Bois scale 0.2}}
}

#declare Chaise = union {
	object { SupportC texture { Bois scale 0.2}}
	object { Coussin translate <(LoCo)*0.5, 0.04*2, 0> }
	object { Coussin translate <(LoCo)*1.5, 0.04*2, 0> }
	object { Coussin translate <(LoCo)*2.5, 0.04*2, 0> }
	object { Coussin translate <-(LoCo+0.02)*0.5, 0.04*2, 0> rotate -45*z}
	object { Dossier rotate -45*z texture { Bois scale 0.2}}
	object { Pieds rotate -45*z translate <0.2, 0.01, 0> }
	object { Pieds rotate 45*z translate <LoC-0.2, 0.01, 0> }
}


// Ici les objets
#if (test)
	plane { y, 0  pigment { color rgb <0.7,0.5,0.3> }}
	#declare Palmier = cylinder {  0*y,  3*y,  0.2 }

#else
	#include "PALM2.inc"		// palm2.inc by Tom Aust : www.aust-anfertigungen.de modified by Ph. B.
	#include "TOMTREE.inc"	// tomtree.inc by Tom Aust : www.aust-anfertigungen.de
	#declare Palmier = object{ TREE scale 4.5}
	object {Dunes 
		scale <20, 10, 20>
	texture { pigment { color rgb <1.0, 0.8, 0.55> }
			    finish  { diffuse 0.7 specular 0.1 } }
   	photons { collect off }}
#end


object { Swim }
object { IntSwimC }

object { Flotte }

object { Palmier translate <-6,-0.2,5.3>  photons { collect off }}
object { Palmier scale <1.1, 1.2, 1.1> rotate y*27 translate <-5.3,0,7>  photons { collect off }}
object { Palmier rotate <1,-53,-5> translate <-4.1,-0.2,6.2>  photons { collect off }}

object { TablePara translate <0.2, 0, 7> rotate y*-11 }
object { Chaise rotate y*73 translate <-2.5, HC, 8>  scale 0.9 }
object { Chaise rotate y*90 translate <-0.1, HC, 8.2> scale 0.9 }


object { Verre scale 0.075 translate <-0.1, HT, 7.1> rotate y*-11 }
object { Verre scale 0.075 translate <.45, HT, 7.2> rotate y*-11 }


text { ttf "Gothic.ttf", "GRAPHIKTO",  0.2, 0
	translate <24,-0.25,-17.6> scale 0.2
	texture { pigment { color rgb <1.0, 0.8, 0.55> }
			    finish  { diffuse 0.7 specular 0.1 } }
   photons { collect off }
}
