// Persistence of Vision Ray Tracer Scene Description File
// File: Desert.pov
// Vers: 3.6
// Desc: IRTC "Desert" entry
// Date: 23/08/2004
// Auth: No Falzon <noe.falzon[at]tiscali.fr>
// Final render format : 800*300
// Final render antialias settings : +a0.0 +am2 +r2

#version 3.6;
#include "colors.inc"
global_settings {
  assumed_gamma 1.0

}
// ----------------------------------------
#declare camera_ = 3;
#declare testiso = 0;

#if  (camera_ = 1)
camera {
  location  <1.7, 2, -7>
  direction z
  right     x*image_width/image_height
}
#end

#if (camera_ = 2)
camera {
  location  <1.7, 2, -7>*0.5
  look_at 0
  right     x*image_width/image_height
}
#end

#if (camera_ = 3)
camera {
  location  <1.7, 2, -7>*0.8
  look_at z*3
  right     x*image_width/image_height
}
#end



light_source {
  <4,4,-4>      // position of the light source
  color rgb 1.0
}
light_source {
  <10,2.5,30>      // position of the light source
  color rgb <1,0,0>
  fade_distance 15
  fade_power 1  

}


// ----------------------------------------


#if (testiso = 0)
plane {
  y, -1
  pigment {color rgb 0.0}

  finish {ambient 0 reflection 0.5 phong 5}

  hollow
}

plane {
  y, 5
  pigment {color rgb 0.0}

  finish{ambient 0 reflection 0.5 phong 5}

  hollow
}



#declare texCyl = texture {	pigment {color rgb <0,1,0>}
						finish {ambient 0.4}
}
	

#declare conteur = -100;
#while (conteur < 100)
cylinder {
	<conteur,-1,-100>, <conteur,-1,1000>, 0.02
	texture {texCyl}
}
#declare conteur = conteur + 4;
#end

#declare conteur = -100;
#while (conteur < 1000)
cylinder {
	<-1000,-1,conteur>, <1000,-1,conteur>, 0.02
texture {texCyl}
}
#declare conteur = conteur + 4;
#end

#declare conteur = -100;
#while (conteur < 100)
cylinder {
	<conteur,5,-100>, <conteur,5,1000>, 0.02
texture {texCyl}
}
#declare conteur = conteur + 4;
#end

#declare conteur = -100;
#while (conteur < 1000)
cylinder {
	<-1000,5,conteur>, <1000,5,conteur>, 0.02
texture {texCyl}
}
#declare conteur = conteur + 4;
#end

fog
{
  fog_type 1
  distance 40
  color Black
}


#end


#declare fn_X = function { pattern { bozo scale 0.15 } }
#declare fn_Y = function { sqrt(x*x + y*y + z*z) - 0.8 }

isosurface {
  function { fn_Y(x,y,z) - fn_X(x,y,z)*0.2 }          // function (can also contain declared functions
  contained_by { box { -1.2, 1.2 } }  // container shape
  threshold 0.0                     // optional threshold value for isosurface [0.0]
  accuracy 0.001                      // accuracy of calculation [0.001]
  max_gradient 4                      // maximum gradient the function can have [1.1]
  //evaluate 5, 1.2, 0.95             // evaluate the maximum gradient
  //max_trace 1                       // maybe increase for use in CSG [1]
  //all_intersections                 // alternative to 'max_trace'
  //open                              // remove visible container surface
  
  texture {
      pigment { rgb 0.9 }
  		finish {ambient 0 diffuse 1 reflection { 0.1 0.3 } brilliance 2.5 phong 1 phong_size 200}
	}
}