#include "colors.inc"
#include "functions.inc" 

sky_sphere { pigment { bozo color_map {
[0 White]
[.23 White]
[.23 Black] 
[1 Black] }
scale .001 turbulence .2 }}
         
                    
camera { location <0,1.8,-4> look_at <0,0,0> }
light_source { <200,150,-100> color rgb 2 }        
               

#declare fn_Pigm1 =  function { pigment { image_map { jpeg "earth" map_type 1 interpolate 2 } } }  
  
#declare fn_Pigm2 = function { pigment { crackle color_map {
[0 Black ]
[.02 Black ]
[.02 White ] 
[1 White ]} scale .01 } }
            
        
isosurface {
   function { f_sphere(x, y, z, 1.5)-(fn_Pigm1(x/2, y/2, z/2).hf*0.03-fn_Pigm2(x/2, y/2, z/2).hf*0.001) }       
  contained_by { box { -2, 2 } } 
  //threshold 0.0                    
  accuracy 0.001                     
  max_gradient 4                     
                      /*                    
sphere { 0, 1.5  //for test renderings     */
pigment { image_map { jpeg "earth2.jpg" map_type 1 interpolate 2 }} 
finish { diffuse .4 }
rotate <0,-100,0> } 
 
 

#declare Media =
media {	emission 0.5 intervals 1 samples 5 method 3 density { spherical	ramp_wave turbulence 0.1 
color_map { [ 0 rgb 0 ] [ 1 rgb 1 ] }}}

sphere { < 0, 0, 0>, 1 pigment { color rgbf <1, 1, 1, 1> } finish { ambient 0 diffuse 0 } interior { media { Media } }
scale 1.8 translate <.1,.1,-.1> hollow } 

sphere { 0, 1 pigment { image_map { gif "moon.gif" map_type 1 }} 
rotate <0,-145,0> translate <-5,0,30> }   

      
                      