// ************************************************************************************************************************
// Draw Reference Axes (For Debugging)
//    Note: Tic Marks are drawn on the Axes by "skipping" every "n" POV units using Gradients. The Axes are colored as
//          follows: X=Red, Y=Green and Z=Blue. The Origin is a White Circle. The width of the Tic Marks can be changed 
//          using the axStep variable.    
// ************************************************************************************************************************
// #declare Axes =  1; // 0=No, 1=Yes (insert at top of scene file)
// ************************************************************************************************************************
#declare axShowTics    = 0     ; // Number of Points, radiating out from Origin
#declare axRadius      = 0.2*4 ; // Size of Axis Cylinders in POV Units
#declare axStep        = 1*12  ; // Number of POV Units per TIC Mark
#declare axSize        = 5000  ; // Max. Size of each Axis
#declare axSpacing     = 10    ; // Spacing of Grid Lines
// ************************************************************************************************************************
#if (Axes=1) // /Axes
   union {
      cylinder {<-axSize,0,0>, <axSize,0,0>, axRadius pigment {gradient x scale axStep*2 // X-Axis (Red)
         // color_map {[0.00 Red*5] [0.50 Red*5] [0.50 White filter 1.0] [1.00 White filter 1.0] } } }      // Clear
         color_map {[0.00 Red*5] [0.50 Red*5] [0.50 Red/2] [1.00 Red/2] } } }                               // Alternating
      cylinder {<0,-axSize,0>, <0,axSize,0>, axRadius pigment {gradient y scale axStep*2 // Y-Axis (Green)  
         // color_map {[0.00 Green*5] [0.50 Green*5] [0.50 White filter 1.0] [1.00 White filter 1.0] } } }  // Clear
         color_map {[0.00 Green*5] [0.50 Green*5] [0.50 Green/2] [1.00 Green/2] } } }                       // Alternating
      cylinder {<0,0,-axSize>, <0,0,axSize>, axRadius pigment {gradient z scale axStep*2 // Z-Axis (Blue)   
         // color_map {[0.00 Blue*5] [0.50 Blue*5] [0.50 White filter 1.0] [1.00 White filter 1.0] } } }    // Clear
         color_map {[0.00 Blue*5] [0.50 Blue*5] [0.50 Blue/2] [1.00 Blue/2] } } }                           // Alternating
      sphere { <0, 0, 0>, axRadius*1.5 pigment {color White } } // Origin (White)
      finish {ambient 2.0 diffuse 0.5 reflection 0.0}
      }
#end
// ************************************************************************************************************************
// Draw Reference Grid Lines (For Debugging)
//    Note: Grid Lines are drawn every 10 POV Units from 0-200, to reduce Object count.
//          This is done my shining a light through an X-Z Grid down onto the terrain.
// ************************************************************************************************************************
// #declare GridLines =  1; // 0=No, 1=Yes (insert at top of scene file)
// ************************************************************************************************************************
#if (GridLines=1) // GridLines
   // Would this be faster shining through Gradients with transparency?
   #declare Grid_Object = 
      union {
         #if (Axes=1)
            #declare X = 1;
         #else
            #declare X = 0;
         #end
         #while (X <= 20) // Create 20 Grid Lines on X and Z axes
            cylinder {<X*axSpacing,axSize,axSize>, <X*axSpacing,axSize,-axSize>, axRadius/2} // cylinder {<X,axSize,axSize>, <X,axSize,-axSize>, axRadius/4}
            cylinder {<-X*axSpacing,axSize,axSize>, <-X*axSpacing,axSize,-axSize>, axRadius/2} // cylinder {<-X,axSize,axSize>, <-X,axSize,-axSize>, axRadius/4}
            cylinder {<-axSize,axSize,X*axSpacing>, <+axSize,axSize,X*axSpacing>, axRadius/2} // cylinder {<-axSize,axSize,X>, <+axSize,axSize,X>, axRadius/4}
            cylinder {<-axSize,axSize,-X*axSpacing>, <+axSize,axSize,-X*axSpacing>, axRadius/2} // cylinder {<-axSize,axSize,-X>, <+axSize,axSize,-X>, axRadius/4}
            #declare X = X + 1;
         #end
         }
   light_source {
      <0,axSize*20>
      color White*2
      parallel
      point_at <0, 0, 0>
      projected_through {Grid_Object}
   }
#end
