// *********************************************************************************************************************
// Crayon Macro 
//    Usage: MakeCrayon (CrayonColor, CrayonText)
// *********************************************************************************************************************
#macro MakeCrayon (cra_Color, cra_Text)
   // Bottom of Crayon is centered at the Origin and points along the positive Y axis.
   #declare cra_R    = 0.6             ;  // Crayon Radius
   #declare cra_H    = 8.0             ;  // Crayon Length
   #declare cra_L    = 0.4             ;  // Crayon Label Line Thickness
   #declare cra_C    = cra_Color       ;  // Saved Color
   #declare txt_Text = cra_Text           // Saved Color Name
   #declare cra_Font = "ArialBD.TTF"   ;  // Crayon Font (or Arial.TTF)
   #ifndef (cra_Rand)                      
      #declare cra_Rand = seed(8)      ;  // Random Stream for Crayon Adjustment
   #end  
   // ******************************************************************************************************************
   #declare obj_Crayon_Writing_1 =
      union {
         // Color of Crayon
         text {ttf cra_Font cra_Text, 1.0, <0.1, 0, 0> scale 0.65
	         translate <0, -0.5, -0.5> rotate z*90
	         translate z*-cra_R/2 translate y*cra_L*3.5
            rotate y*-90 }
         // Upper Wrapper Lines
         box {<-1,cra_L*1.0  , -1>, <1,cra_L*1.6       , 1> }
         box {<-1,cra_L*2.0  , -1>, <1,cra_L*2.6       , 1> }
         // Lower Wrapper Lines
         box {<-1,cra_H-cra_L*1.0, -1>, <1,cra_H-cra_L*1.6, 1> }
         box {<-1,cra_H-cra_L*2.0, -1>, <1,cra_H-cra_L*2.6, 1> }
         // Randomly Rotate Crayon Label
         rotate y*360*rand(cra_Rand) 
         }   
   // Repeat Color Name 3 times around Crayon
   #declare obj_Crayon_Writing =
      union {
         object {obj_Crayon_Writing_1 rotate y*000}
         object {obj_Crayon_Writing_1 rotate y*120}
         object {obj_Crayon_Writing_1 rotate y*240}
         }

   #declare obj_Crayon_Wrapper =
      // Lighten Wrapper Colors
      #declare cra_C = cra_Color + White*0.25; 
      #declare cra_C = cra_C * 0.9 ;
      // #if (cra_C.gray > 0.80) #declare cra_C = (cra_C + White*0.1*<1,1,1,0>)/2 ; #end
      // #if (cra_C.gray > 0.75) #declare cra_C = (cra_C - White)/2 ; #end
      cylinder {<0,0,0> <0,cra_H,0>, cra_R open
         #if (Images_On=1)
            texture {
               object {
                  obj_Crayon_Writing
                  // Crayon Color
                  texture {
                     pigment {granite scale 0.10 color_map {[0.0 cra_C*0.60] [1.0 cra_C*0.75] } }
                     finish {ambient 0.2 diffuse 0.3 reflection 0.0 }  }
                  // Black Writing
                  texture {
                     pigment {
                        granite scale 0.10
                        color_map {[0.0 White*0.10] [1.0 White*0.20] } }
                     finish {ambient 0.2 diffuse 0.3 reflection 0.0 }
                     }
                  }
               }
         #else
            texture {
               pigment {color cra_C*(0.60+0.75)/2}
               finish {ambient 0.2 diffuse 0.3 reflection 0.0}
               }
         #end
         scale <1,0.9,1> translate y*0.05
         translate y*cra_L
      }
   
   // ******************************************************************************************************************
   #declare obj_Crayon_Stick =
      // Adjust Colors
      #declare cra_C = cra_Color * 0.9 ;
      //#if (cra_C.gray < 0.25) #declare cra_C = cra_C + White*0.5 ; #end
      union {
         // Crayon Stick /Crayon /Stick
         cylinder {<0, -0.01, 0> <0,cra_H,0> ,cra_R*0.95}
         cone {<0, cra_H, 0>, cra_R*0.70, <0,cra_H+cra_R*1.55,0> ,cra_R*0.30}
         texture {
            pigment {color cra_C*1.1}
            #if (Images_On=1)
               finish {ambient 0.3 diffuse 0.3 reflection 0.03 phong 0.30 phong_size 40.0 }
            #else
               finish {ambient 0.3 diffuse 0.3 reflection 0}
            #end
            // normal {granite rotate 5 scale 0.02 bump_size 0.2 turbulence 0.05 accuracy 0.1}
            }
         }

   // ******************************************************************************************************************
   union {
      object {obj_Crayon_Wrapper}
      object {obj_Crayon_Stick}
   }
#end

