// ************************************************************************************************************************
// Floor Plane with Self-Normals /Floor (Box, Under-Layer)
// ************************************************************************************************************************
#declare TileSize = 12*in ;
#declare TileThick = 0.56*in/2/22 ;
#if (Floor_Type=1 | Floor_Type = 3)
   box {<0,0,0> <Room_Wide, 0.1, Room_Deep>
      translate y*-0.25*in



      texture {
         #if (Images_On=1)
            pigment {image_map {jpeg "_Floor.jpg" map_type 0} rotate x*90 scale TileSize}
            finish {ambient 0.05 diffuse 0.1 reflection 0.04 specular 0.06 phong 1 phong_size 1000}
         #else   
            pigment {rgb <97,67,32>/255}
            finish {ambient 0.3 diffuse 0.3 reflection 0 specular 0}
         #end
         #if (Normals_On=1)
            normal {
               average 
               normal_map {
                  [1.0 bump_map {jpeg "_Floor.jpg" bump_size +0.1*7} rotate x*90 scale TileSize accuracy 1e-9]
                  [0.5 bump_map {jpeg "_Floor.jpg" bump_size -0.1*7} rotate x*90 scale TileSize accuracy 1e-9]
                  }   
               }
         #end
         }
         translate y*-0.1
      }
#end

// ************************************************************************************************************************
// Floor with manually-placed Tiles, with random variations /Floor
//    NOTE: Giving each Tile its own Normal and texture was too SLOW, so the
//          entire resulting Unioned Floor is given a common Normal and Texture.
//
//    Advanced Floor Overhead: 393 Objects, 28506 Tokens
// ************************************************************************************************************************
#if (Floor_Type=2 | Floor_Type=3)
   #declare obj_Tile = height_field {jpeg "_Floor.jpg" smooth scale <TileSize, TileThick, TileSize> }
   #declare Stream1 = seed(101)  ; // Random Numbers (Tile Adjustment)
   #declare Stream2 = seed(201)  ; // Random Numbers (Tile Rotation)
   #declare x_Min   = 0*in       ;
   #declare x_Max   = Room_Wide+TileSize ;
   #declare x_Step  = TileSize   ;
   #declare z_Min   = 0          ;
   #declare z_Max   = Room_Deep+TileSize ;
   #declare z_Step  = TileSize   ;
   // #declare y_Pos   = 0.01*in-0.20*in ;
   #declare y_Pos   = -0.19*in   ; // 0.01*in-0.20*in ;

   union {         
      #declare x_Pos = x_Min;                   // Start x_Pos Loop
      #while (x_Pos < x_Max)
         // Inner loop
         #declare z_Pos = 0;                    // Start z_Pos Loop
         #while (z_Pos < z_Max)
            object {obj_Tile
               // Random Vertical Adjustment
               translate y*(rand(Stream1)-rand(Stream1))/6/2/2
               translate <x_Pos, y_Pos, z_Pos>
               }
            #declare z_Pos = z_Pos + z_Step;    // Next z_Pos
         #end
         #declare x_Pos = x_Pos + x_Step;       // Next x_Pos
      #end

      pigment {
         // The "turbulence" value controls how "Dirty" the floor appears, ie,
         // how much of the other layers will shine through and how often.
         // cells translate 0.5 scale <1*ft, 0.02, 1*ft>
         granite scale <TileSize, TileThick TileSize>
            turbulence <0,0.0,0> // Minimally Dirty
         pigment_map {
            [0.00 image_map {jpeg "_Floor.jpg" map_type 0} rotate x*90 translate 0.5 rotate y*000]
            [0.25 image_map {jpeg "_Floor.jpg" map_type 0} rotate x*90 translate 0.5 rotate y*090]
            [0.50 image_map {jpeg "_Floor.jpg" map_type 0} rotate x*90 translate 0.5 rotate y*180]
            [0.75 image_map {jpeg "_Floor.jpg" map_type 0} rotate x*90 translate 0.5 rotate y*270]
            }
         }
         finish {ambient 0.3 
            diffuse 0.3
            // reflection 0.04
            reflection 0.05  
            specular 0.01*5
            phong 0.3
            // phong_size 40*3
            phong_size 60     
            } 
         // normal {agate 0.2 scale 0.1 bump_size 0.1}
      }
#end

