#include "bowling.inc"

#declare Widescreen = true;
#declare UseRadiosity = true;
#declare UseBlur = true;
#declare FinalRender = true;
#declare MidnightBowling = false;

#if(FinalRender)
	#declare NumAreaLights = 8;
#else
	#declare NumAreaLights = 2;
#end

global_settings{
	#if(UseRadiosity)
		ambient_light 0
		radiosity {
			pretrace_start 0.04
			pretrace_end   0.08
			#if(FinalRender)
				count 50
			#else
				count 25
			#end
			nearest_count 5
			error_bound 0.5
			recursion_limit 5
			low_error_factor 0.5
			gray_threshold 0.0
			minimum_reuse 0.015
			brightness 1
			//adc_bailout 0.01/2
		}
	#end
}

//Lane-Cam
camera{
	location<-3, 1.5, -8> //Was <-2.95, 3, -8>
	//location<-2, 3, -8>
	look_at<0, 1.5, 0>
	#if(Widescreen)
		up<0, 1, 0>
		right<1.778, 0, 0>
	#end
	#if(UseBlur)
		//aperture 0.65
		aperture 0.40
		#if(FinalRender)
			blur_samples 150
			variance 1/10000
		#else
			blur_samples 25
		#end
	//focal_point <3, 1, 1>
		focal_point<0, 1.5, 0>
	#end
	sky<0, 5, -5>
}

//Pin Cam
/*
camera{
	location<0, 1, -2>
	look_at<0, 1, 2>
	#if(Widescreen)
		up<0, 1, 0>
		right<1.778, 0, 0>
	#end
}
*/

//Hood Cam
/*
camera{
	location<0, 6, -15>
	look_at<0, 6, 1>
	#if(Widescreen)
		up<0, 1, 0>
		right<1.778, 0, 0>
	#end

}
*/

//Ball Return Cam?
/*
camera{
	location<-8, 5, -50>
	look_at<-8, 1.5, 0>
}
*/

//Alley Cam
/*
camera{
	location<30, 2, -75>
	look_at<0, 0, 0>
}
*/
//Work Stuff
/*
//Bombing View of Pins
camera{
	location<0, 15, 3>
	look_at<0, 0, 3>
}
//Gutter Cam
camera{
	location<-7, 5, -5>
	look_at<-7, 0, 1>
}
//Gutter Light
light_source{
	<-7, 10, -10>
	color rgb 1
	
}
//Fill for Pins
light_source{
	<0, 20, 3>
	color rgb 1
}

//Scene Filler
light_source{
	<5, 20, -20>
	color rgb 1
}
*/

/*
//Ball Cam
camera{
	location <1, 3, -5>
	look_at <1, 1, 1>
}
*/

//Fill Lights
light_source{
	<-7, 29, -125> //was <-20, 50, -150>
	#if(MidnightBowling)
		color rgb<0.2, 0.2, 0.5>
	#else
		color rgb <0.93, 0.93, 0.95>
	#end
	area_light
	<-1, 0, -1>, <1, 0, 1>
	NumAreaLights , NumAreaLights
	circular
}


//Bowling Alley Itself
object{ BackWall }
object{ Ceiling }

//Lanes
#declare Counter = -10;
#while (Counter <= 10)
	union{
		object{ Lane }
		object{ Gutter translate<-6, 0, 0> }
		object{ Gutter translate<6, 0, 0> }
		object{ LaneSeperator translate<-8.5, 0, 0> }
		object{ PinHood } 
		//Flourescant Lights About Pins
		light_source{
			<0, 5, 0>
			#if(MidnightBowling)
				color rgb<0.25, 0.25, 1>
			#else
				color rgb <1.0, 1.0, 1.90>
				//color rgb <0.9, 0.9, 1.3>
			#end
			area_light
			<-0.5, 0, -0.5>, <0.5, 0, 0.5>
			NumAreaLights, NumAreaLights
			adaptive 5
			circular
			fade_distance 8
			fade_power 2
		}
		translate<Counter*17, 0, 0>
	}
	#declare Counter = Counter + 1;
#end




object{ Ball rotate<10, 23, -15> translate<1, 0.8, -1> }

object{ Pin translate<0, 0, 1>  }
object{ Pin translate<-1.5, 0, 2> }
object{ Pin translate<1.5, 0, 2> }
object{ Pin translate<-3, 0, 3> }
object{ Pin translate<0, 0, 3> }
object{ Pin translate<3, 0, 3> }
object{ Pin translate<-1.5, 0, 4> }
object{ Pin translate<1.5, 0, 4> }
object{ Pin translate<-4.5, 0, 4> }
object{ Pin translate<4.5, 0, 4> }

union{
	object{ Pin translate<0, 0, 1>  }
	object{ Pin translate<-1.5, 0, 2> }
	object{ Pin translate<1.5, 0, 2> }
	object{ Pin translate<-3, 0, 3> }
	object{ Pin translate<0, 0, 3> }
	object{ Pin translate<3, 0, 3> }
	object{ Pin translate<-1.5, 0, 4> }
	object{ Pin translate<1.5, 0, 4> }
	object{ Pin translate<-4.5, 0, 4> }
	object{ Pin translate<4.5, 0, 4> }	
	translate<17, 0, 0>
}

