#include "colors.inc"
#include "shapes.inc"
#include "woods.inc"
#include "metals.inc"
#include "man1.inc"
#include "man2.inc"
#include "carromfurniture.inc"
#include "carrompieces.inc"
 
camera { location <12, 0.8, 0> look_at <0,0,3> }

//outside light
light_source { <2000,20000,30000>, 1 }

//inside general light
light_source { <14, 5, 2>, 0.5 media_interaction off photons { reflection off }}

background { rgb <0.3, 0.6, 0.9> }

global_settings {
  //assumed_gamma 1  //if radiosity is commented out uncomment this line
 photons { count 20000  media 100 }
   radiosity {
    pretrace_start 0.08           // start pretrace at this size [0.08]
    pretrace_end   0.005           // end pretrace at this size [0.04]
    count 500                     // higher -> higher quality (1..1600) [35]
    nearest_count 10               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]
    adc_bailout 0.01/2
   }


}


//declarations
#declare Room = union
 { difference
   { box { <-11, -7, -11>, <16, 7, 10.5>}
     box { <-10, -6, -10>, <15, 6, 10> }
     box { <-5, -1, 9.5>, <3, 4.5, 11> }
   }
   box { <-1.25, -1, 10>, <-0.75, 4.5, 10.5> }
   box { <-5, 1.25, 10>, <3, 1.75, 10.5> }  
   pigment { rgb 1 }
  }

#declare Fireplace = union{
   box{ <-10, -0.5, 3.5>, <-8, -1, -3.5>} 
   box{ <-10, -0.5, 3.4>, <-8.5, -6, 3.2>}
   box{ <-10, -0.5, -3.2>, <-8.5, -6, -3.4>}
   //back
   box{ <-10, -1, -3.2>, <-9.99, -6, 3.2> texture {pigment {image_map {jpeg "walltexture.jpg"}translate (x+y) rotate 90*y scale 6}}}
}

#declare CurtainSurface1 = isosurface {
    function { x - f_noise3d(0, y/5, z*5) } 
    contained_by { box { <0,-1.3,-1.5> <1,4.6,1.5> } }
    open
    rotate 90*y
   	}


#declare Curtains = union{ 
	cylinder { <-6, 4.6, 9.5>, <4, 4.6, 9.5>, 0.07 pigment{MediumWood}}
	
  	object{CurtainSurface1 translate <-4.5,0,9.7>}
	object{CurtainSurface1 translate <4,0,9.7>}
  	
  pigment{Khaki}
}

#declare Carrom_Game = union{
object {Table texture { T_Wood10 finish { specular 0.5 roughness 0.005 }translate x*1 rotate <30, 10, 20>}translate <-30,0,900>}
object { Stool texture { T_Wood10 finish { specular 0.5 roughness 0.005 }translate x*1 rotate <30, 10, 20>}translate <250,0,1200>}
object { Stool texture { T_Wood10 finish { specular 0.5 roughness 0.005 }translate x*1	rotate <30, 10, 20>}translate <250,0,-400>}
object { Carrom_Piece_Layout_2  rotate 90*y translate<460,561,460>}
object { Carrom_Striker translate<350,561,170> }
object { Carrom_Striker translate<700,582,870> }
object { Carrom_Board translate <0,550,0>}
object { man1 rotate 180*y scale <200,200,200> translate <450,0,1200>} //to texture man1 goto man1_mat.inc
object { man2 scale <200,200,200> translate <450,50,-300>} //to texture man2 goto man2_mat.inc
}

//Scene
object {Room}
// floor:
 box { <-10, -5.99, -10>, <15, -6, 10> texture {pigment {image_map {jpeg "woodfloor.jpg"}translate (x+y) scale 5 rotate 90*x}finish { specular 0.5 roughness 0.005}}
   		
   photons { target reflection on }
 }
object {Curtains}
object {Fireplace texture {T_Wood14 finish { specular 0.35 roughness 0.05 }}}
object {Picture_Frame rotate <90,-90,180> scale 0.46 translate<-10,0,-4>}
object {Carrom_Game scale 0.005 translate<-3,-6,-1>}
object {Lamp_Shade rotate 180*x scale 0.005 translate<-8.75,0,5>}
object {Lamp_Shade rotate 180*x scale 0.005 translate<-8.75,0,-5>}

// Scattering media box:
 box
 { <-5, -6.5, -10.5>, <3, 6.5, 10.25>
   pigment { rgbt 1 } hollow
   photons { pass_through }
   interior
   { media
     { scattering { 1, 0.07 extinction 0.01 }
       samples 30,100
     }
   }
 }

 
 
