#include "woods.inc"

#declare Front_Panel = union{

	sphere { <0, 2.5, 0>, 2.5 }
	cylinder { <0, 2.5, 0>, <0, 27.5, 0>, 2.5 }
	sphere { <0, 27.5, 0>, 2.5 }
	
	box { <0, 2.5, 2.5>, <917.5, 27.5, 0> }
	cylinder { <0, 2.5, 0>, <917.5, 2.5, 0>, 2.5 }
	cylinder { <0, 27.5, 0>, <917.5, 27.5, 0>, 2.5 }
	
	sphere { <917.5, 2.5, 0>, 2.5 }
	cylinder { <917.5, 2.5, 0>, <917.5, 27.5, 0>, 2.5 }
	sphere { <917.5, 27.5, 0>, 2.5 }
}

#declare Side_Panel = union{
	box { <-2.5, 2.5, 0>, <0, 27.5, 917.5> }
	cylinder { <0, 2.5, 0>, <0, 2.5, 917.5>, 2.5 }
	cylinder { <0, 27.5, 0>, <0, 27.5, 917.5>, 2.5 }
}

#declare Mid_Section = difference{
	box{ <0, 0, 0>, <917.501, 29.999, 917.501>}
	box{ <90,9,90>, <830,30,830>}
}
	
#declare Corner_Plug = difference {
 	cylinder { <0,0,0> <0,30.0001,0> 20}
	cylinder { <20,-10,20> <20,40,20> 20.001}
	pigment {Black}
}

#declare Carrom_Board_Wood = union{
		//edging
		object { Front_Panel}
		object { Front_Panel rotate 180*y translate <917.5, 0, 917.5> }
		object { Side_Panel}
		object { Side_Panel rotate 180*y translate <917.5, 0, 917.5> }
		//main body
		object { Mid_Section }
				
		//corner details
		object { Corner_Plug translate <90, 0, 90>}
		object { Corner_Plug rotate 90*y translate <90, 0, 830> }
		object { Corner_Plug rotate 180*y translate <830, 0, 830> }
		object { Corner_Plug rotate 270*y translate <830, 0, 90> }		
	}
	
	
#declare Carrom_Board = difference{	
	union{
	// Main Frame
	object { Carrom_Board_Wood 
	texture {T_Wood14
            finish { specular 0.35 roughness 0.05 }
            translate x*1
            rotate <15, 10, 0>
            translate y*2
        }
	}
	//Table Top
	box {<0,-0.001,0>, <740,0,740>
		 texture {
    		pigment {
      			image_map {
       				 gif "CarromTableTop.gif"
            	}
      		translate 410*(x+y) 
      		scale 740             
      		rotate 90*x
    		}
   		finish { specular 0.5 roughness 0.005}
  		}
   		translate <90,9.001,90>}
   	} 
	//pocket holes
	cylinder { <110,-10,110> <110,40,110> 20 pigment {color rgb <1.00000,0.84314,0.43922>}}
	cylinder { <810,-10,810> <810,40,810> 20 pigment {color rgb <1.00000,0.84314,0.43922>}}
	cylinder { <110,-10,810> <110,40,810> 20 pigment {color rgb <1.00000,0.84314,0.43922>}}
	cylinder { <810,-10,110> <810,40,110> 20 pigment {color rgb <1.00000,0.84314,0.43922>}}
}

#declare Table_Leg = difference{
	box { < 0,0,0><30,1100,30> rotate -55*x}
	box { < -100,-10,-100><100,30,100> }
	box { < -100,600,-800><100,680,-950> }
}

#declare Table = union{
	//legs
	object { Table_Leg translate <0,-30,0>}
	object { Table_Leg rotate 180*y translate <0,-30,-900>}
	object { Table_Leg translate <900,-30,0>}
	object { Table_Leg rotate 180*y translate <900,-30,-900>}
	// joining poles
	cylinder { <0,150,-225><900,150,-225>15}
	cylinder { <0,150,-675><900,150,-675>15}
}

#declare Stool = union{
	//legs
	cylinder { <0,0,0><0,300,0>15}
	cylinder { <0,0,200><0,300,200>15}
	cylinder { <500,0,0><500,300,0>15}
	cylinder { <500,0,200><500,300,200>15}
	//top
	box { <-50,300,-50> <550,350,250> }
}

#declare Picture_Frame_Wood = difference {
box { <0, 0, 0>, <17, 0.5, 11.5> }
box { <0.5, 0.2, 0.5>, <16.5, 0.501, 11> }
}

#declare Picture_Frame = union{
object {Picture_Frame_Wood texture { T_Wood10 finish { specular 0.5 roughness 0.005 }translate x*1 rotate <30, 10, 20>}}
box {<0.5,0.200,0.5>, <16.5,0.201,11>
		 texture {pigment {image_map {jpeg "boat.jpg"}
      		translate 1*(x+y) 
      		scale 16             
      		rotate 90*x
    		}
   		finish { specular 0.5 roughness 0.005 ambient 0.0 }
}}}

#declare Lamp_Shade = union{
	cone { <0, 150, 0>, 0.0, <0, 50, 0>, 150 open texture{T_Silver_3C pigment{DarkGreen}}}
	cylinder{ <0, 120, 0>, <0, 20000, 0>, 5 texture{T_Silver_3C pigment{DarkGreen}}}
	 
	light_source { <0,100,0>,0.1 fade_distance 500
  fade_power 2}
                 

}

#declare Rug = box {<0,0,0>, <16,0.05,9>
		 texture {pigment {image_map {gif "TrikonRug.gif"}
      		translate 1*(x+y) 
      		scale <16,9,1>             
      		rotate 90*x
    		}
   		finish { specular 0.5 roughness 0.005 ambient 0.15 }
}}
