#version 3.6;

#declare FOCAL_BLUR_HQ = false;
#declare FOCAL_BLUR = false;
#declare RADIOSITY = false;
#declare AREA_LIGHTS = true;
#declare scene_ambient = .15;

#include "rad_def.inc"

global_settings
	{
	#if (RADIOSITY)
		radiosity
			{
			Rad_Settings(Radiosity_IndoorLQ, true, false)
			}
		//ambient_light 0
		#end
	}

camera
	{
	angle 40
	location <4, 9, 10> * 2.1
	look_at <0, 2.2, 0>  
	//location <0, .2, 10>
	//look_at <0, .2, 0>
	#if (FOCAL_BLUR)
		//focal_point <6, 2.5, 5>
		focal_point <5, 2.5, 5>
		aperture .2
		#if (FOCAL_BLUR_HQ)
			blur_samples 10
			#else
			blur_samples 3
			#end
		#end
	}
  
#include "colors.inc"
#include "woods.inc"
#include "stones.inc"

#declare refl = .2;
#declare refli = 1 - refl;

#declare norm =
normal
	{
	facets 0
	scale .1
	}

plane
	{
	<0, 1, 0>, 0
	/*
	texture
		{
		pigment
			{
			agate
			color_map
				{
				[0 color rgb .3]
				[1 color rgb .5]
				}
			agate_turb 1.5
			scale 4
			}
		finish
			{
			reflection .3
			ambient scene_ambient
			}
		}
	*/
	//texture {T_Stone21 scale 3}
	//texture {T_Wood12 scale 3}
	texture
		{
		pigment
			{
			marble
			turbulence 0.7
			color_map
				{
				[0.000, 0.155   color rgbt <0.686, 0.235, 0.182, 0.000>*refli color rgbt <0.686, 0.235, 0.182, 0.000>*refli]
				[0.155, 0.328   color rgbt <0.686, 0.235, 0.182, 0.000>*refli color rgbt <0.494, 0.243, 0.194, 0.000>*refli]
				[0.328, 0.474   color rgbt <0.494, 0.243, 0.194, 0.000>*refli color rgbt <0.769, 0.329, 0.273, 0.000>*refli]
				[0.474, 0.647   color rgbt <0.769, 0.329, 0.273, 0.000>*refli color rgbt <0.769, 0.329, 0.273, 0.000>*refli]
				[0.647, 0.810   color rgbt <0.769, 0.329, 0.273, 0.000>*refli color rgbt <0.686, 0.235, 0.182, 0.000>*refli]
				[0.810, 0.922   color rgbt <0.686, 0.235, 0.182, 0.000>*refli color rgbt <0.792, 0.388, 0.327, 0.000>*refli]
				[0.922, 1.001   color rgbt <0.792, 0.388, 0.327, 0.000>*refli color rgbt <0.686, 0.235, 0.182, 0.000>*refli]
				}
			}
		scale <1.3, 2.5, 1.7>
		rotate <0, 0, 40>
		finish
			{
			reflection refl
			}
		scale 3
		}
	texture
		{
		pigment
			{
			granite
			turbulence 0.0
			color_map
				{
				[0.0, 0.07 color White*refli color White*refli]
				[0.07, 0.2 color White*refli color DimGray*refli]
				[0.2, 0.3 color DimGray*refli color Clear*refli]
				[0.3, 0.7 color Clear*refli color Clear*refli]
				[0.7, 1.0 color Clear*refli color DimGray*refli]
				}
			}
		scale <1, 2, 2>
		rotate <0, 0, 4>
		finish
			{
			reflection refl
			}
		scale 3
		}
	texture
		{
		T_Crack4 scale <1, 0.6, 1> rotate <10, 0, -20>
		finish
			{
			phong 1.0
			phong_size 90
			//reflection .3
			}
		scale 3
		}
	}

#declare round = .02;
#declare faceplate = .015;
#declare cubepuzzlebox =
union
	{
	difference
		{
		//original box
		union
			{
			box {<-2.5 + faceplate, 0 + faceplate, -2.5 + faceplate>, <2.5 - faceplate, 5 - faceplate, 2.5 - faceplate>}
			//top faceplate
			difference
				{
				box
					{
					<-2.5, 5, -2.5>, <2.5, 5 - faceplate, 2.5>
					}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate x*90 translate <2.5, 5, 0>}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate x*90 translate <-2.5, 5, 0>}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate z*90 translate <0, 5, 2.5>}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate z*90 translate <0, 5, -2.5>}
				texture
					{
					pigment
						{
						color rgb <.7, .7, .7>
						}
					normal
						{
						bumps .3
						scale <.01, .01, 1>
						}
					finish
						{
						reflection .4
						specular .2
						ambient scene_ambient
						}
					}
				}
			//bottom faceplate
			difference
				{
				box
					{
					<-2.5, 0, -2.5>, <2.5, 0 + faceplate, 2.5>
					}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate x*90 translate <2.5, 0, 0>}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate x*90 translate <-2.5, 0, 0>}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate z*90 translate <0, 0, 2.5>}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate z*90 translate <0, 0, -2.5>}
				texture
					{
					pigment
						{
						color rgb <.7, .7, .7>
						}
					normal
						{
						bumps .3
						scale <.01, .01, 1>
						}
					finish
						{
						reflection .4
						specular .2
						ambient scene_ambient
						}
					}
				}
			//left side faceplate
			difference
				{
				box
					{
					<-2.5, 0, -2.5>, <-2.5 + faceplate, 5, 2.5>
					}
				box {<-round, -.1, -round>, <round, 5.1, round> rotate y*45 translate <-2.5, 0, -2.5>}
				box {<-round, -.1, -round>, <round, 5.1, round> rotate y*45 translate <-2.5, 0, 2.5>}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate x*90 translate <-2.5, 5, 0>}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate x*90 translate <-2.5, 0, 0>}
				texture
					{
					pigment
						{
						color rgb <.7, .7, .7>
						}
					normal
						{
						bumps .3
						scale <.01, .01, 1>
						}
					finish
						{
						reflection .4
						specular .2
						ambient scene_ambient
						}
					}
				}
			//right side faceplate
			difference
				{
				box
					{
					<2.5, 0, -2.5>, <2.5 - faceplate, 5, 2.5>
					}
				box {<-round, -.1, -round>, <round, 5.1, round> rotate y*45 translate <2.5, 0, -2.5>}
				box {<-round, -.1, -round>, <round, 5.1, round> rotate y*45 translate <2.5, 0, 2.5>}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate x*90 translate <2.5, 5, 0>}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate x*90 translate <2.5, 0, 0>}
				texture
					{
					pigment
						{
						color rgb <.7, .7, .7>
						}
					normal
						{
						bumps .3
						scale <.01, .01, 1>
						}
					finish
						{
						reflection .4
						specular .2
						ambient scene_ambient
						}
					}
				}
			//front side faceplate
			difference
				{
				box
					{
					<-2.5, 0, -2.5>, <2.5, 5, -2.5 + faceplate>
					}
				box {<-round, -.1, -round>, <round, 5.1, round> rotate y*45 translate <2.5, 0, -2.5>}
				box {<-round, -.1, -round>, <round, 5.1, round> rotate y*45 translate <-2.5, 0, -2.5>}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate z*90 translate <0, 5, -2.5>}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate z*90 translate <0, 0, -2.5>}
				texture
					{
					pigment
						{
						color rgb <.7, .7, .7>
						}
					normal
						{
						bumps .3
						scale <1, .01, .01>
						}
					finish
						{
						reflection .4
						specular .2
						ambient scene_ambient
						}
					}
				}
			//back side faceplate
			difference
				{
				box
					{
					<-2.5, 0, 2.5>, <2.5, 5, 2.5 - faceplate>
					}
				box {<-round, -.1, -round>, <round, 5.1, round> rotate y*45 translate <2.5, 0, 2.5>}
				box {<-round, -.1, -round>, <round, 5.1, round> rotate y*45 translate <-2.5, 0, 2.5>}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate z*90 translate <0, 5, 2.5>}
				box {<-round, -2.5, -round>, <round, 2.5, round> rotate y*45 rotate z*90 translate <0, 0, 2.5>}
				texture
					{
					pigment
						{
						color rgb <.7, .7, .7>
						}
					normal
						{
						bumps .3
						scale <1, .01, .01>
						}
					finish
						{
						reflection .4
						specular .2
						ambient scene_ambient
						}
					}
				}
			}
		//circular cut-outs
		cylinder {<-2.6, 2.5, 0>, <2.6, 2.5, 0>, 2}
		cylinder {<0, 5.1, 0>, <0, -.1, 0>, 2}
		cylinder {<0, 2.5, -2.6>, <0, 2.5, 2.6>, 2}
		//box cut-outs
		box {<-2.6, 1.5, 1.5>, <2.6, -1.5, -1.5> rotate <45, 0, 0> translate <0, 2.5, 0>}
		box {<-1.5, 5.1, 1.5>, <1.5, -.1, -1.5> rotate <0, 45, 0>}
		box {<1.5, 1.5, -2.6>, <-1.5, -1.5, 2.6> rotate <0, 0, 45> translate <0, 2.5, 0>}
		texture
			{
			pigment
				{
				color rgb <.7, .7, .7>
				}
			normal
				{
				dents .2
				scale .1
				}
			normal
				{
				bumps .3
				scale .05
				}
			finish
				{
				reflection .4
				specular .2
				ambient scene_ambient
				}
			}
		}
	}
 
#declare cubepuzzlecube =
box
	{
	<-1.5, -1.5, -1.5>, <1.5, 1.5, 1.5>
	texture
		{
		pigment
			{
			color rgb <.65, .5, .25>
			}
		normal
			{
		  facets
		  coords .2
  		scale 3
			}
		finish
			{
			reflection .1
			metallic
			ambient scene_ambient
			}
		}
	}

object {cubepuzzlebox}

object
	{
	cubepuzzlecube
	rotate <6, 0, 0>
	rotate y * 45
	translate <.2, 2.13, .2>
	}

#declare spheretex =
texture
	{
	pigment
		{
		color rgb <1, .53, 0> * .5
		//color rgb 0
		}
	/*
	normal
		{
		average
		normal_map
			{
			[1 dents .6 scale .06]
			[1 bumps .2 scale .04]
			}
		}
	*/
	finish
		{
		//reflection 1
		reflection .2
		specular .2
		roughness .03
		//metallic
		ambient scene_ambient
		}
	}


#declare sphere_join = .05;
#declare sphere_cyl = .83;
#declare sphere_gap = .06;
#declare sphere_size = 2.1;
#declare sphere_part1 =
union
	{
	difference
		{
		cylinder {<-3, 0, 0>, <3, 0, 0>, sphere_cyl - sphere_join}
		difference
			{
			sphere {<0, -sphere_cyl - sphere_gap, 0>, 4}
			sphere {<0, -sphere_cyl - sphere_gap, 0>, sphere_size}
			}
		texture {spheretex}
		}
	sphere
		{
		<0, -sphere_cyl, 0>, .15
		texture
			{
			pigment {color 0}
			finish {reflection .8 ambient scene_ambient}
			}
		}
	}

#declare sphere_part2 =
difference
	{
	cylinder {<-3, 0, 0>, <3, 0, 0>, sphere_cyl - sphere_join}
	difference
		{
		sphere {<0, -sphere_cyl - sphere_gap, 0>, 4}
		sphere {<0, -sphere_cyl - sphere_gap, 0>, sphere_size}
		}
	cylinder {<-sphere_cyl - sphere_gap, -sphere_cyl - sphere_gap, -3>, <-sphere_cyl - sphere_gap, -sphere_cyl - sphere_gap, 3>, sphere_cyl}
	cylinder {<sphere_cyl + sphere_gap, -sphere_cyl - sphere_gap, -3>, <sphere_cyl + sphere_gap, -sphere_cyl - sphere_gap, 3>, sphere_cyl}
	texture {spheretex}
	}

#declare sphere_part3 =
difference
	{
	cylinder {<-3, 0, 0>, <3, 0, 0>, sphere_cyl - sphere_join}
	difference
		{
		sphere {<0, -sphere_cyl - sphere_gap, 0>, 4}
		sphere {<0, -sphere_cyl - sphere_gap, 0>, sphere_size}
		}
	cylinder {<-sphere_cyl - sphere_gap, -sphere_cyl - sphere_gap, -3>, <-sphere_cyl - sphere_gap, -sphere_cyl - sphere_gap, 3>, sphere_cyl}
	cylinder {<sphere_cyl + sphere_gap, -sphere_cyl - sphere_gap, -3>, <sphere_cyl + sphere_gap, -sphere_cyl - sphere_gap, 3>, sphere_cyl}
	cylinder {<0, 3, sphere_cyl + sphere_gap>, <0, -3, sphere_cyl + sphere_gap>, sphere_cyl}
	texture {spheretex}
	}

#declare sphere_all =
union
	{
	object {sphere_part2 rotate x*-90 rotate z*90 translate <0, 0, -sphere_cyl - sphere_gap>}
	object {sphere_part2 rotate x*90 rotate z*90 translate <0, 0, sphere_cyl + sphere_gap>}
	object {sphere_part2 rotate x*180 translate <0, -sphere_cyl - sphere_gap, 0>}
	object {sphere_part3 rotate y*-90 rotate z*-90 translate <sphere_cyl + sphere_gap, 0, 0>}
	object {sphere_part3 rotate y*90 rotate z*90 translate <-sphere_cyl - sphere_gap, 0, 0>}
	object {sphere_part1 translate <0, sphere_cyl + sphere_gap, 0>}
	}

light_source
	{
	<5, 2, 10>, .5
	}

object
	{
	sphere_all
	rotate <-10, 0, 0>
	rotate <0, -45, 0>
	translate <5, sphere_size, 5>
	}

object
	{
	sphere_part1
	rotate <20, 0, 0>
	rotate <0, -10, 0>
	translate <7, sphere_cyl, -3>
	}

object
	{
	sphere_part2
	rotate <190, 0, 0>
	rotate <0, -120, 0>
	translate <3, sphere_cyl, -7>
	}

object
	{
	sphere_part2
	rotate <210, 0, 0>
	rotate <0, -40, 0>
	translate <7, sphere_cyl, 0>
	}

object
	{
	sphere_part2
	rotate <170, 0, 0>
	rotate <0, 80, 0>
	translate <6, sphere_cyl, -9>
	}

object
	{
	sphere_part3
	rotate <170, 0, 0>
	rotate <0, 100, 0>
	translate <8, sphere_cyl, -7>
	}

object
	{
	sphere_part3
	rotate <170, 0, 0>
	rotate <0, -40, 0>
	translate <3, sphere_cyl, -14>
	}

object
	{
	cubepuzzlebox
	rotate <0, 57, 0>
	translate <-10, 0, -5>
	}

object
	{
	cubepuzzlecube
	rotate x * 90
	rotate y * 0
	translate <-3, 1.5, 7>
	}

#declare lightpos = <10, 10, 0>;
#declare lightsize = 1;
light_source
	{
	lightpos, 2
	fade_distance 10
	fade_power 2
	#if (AREA_LIGHTS)
		area_light .5, .5, 8, 8
		orient
		circular
		adaptive 0
		#end
	}
