#declare RAD = on;
global_settings {
  #if(RAD)
  radiosity {
  }
  #end
}

#if(RAD)
#default {
  finish { ambient 0.02 }
}
#else
#default {
  finish { ambient 0.4 }
}
#end

// x is the desk's left-right.  positive values are right
// y is up, zero is the ground, positive values are up
// z is across the depth of the desk, positive numbers are farther away.
// origin sits under bottom left corner of desk.
// units are inches
camera
{
  up <0, 1, 0>
  right <1, 0, 0>
  location <6,54,-40>
  look_at <22,46,0>
  angle 35
  //look_at <26,21.5,28>
  //angle 20

  //thumbtacks
  //look_at <15,35,20>
  //angle 10

  //photo
  //look_at <48,44,13>
  //angle 7

  //back of computer
  //location <43,70,0>
  //look_at <45,30,17>
  //angle 20

  //coffee cup
  //look_at <16,32,23>
  //angle 6

  //water bottle
  //look_at <45,35,12>
  //angle 10

  //keyboard
  //location <34.5,80,2>
  //look_at <34.5,31,2>
  //location <25,60,6>
  //look_at <25,31,6>
  //location <45,60,6>
  //look_at <45,31,6>
  //location <0,31,4.5>
  //look_at <35,31,4.5>
  //angle 23

  //monitor controls
  //location <10,54,-40>
  //look_at <32,40,10>
  //angle 10
  //look_at <25,41,10>
  //angle 4

  //shelf light
  //location <10,44,-30>
  //look_at <18,58,0>
  //angle 30

  //shelf detail
  //location <10,54,-40>
  //look_at <42,60,14>
  //angle 10

  //location <14,70,-30>
  //look_at <23.5,54.5,10>
  //angle 10

  //computer front
  //location <0,40,10>
  //look_at <23,32.5,19>
  //angle 35

  //detail of computer front corner
  //location <4,40,-40>
  //look_at <23,32.5,10>
  //angle 5

  //location <35,40,-20>
  //look_at <24.5,54,10>
  //angle 5
}

#include "colors.inc"
#include "metals.inc"
#include "woods.inc"
#include "roundedbox.pov"
#include "logo.inc"

#declare glass = texture { pigment { White transmit 0.95 } finish { specular 0.8 ambient 0.0 reflection 0.1 diffuse 0.0 roughness 0.001 } }
#declare greenled = texture { pigment { color rgb <0.3 1 0> } finish { specular 0.4 ambient 1.5 reflection 0 diffuse 0.4 } }
#declare shinyblack = texture { pigment { color rgb <0.05 0.05 0.05> } finish { specular 0.4 reflection 0.2 diffuse 0.6 } }
#declare shinyoffwhite = texture { pigment { color rgb <0.9 0.9 0.8> } finish { specular 0.4 reflection 0.2 diffuse 0.6 } }
#declare shinyred = texture { pigment { color rgb <0.8,0,0> } finish { specular 0.4 reflection 0.2 diffuse 0.6 } }
#declare shinyblue = texture { pigment { color rgb <0,0,0.8> } finish { specular 0.4 reflection 0.2 diffuse 0.6 } }
#declare shinyyellow = texture { pigment { color rgb <0.8,0.8,0> } finish { specular 0.4 reflection 0.2 diffuse 0.6 } }
#declare blackrubber = texture { pigment { color rgb <0.2 0.2 0.2> } finish { specular 0 reflection 0 diffuse 0.7 } }
#declare blackplastic = texture { pigment { color rgb <0.2 0.2 0.2> } finish { specular 0.4 reflection 0 diffuse 0.5 } }
#declare blackrubber = texture { pigment { color rgb <0.2 0.2 0.2> } finish { specular 0 reflection 0 diffuse 0.7 } }
#declare purpleplastic = texture { pigment { color rgb <0.8 0.0 0.8> } finish { specular 0.5 diffuse 0.6 } }
#declare limegreenplastic = texture { pigment { color rgb <0.7 1.0 0.0> } finish { specular 0.5 diffuse 0.6 } }
#declare blackrubber = texture { pigment { color rgb <0.2 0.2 0.2> } finish { specular 0 reflection 0 diffuse 0.7 } }
#declare aluminum = texture { pigment { color rgb <0.6,0.6,0.6> } finish { specular 0.4 reflection 0.1 diffuse 0.5 roughness 0.05 metallic } }
#declare chrome = texture { pigment { color rgb <0.6,0.6,0.6> } finish { specular 0.5 reflection 0.7 roughness 0.005 metallic } }
#declare magnetred = texture { pigment { color rgb <0.7,0,0> } finish { diffuse 0.6 specular 0.2 } }
#declare redpaint = texture { pigment { color rgb <1,0,0> } finish { diffuse 0.8 specular 0.2 } }
#declare bluepaint = texture { pigment { color rgb <0,0,1> } finish { diffuse 0.8 specular 0.2 } }
#declare whitepaint = texture { pigment { color rgb <1,1,1> } finish { diffuse 0.8 specular 0.2 } }
#declare whitepaper = texture { pigment { color rgb <1,1,1> } finish { diffuse 0.55 specular 0.1 } }
#declare offwhitepaint = texture { pigment { color rgb <0.9,0.9,0.85> } finish { diffuse 0.9 specular 0.1 } normal { bozo 0.3 scale 0.2 } }
#declare ltgreypaint = texture { pigment { color rgb <0.8,0.8,0.8> } finish { diffuse 0.8 specular 0.2 } }
#declare greypaint = texture { pigment { color rgb <0.7,0.7,0.7> } finish { diffuse 0.8 specular 0.2 } }
#declare dkgreypaint = texture { pigment { color rgb <0.4,0.4,0.4> } finish { diffuse 0.8 specular 0.2 } }
#declare beigepaint = texture { pigment { color rgb <0.7,0.6,0.5> } finish { diffuse 0.8 specular 0.2 } }
#declare ltbeigepaint = texture { pigment { color rgb <0.8,0.7,0.6> } finish { diffuse 0.8 specular 0.2 } }

//#declare deskwood = texture { pigment { color rgb <0.9,0.8,0.7> } finish { diffuse 0.8 specular 0.2 } }

#declare deskwood_streaks =
pigment {
  bozo
  color_map {
    [0.0 color rgb <0.5,0.4,0.2>]
    [0.8 color rgb <0.68,0.6,0.45>]
    [1.0 color rgb <0.68,0.6,0.45>]
  }
  scale <4,1,0.1>
  rotate 90*y
}

#declare deskwood_background =
pigment {
  color rgb <0.68,0.6,0.45>
}

#declare deskwood_turb =
    texture {
      pigment {
	wood turbulence 0.05
	rotate 90*y rotate 2*z translate <0,30,10>
	pigment_map {
	  [0.0 deskwood_streaks ]
	  [0.3 deskwood_streaks ]
	  [0.7 deskwood_background ]
	  [1.0 deskwood_background ]
	}
      }
      finish { diffuse 0.8 specular 0.2 }
    }
#declare deskwood_streaks =
    texture {
      pigment {
	bozo
	color_map {
	  [0.0 color rgbt <0.5,0.4,0.2,0.0>]
	  [0.1 color rgbt <0.5,0.4,0.2,0.0>]
	  [0.6 color rgbt <0.8,0.7,0.6,1.0>]
	  [1.0 color rgbt <0.8,0.7,0.6,1.0>]
	}
	scale <4,1,0.1>
      }
      finish { diffuse 0.8 specular 0.2 }
    }

#declare framewood = texture { pigment { color rgb <0.7,0.4,0.3> } finish { diffuse 0.8 specular 0.2 } }

//H_streaks and V_streaks are used to make natural looking fiber streaks
//for the fabricboard
#declare H_streaks = pigment { bozo color_map { [0.0 color rgb <0.6,0.5,0.4>] [1.0 color rgb <0.8,0.7,0.6>] } scale <2,0.05,1> }
#declare V_streaks = pigment { bozo color_map { [0.0 color rgb <0.6,0.5,0.4>] [1.0 color rgb <0.8,0.7,0.6>] } scale <0.05,2,1> }

//I'm quite proud of this one.  I made a fabric bump map (see fabricbumps.pov),
//which looks good.  But then, I overlayed a checkerboard of H_streaks and
//V_streaks with the checker pattern.  The checker pattern and the bump map
//are scaled together so that the streaks line up with the fiber bumps.
#declare fabricboard = texture {
  pigment { checker pigment { H_streaks } pigment { V_streaks } scale 0.5*0.17 }
  normal { bump_map { gif "fabricbumps.gif" bump_size 10 } scale 0.17 }
  finish { diffuse 0.8 specular 0.2 }
}

#declare dkbeigepaint = texture { pigment { color rgb <0.6,0.5,0.4> } finish { diffuse 0.8 specular 0.2 } }
#declare orangebeigepaint = texture { pigment { color rgb <0.8,0.6,0.4> } finish { diffuse 0.8 specular 0.2 } }
#declare clearblue = texture { pigment { color rgbf <0,0,0.75,0.7> } finish { diffuse 0.6 specular 0.4 } }
#declare clearred = texture { pigment { color rgbf <0.75,0,0,0.7> } finish { diffuse 0.6 specular 0.4 } }
#declare cleargreen = texture { pigment { color rgbf <0,0.75,0,0.7> } finish { diffuse 0.6 specular 0.4 } }
#declare transyellow = texture { pigment { color rgbf <0.95,0.95,0,0.2> } finish { diffuse 0.8 specular 0.2 } }
#declare whiteplastic = texture { pigment { color rgb <0.95,0.95,0.95> } finish { diffuse 0.9 specular 0.1 } }
#declare blueplastic = texture { pigment { color rgb <0.1,0.1,0.9> } finish { diffuse 0.9 specular 0.1 } }

//light_source { <-30,96,-100> color rgb <1,1,1> }
//light_source { <10,96,-100> color rgb <1,1,1> }
//light_source { <41,40,29> color rgb <0.5,0.5,0.5> }
light_source { <10,96,-20> color rgb <0.9,0.9,0.9> area_light <10,0,0> <0,0,36> 9 21 }
//light_source { <10,96,-20> color rgb <0.9,0.9,0.9> area_light <10,0,0> <0,0,36> 3 7 }

//room
union {
  box { <50,0,-30> <50,100,150> texture { offwhitepaint } }  //south wall
  box { <-100,100,-100> <50,101,150> texture { whitepaint } } // ceiling
  box { <-100,0,-101> <50,100,-100> texture { whitepaint } } //back wall
  box { <-100,0,-100> <-101,100,150> texture { whitepaint } } //north wall
}

//desk
union {
  //desktop
  difference {
    //box { <0,29,0> <48,30,30> texture { beigepaint } }
    roundedbox(0,29,0,  48,30,30,  0.1)
    cylinder { <43,28,26.5> <43,31,26.5> 0.25 texture { beigepaint } }
    cylinder { <45,28,26.5> <45,31,26.5> 0.25 texture { beigepaint } }
    cylinder { <43,28,28.5> <43,31,28.5> 0.25 texture { beigepaint } }
    cylinder { <45,28,28.5> <45,31,28.5> 0.25 texture { beigepaint } }
    box { <42.75,28,26.5> <45.25,31,28.5> texture { beigepaint } }
    box { <43,28,26.25> <45,31,28.75> texture { beigepaint } }
    texture { beigepaint }
  }
  //the wood texture of the desktop
  box { <0.1,29.5,0.1> <47.9,30.001,29.9>
    texture { deskwood_turb } texture { deskwood_streaks }
  }
  //sides
  union {
    cylinder { <0.75,30.05,20> <0.75,60,20> 0.75 }
    box { <0,30.05,20> <1.5,60,30> }
  }
  union {
    cylinder { <0.75,30.05,20> <0.75,60,20> 0.75 }
    box { <0,30.05,20> <1.5,60,30> }
    translate 46.5*x
  }
  //shelf
  union {
    //left bracket
    cylinder { <1.53,60.25,14> <1.97,60.25,14> 0.5 }
    cylinder { <1.53,58.75,14> <1.97,58.75,14> 0.5 }
    box { <1.53,60.75,14> <1.97,58.25,30> }
    box { <1.53,60.25,13.5> <1.97,58.75,30> }

    //right bracket
    cylinder { <46.47,60.25,14> <46.03,60.25,14> 0.5 }
    cylinder { <46.47,58.75,14> <46.03,58.75,14> 0.5 }
    difference {
      union {
	box { <46.47,60.75,14> <46.03,58.25,30> }
	box { <46.47,60.25,13.5> <46.03,58.75,30> }
      }
      cylinder { <45,59.5,28.5> <50,59.5,28.5> 0.25 }
      cylinder { <45,59.5,21> <50,59.5,21> 0.25 }
    }
    difference {
      sphere { <0,0,0> 0.25 }
      box { <-1,-0.02,-1> <-0.05,0.02,1> }
      scale 0.5*x
      rotate 10*x
      translate <46.2,59.6,28.5>
      texture { chrome }
    }
    difference {
      sphere { <0,0,0> 0.25 }
      box { <-1,-0.02,-1> <-0.05,0.02,1> }
      scale 0.5*x
      rotate 40*x
      translate <46.13,59.5,21>
      texture { chrome }
    }

    //metal shelf
    box { <2.0,60.75,14.2> <46,60.65,30> }
    box { <2.0,60.2,14> <46,60.55,14.1> }
    box { <2.0,60,14.2> <46,60.1,14.7> }
    cylinder { <2.0,60.2,14.2> <46,60.2,14.2> 0.2 }
    cylinder { <2.0,60.55,14.2> <46,60.55,14.2> 0.2 }
    difference {  // left inside curve of support flange
      cylinder { <2.2,60.55,14.2> <2.2,60.55,30> 0.2 }
      cylinder { <2.2,60.55,14> <2.2,60.55,31> 0.1 }
      box { <2.1,60.55,14> <2.5,60.35,31> }
      box { <2.2,60.65,14> <2.5,60.35,31> }
    }
    box { <2.0,60.55,14.2> <2.1,60,30> }
    difference {  // right inside curve of support flange
      cylinder { <45.8,60.55,14.2> <45.8,60.55,30> 0.2 }
      cylinder { <45.8,60.55,14> <45.8,60.55,31> 0.1 }
      box { <45.9,60.55,14> <45.5,60.35,31> }
      box { <45.8,60.65,14> <45.5,60.35,31> }
    }
    difference { //right support flange
      box { <46.0,60.55,14.2> <45.9,60,30> }
      box { <45,59,15> <47,60.35,15.2> }
      box { <45,59,22> <47,60.35,22.2> }
      box { <45,59,29> <47,60.35,29.2> }
    }
    //support flange screws
    union {
      sphere { <0,0,0> 0.15 scale 0.25*x }
      cylinder { <0,0,0> <0.05,0,0> 0.15 }
      translate <45.83,60.35,22.1>
      texture { blackrubber }
    }
    union {
      sphere { <0,0,0> 0.15 scale 0.25*x }
      cylinder { <0,0,0> <0.05,0,0> 0.15 }
      translate <45.83,60.35,29.1>
      texture { blackrubber }
    }

    //light
    union {
      cylinder { <0,0,0.2> <24,0,0.2> 0.2 }
      box { <0,0,0> <24,1.5,0.2> }
      box { <0,0,0> <0.1,1.5,5> }
      box { <24,0,0> <23.9,1.5,5> }
      cylinder { <0,0.2,3> <24,0.2,3> 0.2 }
      box { <0,0,3> <24,0.1,5> }
      cylinder { <0.5,0.7,1.5> <23.5,0.7,1.5> 0.4
	texture { pigment { color rgb <1,1,1> } finish { ambient 1.0 } }
      }
      box {  //glass
	<0.1,0.05,0.1> <23.9,0.1,2.9>
	texture { pigment { color rgb <1,1,0.97> } finish { diffuse 1.4 } }
	interior { ior 1.5 }
      }
      light_source { <12,0,1.5> color rgb <0.9,0.9,0.9> area_light <23.8,0,0> <0,0,2.8> 23 7 }
      //light_source { <12,0,1.5> color rgb <0.9,0.9,0.9> area_light <23.8,0,0> <0,0,2.8> 11 3 }
      translate <12,58.5,15>
    }
  }
  //back wall
  union {
    box { <0,30,30.5> <48,59.75,31> }
    box { <0,59,30> <48,59.75,30.1> }
    box { <0,44,30> <48,44.75,30.1> }
    box { <0,30.05,30> <48,30.75,30.1> }
    box { <0,30,30.15> <48,44.5,30.25> texture { fabricboard } }
    #local i=1;
    #while (i<=6)
      cylinder { <0,44.75+2.25*i,30.1> <48,44.75+2.25*i,30.1> 0.1 }
      box { <0,44.75+2.25*i,30> <48,43.25+2.25*i,30.1> }
      cylinder { <0,43.25+2.25*i,30.06> <48,43.25+2.25*i,30.06> 0.06 }
      #local i=i+1;
    #end

  }
  //drawer
  texture { ltbeigepaint }
}

//computer
union {
  //box { <0,0,0> <16,4,16> }
  difference {
    roundedbox(0,0,0,  16,4,16, 0.0625)
    cylinder { <0,1.5,0> <10,1.5,-0.08> 0.06 }
    texture { greypaint }
  }
  //stickers
  union {
    box { <0,0,0.1> <2.5,0.01,0.4> }
    box { <0.1,0,0> <2.4,0.01,0.5> }
    cylinder { <0.1,0,0.1> <0.1,0.01,0.1> 0.1 }
    cylinder { <2.4,0,0.1> <2.4,0.01,0.1> 0.1 }
    cylinder { <0.1,0,0.4> <0.1,0.01,0.4> 0.1 }
    cylinder { <2.4,0,0.4> <2.4,0.01,0.4> 0.1 }
    text { ttf "cyrvetic.ttf", "CFA-02687", 0.01 0
      rotate 90*x scale 0.4 translate <0.3,0.015,0.1>
      texture { redpaint } }
    texture { whitepaint }
    rotate 98*y
    translate <0.7,4,5>
  }
  union {
    box { <0,0,0.1> <2.5,0.01,0.4> }
    box { <0.1,0,0> <2.4,0.01,0.5> }
    cylinder { <0.1,0,0.1> <0.1,0.01,0.1> 0.1 }
    cylinder { <2.4,0,0.1> <2.4,0.01,0.1> 0.1 }
    cylinder { <0.1,0,0.4> <0.1,0.01,0.4> 0.1 }
    cylinder { <2.4,0,0.4> <2.4,0.01,0.4> 0.1 }
    text { ttf "cyrvetic.ttf", "SMITHSONIAN INSTITUTION", 0.01 0
      rotate 90*x scale 0.11 translate <0.4,0.015,0.38>
      texture { blackplastic } }
    #declare i=0;
    #while (i<30)
      box { <0.3+i*0.06,0,0.21> <0.3+i*0.06,0.015,0.34> texture { blackplastic }}
      #declare i=i+1;
    #end
    text { ttf "cyrvetic.ttf", "320141", 0.01 0
      rotate 90*x scale 0.18 translate <0.8,0.015,0.06>
      texture { blackplastic } }
    texture { whitepaint }
    rotate 89*y
    translate <0.9,4,8>
  }
  //power cord
  union {
    roundedbox(0,0,0,  1.25,0.75,0.5, 0.08)
    cylinder { <1.25,0.375,0.25> <1.75,0.375,0.25> 0.21 }
    torus { 0.21 0.08 translate <1.3,0.375,0.25> }
    sphere_sweep {
      cubic_spline 9,
      <0,0.375,0.25> 0.18
      <1.75,0.375,0.25> 0.18
      <2.75,0.300,0.75> 0.18
      <4.5,-0.5,2.25> 0.18
      <5.25,-1.5,7> 0.18
      <5.5,-2.18,12.5> 0.18
      <5.5,-2.68,13> 0.18
      <5.5,-4,13> 0.18
      <5.5,-8,13> 0.18
    }
    texture { blackplastic }
    translate <16,2,2>
  }
  //ethernet
  union {
    sphere_sweep {
      cubic_spline 9,
      <-1,0.75,0> 0.12
      <-0.25,0.75,0> 0.12
      <1,0.75,0> 0.12
      <3,0.35,0.5> 0.12
      <5,0.45,1.5> 0.12
      <6.5,0.35,3> 0.12
      <6.75,0.25,5> 0.12
      <6.65,-0.5,5.7> 0.12
      <6.65,-2.5,5.7> 0.12
    }
    translate <16,0,9>
    texture { bluepaint }
  }
  //monitor cord
  union {
    sphere_sweep {
      cubic_spline 10,
      <-1,0.75,0> 0.18
      <-0.25,0.75,0> 0.18
      <2,0.75,0> 0.18
      <3.5,0.85,-0.25> 0.18
      <6,1.25,-1.5> 0.18
      <7,1.35,-3> 0.18
      <6,1.75,-4.5> 0.18
      <2.5,3,-5.5> 0.18
      <0,4.19,-6> 0.18
      <-1,4.25,-6> 0.18
    }
    cylinder { <6,1.75,-4.5> <4.25,2.375,-5.08> .4 }
    texture { ltgreypaint }
    translate <16,0,11>
  }
  //face plate
  union {
    box { <-0.1,0.1,0.1>  <0.1,3.9,15.9> }
    difference {  //box portion of top part of front panel
      roundedbox(-1,1.5,0,  0,4,16,  0.06)
      //smart card slot
      box { <-3,2.92,13.75> <3,3.08,11.75> }
      //smart card finger hole
      sphere { <0,0,0> 0.27 scale <1,1,2.5> translate <-1,3.0,12.75> }
      //this is actually the LED, should be dark green or black, not a hole
      cylinder { <-3,3.3,13.5> <3,3.3,13.5> 0.06 }

      //floppy drive stuff
      box { <-3,2.45,14.5> <3,2.3,11> } //disk hole
      box { <-3,2.49,13.5> <-0.8,2.0,12> } //finger hole
      box { <-3,2.0,11.8> <3,2.2,11.2> } //button hole
      box { <-3,2.0,13.8> <-0.95,2.15,14.1> } //LED hole

      //floppy drive and smart card edges
      box { <-3,3.5,14.9> <3,1.8,14.95> }  //left
      box { <-3,3.5,10.4> <3,1.8,10.45> }  //right
      box { <-3,3.5,14.9> <3,3.55,10.4> }  //top
      box { <-3,2.55,14.9> <3,2.6,10.4> }  //middle
      box { <-3,1.85,14.9> <3,1.8,10.4> }  //bottom

      //cdrom drive edges
      box { <-3,3.5,5.7> <3,2.05,5.65> }  //left
      box { <-3,3.5,0.8> <3,2.05,0.85> }  //right
      box { <-3,3.5,0.8> <3,3.55,5.7> }  //top
      box { <-3,2.05,0.8> <3,2.1,5.7> }  //bottom

      //cdrom hole
      cylinder { <-3,3.3,5.2> <3,3.3,5.2> 0.07 }
      cylinder { <-3,3.3,1.2> <3,3.3,1.2> 0.07 }
      cylinder { <-3,2.8,5.2> <3,2.8,5.2> 0.07 }
      cylinder { <-3,2.8,1.2> <3,2.8,1.2> 0.07 }
      box { <-3,3.37,5.2> <3,2.73,1.2> }
      box { <-3,3.3,5.27> <3,2.8,1.13> }
      //headphone jack
      cylinder { <-3,2.4,5.2> <3,2.4,5.2> 0.07 }
      cone { <-1.1,2.4,5.2> 0.2 <-0.9,2.4,5.2> 0.01 }
      //button holes and divet
      box { <-3,2.25,2.3> <-0.95,2.55,1.1> }
      box { <-3,2.3,2.25> <3,2.5,1.9> }
      box { <-3,2.3,1.5> <3,2.5,1.15> }
      //volume control hole and divet
      box { <-3,2.33,4.7> <3,2.47,4.3> }
      cylinder { <-1.3,2.33,4.5> <-1.3,2.47,4.5> 0.45 }
    }
    //floppy drive led
    box { <-1,2.05,13.85> <-0.8,2.1,14.05> texture { blackplastic } }
    //floppy drive button
    box { <-1.03,2.02,11.78> <0,2.18,11.22> }
    //cdrom front
    roundedbox(-1,2.76,1.16,  0,3.34,5.24,  0.065)
    //cdrom buttons
    box { <-1.05,2.32,2.23> <0,2.48,1.92> }
    box { <-1.05,2.32,1.48> <0,2.48,1.17> }
    //volume control
    cylinder { <-0.77,2.35,4.5> <-0.77,2.45,4.5> 0.3 }


    difference {
      union {
	cylinder { <1.5,2.5,0> <1.5,2.5,16> 2.835 }
	cylinder { <1.5,2.5,0.06> <1.5,2.5,15.94> 2.895 }
	torus { 2.835 0.06 rotate 90*x translate <1.5,2.5,0.06> }
	torus { 2.835 0.06 rotate 90*x translate <1.5,2.5,15.94> }
      }
      box { <0,-10,-1> < 10,10,20> }  //cut off right side
      box { <-2,3.97,-1> <10,5,20> } //cut off top
      box { <-0.94,3.94,-1> <10,5,0.06> } //cut off top front corner
      box { <-0.94,3.94,17> <10,5,15.94> } //cut off top back corner
      box { <-2,1.56,-1> <10,0,20> } //cut off bottom
      box { <-3,2,0.75> <3,3.6,5.75> } //cut out cd-rom hole
      box { <-3,1.75,15> <3,3.6,10.5> } //cut out floppy/smart-card hole
      //power button divet and hole
      sphere { <0,0,0> 0.25 scale <0.4,1,3> translate <-1.4,2.5,15.9> }
      sphere { <0,0,0> 0.35 scale <2,0.5,1> translate <-1.25,2.5,15.5> }
    }
    //power button
    sphere { <0,0,0> 0.30 scale <0.3,0.5,1> translate <-1.30,2.5,15.5> }
    //power button light
    sphere { <0,0,0> 0.08 scale <0.3,0.5,1> translate <-1.38,2.5,15.5>
      texture { greenled } }
    sphere { <-1.179,1.56,0.06> 0.06 }
    cylinder { <-1.179,1.56,0.06> <-0.9,1.56,0.06> 0.06 }
    cylinder { <-1.179,1.56,0.06> <-1.179,1.56,15.94> 0.06 }

    box { <-0.5,1.5,1>  <0,0,15> } //bottom front of front panel
    roundedbox(-0.25,1.5,0,  0,0,16,  0.06) //bottom front edges
    difference {
      sphere { <0,0,0> 2 scale 2.5*z translate <1,0.5,0.5> }
      sphere { <0,0,0> 1.75 scale 2.5*z translate <1,0.5,0.5> }
      box { <0,-10,-10> <5,10,10> } //cut off inside computer
      box { <-5,-10,0> <5,10,-10> } //cut off side
      box { <-5,1.47,-10> <5,10,10> } //cut off above
      box { <-5,0.03,-10> <5,-5,10> } //cut off below
    }
    difference {
      sphere { <0,0,0> 2 scale 2.5*z translate <1,0.5,15.5> }
      sphere { <0,0,0> 1.75 scale 2.5*z translate <1,0.5,15.5> }
      box { <0,-10,10> <5,10,25> } //cut off inside computer
      box { <-5,-10,16> <5,10,25> } //cut off side
      box { <-5,1.47,10> <5,10,25> } //cut off above
      box { <-5,0.03,10> <5,-5,20> } //cut off below
    }
    texture { dkgreypaint }
  }
  translate <22,30.1,12>
}

#declare baseraise=0.75;
#declare row_rotate=0;
#declare row_raise=0;
#declare keycol=0;
#declare keyrow=0;
#macro key(kwid,tbig,t1,t2,t3,clr)
union {
  prism { conic_sweep bezier_spline -2, -1.5, 48,
    <-0.4,0.0> <-0.466666666667,0.0> <-0.5,0.0333333333333> <-0.5,0.1>
    <-0.5,0.1> <-0.5,0.166666666667> <-0.5,0.3> <-0.5,0.5>
    <-0.5,0.5> <-0.5,0.7> <-0.5,0.833333333333> <-0.5,0.9>
    <-0.5,0.9> <-0.5,0.966666666667> <-0.466666666667,1.0> <-0.4,1.0>
    <-0.4,1.0> <-0.333333333333,1.0> <-0.2,1.0> <0.0,1.0>
    <0.0,1.0> <0.2,1.0> <0.333333333333,1.0> <0.4,1.0>
    <0.4,1.0> <0.466666666667,1.0> <0.5,0.966666666667> <0.5,0.9>
    <0.5,0.9> <0.5,0.833333333333> <0.5,0.7> <0.5,0.5>
    <0.5,0.5> <0.5,0.3> <0.5,0.166666666667> <0.5,0.1>
    <0.5,0.1> <0.5,0.0333333333333> <0.466666666667,0.0> <0.4,0.0>
    <0.4,0.0> <0.333333333333,0.0> <0.2,0.0> <0.0,0.0>
    <0.0,0.0> <-0.2,0.0> <-0.333333333333,0.0> <-0.4,0.0>
    translate <1,2,0>
    //scale <0.35*kwid,0.35,0.35>
    //fudge the scale so that wider keys scale 5% larger
    scale <0.35*(1.05*(kwid-1)+1),0.35,0.35>
    texture { clr }
  }
  #if (strlen(tbig))
    text { ttf "cyrvetic.ttf", tbig, 0.01 0
    rotate 90*x scale 0.2 translate <0.15,0.18,-0.2>
    texture { blackplastic } }
  #end
  #if (strlen(t1))
    text { ttf "cyrvetic.ttf", t1, 0.01 0
    rotate 90*x scale 0.13 translate <0.15,0.18,-0.18>
    texture { blackplastic } }
  #end
  #if (strlen(t2))
    text { ttf "cyrvetic.ttf", t2, 0.01 0
    rotate 90*x scale 0.13 translate <0.15,0.18,-0.3>
    texture { blackplastic } }
  #end
  #if (strlen(t3))
    text { ttf "cyrvetic.ttf", t3, 0.01 0
    rotate 90*x scale 0.13 translate <0.15,0.18,-0.4>
    texture { blackplastic } }
  #end
  rotate -row_rotate*x
  translate <keycol*0.75,baseraise+row_raise,0-keyrow*0.75>
}
  #declare keycol=keycol+kwid;
#end
#macro tallkey(kwid,t1,clr)
union {
  prism { conic_sweep bezier_spline -2, -1.5, 48,
    <-0.4,0.0> <-0.466666666667,0.0> <-0.5,0.0333333333333> <-0.5,0.1>
    <-0.5,0.1> <-0.5,0.166666666667> <-0.5,0.3> <-0.5,0.5>
    <-0.5,0.5> <-0.5,0.7> <-0.5,0.833333333333> <-0.5,0.9>
    <-0.5,0.9> <-0.5,0.966666666667> <-0.466666666667,1.0> <-0.4,1.0>
    <-0.4,1.0> <-0.333333333333,1.0> <-0.2,1.0> <0.0,1.0>
    <0.0,1.0> <0.2,1.0> <0.333333333333,1.0> <0.4,1.0>
    <0.4,1.0> <0.466666666667,1.0> <0.5,0.966666666667> <0.5,0.9>
    <0.5,0.9> <0.5,0.833333333333> <0.5,0.7> <0.5,0.5>
    <0.5,0.5> <0.5,0.3> <0.5,0.166666666667> <0.5,0.1>
    <0.5,0.1> <0.5,0.0333333333333> <0.466666666667,0.0> <0.4,0.0>
    <0.4,0.0> <0.333333333333,0.0> <0.2,0.0> <0.0,0.0>
    <0.0,0.0> <-0.2,0.0> <-0.333333333333,0.0> <-0.4,0.0>
    translate <1,2,0>
    scale <0.35,0.35,0.72>
    texture { clr }
  }
  #if (strlen(t1))
    text { ttf "cyrvetic.ttf", t1, 0.01 0
    rotate 90*x scale 0.13 translate <0.15,0.18,-0.2>
    texture { blackplastic } }
  #end
  rotate -row_rotate*x
  translate <keycol*0.75,baseraise+row_raise,0-keyrow*0.75>
}
  #declare keycol=keycol+kwid;
#end
#macro povkey(kwid,clr)
union {
  prism { conic_sweep bezier_spline -2, -1.5, 48,
    <-0.4,0.0> <-0.466666666667,0.0> <-0.5,0.0333333333333> <-0.5,0.1>
    <-0.5,0.1> <-0.5,0.166666666667> <-0.5,0.3> <-0.5,0.5>
    <-0.5,0.5> <-0.5,0.7> <-0.5,0.833333333333> <-0.5,0.9>
    <-0.5,0.9> <-0.5,0.966666666667> <-0.466666666667,1.0> <-0.4,1.0>
    <-0.4,1.0> <-0.333333333333,1.0> <-0.2,1.0> <0.0,1.0>
    <0.0,1.0> <0.2,1.0> <0.333333333333,1.0> <0.4,1.0>
    <0.4,1.0> <0.466666666667,1.0> <0.5,0.966666666667> <0.5,0.9>
    <0.5,0.9> <0.5,0.833333333333> <0.5,0.7> <0.5,0.5>
    <0.5,0.5> <0.5,0.3> <0.5,0.166666666667> <0.5,0.1>
    <0.5,0.1> <0.5,0.0333333333333> <0.466666666667,0.0> <0.4,0.0>
    <0.4,0.0> <0.333333333333,0.0> <0.2,0.0> <0.0,0.0>
    <0.0,0.0> <-0.2,0.0> <-0.333333333333,0.0> <-0.4,0.0>
    translate <1,2,0>
    scale <0.35*kwid,0.35,0.35>
    texture { clr }
  }
  text { ttf "povlogo.ttf", "P", 0.01 0
    rotate 90*x scale 0.4 translate <0.15,0.18,-0.48>
    texture { bluepaint } }
  rotate -row_rotate*x
  translate <keycol*0.75,baseraise+row_raise,0-keyrow*0.75>
}
  #declare keycol=keycol+kwid;
#end
#macro keyskip(kwid)
  #declare keycol=keycol+kwid;
#end

//keyboard
union {
//main keyboard body
difference {
  union {
    intersection {
      union {
        cylinder { <-0.25,18,0> <19.3,18,0> 16.9}
        torus { 16.36 0.06 rotate 90*z translate <19.3,18,0> }
        torus { 16.36 0.06 rotate 90*z translate <-0.25,18,0> }
      }
      box { <-1,0,-0.2> <21,3,5> }
    }
    difference {
      intersection {
	cylinder { <-0.31,18,0> <19.36,18,0> 16.9}
	box { <-1,0,-0.2> <21,3,4.94> }
      }
      cylinder { <-1,18,0> <21,18,0> 16.36 }
    }
  }
  cylinder { <-1,18,0> <21,18,0> 16.3 }
  //hole for set of keys on left
  box { <0,1,0> <1.5,3,3.75> translate <-0.04,0,-0.04> }
  //hole for main keyboard
  box { <1.875,1,0> <13.125,3,3.75> translate <-0.04,0,-0.04> }

  //hole for six keys - insert, del, home, end, pageup/down
  box { <13.5,1,2.25> <15.75,3,3.75> translate <-0.04,0,-0.04> }
  //hole for arrow keys
  box { <13.5,1,0> <15.75,3,0.75> translate <-0.04,0,-0.04> }
  box { <14.25,1,0.75> <15,3,1.5> translate <-0.04,0,-0.04> }

  //hole for numeric keypad
  box { <16.125,1,0> <19.125,3,3.75> translate <-0.04,0,-0.04> }

  //holes for top row of buttons
  box { <0,1,4.125> <1.5,3,4.875> translate <-0.04,0,-0.04> }
  box { <1.875,1,4.125> <2.625,3,4.875> translate <-0.04,0,-0.04> }
  box { <3.375,1,4.125> <6.375,3,4.875> translate <-0.04,0,-0.04> }
  box { <6.75,1,4.125> <9.75,3,4.875> translate <-0.04,0,-0.04> }
  box { <10.125,1,4.125> <13.125,3,4.875> translate <-0.04,0,-0.04> }
  box { <13.5,1,4.125> <15.75,3,4.875> translate <-0.04,0,-0.04> }
  box { <16.125,1,4.125> <19.125,3,4.875> translate <-0.04,0,-0.04> }
  translate <0,-1,-3.7>
}
//keyboard cord
sphere_sweep {
  cubic_spline 19,
  <10,1,4> 0.1
  <11,1,4.5> 0.1
  <19,0.5,4> 0.1
  <21,0.12,7> 0.1
  <25,0.12,8.5> 0.1
  <28,0.3,10> 0.1
  <28.25,-1,11> 0.1
  <28.25,-2,11> 0.1
  <28.25,-2,11> 0.1
  <28.25,-1,11> 0.1
  <28,0.25,11> 0.1
  <26.25,0.12,11.5> 0.1
  <25.75,0.12,13> 0.1
  <24.25,0.12,13> 0.1
  <24,0.12,11> 0.1
  <23,0.12,11> 0.1
  <21,0.25,11.5> 0.1
  <17.5,0.30,11.5> 0.1
  <16,0.30,11.5> 0.1
}

//underside of keyboard
box { <-0.1,0.3,-0.1> <19.05,0.5,4.9> translate <0,0,-3.7> texture { dkgreypaint } }
box { <-0.1,0.4,3> <19.05,0.8,4.9> translate <0,0,-3.7> texture { dkgreypaint } }
//top edge of keyboard
union {
  //box { <-2,0.5,0> <2,0.51,0.55> texture { dkgreypaint } }
  text { ttf "cyrvetic.ttf", "Num Lock", 0.01 0
    rotate 90*x scale 0.13 translate <-1.8,0.46,0.40>
    texture { blackplastic } }
  text { ttf "cyrvetic.ttf", "Caps Lock", 0.01 0
    rotate 90*x scale 0.13 translate <-0.8,0.46,0.40>
    texture { blackplastic } }
  text { ttf "cyrvetic.ttf", "Scroll Lock", 0.01 0
    rotate 90*x scale 0.13 translate <0.2,0.46,0.40>
    texture { blackplastic } }
  text { ttf "cyrvetic.ttf", "Compose", 0.01 0
    rotate 90*x scale 0.13 translate <1.2,0.46,0.40>
    texture { blackplastic } }
  text { ttf "povlogo.ttf", "P", 0.01 0
    rotate 90*x scale 0.8 translate <3.0,0.51,0.06>
    texture { bluepaint } }
  sphere { <0,0,0> 0.05 scale <1,0.1,2> translate <-1.5,0.45,0.2> texture { blackplastic } }
  sphere { <0,0,0> 0.05 scale <1,0.1,2> translate <-0.5,0.45,0.2> texture { blackplastic } }
  sphere { <0,0,0> 0.05 scale <1,0.1,2> translate <0.5,0.45,0.2> texture { blackplastic } }
  sphere { <0,0,0> 0.05 scale <1,0.1,2> translate <1.5,0.45,0.2> texture { blackplastic } }

  difference {
    intersection {
      cylinder { <0,0,0> <0,0.5,0> 42 translate -40.85*z }
      box { <-40,-1,0> <40,1,3> }
    }
    box { <-2,0.45,0> <2,0.51,0.55> texture { dkgreypaint } }
  }
  rotate -12*x
  translate <9.52,0.92,1.4>
}
cylinder { <-0.25,1.41,1.3> <19.3,1.41,1.3> 0.06 }
//bottom edge of keyboard
union {
  intersection {
    union {
      cylinder { <-0.25,0,0> <19.3,0,0> 0.6 }
      torus { 0.54 0.06 rotate 90*z translate <-0.25,0,0> }
      torus { 0.54 0.06 rotate 90*z translate <19.3,0,0> }
    }
    box { <-1,0,-1> <20,1,0> }
  }
  intersection {
    cylinder { <-0.31,0,0> <19.36,0,0> 0.54 }
    box { <-1,0,-1> <20,1,0> }
  }
  translate <0,0.1,-3.9>
}

//left side of keyboard
sphere { <-0.25,1.41,1.3> 0.06 }
sphere { <19.3,1.41,1.3> 0.06 }

//the keys
#declare keycol=0;
#declare keyrow=-1.5;
#declare row_rotate=13;
#declare row_raise=0.7;
key(2, ""," Help","","",greypaint)
keyskip(0.5)
key(1,"","","","",greypaint)
keyskip(1)
key(1,"","F1","","",greypaint)
key(1,"","F2","","",greypaint)
key(1,"","F3","","",greypaint)
key(1,"","F4","","",greypaint)
keyskip(0.5)
key(1,"","F5","","",greypaint)
key(1,"","F6","","",greypaint)
key(1,"","F7","","",greypaint)
key(1,"","F8","","",greypaint)
keyskip(0.5)
key(1,"","F9","","",greypaint)
key(1,"","F10","","",greypaint)
key(1,"","F11","","",greypaint)
key(1,"","F12","","",greypaint)
keyskip(0.5)
key(1,"","Print","Screen","",greypaint)
key(1,"","Screen","Lock","",greypaint)
key(1,"","Pause","","",greypaint)
keyskip(0.5)
key(1,"","Mon","","Mute",greypaint)
key(1,"","C-","","V-",greypaint)
key(1,"","C+","","V+",greypaint)
povkey(1,ltgreypaint)

#declare keycol=0;
#declare keyrow=0;
#declare row_rotate=10;
#declare row_raise=0.4;
key(1, "","Stop","","",greypaint)
key(1, "","Again","","",greypaint)
keyskip(0.5)
key(1, "","Esc","","",greypaint)
key(1, "!","","","1",ltgreypaint)
key(1, "","@","","2",ltgreypaint)
key(1, "","#","","3",ltgreypaint)
key(1, "","$","","4",ltgreypaint)
key(1, "","%","","5",ltgreypaint)
key(1, "","^","","6",ltgreypaint)
key(1, "","&","","7",ltgreypaint)
key(1, "","*","","8",ltgreypaint)
key(1, "","(","","9",ltgreypaint)
key(1, "",")","","0",ltgreypaint)
key(1, "","_","","-",ltgreypaint)
key(1, "","+","","=",ltgreypaint)
key(1, "","|","","\\",ltgreypaint)
key(1, "","~","","`",ltgreypaint)

keyskip(0.5)
key(1, "","Insert","","",greypaint)
key(1, "","Home","","",greypaint)
key(1, "","Page","Up","",greypaint)

keyskip(0.5)
key(1, "","Num","Lock","",greypaint)
key(1, "/","","","",greypaint)
key(1, "*","","","",greypaint)
key(1, "-","","","",greypaint)

#declare keyrow=1;
#declare keycol=0;
#declare row_rotate=7.5;
#declare row_raise=0.24;
key(1, "","Props","","",greypaint)
key(1, "","Undo","","",greypaint)
keyskip(0.5)
key(1.5, "","Tab","","",greypaint)
key(1, "Q","","","",ltgreypaint)
key(1, "W","","","",ltgreypaint)
key(1, "E","","","",ltgreypaint)
key(1, "R","","","",ltgreypaint)
key(1, "T","","","",ltgreypaint)
key(1, "Y","","","",ltgreypaint)
key(1, "U","","","",ltgreypaint)
key(1, "I","","","",ltgreypaint)
key(1, "O","","","",ltgreypaint)
key(1, "P","","","",ltgreypaint)
key(1, "","{","","[",ltgreypaint)
key(1, "","}","","]",ltgreypaint)
key(1.5, "","Back","Space","",greypaint)
keyskip(0.5)
key(1, "","Del","","",greypaint)
key(1, "","End","","",greypaint)
key(1, "","Page","Down","",greypaint)
keyskip(0.5)
key(1, "","7","","Home",ltgreypaint)
key(1, "","8","","",ltgreypaint)
key(1, "","9","","PgUp",ltgreypaint)
tallkey(1, "+",greypaint)

#declare keyrow=2;
#declare keycol=0;
#declare row_rotate=5;
#declare row_raise=0.12;
key(1, "","Front","","",greypaint)
key(1, "","Copy","","",greypaint)
keyskip(0.5)
key(1.75, ""," Control","","",greypaint)
key(1, "A","","","",ltgreypaint)
key(1, "S","","","",ltgreypaint)
key(1, "D","","","",ltgreypaint)
key(1, "F","","","",ltgreypaint)
key(1, "G","","","",ltgreypaint)
key(1, "H","","","",ltgreypaint)
key(1, "J","","","",ltgreypaint)
key(1, "K","","","",ltgreypaint)
key(1, "L","","","",ltgreypaint)
key(1, "",":","",";",ltgreypaint)
key(1, "","\"","","'",ltgreypaint)
key(2.25, "","   Return","","",greypaint)
keyskip(4)
key(1, "","4","","",ltgreypaint)
key(1, "","5","","",ltgreypaint)
key(1, "","6","","",ltgreypaint)

#declare keyrow=3;
#declare keycol=0;
#declare row_rotate=3;
#declare row_raise=0.04;
key(1, "","Open","","",greypaint)
key(1, "","Paste","","",greypaint)
keyskip(0.5)
key(2.25, "","   Shift","","",greypaint)
key(1, "Z","","","",ltgreypaint)
key(1, "X","","","",ltgreypaint)
key(1, "C","","","",ltgreypaint)
key(1, "V","","","",ltgreypaint)
key(1, "B","","","",ltgreypaint)
key(1, "N","","","",ltgreypaint)
key(1, "M","","","",ltgreypaint)
key(1, "","<","",",",ltgreypaint)
key(1, "",">","",".",ltgreypaint)
key(1, "","?","","/",ltgreypaint)
key(2.75, "","     Shift","","",greypaint)
keyskip(1.5)
key(1, "","|","^","",greypaint)
keyskip(1.5)
key(1, "","1","","End",ltgreypaint)
key(1, "","2","","",ltgreypaint)
key(1, "","3","","PgDn",ltgreypaint)
tallkey(1, "Enter",greypaint)

#declare keyrow=4;
#declare keycol=0;
#declare row_rotate=1;
#declare row_raise=0;
key(1, "","Find","","",greypaint)
key(1, "","Cut","","",greypaint)
keyskip(0.5)
key(1.75, ""," Caps Lock","","",greypaint)
key(1, "","Alt","","",greypaint)
key(1.5, "","Meta","","",greypaint)
key(7.25, "","","","",ltgreypaint)
key(1.5, "","Meta","","",greypaint)
key(1, "","Com-","pose","",greypaint)
key(1, "","Alt","Graph","",greypaint)
keyskip(0.5)
key(1, "","<-","","",greypaint)
key(1, "","|","V","",greypaint)
key(1, "","->","","",greypaint)
keyskip(0.5)
key(2, ""," 0",""," Ins",ltgreypaint)
key(1, "",".","","Del",ltgreypaint)

translate <20,30.05,8>
texture { greypaint }
}


//mouse pad
union {
  box { <0,0,1> <9,0.2,6> }
  box { <1,0,0> <8,0.2,7> }
  cylinder { <1,0,1> <1,0.2,1> 1 }
  cylinder { <8,0,1> <8,0.2,1> 1 }
  cylinder { <1,0,6> <1,0.2,6> 1 }
  cylinder { <8,0,6> <8,0.2,6> 1 }
  texture { blackrubber }
  rotate 14*y
  translate <39.2,30,4>
}

//mouse
#declare US=5;
#declare VS=5;
#declare FN=0.001;

background { color Black }

difference {
  union {
    bicubic_patch {
      type 0
      flatness FN
      u_steps US
      v_steps VS
      <0,0,3> <-0.6,0,5> <3.6,0,5> <3,0,3>
      <0.25,0,2> <1.0,1,2.5> <2.0,1,2.5> <2.75,0,2>
      <0.25,0,1> <1.0,2,-1> <2.0,2,-1> <2.75,0,1>
      <0,0,0> <-0.75,0,-3> <3.75,0,-3> <3,0,0>
      texture { whitepaint }
    }

    bicubic_patch {
      type 0
      flatness FN
      u_steps US
      v_steps VS
      <3,0,3> <2.75,0,2> <2.75,0,1> <3,0,0>
      <3.05,-0.05,3.025> <2.7875,-0.05,1.975> <2.76875,-0.05,1.05> <3.025,-0.05,0.025>
      <3.05,-0.35,3.025> <2.7875,-0.35,1.975> <2.76875,-0.35,1.05> <3.025,-0.35,0.025>
      <3,-0.4,3> <2.75,-0.4,2> <2.75,-0.4,1> <3,-0.4,0>
      texture { whitepaint }
    }

    bicubic_patch {
      type 0
      flatness FN
      u_steps US
      v_steps VS
      <0,0,3> <0.25,0,2> <0.25,0,1> <0,0,0>
      <-0.05,-0.05,3.025> <0.2125,-0.05,1.975> <0.23125,-0.05,1.05> <-0.025,-0.05,0.025>
      <-0.05,-0.35,3.025> <0.2125,-0.35,1.975> <0.23125,-0.35,1.05> <-0.025,-0.35,0.025>
      <0,-0.4,3> <0.25,-0.4,2> <0.25,-0.4,1> <0,-0.4,0>
      texture { whitepaint }
    }

    bicubic_patch {
      type 0
      flatness FN
      u_steps US
      v_steps VS
      <0,0,0> <-0.75,0,-3> <3.75,0,-3> <3,0,0>
      <-0.025,-0.05,0.025> <-0.79375,-0.05,-3.05> <3.79375,-0.05,-3.05> <3.025,-0.05,0.025>
      <-0.025,-0.35,0.025> <-0.79375,-0.35,-3.05> <3.79375,-0.35,-3.05> <3.025,-0.35,0.025>
      <0,-0.4,0> <-0.75,-0.4,-3> <3.75,-0.4,-3> <3,-0.4,0>
      texture { whitepaint }
    }

    bicubic_patch {
      type 0
      flatness FN
      u_steps US
      v_steps VS
      <0,0,3> <-0.6,0,5> <3.6,0,5> <3,0,3>
      <-0.05,-0.05,3.025> <-0.68,-0.05,5.125> <3.68,-0.05,5.125> <3.05,-0.05,3.025>
      <-0.05,-0.35,3.025> <-0.68,-0.35,5.125> <3.68,-0.35,5.125> <3.05,-0.35,3.025>
      <0,-0.4,3> <-0.6,-0.4,5> <3.6,-0.4,5> <3,-0.4,3>
      texture { ltgreypaint }
    }

  }
  box { <1,-1,2> <1.03,3,6> }
  box { <2,-1,2> <1.97,3,6> }
  box { <-1,-0.1,1.45> <4,-0.07,6> }
  difference {
    cylinder { <1.5,-0.1,0> <1.5,3,0> 2.04 }
    cylinder { <1.5,-0.1,0> <1.5,3,0> 2.01 }
    box { <-1,-1,-3> <4,3,0> }
  }
  scale <0.6,0.8,0.6>
  rotate 25*y
  translate <41,30.64,5>
}

//mouse cord
union {
  sphere_sweep {
    cubic_spline 16,
    <42.5,0.3,5> 0.08
    <42.9,0.3,7> 0.08
    <44,0.35,8> 0.08
    <46,0.4,8.5> 0.08
    <48,0.4,9> 0.08
    <48.5,-0.5,9.5> 0.08
    <49,-5.5,10> 0.08
    <49,-5.5,17> 0.08
    <48.5,-0.5,18> 0.08
    <48,0.45,18> 0.08
    <47,0.35,18.2> 0.08
    <45,0.13,18.75> 0.08
    <43,0.4,18> 0.08
    <40,0.4,19> 0.08
    <36,0.55,19.5> 0.08
    <34,0.55,19.5> 0.08
  }
  translate <0,30,0>
  texture { ltgreypaint }
}

//monitor stand
difference {
  union {
    box { <0.2,1.9,0.2> <11.8,2,11.8> }
    difference {
      cylinder { <0.2,1.8,0.2> <11.8,1.8,0.2> 0.2 }
      cylinder { <0,1.8,0.2> <12,1.8,0.2> 0.1 }
      box { <0.2,1.8,0.1> <11.8,1.5,0.5> }
      box { <0,1.9,0.2> <12,1.5,0.5> }
    }
    box { <0.2,1.60,0> <11.8,1.8,0.1> }

    box { <0,0.2,0.2> <0.1,1.8,11.8> }
    difference {
      cylinder { <0.2,1.8,0.2> <0.2,1.8,11.8> 0.2 }
      cylinder { <0.2,1.8,0> <0.2,1.8,12> 0.1 }
      box { <0.1,1.8,0> <0.5,1.5,12> }
      box { <0.2,1.9,0> <0.5,1.5,12> }
    }
    box { <12,0.2,0.2> <11.9,1.8,11.8> }
    difference {
      cylinder { <11.8,1.8,0.2> <11.8,1.8,11.8> 0.2 }
      cylinder { <11.8,1.8,0> <11.8,1.8,12> 0.1 }
      box { <11.9,1.8,0> <11.5,1.5,12> }
      box { <11.8,1.9,0> <11.5,1.5,12> }
    }

    box { <0.2,0,0.2> <0.6,0.1,11.8> }
    difference {
      cylinder { <0.2,0.2,0.2> <0.2,0.2,11.8> 0.2 }
      cylinder { <0.2,0.2,0> <0.2,0.2,12> 0.1 }
      box { <0.1,0.2,0> <0.5,0.5,12> }
      box { <0.2,0.1,0> <0.5,0.5,12> }
    }
    box { <11.8,0,0.2> <11.4,0.1,11.8> }
    difference {
      cylinder { <11.8,0.2,0.2> <11.8,0.2,11.8> 0.2 }
      cylinder { <11.8,0.2,0> <11.8,0.2,12> 0.1 }
      box { <11.9,0.2,0> <11.5,0.5,12> }
      box { <11.8,0.1,0> <11.5,0.5,12> }
    }
  }
  cylinder { <0.5,1.5,0.5> <0.5,2.5,0.5> 0.2 }
  cylinder { <11.5,1.5,0.5> <11.5,2.5,0.5> 0.2 }
  cylinder { <0.5,1.5,11.5> <0.5,2.5,11.5> 0.2 }
  cylinder { <11.5,1.5,11.5> <11.5,2.5,11.5> 0.2 }

  texture { beigepaint }
  translate <24,34.2,12>
}

//monitor
union {
  //the monitor base and swiveler
  //box { <0,0,0> <10,1,11> texture { greypaint } }
  roundedbox(0,0,0,  10,1,11, 0.0625)

  // the monitor part of the monitor
  union {
    //the big box that sits behind the monitor face
    roundedbox (-5,3,3  5,13,16, 0.1)

    //monitor sides, and rounded corners
    box { <-9.06,0.06,-0.912> <-8,15.94,2.94> }
    sphere { <-9,15.94,-0.912> 0.06 }
    sphere { <-9,0.06,-0.912> 0.06 }
    sphere { <-9,15.94,2.94> 0.06 }
    sphere { <-9,0.06,2.94> 0.06 }
    cylinder { <-9,15.94,-0.912> <-9,15.94,2.94> 0.06 }
    cylinder { <-9,0.06,-0.912> <-9,0.06,2.94> 0.06 }
    cylinder { <-9,15.94,-0.912> <-9,0.06,-0.912> 0.06 }
    cylinder { <-9,15.94,2.94> <-9,0.06,2.94> 0.06 }
    box { <9.06,0.06,-0.912> <8,15.94,2.94> }
    sphere { <9,15.94,-0.912> 0.06 }
    sphere { <9,0.06,-0.912> 0.06 }
    sphere { <9,15.94,2.94> 0.06 }
    sphere { <9,0.06,2.94> 0.06 }
    cylinder { <9,15.94,-0.912> <9,15.94,2.94> 0.06 }
    cylinder { <9,0.06,-0.912> <9,0.06,2.94> 0.06 }
    cylinder { <9,15.94,-0.912> <9,0.06,-0.912> 0.06 }
    cylinder { <9,15.94,2.94> <9,0.06,2.94> 0.06 }

    //Monitor controls
    difference {
      intersection {
	union {
	  cylinder { <0,0,38> <0,-0.75,38> 39.84 }
	  cylinder { <0,0,38> <0,-0.69,38> 39.9 }
	  torus { 39.84 0.06 translate <0,-0.69,38> }
	}
	box { <-5,-1,-10> <5,1,3> }
      }
      cylinder { <0,1,38> <0,15,38> 36 }
      intersection {  // long divet for button row
        torus { 39.92 0.1 translate <0,-0.37,38> }
	box { <-4.7,0,-10> <4.7,-1,5> }
      }
      box { <3.8,-0.28,-2> <4.77,-0.46,0> }  //power button hole
      difference { //reset button hole and button
        box { <-4.1,-0.28,-2> <-4.3,-0.46,0> }
        box { <-4.13,-0.31,-2> <-4.27,-0.43,0> }
      }
      sphere { <-4.2,-0.37,-1.6> 0.03 } //reset button dimple
      box { <-3.6,-0.28,-2> <-3.1,-0.46,0> } //button hole
      box { <-3.0,-0.28,-2> <-2.5,-0.46,0> } //button hole
      box { <-2.4,-0.28,-2> <-1.9,-0.46,0> } //button hole
      box { <-1.8,-0.28,-2> <-1.3,-0.46,0> } //button hole
      box { <-1.2,-0.28,-2> <-0.7,-0.46,0> } //button hole
// [-3.6,-3.1] [-3.0,-2.5] [-2.4,-1.9] [-1.8,-1.3] [-1.2,-0.7]

      box { <-0.2,-0.28,-2> <0.3,-0.46,0> } //button hole
      box { <0.4,-0.28,-2> <0.9,-0.46,0> } //button hole
      box { <1.2,-0.28,-2> <1.7,-0.46,0> } //button hole
      box { <1.8,-0.28,-2> <2.3,-0.46,0> } //button hole
    }
    //rounded ends of control box
    sphere { <-5,-0.69,-1.525> 0.06 }
    cylinder { <-5,-0.69,-1.525> <-5,0.5,-1.525> 0.06 }
    cylinder { <-5,-0.69,-1.525> <-5,-0.69,3> 0.06 }
    box { <-5,0.5,-1.525> <-5.06,-0.69,3> }
    sphere { <5,-0.69,-1.525> 0.06 }
    cylinder { <5,-0.69,-1.525> <5,0.5,-1.525> 0.06 }
    cylinder { <5,-0.69,-1.525> <5,-0.69,3> 0.06 }
    box { <5,0.5,-1.525> <5.06,-0.69,3> }

    box { <3,-0.28,-1.79> <3.1,-0.46,0> texture { blackplastic } }
    box { <3.4,-0.28,-1.77> <3.5,-0.46,0> texture { greenled } }
    //row of buttons
    difference {
      intersection {
        cylinder { <0,-0.32,38> <0,-0.42,38> 39.97 }
	box { <-3.58,-1,-10> <4.75,1,3> }
      }
      box { <-3.12,-0.28,-2> <-2.98,-0.46,0> }
      box { <-2.52,-0.28,-2> <-2.38,-0.46,0> }
      box { <-1.92,-0.28,-2> <-1.78,-0.46,0> }
      box { <-1.32,-0.28,-2> <-1.18,-0.46,0> }
      box { <-0.72,-0.28,-2> <-0.18,-0.46,0> }
      box { <0.28,-0.28,-2> <0.42,-0.46,0> }
      box { <0.88,-0.28,-2> <1.22,-0.46,0> }
      box { <1.68,-0.28,-2> <1.82,-0.46,0> }
      box { <2.28,-1,-3> <3.82,0,3> }
    }

    //This is the monitor face
    difference {
      intersection {
	union {
	  cylinder { <0,0,38> <0,16,38> 39.94 }
	  cylinder { <0,0.06,38> <0,15.94,38> 40 }
	  torus { 39.94 0.06 translate <0,15.94,38> }
	  torus { 39.94 0.06 translate <0,0.06,38> }
	}
	box { <-9,-1,-10> <9,17,3> }
      }
      cylinder { <0,1,38> <0,15,38> 39.5 }

      //these boxes and cylinders make the hole for the screen
      //(without the bevels)
      box { <-7,2.06,-10> <7,13.94,10> }
      box { <-6.94,2,-10> <6.94,14,10> }
      cylinder { <-6.94,2.06,-10> <-6.94,2.06,10> 0.06 }
      cylinder { <6.94,2.06,-10> <6.94,2.06,10> 0.06 }
      cylinder { <-6.94,13.94,-10> <-6.94,13.94,10> 0.06 }
      cylinder { <6.94,13.94,-10> <6.94,13.94,10> 0.06 }

      //screen hole bevels are made by subtracting this object which is
      //sort of a pyramid shape, but not really
      difference {
	cylinder { <0,1,38> <0,15,38> 40.1 }
	cone { <0,0.3,38> 40.5 <0,2.1,38> 39.5 }
	cone { <0,15.7,38> 40.5 <0,13.9,38> 39.5 }
	box { <-100,-1,-100> <0,18,100> rotate 60*y translate <-7.1,0,-1> }
	box { <100,-1,-100> <0,18,100> rotate -60*y translate <7.1,0,-1> }
	cylinder { <0,0,38> <0,16,38> 39.55 }
      }

    }

    //monitor light source
    //light_source { <0,8,0.9> color rgb <0.5,0.5,0.7> area_light <1,0,0> <0,1,0> 14 12 }

    //monitor picture
    intersection {
      cylinder { <0,0.06,38> <0,15.94,38> 39.25 }
      box { <-8,1,-2> <8,15,1> }
      texture {
	pigment { image_map { png "desktop1.png" once }
	  scale <14,12,1> translate <-7,2,0> }
	finish { ambient 0.8 }
      }
      //no_shadow
    }

    //monitor label
  //intersection {
  //  cylinder { <0,0.06,38> <0,15.94,38> 40.001 }
  //  box { <-8,0.1,-2> <-5.8,1.15,0> }
  //  texture {
  //	pigment { image_map { gif "irtc-logo.gif" transmit 0, 1.0 }
  //	  scale <2.22,1.2,1> translate <-8,0.05,0> }
  //    finish { ambient 0.5 }
  //  }
  //}
    //monitor label
    object {
      Povray_Logo
      pigment {   planar scale 2 translate y
	color_map {
	  [0.0, color <1.0, 0.4, 0.4>] // Red
	  [0.5, color <0.4, 0.9, 0.4>] // Green
	  [1.0, color <0.4, 0.4, 1.0>] // Blue
	}
      }
      scale 0.7
      rotate 10*y
      translate <-8.2,0.8,-1.2>
    }

    translate <5,3,0>
    texture { greypaint }
  }
  //difference {
  //  cylinder { <0,0,38> <0,16,38> 40 }
  //  box { <-9,-1,-10> <-100,17,100> }
  //  box { <9,-1,-10> <100,17,100> }
  //  box { <-100,-1,3> <100,17,100> }
  //  box { <-7,2,-10> <7,14,100> }
  //  cylinder { <0,1,38> <0,15,38> 39.5 }
  //  translate <5.5,3,0>
  //}

  rotate 1*y //just skew things a bit to look "normal"
  translate <24.9,36.3,11.75>
  texture { dkgreypaint }
}

//
// objects used to populate the desk
//

//water bottle
union {
  torus { 1.25 0.2 translate 0.2*y }
  cylinder { <0,0.2,0> <0,5,0> 1.45
    texture { whitepaint }
    texture {
      pigment { image_map { gif "irtc-logo-wide.gif"
          map_type 2 transmit 0,1 once }
        rotate 180*y scale <1,2,1> translate <0,1.75,0> }
      finish { diffuse 0.8 specular 0.2 }
    }
  }
  torus { 0.75 0.7 translate 5*y }
  difference {
    cylinder { <0,5.6,0> <0,6.5,0> 1.2 }
    torus { 1.35 0.55 translate 6.08*y }
  }
  cylinder { <0,6.5,0> <0,6.85,0> 0.95 }
  cylinder { <0,6.5,0> <0,6.55,0> 1 }
  cylinder { <0,6.80,0> <0,6.85,0> 1 }

  //detailing
  torus { 1.45 0.02 translate 5*y }
  torus { 1.45 0.02 translate 4.75*y }
  torus { 1.45 0.02 translate 4.65*y }
  torus { 1.45 0.02 translate 4.4*y }

  //cover
  union {
    cylinder { <0,6.57,0> <0,6.78,0> 1.03 }
    cylinder { <0,6.87,0> <0,7.3,0> 1.03 }
    torus { 0.94 0.07 translate 7.3*y }
    cone { <0,7.37,0> 0.94 <0,7.47,0> 0.5 }
    torus { 0.5 0.07 translate 7.47*y }
    cone { <0,7.54,0> 0.5 <0,7.58,0> 0.31 }
    difference {
      cylinder { <0,7.56,0> <0,7.64,0> 0.38 }
      torus { 0.38 0.07 translate 7.64*y }
    }
    difference {
      cylinder { <0,7.5,0> <0,7.9,0> 0.31 }
      cylinder { <0,7.5,0> <0,8,0> 0.29 }
    }
    union { //lid thumbtab
      cylinder { <-0.25,0,-0.25> <-0.25,0,0.25> 0.03 }
      cylinder { <-0.25,0,-0.3> <0.1,0,-0.31> 0.03 }
      cylinder { <-0.25,0,0.3> <0.1,0,0.31> 0.03 }
      torus { 0.05 0.03 translate <-0.2,0,-0.25> }
      torus { 0.05 0.03 translate <-0.2,0,0.25> }
      box { <-0.25,-0.03,-0.3> <0.1,0.03,0.3> }
      cylinder { <-0.12,0,0> <0,0.12,0> 0.03 }
      cylinder { <-0.2,0,-0.2> <0,0.2,-0.2> 0.03 }
      cylinder { <-0.2,0,0.2> <0,0.2,0.2> 0.03 }
      cylinder { <-0.13,0,-0.2> <0,0.13,-0.2> 0.03 }
      cylinder { <-0.13,0,0.2> <0,0.13,0.2> 0.03 }
      rotate -10*z
      translate <-1,6.9,0>
    }
    union {  //lid connector
      difference {
	cylinder { <1.25,6.735,-0.15> <1.25,6.735,0.15> 0.165 }
	cylinder { <1.25,6.735,-0.2> <1.25,6.735,0.2> 0.15 }
	box { <0,6,-1> <1.25,7,1> }
      }
      box { <1,6.57,0.15> <1.25,6.6,-0.15> }
      box { <1,6.87,0.15> <1.25,6.9,-0.15> }
    }
    texture { redpaint }
  }
  //valve
  union {
    cylinder { <0,7.8,0> <0,8.15,0> 0.27 }
    torus { 0.34 0.07 translate 8.15*y }
    difference {
      sphere { <0,7.07,0> 1.2 }
      box { <-5,0,-5> <5,8.22,5> }
      cylinder { <0,7,0> <0,9,0> 0.13 }
    }
    texture { blackrubber }
  }

  texture { whitepaint }
  rotate 27*y
  translate <45,30.05,12>
}

//coffee cup
union {
  //cup
  difference {
    cylinder { <0,0.6,0> <0,3.75,0> 1.625 }
    cylinder { <0,0.9,0> <0,3.8,0> 1.375 }
    cone { <0,3,0> 1.3 <0,3.8,0> 1.5 }
    //round the transition between cone and cylinder
    #declare trans_rad=1;
    //intersection of cone and cylinder above occurs at y=3.3
    difference {
      cylinder { <0,0,0> <0,0.2443*trans_rad,0> 1.375+trans_rad }
      torus { 1.375+trans_rad trans_rad }
      translate (3.3-trans_rad*0.12309)*y
    }
  }
  torus { 1.585 0.04 translate <0,3.75,0> }
  torus { 1.535 0.04 translate <0,3.75,0> }
  torus { 1.585 0.04 translate <0,0.6,0> }
  //handle
  //top nut
  intersection {
    sphere { <0,-0.20,0> 0.4 }
    prism {
      linear_sweep linear_spline -0.1,0.25,7,
      <-0.216,0.125> <0,0.25> <0.216,0.125>
      <0.216,-0.125> <0,-0.25> <-0.216,-0.125> <-0.216,0.125>
    }
    scale 1.2
    rotate -90*z
    translate <1.625,3.25,0>
  }
  //top of u-bolt
  cylinder { <1.625,3.25,0> <2.125,3.25,0> 0.1875 }
  difference {
    torus { 0.5 0.1875 rotate 90*x }
    box { <-2,-2,-2> <2,0,2> }
    box { <-2,-2,-2> <0,2,2> }
    translate <2.125,2.75,0>
  }
  cylinder { <2.625,1.75,0> <2.625,2.75,0> 0.1875 }
  difference {
    torus { 0.5 0.1875 rotate 90*x }
    box { <-2,2,-2> <2,0,2> }
    box { <-2,-2,-2> <0,2,2> }
    translate <2.125,1.75,0>
  }
  //bottom of u-bolt
  cylinder { <1.625,1.25,0> <2.125,1.25,0> 0.1875 }
  //bottom nut
  intersection {
    sphere { <0,-0.20,0> 0.4 }
    prism {
      linear_sweep linear_spline -0.1,0.25,7,
      <-0.216,0.125> <0,0.25> <0.216,0.125>
      <0.216,-0.125> <0,-0.25> <-0.216,-0.125> <-0.216,0.125>
    }
    scale 1.2
    rotate -90*z
    translate <1.625,1.25,0>
  }

  //top outside bolt
  cylinder { <-1.625,3.25,0> <-2.125,3.25,0> 0.18 }
  torus { 0.14 0.04 rotate 90*z translate <-2.125,3.25,0> }
  cylinder { <-1.625,3.25,0> <-2.165,3.25,0> 0.14 }
  isosurface {
    function { f_helix1(x,y,z,1,90,0.03,0.18,1,1,0) }
    contained_by { box { <-1,0,-1> <1,1,1> } }
    max_gradient 2
    rotate -90*z
    translate <-2.125,3.25,0>
  }
  intersection {
    sphere { <0,-0.20,0> 0.4 }
    prism {
      linear_sweep linear_spline -0.1,0.25,7,
      <-0.216,0.125> <0,0.25> <0.216,0.125>
      <0.216,-0.125> <0,-0.25> <-0.216,-0.125> <-0.216,0.125>
    }
    scale 1.2
    rotate 90*z
    translate <-1.625,3.25,0>
  }

  //bottom outside bolt
  cylinder { <-1.625,1.25,0> <-2.125,1.25,0> 0.18 }
  torus { 0.14 0.04 rotate 90*z translate <-2.125,1.25,0> }
  cylinder { <-1.625,1.25,0> <-2.165,1.25,0> 0.14 }
  isosurface {
    function { f_helix1(x,y,z,1,90,0.03,0.18,1,1,0) }
    contained_by { box { <-1,0,-1> <1,1,1> } }
    max_gradient 2
    rotate -90*z
    translate <-2.125,1.25,0>
  }
  //nut
  intersection {
    sphere { <0,-0.20,0> 0.4 }
    prism {
      linear_sweep linear_spline -0.1,0.25,7,
      <-0.216,0.125> <0,0.25> <0.216,0.125>
      <0.216,-0.125> <0,-0.25> <-0.216,-0.125> <-0.216,0.125>
    }
    scale 1.2
    rotate 90*z
    translate <-1.625,1.25,0>
  }

  //base
  cone { <0,0,0> 1.45 <0,0.65,0> 1.55 }
  #local i=0;
  #while (i<7)
    torus { 1.5+i*0.01 0.04 translate (0.05+0.08*i)*y texture { blackrubber } }
    #local i=i+1;
  #end
  texture { blackplastic }
  rotate -5*y
  translate <16,30.02,23>
}
//fork, spoon
//horseshoe magnets
#declare horseshoe =
union {
  difference {
    union {
      cylinder { <-0.157,0,0> <0.157,0,0> 0.5625 }
      box { <-0.157,0,-0.55> <0.157,0.45,0.55> }
    }
    box { <-1,0.43,-1> <1,1,1> texture { chrome } }
    box { <-0.2,0,0> <0.2,1,0.1875> rotate 8*x translate -0.1875*z }
    box { <-0.2,0,-0.1875> <0.2,1,0> rotate -8*x translate 0.1875*z }
    box { <-0.2,0,0> <0.2,1,0.1875> rotate 18*x translate -0.78*z }
    box { <-0.2,0,-0.1875> <0.2,1,0> rotate -18*x translate 0.78*z }
    cylinder { <-0.2,0,0> <0.2,0,0> 0.1875 }
    sphere { <0.157,-0.4,0> 0.09 }
  }
  text { ttf "povlogo.ttf", "P", 1 0
    rotate -90*y scale 0.12 translate <0.12,-0.47,-0.04> }
  texture { magnetred }
  normal {
    crackle 1
    scale 0.03
  }
  rotate 90*x
  translate <0,0,-0.43>
}

//on back wall
union {
  horseshoe
  //rotate 110*y
  //translate <7.5,54,-35.8>
  rotate 10*z
  translate <20,53.2,29.97>
}

//on right wall
union {
  horseshoe
  rotate 10*z
  rotate 90*y
  translate <46.49,45.2,20.9>
}

//on desk
union {
  horseshoe
  rotate 90*z
  rotate 140*y
  translate <11,30.16,28>
}

//clip magnets
//disk magnets
//body and paint are separate so that we can "chip" the paint
#declare roundmag_body =
union {
  cylinder { <0,0,-0.015> <0,0,-0.205> 0.375 }
  cylinder { <0,0,0> <0,0,-0.22> 0.36 }
  torus { 0.36 0.015 rotate 90*x translate -0.205*z }
  torus { 0.36 0.015 rotate 90*x translate -0.015*z }
  texture { blackrubber }
}
#declare roundmag_paint =
union {
  cylinder { <0,0,-0.020> <0,0,-0.210> 0.380 }
  cylinder { <0,0,-0.005> <0,0,-0.225> 0.365 }
  torus { 0.365 0.015 rotate 90*x translate -0.210*z }
  torus { 0.365 0.015 rotate 90*x translate -0.020*z }
}

union {
  object { roundmag_body }
  difference {
    object { roundmag_paint texture { orangebeigepaint } }
    sphere { <0.37,0,-0.21> 0.05 rotate 20*z }
    sphere { <0.37,0,-0.21> 0.02 rotate 100*z }
  }
  translate <14.5,51,29.95>
}

union {
  object { roundmag_body }
  difference {
    object { roundmag_paint texture { whitepaint } }
    sphere { <0.37,0,0> 0.04 rotate -20*z }
    sphere { <0.37,0,-0.21> 0.07 rotate 200*z }
    sphere { <0.37,0,-0.21> 0.03 rotate 220*z }
  }
  rotate -65*y
  translate <47.85,39,19.55>
}

union {
  object { roundmag_body }
  difference {
    object { roundmag_paint texture { whitepaint } }
    sphere { <0.37,0,-0.21> 0.02 rotate -20*z }
    sphere { <0.37,0,-0.21> 0.07 rotate 200*z }
  }
  rotate 90*y
  translate <46.5,42.4,20.5>
}

union {
  object { roundmag_body }
  difference {
    object { roundmag_paint texture { orangebeigepaint } }
    sphere { <0.37,0,-0.21> 0.03 rotate 10*z }
    sphere { <0.37,0,-0.21> 0.09 rotate 90*z }
  }
  rotate 90*y
  translate <46.5,41,20.9>
}

//nose magnet
union {
  difference {
    union {
      cylinder { <0,0,0> <0,0,-0.375> 0.8 }
      cylinder { <0,0,0> <0,0,-0.335> 0.83 }
      torus { 0.8 0.03 rotate 90*x translate <0,0,-0.345> }
    }
    //smile
    difference {
      torus { 0.65 0.07 rotate 90*x translate -0.375*z }
      box { <-1,0,-1> <1,1,1> rotate 45*z }
      box { <-1,0,-1> <1,1,1> rotate -45*z }
    }
    sphere { <0,-0.65,-0.375> 0.07 rotate 45*z }
    sphere { <0,-0.65,-0.375> 0.07 rotate -45*z }
  }
  //eyes
  sphere { <-0.375,0.375,-0.33> 0.2 texture { limegreenplastic } }
  sphere { <0.375,0.375,-0.33> 0.2 texture { limegreenplastic } }
  //nose
  difference {
    union {
      box { <-0.2,-0.45,0> <0.2,0.77,-0.875> }
      box { <-0.2,-0.2,0> <0.2,0.77,-1.1> }
      cylinder { <-0.2,-0.2,-0.875> <0.2,-0.2,-0.875> 0.25 }
    }
    box { <-2,-2,-2> <0,2,2> rotate -2*z rotate -3*y translate <-0.1,0,0> }
    box { <2,-2,-2> <0,2,2> rotate 2*z rotate 3*y translate <0.1,0,0> }
    box { <-2,-2,-2> <2,2,0> rotate 40*x translate <0,0,-1.02> }
  }
  texture { purpleplastic }

  rotate -5*z
  translate <43,60.3,13.97>
}
//spinning man
union {
  //base
  cylinder { <0,0,0> <0,0,-0.25> 0.65 }
  cylinder { <0,0,0> <0,0,-0.22> 0.68 }
  torus { 0.65 0.03 rotate 90*x translate <0,0,-0.22> }
  cylinder { <0,0,0> <0,0,-0.4> 0.09 }
  union {  //body
    cylinder { <0,0,-0.41> <0,0,-1> 0.09 }
    //none of the beams use square cross sections in real toy, but I will
    difference {
      union {
	box { <-3,-0.1,-0.6> <3,0.1,-0.8> }
	box { <-0.675,-0.15,-0.55> <0.675,0.15,-0.85> }
	box { <-0.1,-3,-0.6> <0.1,5,-0.8> }
	box { <-0.15,-0.675,-0.55> <0.15,0.675,-0.85> }
      }
      cylinder { <0,0,-0.5> <0,0,-1.5> 0.1 }
    }
    //axles
    cylinder { <-3,0,-0.6> <-3,0,-1.3> 0.09 }
    cylinder { <3,0,-0.6> <3,0,-1.3> 0.09 }
    cylinder { <0,-3,-0.6> <0,-3,-1.3> 0.09 }
    //head
    cylinder { <0,5,-0.6> <0,5,-0.8> 0.2 }
    union {  //right arm
      box { <-0.1,0,-0.6> <0.1,-1.875,-0.8> }
      cylinder { <0,-1.875,-0.6> <0,-1.875,-0.8> 0.2 }
      rotate -3*z
      translate <3,0,-0.35>
    }
    union {  //left arm
      box { <-0.1,0,-0.6> <0.1,-1.875,-0.8> }
      cylinder { <0,-1.875,-0.6> <0,-1.875,-0.8> 0.2 }
      rotate -3*z
      translate <-3,0,-0.35>
    }
    union {  //legs
      box { <-0.1,0,-0.6> <0.1,-1.875,-0.8> rotate 45*z }
      cylinder { <0,-1.875,-0.6> <0,-1.875,-0.8> 0.2 rotate 45*z }
      box { <-0.1,0,-0.6> <0.1,-1.875,-0.8> rotate -45*z }
      cylinder { <0,-1.875,-0.6> <0,-1.875,-0.8> 0.2 rotate -45*z }
      rotate -3*z
      translate <0,-3,-0.35>
    }
    rotate 3*z
  }
  texture { transyellow }
  translate <31,60.3,13.97>
}

//legos
#declare legotop =
union {
  cylinder { <0,0,0> <0,0.12,0> 0.3 }
  cylinder { <0,0,0> <0,0.15,0> 0.27 }
  torus { 0.27 0.03 translate 0.12*y }
  text { ttf "cyrvetic.ttf", "POVO", 0.03, 0
    scale <0.18,0.28,1> rotate 90*x rotate -90*y translate <0.1,0.16,-0.2>
  }
}

//build-scale is in "lego units" so one unit is 5/16 inch.
//at end is a scale to convert it to real size in inches
#declare lego =
union {
  box { <0,0,0> <4,1.2,0.18> }
  box { <0,0,2> <4,1.2,1.82> }
  box { <0,0,0> <0.18,1.2,2> }
  box { <4,0,0> <3.82,1.2,2> }
  difference {  //top, with holes in underside
    box { <0,1.02,0> <4,1.2,2> }
    cylinder { <0.5,0,0.5> <0.5,1.15,0.5> 0.15 }
    cylinder { <1.5,0,0.5> <1.5,1.15,0.5> 0.15 }
    cylinder { <2.5,0,0.5> <2.5,1.15,0.5> 0.15 }
    cylinder { <3.5,0,0.5> <3.5,1.15,0.5> 0.15 }
    cylinder { <0.5,0,1.5> <0.5,1.15,1.5> 0.15 }
    cylinder { <1.5,0,1.5> <1.5,1.15,1.5> 0.15 }
    cylinder { <2.5,0,1.5> <2.5,1.15,1.5> 0.15 }
    cylinder { <3.5,0,1.5> <3.5,1.15,1.5> 0.15 }
  }
  box { <1.96,0,0> <2.04,1.1,0.65> }
  box { <1.96,0,1.35> <2.04,1.1,2> }
  //three round tubes on underside of lego
  difference {
    cylinder { <1,0,1> <1,1.1,1> 0.4 }
    cylinder { <1,-1,1> <1,1.0,1> 0.3 }
  }
  difference {
    cylinder { <2,0,1> <2,1.1,1> 0.4 }
    cylinder { <2,-1,1> <2,1.0,1> 0.3 }
  }
  difference {
    cylinder { <3,0,1> <3,1.1,1> 0.4 }
    cylinder { <3,-1,1> <3,1.0,1> 0.3 }
  }
  //nibs on inside of box for grabbing lego tops
  cylinder { <0.18,0,0.5> <0.18,1.1,0.5> 0.04 }
  cylinder { <0.18,0,1.5> <0.18,1.1,1.5> 0.04 }
  cylinder { <3.82,0,0.5> <3.82,1.1,0.5> 0.04 }
  cylinder { <3.82,0,1.5> <3.82,1.1,1.5> 0.04 }
  cylinder { <0.5,0,0.18> <0.5,1.1,0.18> 0.04 }
  cylinder { <1.5,0,0.18> <1.5,1.1,0.18> 0.04 }
  cylinder { <2.5,0,0.18> <2.5,1.1,0.18> 0.04 }
  cylinder { <3.5,0,0.18> <3.5,1.1,0.18> 0.04 }
  cylinder { <0.5,0,1.82> <0.5,1.1,1.82> 0.04 }
  cylinder { <1.5,0,1.82> <1.5,1.1,1.82> 0.04 }
  cylinder { <2.5,0,1.82> <2.5,1.1,1.82> 0.04 }
  cylinder { <3.5,0,1.82> <3.5,1.1,1.82> 0.04 }
  //top of lego
  object { legotop translate <0.5,1.2,0.5> }
  object { legotop translate <1.5,1.2,0.5> }
  object { legotop translate <2.5,1.2,0.5> }
  object { legotop translate <3.5,1.2,0.5> }
  object { legotop translate <0.5,1.2,1.5> }
  object { legotop translate <1.5,1.2,1.5> }
  object { legotop translate <2.5,1.2,1.5> }
  object { legotop translate <3.5,1.2,1.5> }

  //reduce units to real lego size in inches
  scale 0.3125
}

union {
  object { lego texture { shinyoffwhite } }
  object { lego texture { shinyred } translate <4*5/16,0,0> }
  object { lego texture { shinyblue } translate <2*5/16,1.2*5/16,0> }
  rotate -10*y translate <30,34.12,11.8>
}
object { lego texture { shinyyellow } rotate 90*x rotate 3*y translate <27,34.745,12.4> }

//chess pieces

//bishop
union {
  //base
  difference {
    sphere_sweep {
      cubic_spline 5,
      <0,-0.1,0> 0.5
      <0,0,0> 0.5
      <0,0.5,0> 0.35
      <0,1,0> 0.3
      <0,1.1,0> 0.3
      scale <1,0.3,1>
    }
    box { <-1,0.3,-1> <1,2,1> }
    translate <0,0.2,0>
  }
  torus { 0.28 0.02 translate <0,0.5,0> }
  cylinder { <0,0.5,0> <0,0.52,0> 0.28 }
  torus { 0.5 0.05 translate <0,0.05,0> }
  cylinder { <0,0,0> <0,0.1,0> 0.5 }
  //shaft
  difference {
    sphere_sweep {
      cubic_spline 5,
      <0,0.4,0> 0.3
      <0,0.45,0> 0.26
      <0,0.7,0> 0.20
      <0,1.1,0> 0.16
      <0,1.2,0> 0.15
    }
    box { <-1,1.1,-1> <1,2,1> }
    box { <-1,0.5,-1> <1,0,1> }
  }
  torus { 0.25 0.05 translate <0,1.14,0> }
  torus { 0.21 0.04 translate <0,1.22,0> }
  torus { 0.18 0.03 translate <0,1.28,0> }
  cone { <0,1.31,0> 0.17 <0,1.6,0> 0.25 }
  torus { 0.228 0.029 translate <0,1.62,0> }
  difference {
    cone { <0,1.639,0> 0.25 <0,2,0> 0.025 }
    box { <0.08,1.68,-1> <0.12,2.5,1> }
  }
  sphere { <0,0,0> 0.08 scale <1,0.7,1> translate <0,2.03,0> }
  texture { shinyblack }
  rotate 70*y
  translate <23,34.12,25>
}

//pawn
union {
  //base
  union {
  difference {
    sphere_sweep {
      cubic_spline 5,
      <0,-0.1,0> 0.5
      <0,0,0> 0.5
      <0,0.5,0> 0.35
      <0,1,0> 0.3
      <0,1.1,0> 0.3
      scale <1,0.3,1>
    }
    box { <-1,0.3,-1> <1,2,1> }
    translate <0,0.2,0>
  }
  torus { 0.28 0.02 translate <0,0.5,0> }
  cylinder { <0,0.5,0> <0,0.52,0> 0.28 }
  torus { 0.5 0.05 translate <0,0.05,0> }
  cylinder { <0,0,0> <0,0.1,0> 0.5 }
  scale 0.9
  }
  //shaft
  difference {
    sphere_sweep {
      cubic_spline 5,
      <0,0.35,0> 0.25
      <0,0.4,0> 0.23
      <0,0.55,0> 0.18
      <0,0.9,0> 0.13
      <0,1.0,0> 0.12
    }
    box { <-1,0.9,-1> <1,2,1> }
    box { <-1,0.45,-1> <1,0,1> }
  }
  torus { 0.23 0.03 translate <0,0.92,0> }
  cone { <0,0.948,0> 0.235 <0,1,0> 0.1 }
  sphere { <0,1.18,0> 0.2 }
  texture { shinyblack }
  translate <24.3,34.12,25.3>
}

//8 ball
union {
  intersection {
    sphere { <0,0,0> 1.125 texture { shinyblack } }
    difference {
      sphere { <0,0,0> 1.5 texture { shinyblack } }
      cylinder { <0,0,0> <0,2,0> 0.5 texture { shinyoffwhite } }
    }
  }

  intersection {
    sphere { <0,0,0> 1.125 texture { shinyoffwhite } }
    difference {
      cylinder { <0,0,0> <0,2,0> 0.5 texture { shinyoffwhite } }
      difference {
	cylinder { <0,0,0.1> <0,2,0.1> 0.12}
	cylinder { <0,0,0.1> <0,3,0.1> 0.06 }
	texture { shinyoffwhite }
      }
      difference {
	cylinder { <0,0,-0.1> <0,2,-0.1> 0.13}
	cylinder { <0,0,-0.1> <0,3,-0.1> 0.07 }
	texture { shinyoffwhite }
      }
    }
  }

  intersection {
    sphere { <0,0,0> 1.125 texture { shinyblack } }
    union {
      difference {
	cylinder { <0,0,0.1> <0,2,0.1> 0.12}
	cylinder { <0,0,0.1> <0,3,0.1> 0.06 }
	texture { shinyblack }
      }
      difference {
	cylinder { <0,0,-0.1> <0,2,-0.1> 0.13}
	cylinder { <0,0,-0.1> <0,3,-0.1> 0.07 }
	texture { shinyblack }
      }
    }
  }
  rotate 30*y
  rotate -30*x
  rotate -10*z
  translate <19.7,31.125,27.5>
}

//sheets of paper
#declare p_w=8.5;
#declare p_h=11;
#macro flattenpaper()
  #declare p_l_y=0;
  #declare p_l_x1=1*p_w/6;
  #declare p_l_x2=2*p_w/6;
  #declare p_r_y=0;
  #declare p_r_x1=4*p_w/6;
  #declare p_r_x2=5*p_w/6;
  #declare p_t_y=0;
  #declare p_t_z1=4*p_h/6;
  #declare p_t_z2=5*p_h/6;
  #declare p_b_y=0;
  #declare p_b_z1=1*p_h/6;
  #declare p_b_z2=2*p_h/6;
  #declare p_ll_y=0;
  #declare p_ll_x1=p_l_x1;
  #declare p_ll_x2=p_l_x2;
  #declare p_ll_z1=p_b_z1;
  #declare p_ll_z2=p_b_z2;
  #declare p_lr_y=0;
  #declare p_lr_x1=p_r_x1;
  #declare p_lr_x2=p_r_x2;
  #declare p_lr_z1=p_b_z1;
  #declare p_lr_z2=p_b_z2;
  #declare p_ul_y=0;
  #declare p_ul_x1=p_l_x1;
  #declare p_ul_x2=p_l_x2;
  #declare p_ul_z1=p_t_z1;
  #declare p_ul_z2=p_t_z2;
  #declare p_ur_y=0;
  #declare p_ur_x1=p_r_x1;
  #declare p_ur_x2=p_r_x2;
  #declare p_ur_z1=p_t_z1;
  #declare p_ur_z2=p_t_z2;
#end
#macro paper_size(w,h)
  #declare p_w=w;
  #declare p_h=h;
#end
#macro paper_curl_left(curl,rad,rad2)
  #declare p_l_y=curl;
  #declare p_ul_y=curl;
  #declare p_ll_y=curl;
  #declare p_l_x1=rad;
  #declare p_l_x2=rad2;
  #declare p_ul_x1=rad;
  #declare p_ul_x2=rad2;
  #declare p_ll_x1=rad;
  #declare p_ll_x2=rad2;
#end
#macro paper_curl_right(curl,rad,rad2)
  #declare p_r_y=curl;
  #declare p_ur_y=curl;
  #declare p_lr_y=curl;
  #declare p_r_x1=p_w-rad;
  #declare p_r_x2=p_w-rad2;
  #declare p_ur_x1=p_w-rad;
  #declare p_ur_x2=p_w-rad2;
  #declare p_lr_x1=p_w-rad;
  #declare p_lr_x2=p_w-rad2;
#end
#macro paper_curl_top(curl,rad,rad2)
  #declare p_t_y=curl;
  #declare p_ul_y=curl;
  #declare p_ur_y=curl;
  #declare p_t_z1=p_h-rad;
  #declare p_t_z2=p_h-rad2;
  #declare p_ul_z1=p_h-rad;
  #declare p_ul_z2=p_h-rad2;
  #declare p_ur_z1=p_h-rad;
  #declare p_ur_z2=p_h-rad2;
#end
#macro paper_curl_bottom(curl,rad,rad2)
  #declare p_b_y=curl;
  #declare p_ll_y=curl;
  #declare p_lr_y=curl;
  #declare p_b_z1=rad;
  #declare p_b_z2=rad2;
  #declare p_ll_z1=rad;
  #declare p_ll_z2=rad2;
  #declare p_lr_z1=rad;
  #declare p_lr_z2=rad2;
#end
#macro paper_curl_ul(curl,rad,rad2)
  #declare p_ul_y=curl;
  #declare p_ul_x1=rad;
  #declare p_ul_x2=rad2;
  #declare p_ul_z1=p_h-rad;
  #declare p_ul_z2=p_h-rad2;
#end
#macro paper_curl_ur(curl,rad,rad2)
  #declare p_ur_y=curl;
  #declare p_ur_x1=p_w-rad;
  #declare p_ur_x2=p_w-rad2;
  #declare p_ur_z1=p_h-rad;
  #declare p_ur_z2=p_h-rad2;
#end
#macro paper_curl_ll(curl,rad,rad2)
  #declare p_ll_y=curl;
  #declare p_ll_x1=rad;
  #declare p_ll_x2=rad2;
  #declare p_ll_z1=rad;
  #declare p_ll_z2=rad2;
#end
#macro paper_curl_lr(curl,rad,rad2)
  #declare p_lr_y=curl;
  #declare p_lr_x1=p_w-rad;
  #declare p_lr_x2=p_w-rad2;
  #declare p_lr_z1=rad;
  #declare p_lr_z2=rad2;
#end
#macro makepaper()
  //use four joined patches, to allow for more flatness in the middle
  bicubic_patch {  //upper left
    type 0 flatness 0.001 u_steps 4 v_steps 4
    <0,p_ul_y,p_h>    <p_ul_x1,p_t_y,p_h> <p_ul_x2,p_t_y,p_h> <p_w/2,p_t_y,p_h>
    <0,p_l_y,p_ul_z1> <p_ul_x1,0,p_ul_z1> <p_ul_x2,0,p_ul_z1> <p_w/2,0,p_t_z1>
    <0,p_l_y,p_ul_z2> <p_ul_x1,0,p_ul_z2> <p_ul_x2,0,p_ul_z2> <p_w/2,0,p_t_z2>
    <0,p_l_y,p_h/2>   <p_l_x1,0,p_h/2>    <p_l_x2,0,p_h/2>    <p_w/2,0,p_h/2>
  }
  bicubic_patch {  //lower left
    type 0 flatness 0.001 u_steps 4 v_steps 4
    <0,p_l_y,p_h/2>   <p_l_x1,0,p_h/2>     <p_l_x2,0,p_h/2>    <p_w/2,0,p_h/2>
    <0,p_l_y,p_ll_z2> <p_ll_x1,0,p_ll_z2>  <p_ll_x2,0,p_ll_z2> <p_w/2,0,p_b_z2>
    <0,p_l_y,p_ll_z1> <p_ll_x1,0,p_ll_z1>  <p_ll_x2,0,p_ll_z1> <p_w/2,0,p_b_z1>
    <0,p_ll_y,0>      <p_ll_x1,p_b_y,0>    <p_ll_x2,p_b_y,0>   <p_w/2,p_b_y,0>
  }
  bicubic_patch {  //lower right
    type 0 flatness 0.001 u_steps 4 v_steps 4
    <p_w/2,0,p_h/2>  <p_r_x2,0,p_h/2>    <p_r_x1,0,p_h/2>    <p_w,p_r_y,p_h/2>
    <p_w/2,0,p_b_z2> <p_lr_x2,0,p_lr_z2> <p_lr_x1,0,p_lr_z2> <p_w,p_r_y,p_lr_z2>
    <p_w/2,0,p_b_z1> <p_lr_x2,0,p_lr_z1> <p_lr_x1,0,p_lr_z1> <p_w,p_r_y,p_lr_z1>
    <p_w/2,p_b_y,0>  <p_lr_x2,p_b_y,0>   <p_lr_x1,p_b_y,0>   <p_w,p_lr_y,0>
  }
  bicubic_patch {  //upper right
    type 0 flatness 0.001 u_steps 4 v_steps 4
    <p_w/2,p_t_y,p_h> <p_ur_x2,p_t_y,p_h> <p_ur_x1,p_t_y,p_h> <p_w,p_ur_y,p_h>
    <p_w/2,0,p_t_z1> <p_ur_x2,0,p_ur_z1> <p_ur_x1,0,p_ur_z1> <p_w,p_r_y,p_ur_z1>
    <p_w/2,0,p_t_z2> <p_ur_x2,0,p_ur_z2> <p_ur_x1,0,p_ur_z2> <p_w,p_r_y,p_ur_z2>
    <p_w/2,0,p_h/2>   <p_r_x2,0,p_h/2>    <p_r_x1,0,p_h/2>    <p_w,p_r_y,p_h/2>
  }
#end

flattenpaper()
paper_curl_ul(1,1,2)
paper_curl_ur(0.3,0.5,0.7)
union {
  makepaper()
  //texture { whitepaint }
  texture {
    pigment { image_map { gif "gamenotes.gif" }
    scale <8.5,11,1> translate <0,0,0> rotate 90*x }
    finish { diffuse 0.55 specular 0.1 }
  }
  rotate -20*y
  translate <13,30.05,7>
}

flattenpaper()
paper_curl_left(1,1,2)
paper_curl_right(0.5,1,2)
paper_curl_ul(1.5,1.5,2.5)
union {
  makepaper()
  texture { whitepaint }
  texture {
    pigment { image_map { jpeg "desk2.jpg" once }
    rotate -90*z scale <6.5,9,1> translate <1,10,0> rotate 90*x }
    finish { diffuse 0.8 specular 0.2 }
  }
  rotate 5*y
  rotate -90*x
  translate <9,41,29.97>
}

paper_size(2,1.5)
flattenpaper()
paper_curl_bottom(0.25,0.25,0.7)
paper_curl_lr(0.4,0.2,0.3)
union {
  makepaper()
  texture {
    pigment { image_map { gif "postit.gif" }
    scale <2,1.5,1> translate <0.2,-0.2,0> rotate 90*x }
    finish { diffuse 0.8 specular 0.2 }
  }
  rotate -3*y
  rotate -90*x
  translate <32,32.2,11.99>
}

//wall calendar
paper_size(11,8.5)
flattenpaper()
paper_curl_top(-1,1,2)
paper_curl_bottom(-0.2,2,4)
union {
  makepaper()
  texture { whitepaper }
  texture {
    pigment { image_map { gif "calendar.gif" once }
    scale <10,7.5,1> translate <0.5,0.5,0> rotate 90*x }
    finish { diffuse 0.55 specular 0.1 }
  }
  rotate -90*x
  rotate 90*y
  translate <49,54,15>
}


//pens, pencils
union {  //bic pen
  cylinder { <0,0,0> <4.875,0,0> 0.14 texture { whiteplastic } }
  cone { <0,0,0> 0.14 <-0.125,0,0> 0.12 texture { blueplastic } }
  cone { <-0.125,0,0> 0.12 <-0.375,0,0> 0.09 texture { blueplastic } }
  difference {
    sphere { <4.71,0,0> 0.22 }
    box { <4.875,-1,-1> <4,1,1> }
    texture { blueplastic }
  }
  cylinder { <-0.375,0,0> <-0.44,0,0> 0.07 texture { dkbeigepaint } }
  cone { <-0.44,0,0> 0.07 <-0.63,0,0> 0.05 texture { dkbeigepaint } }
  cone { <-0.63,0,0> 0.045 <-0.73,0,0> 0.015 texture { T_Gold_2B } }
  text { ttf "cyrvetic.ttf", "POV round stic med/moy USA", 0.02 0
  scale 0.12 translate <1.5,-0.05,-0.14>
  texture { blackplastic } }

  rotate 90*x //letters up
  rotate -65*y
  translate <17.5,30.17,15>
  //rotate 20*y
  //translate <7.5,54,-35.8>
}
union {  //bic pen cap
  //the origin is mid-cap, so that when combined with the pen, the
  //pen is closed
  difference {
    union {
      cylinder { <0.125,0,0> <0.5,0,0> 0.18 }
      torus { 0.18 0.017 rotate 90*z translate <0.125,0,0> }
      cone { <0.125,0,0> 0.18 <-1.0625,0,0> 0.15 }
      cone { <-1.0625,0,0> 0.14 <-1.0925,0,0> 0.10 }
      difference {
        box { <0,-0.1,-0.08> <1.275,0.09,0.08> }
	box { <0,-1,-1> <1,1,1> rotate -45*y translate 1.29*x }
	box { <0,-1,-1> <1,1,1> rotate 45*y translate 1.29*x }
	box { <-1,-1,-1> <0,1,1> rotate -45*z }
	box { <-1,-1,0> <2,1,1> rotate -27*x translate 0.08*z }
	box { <-1,-1,-1> <2,1,0> rotate 27*x translate -0.08*z }
	translate <0.125,0.17,0>
      }
    }
    cylinder { <0.125,0,0> <0.6,0,0> 0.13 }
    cone { <0.126,0,0> 0.13 <-1.05,0,0> 0.11 }
    cone { <0.5,0,0> 0.15 <1.5,0,0> 0.21 }
    difference {
      cylinder { <-1.1,0,0> <-1,0,0> 0.09 }
      cylinder { <-1.1,0,0> <-1,0,0> 0.07 }
      box { <-1.07,0,-0.02> <-1,0.2,0.02> rotate 180*x }
      box { <-1.07,0,-0.02> <-1,0.2,0.02> rotate 60*x }
      box { <-1.07,0,-0.02> <-1,0.2,0.02> rotate 300*x }
    }
  }
  texture { blueplastic }

  rotate -130*x
  rotate 20*y
  translate <19.5,30.19,13>
  //rotate -90*x
  //rotate 20*y
  //rotate -70*y
  //translate <7.5,54,-35.8>
}

//photograph in frame
union {
  //backplate
  box { <0,0,0> <6.5,4.5,-0.24> }
  //photo
  box { <0.25,0.25,-0.4> <6.25,4.25,-0.45>
    texture {
      pigment { image_map { jpeg "desk1.jpg" once }
	scale <6,4,1> translate <0.25,0.25,0> }
      finish { diffuse 0.8 specular 0.2 }
    }
  }
  //glass
  box { <0.25,0.25,-0.5> <6.25,4.25,-0.55> texture { glass } }
  difference { //top edge
    box { <0,-0.25,-0.75> <6.5,0,-0.25> }
    box { <-1,-1,-1> <0,1,1> rotate 45*z }
    box { <0,-1,-1> <1,1,1> rotate -45*z translate 6.5*x }
    translate 4.5*y
  }
  difference {  //bottom edge
    box { <0,0,-0.75> <6.5,0.25,-0.25> }
    box { <-1,-1,-1> <0,1,1> rotate -45*z }
    box { <0,-1,-1> <1,1,1> rotate 45*z translate 6.5*x }
  }
  difference { //left edge
    box { <0,0,-0.75> <0.25,4.5,-0.25> }
    box { <-1,-1,-1> <1,0,1> rotate 45*z }
    box { <-1,0,-1> <1,1,1> rotate -45*z translate 4.5*y }
  }
  difference { //right edge
    box { <0,0,-0.75> <-0.25,4.5,-0.25> }
    box { <-1,-1,-1> <1,0,1> rotate -45*z }
    box { <-1,0,-1> <1,1,1> rotate 45*z translate 4.5*y }
    translate 6.5*x
  }
  texture { framewood }
  rotate 90*y
  translate <49.75,42,15>
}
//thumbtacks
#declare thumbtack =
union {
  cylinder { <0,0,-0.25> <0,0,0.25> 0.018 texture { chrome } }
  cone { <0,0,0.25> 0.018 <0,0,0.375> 0 texture { chrome } }
  difference {
    sphere { <0,0,0.11> 0.23 }
    box { <-1,-1,0> <1,1,1> }
  }
  cylinder { <0,0,-0.01> <0,0,-0.4> .09 }
  cone { <0,0,-0.375> .11 <0,0,-0.44> .125 }
  difference {
    sphere { <0,0,0.275> 0.3 }
    box { <-1,-1,0> <1,1,1> }
    translate <0,0,-0.44>
  }
  interior { ior 1.5 }
}

object { thumbtack rotate -7*x rotate 50*y translate <12,30.2,20> texture { clearblue } }
object { thumbtack rotate -7*x rotate 110*y translate <11,30.2,21> texture { clearred } }
object { thumbtack rotate -7*x rotate 170*y translate <12.2,30.2,21.3> texture { clearred } }
object { thumbtack rotate 95*x rotate 50*y translate <13.5,30.3,20.5> texture { cleargreen } }
object { thumbtack rotate -7*x rotate -40*y translate <12.7,30.3,25> texture { cleargreen } }
object { thumbtack rotate -7*x rotate -60*y translate <18,30.3,24.3> texture { cleargreen } }

object { thumbtack rotate 10*x rotate -5*y translate <18,38,30.1> texture { cleargreen } }
object { thumbtack translate <20,38.1,30.0> texture { clearblue } }
object { thumbtack rotate -7*x rotate -5*y translate <17,36.5,30.1> texture { clearblue } }
object { thumbtack rotate 7*x rotate -5*y translate <18.2,36.0,30.0> texture { clearred } }
object { thumbtack rotate -7*x rotate 5*y translate <19.05,35.8,30.1> texture { clearred } }
object { thumbtack rotate -2*x rotate 10*y translate <20.1,36.1,30.0> texture { cleargreen } }
object { thumbtack rotate 10*x rotate -2*y translate <20.8,36.4,30.0> texture { clearblue } }

//books
//pamphlets
//cd cases
//tape cases
//co-ax connecters

background { color Black }
