//  Persistence of Vision Raytracer V3.5
//  World definition file.
//
//  Contains 5 lights, 14 materials and 29 primitives.
//
//  This file was generated for POV-Ray V3.5 by
//  Moray V3.5 For Windows Copyright (c) 1993-2003 Lutz + Kretzschmar
//

//  Date : 10/24/2004    (24.10.2004)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.4 Beta For Windows.
Comment merged from matita.mdl:
This scene was created with Moray For Windows.
Comment merged from dungeon_01.mdl:
This scene was created with Moray V3.5 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  noise_generator 2
  charset ascii
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera_elettiva
  location  <     -7.231,     -20.569,       6.741>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.36488,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         44.60855    // Vertical      33.456
  look_at   <     -1.026,      -0.455,      -0.730>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <     -1.247,       4.395,      11.945> // Attached to Spotlight001
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35747,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         39.32011    // Vertical      29.490
  look_at   <     -0.841,       4.797,      11.124> // Following Spotlight001
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Spotlight Spotlight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    15.000  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
  media_attenuation on
  rotate <0.0, -34.816582, 44.701588>
  translate  <-1.246805, 4.395302, 11.944682>
}

#declare Light002 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <-2.391481, 0.944509, 1.519742>
}

#declare Light003 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <-2.391481, 0.944509, 1.519742>
}

#declare Light004 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <-2.391481, 0.944509, 1.519742>
}

light_source {   // Luce_attuale
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  photons {
  }
  scale 5.49874
  translate  <-662.934328, 313.792515, 384.883125>
}


//
// ********  MATERIALS  *******
//

#include "test_dd_02.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//



#declare Face = union {
  sphere { // Sphere001
    <0,0,0>,1
    material {
      Fire
    }
    scale 0.069781
    translate  <-2.416932, 0.923442, 1.334614>
  }
  object { Light002 }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      S_Wood1
    }
    scale <0.021461, 0.023147, 0.198543>
    rotate 5.624628*x
    translate  <-2.401889, 0.942886, 1.081467>
  }
  translate  <-0.052409, 0.039307, 0.0>
}
#declare Dungione = union {
  box { // parete
    <-1, -1, -1>, <1, 1, 1>
    material {
      m_mattoni
    }
    photons {
      pass_through
    }
    scale <0.116523, 1.368775, 1.018529>
    translate  <-3.468472, 0.780851, 0.963528>
  }
  box { // parete1
    <-1, -1, -1>, <1, 1, 1>
    material {
      m_mattoni
    }
    scale <0.09206, 1.0, 1.018529>
    rotate -90.0*z
    translate  <-2.550264, 1.119317, 0.963528>
  }
  box { // parete2
    <-1, -1, -1>, <1, 1, 1>
    material {
      m_mattoni
    }
    scale <0.09206, 1.196535, 1.018529>
    rotate -90.0*z
    translate  <0.695029, 1.110101, 0.963528>
  }
  box { // parete3
    <-1, -1, -1>, <1, 1, 1>
    material {
      m_mattoni
    }
    scale <0.109049, 1.127416, 1.018529>
    translate  <-1.622643, 2.157571, 0.963528>
  }
  box { // parete4
    <-1, -1, -1>, <1, 1, 1>
    material {
      m_mattoni
    }
    scale <0.09206, 1.0, 1.018529>
    translate  <-0.416442, 2.021661, 0.963528>
  }
  box { // parete5
    <-1, -1, -1>, <1, 1, 1>
    material {
      m_mattoni
    }
    scale <0.083566, 2.325122, 1.018529>
    translate  <3.626879, 1.257167, 0.963528>
  }
  box { // parete6
    <-1, -1, -1>, <1, 1, 1>
    material {
      m_mattoni
    }
    scale <0.09206, 1.0, 1.018529>
    translate  <1.469308, 2.038649, 0.963528>
  }
  box { // parete7
    <-1, -1, -1>, <1, 1, 1>
    material {
      m_mattoni
    }
    scale <0.09206, 1.0, 1.018529>
    rotate -90.0*z
    translate  <-0.698491, 3.37882, 0.963528>
  }
  material {
    m_mattoni
  }
}
#declare Face1 = union {
  sphere { // Sphere002
    <0,0,0>,1
    material {
      Fire
    }
    scale 0.087919
    translate  <-2.401799, 0.939043, 1.349125>
  }
  object { Light003 }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      S_Wood1
    }
    scale <0.021461, 0.023147, 0.198543>
    rotate 5.624628*x
    translate  <-2.401889, 0.942886, 1.081467>
  }
  rotate 7.372285*z
  translate  -0.0*x
  rotate 90.0*z
  translate  <-0.831574, 4.498779, 0.0>
}
#declare Face2 = union {
  sphere { // Sphere003
    <0,0,0>,1
    material {
      Fire
    }
    scale 0.061557
    translate  <-2.412805, 0.927696, 1.338571>
  }
  object { Light004 }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      S_Wood1
    }
    scale <0.021461, 0.023147, 0.198543>
    rotate 5.624628*x
    translate  <-2.401889, 0.942886, 1.081467>
  }
  translate  <3.891385, 0.026205, 0.0>
}
union { // Dungeon
  object { Face }
  object { Dungione }
  object { Face1 }
  object { Face2 }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      m_pavimento
    }
    scale <3.692408, 2.366665, 0.042657>
    translate  <0.087469, 1.181772, -0.093874>
  }
  box { // parete8
    <-1, -1, -1>, <1, 1, 1>
    material {
      m_mattoni
    }
    scale <0.113423, 1.232048, 1.254877>
    rotate <-0.361223, -2.768959, -90.009102>
    translate  <2.504723, 3.476312, 1.02305>
  }
  scale 3.440322
  rotate <2.768901, -0.361663, -20.245365>
  translate  <1.409092, 7.949667, 0.172318>
}




// Dado20
#include "colors.inc"

#include "shapes.inc"

#include "shapes2.inc"

#include "chars.inc"



#declare Cscl = <1/14, 1/14, 1/100>;

#declare Eins = object {

  char_1

  translate <0, -2.5, -.5>

  scale Cscl

  translate -1*z

  rotate <52.6625, 0, 0>

};

#declare Zwei = object {

  char_2

  translate <0, -2.5, -.5>

  scale Cscl

  translate -1*z

  rotate -60*z

  rotate <-52.6625, -252, 0>

};

#declare Drei = object {

  char_3

  translate <0, -2.5, -.5>

  scale Cscl

  translate -1*z

  rotate -120*z

  rotate <52.6625, -144, 0>

};

#declare Vier = object {

  char_4

  translate <0, -2.5, -.5>

  scale Cscl

  translate -1*z

  rotate 60*z

  rotate <-52.6625, -36, 0>

};

#declare Fuenf = object {

  char_5

  translate <0, -2.5, -.5>

  scale Cscl

  translate -1*z

  rotate 120*z

  rotate <-10.8125, -324, 0>

};

#declare Sechs = union {

  object { char_6 }

  cylinder { <2.2, .4, 0>, <2.2, .4, 1>, .4 }

  translate <0, -2.5, -.5>

  scale Cscl

  translate -1*z

  rotate <-10.8125, -108, 0>

};

#declare Sieben = object {

  char_7

  translate <0, -2.5, -.5>

  scale Cscl

  translate -1*z

  rotate 120*z

  rotate <52.6625, -288, 0>

};

#declare Acht = object {

  char_8

  translate <0, -2.5, -.5>

  scale Cscl

  translate -1*z

  rotate <-10.8125, -180, 0>

};

#declare Neun = union {

  object { char_9 }

  cylinder { <2.2, .4, 0>, <2.2, .4, 1>, .4 }

  translate <0, -2.5, -.5>

  scale Cscl

  translate -1*z

  rotate 180*z

  rotate <10.8125, -72, 0>

};

#declare Zehn = union {

  object { char_1 translate <-2, -2.5, -.5> }

  object { char_0 translate <2, -2.5, -.5> }

  scale Cscl

  translate -1*z

  rotate -60*z

  rotate <10.8125, -216, 0>

};

#declare Elf = union {

  object { char_1 translate <-2, -2.5, -.5> }

  object { char_1 translate <2, -2.5, -.5> }

  scale Cscl

  translate -1*z

  rotate -120*z

  rotate <-10.8125, -36, 0>

};

#declare Zwoelf = union {

  object { char_1 translate <-2, -2.5, -.5> }

  object { char_2 translate <2, -2.5, -.5> }

  scale Cscl

  translate -1*z

  rotate <-10.8125, -252, 0>

};

#declare Dreizehn = union {

  object { char_1 translate <-2, -2.5, -.5> }

  object { char_3 translate <2, -2.5, -.5> }

  scale Cscl

  translate -1*z

  rotate 180*z

  rotate <10.8125, 0, 0>

};

#declare Vierzehn = union {

  object { char_1 translate <-2, -2.5, -.5> }

  object { char_4 translate <2, -2.5, -.5> }

  scale Cscl

  translate -1*z

  rotate 60*z

  rotate <-52.6625, -108, 0>

};

#declare Fuenfzehn = union {

  object { char_1 translate <-2, -2.5, -.5> }

  object { char_5 translate <2, -2.5, -.5> }

  scale Cscl

  translate -1*z

  rotate 180*z

  rotate <10.8125, -288, 0>

};

#declare Sechzehn = union {

  object { char_1 translate <-2, -2.5, -.5> }

  object { char_6 translate <2, -2.5, -.5> }

  scale Cscl

  translate -1*z

  rotate 60*z

  rotate <10.8125, -144, 0>

};

#declare Siebzehn = union {

  object { char_1 translate <-2, -2.5, -.5> }

  object { char_7 translate <2, -2.5, -.5> }

  scale Cscl

  translate -1*z

  rotate 120*z

  rotate <52.6625, -216, 0>

};

#declare Achtzehn = union {

  object { char_1 translate <-2, -2.5, -.5> }

  object { char_8 translate <2, -2.5, -.5> }

  scale Cscl

  translate -1*z

  rotate -60*z

  rotate <-52.6625, -324, 0>

};

#declare Neunzehn = union {

  object { char_1 translate <-2, -2.5, -.5> }

  object { char_9 translate <2, -2.5, -.5> }

  scale Cscl

  translate -1*z

  rotate -120*z

  rotate <52.6625, -72, 0>

};

#declare Zwanzig = union {

  object { char_2 translate <-2, -2.5, -.5> }

  object { char_0 translate <2, -2.5, -.5> }

  scale Cscl

  translate -1*z

  rotate -60*z

  rotate <-52.6625, -180, 0>

};



// 20-Seitiger W"urfel

union {

  object { Icosahedron pigment { Red} }

  union {

    object { Eins }

    object { Zwei }

    object { Drei }

    object { Vier }

    object { Fuenf }

    object { Sechs }

    object { Sieben }

    object { Acht }

    object { Neun }

    object { Zehn }

    object { Elf }

    object { Zwoelf }

    object { Dreizehn }

    object { Vierzehn }

    object { Fuenfzehn }

    object { Sechzehn }

    object { Siebzehn }

    object { Achtzehn }

    object { Neunzehn }

    object { Zwanzig }

    pigment { White }

    finish { ambient .4 }

  }

//  rotate 34.3375*x  // die '1' Seite nach oben

  scale -0.8

  translate <-7,-8,0.8>

}







// Dado6
#declare DiceColor = color red 1 green .95 blue .65;

#declare DotColor = color red .1 green .1 blue .1;

#declare Sqrt2 = 1.41421358;

#declare DiceBody = intersection {

  box { <-.5, -.5, -.5>, <.5, .5, .5> }

  sphere { <0, 0, 0>, .5*Sqrt2 }

};

#declare One = sphere { <0, .6, 0>, .14 };

#declare Two = union {

  sphere { <-.25, .6, -.25>, .14 }

  sphere { <.25, .6, .25>, .14 }

};

#declare Three = union {

  object { One }

  object { Two }

};

#declare Four = union {

  sphere { <-.25, .6, -.25>, .14 }

  sphere { <.25, .6, -.25>, .14 }

  sphere { <-.25, .6, .25>, .14 }

  sphere { <.25, .6, .25>, .14 }

};

#declare Five = union {

  object { Four }

  object { One }

};

#declare Six = union {

  object { Four }

  sphere { <-.25, .6, 0>, .14 }

  sphere { <.25, .6, 0>, .14 }

};

#declare Dice = difference {

  object {

    DiceBody

    pigment { DiceColor }

    finish { phong .7 phong_size 20 ambient .4 }

  }

  union {

    object { One rotate -90*z }

    object { Two }

    object { Three rotate -90*x }

    object { Four rotate 90*x }

    object { Five rotate 180*x }

    object { Six rotate 90*z }

    pigment { DotColor }

    finish { phong .9 phong_size 15 }

  }

  bounded_by { box { <-.52, -.52, -.52>, <.52, .52, .52> } }

};



object { Dice rotate -90*z  scale 1.2 translate <0,-9,0.7>}  





box { // Cube001
  <-1, -1, -1>, <1, 1, 1>
  material {
    t_mappa_dd
  }
  scale <10.0, 10.0, 0.001>
}


plane { // Plane001
  z,0
  material {
    BallWood
  }
}


#declare corpo = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <5.019142, -9.927266>,
  <9.927266, 0.067631>,
  <4.990217, 9.994897>,
  <-5.00468, 9.994897>,
  <-10.062528, -0.014462>,
  <-4.990217, -9.97699>,
  <5.019142, -9.927266>
  rotate -x*90
  material {
    Wood
  }
  photons {
    collect off
  }
  scale <1.0, 1.0, 250.0>
  rotate <-90.0, 0.0, 0.0>
}
#declare Punta = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  7  // control points
  <-1.0, -0.5>,
  <0.0, -1.0>,
  <1.0, -0.5>,
  <1.0, 0.5>,
  <0.0, 1.0>,
  <-1.0, 0.5>,
  <-1.0, -0.5>
  rotate <90,0,90>
  material {
    Maple
  }
  photons {
    pass_through
  }
  scale <10.238987, 9.981844, 40.591892>
  rotate <90.0, 0.0, -180.0>
  translate  <0.0, -40.584557, 0.0>
}
//
// Include file contains 'Eraser'
//
#include "test_dd_02.in1"
#declare Eraser = object {
  Eraser_Raw
  material {
    Gomma
  }
  photons {
    collect off
  }
  scale 0.8
  rotate <-90.0, 0.0, 0.0>
  translate  247.293559*y
}
union { // Matita
  object { corpo }
  object { Punta }
  object { Eraser }
  cone { // Mina_matita
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      Mina
    }
    scale <3.920459, 3.572972, 14.599289>
    rotate <90.0, 0.0, -180.0>
    translate  <-0.005039, -40.670946, -0.016193>
  }
  material {
    Wood
  }
  photons {
    collect off
  }
  scale 0.05
  rotate -76.017952*z
  translate  <-3.902096, -8.170013, 0.0>
}




