// Persistence Of Vision raytracer version 3.5
// Glide scene file
// Ron Gow 2004

#version 3.5;

global_settings{
	hf_gray_16 0 
	max_trace_level 256
	number_of_waves 10
	assumed_gamma 1
}

#default { finish { ambient 0 } }
#declare Ft=1;
#declare In=Ft/12; 

#declare sunpos = <87,115,135>;
#declare campos = <-0,5,-30>;
#declare seepos = <0,5,0>;

camera { 
    location campos
    look_at seepos
    right  x*4/3
    angle 60
} 

light_source { sunpos rgb 2.5}
light_source { <55,10,25> rgb 1 shadowless}

// *******************************
// ********  background  *********
// *******************************

#declare T_Background = texture {
	pigment {
		image_map {
			jpg "bay.jpg"
			once
		}
	}
	finish { ambient 1 diffuse 0 }
}

#declare Background = box { 0 <1,1,.01> texture { T_Background } }

// *******************************
// ***********  scene  ***********
// *******************************

#declare BSF = 350;
#declare BDF = .75;
object { Background scale <BSF*1.075,BSF*.92,1>  translate <-BSF*.53,-BSF*.44,BSF*BDF> }

#include "hanglider.inc"
object { Glider(2) scale .65 rotate <-6,0,17> rotate -y*85 translate <24,10,45> }
object { Glider(0) rotate <-37,0,22> rotate -y*65 translate <-12,21,25> }
