// Geomag system
// Copyright: Grimbert Jerome, September-October 2004.
// Free usage granted. Commercial resale prohibited.
// Modifications are allowed as long as no change to licensing.
//
// some standard finishes
#include "finish.inc"
// several different gold colors, finishes and textures
#include "golds.inc"

// various metal colors, finishes and textures
// brass, copper, chrome, silver
#include "metals.inc"
// various geometric transformation macros
// 
#include "transforms.inc"


#declare sphere_diameter=12.7;// 12.7 mm
#declare rod_length=27; //27 mm
#declare rod_max_diameter=7.4; // 7.4 mm
#declare sphere_contact=sqrt((sphere_diameter/2)*(sphere_diameter/2)-(rod_max_diameter/2)*(rod_max_diameter/2));

// Adjust dimension so that 1 unit be between the centers of two sphere separated by a rod 
#local scaling=1/(rod_length+2*sphere_contact);

#declare sphere_diameter=sphere_diameter*scaling;
#declare rod_length=rod_length*scaling;
#declare rod_max_diameter=rod_max_diameter*scaling;
#declare rod_diameter=0.8*rod_max_diameter;
#declare sphere_contact=sphere_contact*scaling;

#declare R_Yellow=texture {pigment { color Yellow*0.5 } finish {Dull}};
#declare R_Red=texture {pigment { color Red*0.7 } finish {Dull}};
#declare R_Blue=texture {pigment { color Blue*0.7 } finish {Dull}};
#declare R_Green=texture {pigment { color Green*0.5 } finish {Dull}}
#declare R_Glow=texture {pigment { color (Cyan+Green)/2} finish {ambient 0.7 diffuse 0.3} };
#declare R_Metal=texture {pigment { color Blue*0.3 } finish {Glossy metallic on}};

#declare metal=texture {T_Chrome_4C};

#macro Fsphere_rod(pos,dir,col)
(pos+vnormalize(dir));
sphere { pos, sphere_diameter/2 texture {metal}}
rod(pos+vnormalize(dir)*sphere_contact,dir,col)

#end

#macro sphere_rod(pos,dir,col)
   sphere { pos, sphere_diameter/2 texture {metal}}
rod(pos+vnormalize(dir)*sphere_contact,dir,col)

#end


#macro sphere_no_rod(pos)
   sphere { pos, sphere_diameter/2 texture {metal}}
#end


#macro rod(pos,dir,col)
   //cylinder { pos,pos+vnormalize(dir)*rod_length,rod_max_diameter/2 texture { col } }
   difference {
      union {
         torus { rod_diameter/4,rod_diameter/4 translate <0,rod_diameter/4,0> }
         torus { rod_diameter/4,rod_diameter/4 translate <0,rod_length-rod_diameter/4,0> }
         torus { rod_max_diameter/4,rod_max_diameter/4 translate <0,rod_length/5,0> }
         torus { rod_max_diameter/4,rod_max_diameter/4 translate <0,rod_length*4/5,0> }
         torus { rod_max_diameter/4,rod_max_diameter/4 translate <0,rod_length*2/4,0> }


         prism { 0, rod_length, 
#local step=30;  
            step+1 
#local i=0;
#while (i<=step)
#local point=<rod_diameter/2,0,0>;
#if (mod(i,5)!=0)
#local point=point*0.85;
#end
#local point=vrotate(point,<0,360/step*i,0>);
               ,<point.x,point.z>
#local i=i+1;
#end
         } // end prism
      } // end union
      sphere { <0,-sphere_contact,0>, sphere_diameter/2 }
      sphere { <0,rod_length+sphere_contact,0>, sphere_diameter/2 }
      texture { col } 

      Point_At_Trans(dir)
         translate pos

   }

#end

#macro Fno_rod_around(pos,dir)
(pos+vnormalize(dir));
#end

#macro rod_around(pos,dir,col)
rod(pos+vnormalize(dir)*sphere_contact,dir,col)
#end

#macro Frod_around(pos,dir,col)
   (pos+vnormalize(dir));
rod(pos+vnormalize(dir)*sphere_contact,dir,col)
#end

#macro Frod_intersect(pos,ori,dir,col,res)
   // find point on line defined by ori and dir such that distance from pos = 1
#local dd=vnormalize(dir);
#local step=1/2;
#local cur=ori;
#local dis=vlength(cur-pos);

#while(abs(dis-1)>0.001)
#if (dis>1)
#local cur=cur-step*dd;
#else
#local cur=cur+step*dd;
#end
#if (abs(dis-1)<0.9)
#local step=step*2/3;
#end
#local dis=vlength(cur-pos);
#end
#declare res=Frod_around(pos,(cur-pos),col)
#end

#macro Fno_rod_intersect(pos,ori,dir,res)
   // find point on line defined by ori and dir such that distance from pos = 1
#local dd=vnormalize(dir);
#local step=1/2;
#local cur=ori;
#local dis=vlength(cur-pos);

#while(abs(dis-1)>0.001)
#if (dis>1)
#local cur=cur-step*dd;
#else
#local cur=cur+step*dd;
#end
#if (abs(dis-1)<0.9)
#local step=step*2/3;
#end
#local dis=vlength(cur-pos);
#end
#declare res=Fno_rod_around(pos,(cur-pos))
#end
