// Copyright: Grimbert Jerome, September-October 2004.
// Free usage granted. Commercial resale prohibited.
// Modifications are allowed as long as no change to licensing.
//
#include "colors.inc"
#include "finish.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"
#include "glass.inc"


#declare gob=1;
#declare geo=1;
#declare pente=1;
#declare affiche=1;
#declare lig=1;

global_settings { 
   max_trace_level 150
      assumed_gamma 2.2
}
camera { location <-100,180,120> right image_width*x up image_height*y look_at <0,110,0> angle 45 //30
}
   light_source { <-100,180,100>, <0.58,0.55,0.50> 
#if (lig=1)
      area_light <0,30,0>,<0,0,60>, 10, 10
         adaptive 3
         jitter 
#end

   }
   light_source { 0,1
#if (lig=1)
      area_light <50,0,0>,<0,0,180>, 15, 15
         adaptive 3
         jitter 
#end
         translate <0,239,120>  }
#declare MyWallF=finish { specular 0.10 roughness 0.35 }

         plane {-y, -240 texture { pigment { White } finish {MyWallF} } }
         plane {z, -50 texture { pigment { White*0.9+Red*0.02+Yellow*0.01 } finish { MyWallF } } }
         plane {-z, -1050 texture { pigment { White*0.9 } finish { MyWallF} } }
         plane {-x, -100 texture { pigment { White*0.9+Red*0.02+Yellow*0.01 } finish { MyWallF } } }
         box { <100,0,-50>,<99,10,100> 
            texture { 
               pigment { wood scale 1/5
                  pigment_map {
                     [0 Aquamarine ]
                        [1 Aquamarine*0.9 ] }
               } finish { Dull } } }

box { <-100,99.8,50>,<100,95,-50> texture { 
   pigment { White*0.9 }
}
}


#local s=seed(12323);
#local i=-100;
#while(i<100)
#local j=-50;
#while(j<50)
superellipsoid { <0.15,0.5> rotate 90*x scale <4.95,0.2,4.95> 
   rotate <0,(rand(s)-0.5)*3,0>
      rotate <(rand(s)-0.5)*0.5,0,0>
      rotate <0,0,(rand(s)-0.5)*0.5>
      translate <i+5,99.8,j+5> 
      texture { pigment { White } finish { Glossy } } }
#local j=j+10;
#end
#local i=i+10;
#end
#declare orig = <0,103,0>;
      background { White }

      plane { y, 0
         texture {
            checker
               texture {
                  T_Wood1 scale 2.5
               }
            , texture { T_Wood1 scale 2.5 rotate <0,90,0> }
            scale 20 }
            //finish { Glossy }
      }
#if (gob=1)
#declare pion_blanc=sphere { <0,1,0>,1 scale <2.1/2,0.6/2,2.1/2>  texture { pigment { color White } } finish { Dull } }
#declare pion_noir=sphere { <0,1,0>,1 scale <2.1/2,0.6/2,2.1/2>  texture { pigment { color Black } } finish { Dull } }

#declare goparty=array[19][19]
{ 
   { 0,0,0,0,1,2,2,0,0,2,2,1,0,0,0,0,0,0,0},
   { 0,0,0,0,1,0,1,2,0,2,1,1,1,0,1,1,1,1,0},
   { 1,1,1,1,1,1,1,2,0,2,1,0,0,1,2,0,2,2,1},
   { 1,2,2,2,2,2,2,0,2,2,2,1,1,2,0,2,2,1,1},
   { 2,0,2,1,2,1,2,2,1,0,2,2,1,2,2,1,1,1,0},
   { 0,2,2,1,1,1,1,1,0,0,0,2,2,2,2,2,2,1,2},
   { 2,2,0,1,0,1,1,2,1,1,1,1,1,2,1,0,2,2,0},
   { 1,1,1,0,1,1,2,2,2,1,2,2,1,1,1,1,2,0,0},
   { 1,2,1,1,1,0,2,0,2,2,0,0,2,2,2,2,2,1,0},
   { 0,2,0,2,1,2,2,2,1,2,0,2,1,0,1,1,1,1,1},
   { 2,2,0,2,2,1,1,1,1,0,2,2,1,1,0,1,2,2,1},
   { 2,1,0,1,2,2,2,2,1,2,2,1,1,1,2,2,0,2,2},
   { 1,0,1,1,2,0,1,2,1,0,2,2,1,2,2,2,0,2,2},
   { 0,0,1,2,2,1,1,1,0,1,1,0,1,2,0,1,2,0,0},
   { 0,0,1,1,2,1,2,1,0,0,0,1,1,2,1,1,1,2,0},
   { 0,0,1,2,0,2,2,2,2,2,2,2,1,1,0,1,2,0,0},
   { 0,0,1,2,0,0,0,1,1,1,1,2,1,0,1,2,2,2,0},
   { 0,0,1,2,0,2,0,2,2,2,2,1,0,1,1,1,2,0,0},
   { 0,0,1,1,2,0,0,0,0,0,2,1,1,0,1,2,2,0,0},
};                
// various (mostly layered) wood textures
// T_Wood1 - T_Wood35
#include "woods.inc"

#declare rtt=seed(5456);
#declare goban=
union {
#local i=0;
#local a=42;
#local aa=42/20;
#local b=45.6;
#local bb=45.6/20;
#local ep=1.5;
   box { <0,0,0>,<a,ep,b> texture { T_Wood10 translate <10,20,10> scale 10 rotate x+3*z+y }}
#while (i<19)
   cylinder { <aa+aa*i,0,bb>,<aa+aa*i,0,b-bb>,aa/20 scale <1,0.01,1> texture { pigment { color Black }  } finish { Dull }  translate ep*y}
   cylinder { <aa,0,bb+bb*i>,<a-aa,0,bb+bb*i>,bb/20 scale <1,0.01,1> texture { pigment { color Black }  } finish { Dull } translate ep*y }
#local j=0;
#while (j<19)
#switch(goparty[i][j])
#case(1)
   object { pion_blanc translate rand(rtt)*aa/10*x rotate rand(rtt)*360*y 
      translate <a-aa-aa*j,ep,bb+bb*i> }
#break
#case(2)
   object { pion_noir translate rand(rtt)*aa/10*x rotate rand(rtt)*360*y 
      translate <a-aa-aa*j,ep,bb+bb*i> }

#break
#end
#local j=j+1;
#end

#local i=i+1;
#end

   translate <-a/2,0,-b/2>
      rotate 86*y
      translate <0,100,9> }
      object { goban }

      object { pion_noir translate <-a/2-12,100,5> }
      object { pion_noir translate <-a/2-13.5,100,7.2> }
      object { pion_noir translate <-a/2-11.5,100,8.2> }

      object { pion_blanc translate <a/2+12,100,-5.3> } 
      object { pion_blanc translate <a/2+12.9,100,-3> }
      object { pion_blanc translate <a/2+15.9,100,-4> }

      //=================================================
      // Bowl zone

      // Bowl opening are 5.5*aa in diameter
      // Bowl diameter are 8*aa in diameter, height is 3*aa
#declare bowl=
      union {
         difference {
            torus { 5*aa/2,3*aa/2 translate 3*aa*y/2 }
            sphere { <0,3*aa/2,0>,5.5*aa/2 }
         }
         cylinder { 0,<0,ep/4,0>, 5.5*aa/2 }
      }


object { bowl   texture { T_Wood7 rotate 96*x rotate -30*y scale 3 }
   translate <a/2+32,100,-4>
}
#declare b_blanc=<-a/2-17,100,28>;

object { bowl   texture { T_Wood12 rotate 96*x  rotate 10*y scale 6 }
   translate b_blanc
}

#declare i=0;
#while (i<12)
object { pion_blanc translate (aa*2*x) rotate i*30*y translate (b_blanc+ep/4*y) }
#declare i=i+1;
#end

#declare i=0;
#while (i<9)
object { pion_blanc translate (aa*1.5*x) rotate (30+i*40)*y translate (b_blanc+ep/4*y+0.6) }
#declare i=i+1;
#end
#declare i=0;
#while (i<6)
object { pion_blanc translate (aa*1*x) rotate (i*60)*y translate (b_blanc+ep/4*y) }
#declare i=i+1;
#end

#end

//======================================================================================
#include "geomag.inc"

#if (geo=1)


union {
#declare TCUb=texture {R_Yellow};
   sphere_rod(<0,0,0>,<1,0,0>,TCUb)
      sphere_rod(<1,0,0>,<0,1,0>,TCUb)
      sphere_rod(<1,1,0>,<0,0,1>,TCUb)
      sphere_rod(<1,1,1>,<-1,0,0>,TCUb)
      sphere_rod(<0,1,1>,<0,-1,0>,TCUb)
      sphere_rod(<0,0,1>,<0,0,-1>,TCUb)

      sphere_rod(<0,1,0>,<0,-1,0>,TCUb)
      sphere_rod(<1,0,1>,<0,1,0>,TCUb)

      rod_around(<0,1,0>,<1,0,0>,TCUb)
      rod_around(<0,1,0>,<0,0,1>,TCUb)

      rod_around(<1,0,1>,<-1,0,0>,TCUb)
      rod_around(<1,0,1>,<0,0,-1>,TCUb)
#declare TCUb=texture { R_Red };
#declare a=Frod_around(<0,0,0>,<1/2,1/2,-sqrt(1/2)>,TCUb)
      sphere_rod(a,<1/2,1/2,sqrt(1/2)>,TCUb)
      rod_around(a,<-1/2,1/2,sqrt(1/2)>,TCUb)
      rod_around(a,<1/2,-1/2,sqrt(1/2)>,TCUb)

#declare a=Frod_around(<0,0,1>,<1/2,1/2,sqrt(1/2)>,TCUb)
      sphere_rod(a,<1/2,1/2,-sqrt(1/2)>,TCUb)
      rod_around(a,<-1/2,1/2,-sqrt(1/2)>,TCUb)
      rod_around(a,<1/2,-1/2,-sqrt(1/2)>,TCUb)

#declare a=Frod_around(<0,0,0>,<1/2,-sqrt(1/2),1/2>,TCUb)
      sphere_rod(a,<1/2,sqrt(1/2),1/2,>,TCUb)
      rod_around(a,<-1/2,sqrt(1/2),1/2>,TCUb)
      rod_around(a,<1/2,sqrt(1/2),-1/2>,TCUb)

#declare a=Frod_around(<0,1,0>,<1/2,sqrt(1/2),1/2>,TCUb)
      sphere_rod(a,<1/2,-sqrt(1/2),1/2,>,TCUb)
      rod_around(a,<-1/2,-sqrt(1/2),1/2>,TCUb)
      rod_around(a,<1/2,-sqrt(1/2),-1/2>,TCUb)

#declare a=Frod_around(<0,0,0>,<-sqrt(1/2),1/2,1/2>,TCUb)
      sphere_rod(a,<sqrt(1/2),1/2,1/2,>,TCUb)
      rod_around(a,<sqrt(1/2),-1/2,1/2>,TCUb)
      rod_around(a,<sqrt(1/2),1/2,-1/2>,TCUb)

#declare a=Frod_around(<1,0,0>,<sqrt(1/2),1/2,1/2>,TCUb)
      sphere_rod(a,<-sqrt(1/2),1/2,1/2,>,TCUb)
      rod_around(a,<-sqrt(1/2),-1/2,1/2>,TCUb)
      rod_around(a,<-sqrt(1/2),1/2,-1/2>,TCUb)


      rotate <45,0,0> rotate <0,90,0> //translate <0,2,0>
      scale 4
      translate <50,104.5,-42.5>
}


#declare te=array[12];
#declare te[0]=texture { R_Glow };
#declare te[1]=texture { R_Yellow };
#declare te[2]=texture { R_Red };
#declare te[3]=texture { R_Blue };
#declare te[4]=texture { R_Metal };

#declare te[5]=texture { R_Blue };
#declare te[6]=texture { R_Green };
#declare te[7]=texture { R_Red };
#declare te[8]=texture { R_Blue };
#declare te[9]=texture { R_Red };



#declare te[10]=texture { R_Yellow };
#declare te[11]=texture { R_Red };

#macro extrao(pa,pb,pc,center,Ttetra,inx,iny,inz)
#local cf1=(pb+pa+pc)/3;
#local k=cf1;
#if (inx)
Frod_intersect(pb,cf1,(cf1-center),Ttetra,k)
#else
Fno_rod_intersect(pb,cf1,(cf1-center),k)
#end
#if (iny)
sphere_rod(k,(pa-k),Ttetra)
#end
#if (inz)
rod_around(k,(pc-k),Ttetra)
#end
#end

#macro cubi(randp,te,ma,inix,iniy,iniz)

#local p=<0,sphere_diameter/2,0>;
#if (iniy)
#local a=Fsphere_rod(p,<1,1,0>,te[int(ma*rand(randp))])
#else
#local a=Frod_around(p,<1,1,0>,te[int(ma*rand(randp))])
#end
#if (inix)
#local b=Fsphere_rod(a,<-1,1,0>,te[int(ma*rand(randp))])
#else
#local b=Frod_around(a,<-1,1,0>,te[int(ma*rand(randp))])
#end

#local c=Fsphere_rod(b,<-1,-1,0>,te[int(ma*rand(randp))])

sphere_rod(c,<1,-1,0>,te[int(ma*rand(randp))])


#local d=Frod_around(a,<-1,0,1>,te[int(ma*rand(randp))])
#local e=Frod_around(a,<-1,0,-1>,te[int(ma*rand(randp))])

sphere_rod(d,<-1,0,-1>,te[int(ma*rand(randp))])

#if (iniz)
sphere_rod(e,<-1,0,1>,te[int(ma*rand(randp))])
#end
   rod_around(d,<0,-1,-1>,te[int(ma*rand(randp))])
   rod_around(d,<0,1,-1>,te[int(ma*rand(randp))])
   rod_around(e,<0,1,1>,te[int(ma*rand(randp))])
rod_around(e,<0,-1,1>,te[int(ma*rand(randp))])

extrao(p,a,e,(p+a+b+c+d+e)/6,te[int(ma*rand(randp))],inix,iniy,iniz)

   extrao(p,c,d,(p+a+b+c+d+e)/6,te[int(ma*rand(randp))],1,iniy,1)
   extrao(p,a,d,(p+a+b+c+d+e)/6,te[int(ma*rand(randp))],inix,iniy,1)
extrao(p,c,e,(p+a+b+c+d+e)/6,te[int(ma*rand(randp))],1,iniy,iniz)

   extrao(b,a,d,(p+a+b+c+d+e)/6,te[int(ma*rand(randp))],inix,1,1)
   extrao(b,c,d,(p+a+b+c+d+e)/6,te[int(ma*rand(randp))],1,1,1)
   extrao(b,a,e,(p+a+b+c+d+e)/6,te[int(ma*rand(randp))],inix,1,iniz)
extrao(b,c,e,(p+a+b+c+d+e)/6,te[int(ma*rand(randp))],1,1,iniz)


#end
#declare only=1;
#declare zz=seed(434);
#declare sq2=sqrt(2);
#declare i=100-4;
#declare k=-50+4;
#declare j=0; 
#declare inix=1;
#declare iniz=1;
#declare iniy=1;

#while (i>-20)

   union { 
      cubi(zz,te,11,inix,iniy,iniz)
         scale 4
         translate <i,100+j,k>
   } 
#local az=rand(zz);
#declare inix=1;
#declare iniz=1;
#declare iniy=1;
#switch(az)
#range(0,0.20)
#declare j=j+4*sq2;
#declare iniy=0;
#break
#range(0.20,0.30)
#declare k=k+4*sq2;
#declare iniz=0;
#break
#range(0.3,1)
#declare i=i-4*sq2;
#if ((i<30)&(only))
#declare jj=0;
#while (jj<j)
   union { 
      cubi(zz,te,11,1,only,1)
         scale 4
         translate <i,100+jj,k>
   } 
#declare jj=jj+4*sq2;
#declare only=0;
#end
#end
#declare inix=0;
#break
#end              
#end  
#declare only=1;
#declare jj=0;
#while (jj<j)
   union { 
      cubi(zz,te,11,1,only,1)
         scale 4
         translate <i,100+jj,k>
   } 
#declare jj=jj+4*sq2;
#declare only=0;
#end

// =============================================================

#declare te[0]=texture { R_Yellow };
#declare te[1]=texture { R_Green };
#declare te[2]=texture { R_Red };
#declare te[3]=texture { R_Blue };
#declare te[4]=texture { R_Red };

#declare te[5]=texture { R_Blue };
#declare te[6]=texture { R_Green };
#declare te[7]=texture { R_Red };
#declare te[8]=texture { R_Blue };
#declare te[9]=texture { R_Red };



#declare te[10]=texture { R_Yellow };
#declare te[11]=texture { R_Red };

   union {
      cubi(zz,te,11,1,1,1)
         scale 4 translate <100-6,100,-10>
   }      
   union {
      cubi(zz,te,11,1,1,1)
         scale 4 translate <100-6,100,-10+24*sq2>
   }      
#local more=0;
#local ele=4*sq2;
#while(ele<45)
union { cubi(zz,te,11,1,0,1) scale 4 translate <100-6,100+ele,-10> }
#if (mod(ele,12*sq2)=4*sq2)
union { cubi(zz,te,11,1,1,0) scale 4 translate <100-6,100+ele,-10+4*sq2> }
union { cubi(zz,te,11,1,1,0) scale 4 translate <100-6,100+ele,-10+8*sq2> }
union { cubi(zz,te,11,1,1,0) scale 4 translate <100-6,100+ele,-10+12*sq2> }
union { cubi(zz,te,11,1,1,0) scale 4 translate <100-6,100+ele,-10+16*sq2> }
union { cubi(zz,te,11,1,1,0) scale 4 translate <100-6,100+ele,-10+20*sq2> }
#local more=1-more;
union { cubi(zz,te,11,1,0,0) scale 4 translate <100-6,100+ele,-10+24*sq2> }
#else
#if (more=1)
union { cubi(zz,te,11,1,0,1) scale 4 translate <100-6,100+ele,-10+8*sq2> }
union { cubi(zz,te,11,1,0,1) scale 4 translate <100-6,100+ele,-10+16*sq2> }
#end
union { cubi(zz,te,11,1,0,1) scale 4 translate <100-6,100+ele,-10+24*sq2> }
#end


#local ele=ele+4*sq2;
#end
union { cubi(zz,te,11,1,0,1) scale 4 translate <100-6,100+ele,-10+12*sq2> }
   union { 
#local ele2=Frod_around(<0,sphere_diameter/2,0>,-y,R_Glow)
#local ele3=Fsphere_rod(ele2,-y,R_Metal)
#local ele4=Fsphere_rod(ele3,x+z,R_Metal)
#local ele5=Fsphere_rod(ele4,-x+z,R_Metal)
#local ele6=Frod_around(ele3,-x+z,R_Metal)
#local ele7=Fsphere_rod(ele6,x+z,R_Metal)
#local ele8=Frod_around(ele6,y,R_Yellow)
#local ele9=Fsphere_rod(ele8,y,R_Yellow)
#local ele8=Frod_around(ele4,y,R_Yellow)
#local ele9=Fsphere_rod(ele8,y,R_Yellow)
      scale 4 translate <100-6,100+ele-4*sq2,-10+12*sq2>
   }
   union { 
#local ele2=Frod_around(<0,sphere_diameter/2,0>,-y,R_Glow)
#local ele3=Fsphere_rod(ele2,-y,R_Metal)
#local ele4=Fsphere_rod(ele3,x+z,R_Metal)
#local ele5=Fsphere_rod(ele4,-x+z,R_Metal)
#local ele6=Frod_around(ele3,-x+z,R_Metal)
#local ele7=Fsphere_rod(ele6,x+z,R_Metal)

#local ele8=Frod_around(ele6,y,R_Yellow)
#local ele9=Fsphere_rod(ele8,y,R_Yellow)
#local ele8=Frod_around(ele4,y,R_Yellow)
#local ele9=Fsphere_rod(ele8,y,R_Yellow)

      scale 4 translate <100-6,100+ele-4*sq2,-10+8*sq2>
   }
   union { 
#local ele2=Frod_around(<0,sphere_diameter/2,0>,-y,R_Glow)
#local ele3=Fsphere_rod(ele2,-y,R_Metal)
      sphere_no_rod(ele3)
         scale 4 translate <100-6,100+ele-4*sq2,-10+16*sq2>
   }


union {
#declare Ttetra=texture { R_Green };
#declare p=<3,sphere_diameter/2,2>;
#declare a=Fsphere_rod(p,<1,1,0>,Ttetra)
#declare b=Fsphere_rod(a,<-1,1,0>,Ttetra)
#declare c=Fsphere_rod(b,<-1,-1,0>,Ttetra)
   sphere_rod(c,<1,-1,0>,Ttetra)
#declare d=Frod_around(a,<-1,0,1>,Ttetra)
#declare e=Frod_around(a,<-1,0,-1>,Ttetra)
      sphere_rod(d,<-1,0,-1>,Ttetra)
      sphere_rod(e,<-1,0,1>,Ttetra)
      rod_around(d,<0,-1,-1>,Ttetra)
      rod_around(d,<0,1,-1>,Ttetra)
      rod_around(e,<0,1,1>,Ttetra)
      rod_around(e,<0,-1,1>,Ttetra)
#declare ap=b;
#declare aa=Frod_around(ap,<1,1,0>,Ttetra)
#declare ab=Fsphere_rod(aa,<-1,1,0>,Ttetra)
#declare ac=Fsphere_rod(ab,<-1,-1,0>,Ttetra)
      sphere_rod(ac,<1,-1,0>,Ttetra)
#declare ad=Frod_around(aa,<-1,0,1>,Ttetra)
#declare ae=Frod_around(aa,<-1,0,-1>,Ttetra)
      sphere_rod(ad,<-1,0,-1>,Ttetra)
      sphere_rod(ae,<-1,0,1>,Ttetra)
      rod_around(ad,<0,-1,-1>,Ttetra)
      rod_around(ad,<0,1,-1>,Ttetra)
      rod_around(ae,<0,1,1>,Ttetra)
      rod_around(ae,<0,-1,1>,Ttetra)

#declare center=(p+a+b+c+d+e)/6;
#declare Ttetra=texture{R_Blue};

#macro extra(pa,pb,pc)
#local cf1=(pb+pa+pc)/3;
#declare k=cf1;
      Frod_intersect(pb,cf1,(cf1-center),Ttetra,k)
      sphere_rod(k,(pa-k),Ttetra)
      rod_around(k,(pc-k),Ttetra)
#end

      extra(p,a,e)

      extra(p,c,d)
      extra(p,a,d)
      extra(p,c,e)

      extra(b,a,d)
      extra(b,c,d)
      extra(b,a,e)
      extra(b,c,e)
#declare center=(ap+aa+ac+ab+ad+ae)/6;
      extra(ap,aa,ae)

      extra(ap,ac,ad)
      extra(ap,aa,ad)
      extra(ap,ac,ae)
      extra(ab,aa,ad)
      extra(ab,ac,ad)
      extra(ab,aa,ae)
      extra(ab,ac,ae)
      scale 4
      translate <17,100,20>

}

union {
#declare Ttetra=texture { R_Green };
#declare p=<0,sphere_diameter/2,0>;
#declare a=Fsphere_rod(p,<1,1,0>,Ttetra)
#declare b=Fsphere_rod(a,<-1,1,0>,Ttetra)
#declare c=Fsphere_rod(b,<-1,-1,0>,Ttetra)
   sphere_rod(c,<1,-1,0>,Ttetra)
#declare d=Frod_around(a,<-1,0,1>,Ttetra)
#declare e=Frod_around(a,<-1,0,-1>,Ttetra)
      sphere_rod(d,<-1,0,-1>,Ttetra)
      sphere_rod(e,<-1,0,1>,Ttetra)
      rod_around(d,<0,-1,-1>,Ttetra)
      rod_around(d,<0,1,-1>,Ttetra)
      rod_around(e,<0,1,1>,Ttetra)
      rod_around(e,<0,-1,1>,Ttetra)
#declare ap=b;
#declare aa=Frod_around(ap,<1,1,0>,Ttetra)
#declare ab=Fsphere_rod(aa,<-1,1,0>,Ttetra)
#declare ac=Fsphere_rod(ab,<-1,-1,0>,Ttetra)
      sphere_rod(ac,<1,-1,0>,Ttetra)
#declare ad=Frod_around(aa,<-1,0,1>,Ttetra)
#declare ae=Frod_around(aa,<-1,0,-1>,Ttetra)
      sphere_rod(ad,<-1,0,-1>,Ttetra)
      sphere_rod(ae,<-1,0,1>,Ttetra)
      rod_around(ad,<0,-1,-1>,Ttetra)
      rod_around(ad,<0,1,-1>,Ttetra)
      rod_around(ae,<0,1,1>,Ttetra)
      rod_around(ae,<0,-1,1>,Ttetra)

#declare center=(p+a+b+c+d+e)/6;
#declare Ttetra=texture{R_Yellow};


      extra(p,a,e)

      extra(p,c,d)
      extra(p,a,d)
      extra(p,c,e)

      extra(b,a,d)
      extra(b,c,d)
      extra(b,a,e)
      extra(b,c,e)
#declare center=(ap+aa+ac+ab+ad+ae)/6;
      extra(ap,aa,ae)

      extra(ap,ac,ad)
      extra(ap,aa,ad)
      extra(ap,ac,ae)
      extra(ab,aa,ad)
      extra(ab,ac,ad)
      extra(ab,aa,ae)
      extra(ab,ac,ae)
      rotate 33*y
      scale 4
      translate <23,100,-20>

}

#declare dode=texture { R_Blue };
#declare do2=texture { R_Yellow };


#declare aa=array[20];
#declare gold=(sqrt(5)+1)/2;
#declare adjust=sqrt(5)-1;
// vertex coordinate are (+/- gold^-1, +/- gold, 0) (permutted along x,y,z) and (+/-1,+/-1,+/-1)
// for a size of edge a= sqrt(5)-1... we want a size of 1, let's adjust.
#declare aa[0]=<1/gold,gold,0>/adjust;
#declare aa[1]=<1/gold,-gold,0>/adjust;
#declare aa[2]=<-1/gold,gold,0>/adjust;
#declare aa[3]=<-1/gold,-gold,0>/adjust;

#declare aa[4]=<0,1/gold,gold>/adjust;
#declare aa[5]=<0,1/gold,-gold>/adjust;
#declare aa[6]=<0,-1/gold,gold>/adjust;
#declare aa[7]=<0,-1/gold,-gold>/adjust;

#declare aa[8]=<gold,0,1/gold>/adjust;
#declare aa[9]=<-gold,0,1/gold>/adjust;
#declare aa[10]=<gold,0,-1/gold>/adjust;
#declare aa[11]=<-gold,0,-1/gold>/adjust;

#declare aa[12]=<1,1,1>/adjust;
#declare aa[13]=<-1,1,1>/adjust;
#declare aa[14]=<-1,-1,1>/adjust;
#declare aa[15]=<1,-1,1>/adjust;
#declare aa[16]=<1,-1,-1>/adjust;
#declare aa[17]=<-1,-1,-1>/adjust;
#declare aa[18]=<-1,1,-1>/adjust;
#declare aa[19]=<1,1,-1>/adjust;

#declare cf=array[12];
#declare midradius=(3+sqrt(5))/4;
#declare cf[0]=vnormalize(<0,gold,1>)*midradius;
#declare cf[1]=vnormalize(<0,-gold,1>)*midradius;
#declare cf[2]=vnormalize(<0,gold,-1>)*midradius;
#declare cf[3]=vnormalize(<0,-gold,-1>)*midradius;

#declare cf[4]=vnormalize(<1,0,gold>)*midradius;
#declare cf[5]=vnormalize(<1,0,-gold>)*midradius;
#declare cf[6]=vnormalize(<-1,0,gold>)*midradius;
#declare cf[7]=vnormalize(<-1,0,-gold>)*midradius;

#declare cf[8]=vnormalize(<gold,1,0>)*midradius;
#declare cf[9]=vnormalize(<-gold,1,0>)*midradius;
#declare cf[10]=vnormalize(<gold,-1,0>)*midradius;
#declare cf[11]=vnormalize(<-gold,-1,0>)*midradius;

#declare ex=array[12];

union {

#declare i=0;
#declare center=<0,0,0>;
#while (i<20)
   sphere_no_rod(aa[i])
#declare center=center+aa[i];

#declare j=0;

#while (j<i)
#if (abs(vlength(aa[i]-aa[j])-1)<0.1)
      rod_around(aa[i],(aa[j]-aa[i]),dode)

#end

#declare j=j+1;
#end

#declare i=i+1;
#end

#declare f=0;
#while(f<12)
#declare i=0;
#while(i<20)
#if (vlength(cf[f]-aa[i])<1)
#declare ex[f]=<0,0,0>;
      Frod_intersect(aa[i],cf[f],(cf[f]-center),do2,ex[f])
#end
#declare i=i+1;
#end
      sphere_no_rod(ex[f])
#declare f=f+1;
#end rotate 90*y
      translate y*9/5+3*x 
      scale 4
      translate <0,100,-43.7>
}

#declare ico=texture { R_Red };
#declare ico2=texture { R_Metal };
#declare cf=array[12];
#declare adjust=1/2;
#declare cf[0]=(<0,gold,1>)*adjust;
#declare cf[1]=(<0,-gold,1>)*adjust;
#declare cf[2]=(<0,gold,-1>)*adjust;
#declare cf[3]=(<0,-gold,-1>)*adjust;

#declare cf[4]=(<1,0,gold>)*adjust;
#declare cf[5]=(<1,0,-gold>)*adjust;
#declare cf[6]=(<-1,0,gold>)*adjust;
#declare cf[7]=(<-1,0,-gold>)*adjust;

#declare cf[8]=(<gold,1,0>)*adjust;
#declare cf[9]=(<-gold,1,0>)*adjust;
#declare cf[10]=(<gold,-1,0>)*adjust;
#declare cf[11]=(<-gold,-1,0>)*adjust;

union {
#declare f=0;
#while (f<12)
   sphere_no_rod(cf[f])
#declare j=0;
#while (j<f)
#if (abs(vlength(cf[f]-cf[j])-1)<0.1)
      rod_around(cf[f],(cf[j]-cf[f]),ico)
#end
#declare j=j+1;
#end
#declare f=f+1;
#end

#declare f=0;
#while(f<12)
#declare i=0;  

#while(i<f)
#if (abs(vlength(cf[f]-cf[i])-1)<0.1)
#declare j=0;
#while(j<i)
#if ((abs(vlength(cf[j]-cf[i])-1)<0.1)&(abs(vlength(cf[j]-cf[f])-1)<0.1))
#declare l=<0,0,0>;
#declare k=(cf[i]+cf[j]+cf[f])/3;
      Frod_intersect(cf[f],k,k,ico2,l)
      rod_around(l,(cf[i]-l),ico2)
      rod_around(l,(cf[j]-l),ico2)
      sphere_no_rod(l)
#end
#declare j=j+1;

#end  

#end     
#declare i=i+1;   
#end  

#declare f=f+1;
#end rotate 90*y
      translate <-1,1.6,2>
      scale 4
      translate <97,100.2,-35>

}     





union {
#declare a=<0,+sphere_diameter/2,0>;
#declare trian=texture { R_Glow };
#declare b=Fsphere_rod(a,<1,0,0>,trian)
#declare c=a;
   Frod_intersect(a,(a+0.5*x),z,trian,c)
      sphere_rod(b,(c-b),trian)
      sphere_no_rod(c)

#declare a=<0,+sphere_diameter*3/2,0>;
#declare trian=texture { R_Yellow };
#declare b=Fsphere_rod(a,<1,0,0>,trian)
#declare c=a;
      Frod_intersect(a,(a+0.5*x),z+y/6,trian,c)
      sphere_rod(b,(c-b),trian)
      sphere_no_rod(c)
      // general math functions and macros
      // 
#include "math.inc"
#declare d=VPerp_To_Plane(a-c, a-b); 
#declare e=<0,0,0>;
      Frod_intersect(a,(a+b+c)/3,d,trian,e)
      sphere_rod(e,(a-e),trian)
      rod_around(e,(b-e),trian)
      rod_around(e,(c-e),trian)
      rotate y*15
      scale 4
      translate <2,100,45>
}      



#declare te=array[12];
#declare te[0]=texture { R_Yellow };
#declare te[1]=texture { R_Yellow };
#declare te[2]=texture { R_Red };
#declare te[3]=texture { R_Blue };
#declare te[4]=texture { R_Red };

#declare te[5]=texture { R_Blue };
#declare te[6]=texture { R_Green };
#declare te[7]=texture { R_Red };
#declare te[8]=texture { R_Blue };
#declare te[9]=texture { R_Red };



#declare te[10]=texture { R_Yellow };
#declare te[11]=texture { R_Red };
#declare couch=<0,0,0>;
#declare se=seed(778);
union { 
#declare p=<8,sphere_diameter/2,2>;
#while (p.x<24)
#declare a=Fsphere_rod(p,<rand(se),0,rand(se)-0.5>,te[11*rand(se)])
#declare p=a;
#if (p.x < 17)
#declare star=p;
#end
#end
   sphere_no_rod(p)
#declare p=star;
#while (p.z<12.5)
#declare a=Fno_rod_around(p,<rand(se)-0.8,0,rand(se)/3>)
#if (a.x > couch.x)
#declare couch=a;
#end
#if (a.z<12.5)
      rod_around(p,a-p,te[11*rand(se)])
#else
#declare a=<a.x,a.y-0.25,a.z>;
      rod_around(p,(a-p),te[11*rand(se)])
#end
#declare p=a;
      sphere_no_rod(p)
#end

#declare star=p;







      Frod_intersect(p,<p.x,sphere_diameter/2,p.y>,-z,te[11*rand(se)],a)
#declare p=a;
      sphere_no_rod(p)
#while (p.z>10.5)
#declare a=Frod_around(p,<rand(se)/4,0,-1>,te[11*rand(se)])
#declare p=a;
      sphere_no_rod(p)
#end
      // More weight here 
#declare i=0;

#while (i<6)
#declare a=Frod_around(p,vrotate(x,60*i*y),R_Red)
#if (i<5)
      sphere_no_rod(a)
#end
#declare cc=Frod_around(a,vrotate(x,(120+60*i)*y),R_Yellow)
#declare s=(p+a+cc)/3;
#declare pp=<0,0,0>;

      Frod_intersect(p,s,y,R_Blue,pp)
      sphere_no_rod(pp)
      rod_around(pp,(a-pp),R_Metal)
      rod_around(pp,(cc-pp),R_Green)
      rod_around(pp,vrotate(x,(30+i*60)*y),R_Red)
#local aaa=<a.x,2*pp.y-a.y,a.z>;
#local ppp=<p.x,2*pp.y-p.y,p.z>;
#local ccc=<cc.x,2*pp.y-cc.y,cc.z>;
      rod_around(pp,(aaa-pp),R_Metal)
      rod_around(pp,(ccc-pp),R_Green)
      rod_around(pp,(ppp-pp),R_Blue)

      sphere_rod(aaa,(ppp-aaa),R_Yellow)

#declare p=a;
#declare i=i+1;
#end
      sphere_no_rod(cc)
      sphere_no_rod(ccc)
















      // back on the table 
#declare p=couch;
#while (p.x<18)
#declare a=Frod_around(p,<1,0,rand(se)/4>,te[11*rand(se)])
#declare p=a;
      sphere_no_rod(p)
#end

      // More weight here 
#declare i=0;

#while (i<6)
#declare a=Frod_around(p,vrotate(x,60*i*y),R_Green)
#if (i<5)
      sphere_no_rod(a)
#end
#declare cc=Frod_around(a,vrotate(x,(120+60*i)*y),R_Yellow)
#declare s=(p+a+cc)/3;
#declare pp=<0,0,0>;

      Frod_intersect(p,s,y,R_Red,pp)
      sphere_no_rod(pp)
      rod_around(pp,(a-pp),R_Yellow)
      rod_around(pp,(cc-pp),R_Blue)

      //rod_around(pp,vrotate(x,(30+i*60)*y),R_Red)
#local aaa=<a.x,2*pp.y-a.y,a.z>;
#local ppp=<p.x,2*pp.y-p.y,p.z>;
#local ccc=<cc.x,2*pp.y-cc.y,cc.z>;
      rod_around(pp,(aaa-pp),R_Metal)
      rod_around(pp,(ccc-pp),R_Green)
      rod_around(pp,(ppp-pp),R_Blue)

      sphere_rod(aaa,(ppp-aaa),R_Blue)
      rod_around(aaa,(ccc-aaa),R_Red)
#declare www=<0,0,0>;
#declare sss=(ppp+aaa+ccc)/3;

      Frod_intersect(aaa,sss,y,R_Yellow,www)
      sphere_no_rod(www)
      rod_around(www,(ppp-www),R_Yellow)
      rod_around(www,(ccc-www),R_Yellow)

#declare p=a;
#declare i=i+1;
#end
      sphere_no_rod(cc)
      sphere_no_rod(ccc)

#declare p=star;
#declare a=Frod_around(p,-y,te[11*rand(se)])
#declare p=a;
      sphere_no_rod(p)
#declare b=Frod_around(p,vrotate((ppp-www),-24*y),te[11*rand(se)])
#declare c=Frod_around(p,vrotate((ccc-www),-24*y),te[11*rand(se)])
#declare a=Frod_around(p,vrotate((aaa-www),-24*y),te[11*rand(se)])
      sphere_rod(a,(b-a),te[11*rand(se)])
      sphere_rod(b,(c-b),te[11*rand(se)])
      sphere_rod(c,(a-c),te[11*rand(se)])
#declare bb=Frod_around(b,-y,te[11*rand(se)])
#declare cc=Frod_around(c,-y,te[11*rand(se)])
#declare aa=Frod_around(a,-y,te[11*rand(se)])
#declare a=aa;
#declare b=bb;
#declare c=cc;
      sphere_no_rod(a)//,(b-a),te[11*rand(se)])
      sphere_no_rod(b)//,(c-b),te[11*rand(se)])
      sphere_no_rod(c)//,(a-c),te[11*rand(se)])
#declare bb=Frod_around(b,-y,te[11*rand(se)])
#declare cc=Frod_around(c,-y,te[11*rand(se)])
#declare aa=Frod_around(a,-y,te[11*rand(se)])
#declare a=aa;
#declare b=bb;
#declare c=cc;
      sphere_no_rod(a)//,(b-a),te[11*rand(se)])
      sphere_no_rod(b)//,(c-b),te[11*rand(se)])
      sphere_no_rod(c)//,(a-c),te[11*rand(se)])

#declare bb=Frod_around(b,-y,te[11*rand(se)])
#declare cc=Frod_around(c,-y,te[11*rand(se)])
#declare aa=Frod_around(a,-y,te[11*rand(se)])
#declare a=aa;
#declare b=bb;
#declare c=cc;

      sphere_rod(a,(b-a),te[11*rand(se)])
      sphere_rod(b,(c-b),te[11*rand(se)])
      sphere_rod(c,(a-c),te[11*rand(se)])


#declare p=Frod_around(a,vrotate((www-aaa),-24*y),te[11*rand(se)])
      rod_around(b,(p-b),te[11*rand(se)])
      rod_around(c,(p-c),te[11*rand(se)])
      sphere_no_rod(p)

#while (p.y>-5)

      // Variation here
#declare a=Frod_around(p,-y,te[11*rand(se)])
#declare p=a;
      sphere_no_rod(p)
#end

#declare b=Frod_around(p,vrotate((ppp-www),14*y),te[11*rand(se)])
#declare c=Frod_around(p,vrotate((ccc-www),14*y),te[11*rand(se)])
#declare a=Frod_around(p,vrotate((aaa-www),14*y),te[11*rand(se)])
      sphere_rod(a,(b-a),te[11*rand(se)])
      sphere_rod(b,(c-b),te[11*rand(se)])
      sphere_rod(c,(a-c),te[11*rand(se)])



#declare p=Frod_around(a,vrotate((www-aaa),14*y)*<1,-1,1>,te[11*rand(se)])
      rod_around(b,(p-b),te[11*rand(se)])
      rod_around(c,(p-c),te[11*rand(se)])
      sphere_no_rod(p)


      scale 4
      translate <0,100,0>
}

#declare i=0;
#declare p=<0,sphere_diameter/2,0>;
   union {
      sphere_no_rod(p)
#while (i<6)
#declare a=Frod_around(p,vrotate(x,60*i*y),R_Red)
         sphere_rod(a,vrotate(x,(120+60*i)*y),R_Red)
#declare i=i+1;
#end
         rotate -33*y
         scale 4
         translate <36,100,-12>
   }

#declare i=0;
#declare p=<0,sphere_diameter/2,0>;
   union {
      sphere_no_rod(p)
#while (i<6)
#declare a=Frod_around(p,vrotate(x,60*i*y),R_Blue)
         sphere_rod(a,vrotate(x,(120+60*i)*y),R_Red)

#declare i=i+1;
#end
         rotate 16*y
         scale 4

         translate <52,100,-16>
   }


#declare i=0;
#declare p=<16,sphere_diameter/2,-5>;
   union {
      sphere_no_rod(p)
#while (i<6)
#declare a=Frod_around(p,vrotate(x,60*i*y),R_Yellow)
         sphere_rod(a,vrotate(x,(120+60*i)*y),R_Yellow)

#declare i=i+1;
#end
#declare p=Frod_around(a,(a-p),R_Blue)
#declare p=p+(p-a);
#declare i=0;
         sphere_no_rod(p)
#while (i<6)
#declare a=Frod_around(p,vrotate(x,60*i*y),R_Yellow)
         sphere_rod(a,vrotate(x,(120+60*i)*y),R_Yellow)

#declare i=i+1;
#end

#declare p=Frod_around(a,(a-p),R_Blue)
#declare p=p+(p-a);
#declare i=0;
         sphere_no_rod(p)
#while (i<6)
#declare a=Frod_around(p,vrotate(x,60*i*y),R_Yellow)
         sphere_rod(a,vrotate(x,(120+60*i)*y),R_Yellow)

#declare i=i+1;
#end

         scale 4
         translate <0,100,0>
   }

#declare p=<0,sphere_diameter/2,0>;
union {

#declare a=Fsphere_rod(p,<1,0,0>,R_Red)
#declare b=Fsphere_rod(a,<0,0,1>,R_Red)
#declare c=Fsphere_rod(b,<-1,0,0>,R_Red)
   sphere_rod(c,(p-c),R_Red)
#declare e=<0,0,0>;
      Frod_intersect(a,(a+b)/2,<1,0,0>,R_Metal,e)
#declare f=<0,0,0>;
      Frod_intersect(b,(c+b)/2,<0,0,1>,R_Metal,f)
      sphere_rod(e,(b-e),R_Metal)
      sphere_rod(f,(c-f),R_Metal)
      rotate 40*y
      scale 4
      translate <40,100,-32>
}

#declare te[0]=texture { R_Yellow };
#declare te[1]=texture { R_Green };
#declare te[2]=texture { R_Red };
#declare te[3]=texture { R_Blue };
#declare te[4]=texture { R_Glow };

#declare te[5]=texture { R_Metal };
#declare te[6]=texture { R_Green };
#declare te[7]=texture { R_Yellow };
#declare te[8]=texture { R_Red };
#declare te[9]=texture { R_Blue };



#declare te[10]=texture { R_Yellow };
#declare te[11]=texture { R_Red };


union {
#declare p=<0,sphere_diameter/2,-sphere_diameter/2>;
   // More weight here 
#declare niv=0;
#while (niv<12)
#declare i=0;
#while (i<6)
#if (niv=0)
#declare a=Frod_around(p,vrotate(x,60*i*y),te[niv])
#declare cc=Frod_around(a,vrotate(x,(120+60*i)*y),te[niv])
#else
#declare a=Fno_rod_around(p,vrotate(x,60*i*y))
#declare cc=Fno_rod_around(a,vrotate(x,(120+60*i)*y))
#end
#if (niv=0)
   sphere_no_rod(a)
#end
#declare s=(p+a+cc)/3;
#declare pp=<0,0,0>;

      Frod_intersect(p,s,y,te[niv],pp)
      sphere_no_rod(pp)
      rod_around(pp,(a-pp),te[niv])
      rod_around(pp,(cc-pp),te[niv])
#local aaa=<a.x,2*pp.y-a.y,a.z>;
#local ppp=<p.x,2*pp.y-p.y,p.z>;
#local ccc=<cc.x,2*pp.y-cc.y,cc.z>;
      rod_around(pp,(aaa-pp),te[niv])
      rod_around(pp,(ccc-pp),te[niv])
      rod_around(pp,(ppp-pp),te[niv])

      sphere_rod(aaa,(ppp-aaa),te[niv])
      rod_around(aaa,(ccc-aaa),te[niv])

#declare p=a;
#declare i=i+1;
#end
      sphere_no_rod(cc)
      sphere_no_rod(ccc)
#declare p=<0,p.y+(ccc.y-cc.y),-sphere_diameter/2>;
#declare niv=niv+1;
#end

      scale 4
      rotate 90*x
      rotate 90*y
      translate <-75,100,-39>
}

#declare te[4]=texture { R_Blue };

#declare te[5]=texture { R_Blue };


union {
#declare p=<0,sphere_diameter/2,0>;
   // More weight here 
#declare niv=0;
#while (niv<6)
#declare i=0;
#while (i<6)
#if (niv=0)
#declare a=Frod_around(p,vrotate(x,60*i*y),te[niv])
#declare cc=Frod_around(a,vrotate(x,(120+60*i)*y),te[niv+1])
#else
#declare a=Fno_rod_around(p,vrotate(x,60*i*y))
#declare cc=Fno_rod_around(a,vrotate(x,(120+60*i)*y))
#end
#if (niv=0)
   sphere_no_rod(a)
#end
#declare s=(p+a+cc)/3;
#declare pp=<0,0,0>;

      Frod_intersect(p,s,y,te[niv+2],pp)
      sphere_no_rod(pp)
      rod_around(pp,(a-pp),te[niv])
      rod_around(pp,(cc-pp),te[niv+1])
#local aaa=<a.x,2*pp.y-a.y,a.z>;
#local ppp=<p.x,2*pp.y-p.y,p.z>;
#local ccc=<cc.x,2*pp.y-cc.y,cc.z>;
      rod_around(pp,(aaa-pp),te[niv+1])
      rod_around(pp,(ccc-pp),te[niv])
      rod_around(pp,(ppp-pp),te[niv+2])

      sphere_rod(aaa,(ppp-aaa),te[niv+2])
      rod_around(aaa,(ccc-aaa),te[niv+2])

#declare p=a;
#declare i=i+1;
#end
      sphere_no_rod(cc)
      sphere_no_rod(ccc)
#declare p=<0,p.y+(ccc.y-cc.y),0>;
#declare niv=niv+1;
#end

      scale 4 rotate 23*y
      translate <55,100,-29>
}


#end


//=================================================

#if (pente=1)
// various glass finishes, colors and interiors
//
#include "glass.inc"

#declare pion_vert=sphere { <0,1,0>,1 scale <2.01/2,1/2,2.01/2>  
   texture {     pigment { color Col_Glass_Green }
      finish { F_Glass8 }
   } 
   interior { I_Glass1 }  }
#declare pion_rouge=sphere { <0,1,0>,1 scale <2.01/2,1/2,2.01/2>  
   texture {    pigment { color Col_Red_01 filter 0.95 }
      finish { F_Glass8 
      }
   } interior { I_Glass1 }  }

#declare penteparty=array[19][19]
{ 
   { 2,1,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
   { 1,2,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
   { 2,0,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
   { 0,1,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0},
   { 0,2,0,1,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0},
   { 2,2,1,0,0,2,1,2,0,0,0,2,0,0,0,0,0,0,0},
   { 1,2,1,2,1,0,1,1,0,0,1,1,0,0,0,0,0,0,0},
   { 1,2,1,0,0,2,0,2,1,0,1,0,0,0,0,0,0,0,0},
   { 2,1,2,0,0,1,0,0,2,0,1,0,0,0,0,0,0,0,0},
   { 1,2,2,1,2,2,2,1,1,2,1,0,0,0,0,0,0,0,0},
   { 2,0,2,0,1,1,0,1,2,0,1,2,0,0,0,0,0,0,0},
   { 0,0,1,0,2,2,0,1,0,0,0,0,1,0,1,2,0,0,0},
   { 0,0,2,0,1,1,0,2,0,1,2,0,0,2,0,0,0,0,0},
   { 0,1,0,0,2,0,0,0,0,0,0,0,0,0,1,0,0,0,0},
   { 0,0,0,0,0,1,0,0,0,0,0,0,0,0,2,0,0,0,0},
   { 0,0,0,0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,0},
   { 0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0},
   { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
   { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};                

#declare rtt=seed(5456);
#declare goban_pente=
union {
#local i=0;
#local a=42;
#local aa=42/20;
#local b=45.6;
#local bb=45.6/20;
#local ep=0.15;
   box { <0,0,0>,<a,ep,b> texture { pigment { color (White+Yellow)/2 } finish { Phong_Dull } }}
#while (i<19)
   cylinder { <aa+aa*i,0,bb>,<aa+aa*i,0,b-bb>,aa/20 scale <1,0.01,1> texture { pigment { color Black }  } finish { Dull }  translate ep*y}
   cylinder { <aa,0,bb+bb*i>,<a-aa,0,bb+bb*i>,bb/20 scale <1,0.01,1> texture { pigment { color Black }  } finish { Dull } translate ep*y }
#local j=0;
#while (j<19)
#switch(penteparty[i][j])
#case(1)
   object { pion_vert translate rand(rtt)*aa/10*x rotate rand(rtt)*360*y 
      translate <a-aa-aa*j,ep,bb+bb*i> }
#break
#case(2)
   object { pion_rouge translate rand(rtt)*aa/10*x rotate rand(rtt)*360*y 
      translate <a-aa-aa*j,ep,bb+bb*i> }

#break
#end
#local j=j+1;
#end

#local i=i+1;
#end

   translate <-a/2,0,-b/2>
      rotate -9*y
      translate <-55,100,-10> }
      object { goban_pente }
#end

#if (affiche=1)
      //plane {z, -50 texture { pigment { White*0.9+Red*0.02+Yellow*0.01 } finish { MyWallF } } }
      box { <-0.03,-0.03,0>,<1.03,1.03,0> 
         texture { pigment { color White } finish { Glossy } } 
         texture { pigment { image_map { png "affiche.png" once interpolate 2 } } translate -x scale <-1,1,1> }  

         scale <32,24,1>
            translate -49.99*z translate <-45,130,0> }

            box { <-0.03,-0.03,0>,<1.03,1.03,0> 
               texture { pigment { color White } finish { Glossy } } 
               texture { pigment { image_map { png "affiche.png" once interpolate 2 } } translate -x scale <-1,1,1> }  

               scale <32,24,1>
                  rotate -90*y
                  translate 99.99*x translate <0,130,-40> }


#end
