///The Age of Innocence///


#include "Plane.pov"
#include "textures.inc"
#declare Radiosity=on;
#declare Photons=on;

global_settings { 
assumed_gamma 1.0
max_trace_level 10
 radiosity {
    pretrace_start 0.08           
    pretrace_end   0.09          
    count 500                
    nearest_count 5              
    error_bound 3              
    recursion_limit 5            
    low_error_factor .05         
    gray_threshold 0.0            
    minimum_reuse 0.015           
    brightness 1                  

    adc_bailout 0.001/2
                              
  }
 
  photons {
    spacing 0.05               
   count 1000               
   max_trace_level 10          
  

 }
   
 
} 
 
           
//////CAMERA BLOCK *********************************************************************************   
camera {
  location  <0.0, 0.0, 0.0>
  look_at   <5.5, 5.0,  4.5>
  right     x*image_width/image_height
  aperture .15      
  blur_samples 500       
  focal_point <5.5,5,4.5>   
  confidence 0.99           
  variance 1/1000            
}   





/////////end of camera block    


  
 

  
  
  

////////////LIGHTING BLOCK *****************************************************************


light_source {
  <1000, 1000, -5000>     
  color rgb 1.0   
  
  parallel
  
  jitter
  
  photons {
    refraction on
    reflection on
    
  }
   
}



/////end of lighting block 





/////////BACKGROUND BLOCK *********************************************************************************
     
sky_sphere {
  pigment {
    gradient y
    color_map { [0.7 color rgb <0.051,0.051, 1>] [1 color rgb <0.5,0.5,.95, >] }
    
   rotate x*180
  }  
  pigment {
                bozo 
                turbulence .9
                octaves 4
                omega 0.45
                lambda 3
color_map {
  
  [ 0.1  color red 0.99 green 0.99 blue 0.99 ]
  [ 0.3  color red 0.85 green 0.85 blue 0.85 transmit .2 ]
 
  [ 0.5  color red 0.25 green 0.25 blue 0.25  transmit .75]
  [ 1.0  color red .1 green .1 blue 0.1  transmit 1]
  
  
 
} 
scale <0.15, .15, .15>
 rotate x*45
                
   }
  }
  


        

 
/////END OF BACKGROUND BLOCK







                 
/////MATERIAL BLOCK  **********************************
   
#declare SOAP=material {
                texture {
                 pigment { color rgbft <0.1, 0.01, 0.1, .1, .95> }
      
                finish {
                 ambient 0.1       
                 diffuse .2          
                 brilliance 100     
   
    phong 25        
    phong_size 250      
    
    specular .2      
    roughness 0.0005     
   
    
    reflection {
      0.1                      
       .5                     
      fresnel on             
      falloff 2
      exponent 2            
    }
    conserve_energy          
    
    irid {               
      1              
      thickness .2
      turbulence 1.2
    }
  } 

  }
  interior {
    ior 1.45
  } 
 
}
                 

                
                  
                  
 //OBJECT BLOCK *********************************************************************  

     
     
#declare Bubble= sphere {
  <0, 0, 0> 
  0.5       
 material {SOAP}
   
  photons{
    target .005        
    refraction on
    reflection on
    
  }   

}  



///////BUBBLE BLOCK ********************/////////////////////

object {Bubble
         translate <10, 12, 10> 
         }
object {Bubble
         translate <4, 7, 5> 
         }
object {Bubble
         translate <1, 7, 7> 
         }
object {Bubble
         translate <3, 5, 7> 
         }
object {Bubble
         translate <8, 6, 5> 
         }
object {Bubble
         translate <9, 9, 2> 
         scale 2}
object {Bubble
         translate <9, 10, 3> 
         }
object {Bubble
         translate <8, 8, 4> 
         } 
object {Bubble
         translate <2, 2, 4> 
         } 
object {Bubble
         translate <1, 1, 6> 
         }    
object {Bubble
         translate <7, 7, 4> 
         }
object {Bubble
         translate <7, 8, 5> 
         }
object {Bubble
         translate <6, 6.5, 5> 
         }
object {Bubble
         translate <6, 8, 6> 
         }
object {Bubble
         translate <5.5, 5, 5> 
         }
object {Bubble
         translate <5, 5, 6> 
         }
object {Bubble
         translate <2, 5, 7> 
         }
object {Bubble
         translate <5, 8, 9> 
         }
object {Bubble
         translate <9, 10,12> 
         }
object {Bubble
         translate <16, 14, 2> 
         }
object {Bubble
         translate <16, 16.5, 2> 
         }
object {Bubble
         translate <18, 17, 2> 
         }
object {Bubble
         translate <14, 14, 3> 
         }
object {Bubble
         translate <16, 16.5, 8> 
         }
object {Bubble
         translate <14, 14, 16> 
         }
object {Bubble
         translate <6, 3, 9> 
         } 
object {Bubble
         translate <16, 13, 12> 
         } 
object {Bubble
         translate <23, 20, 20> 
         }
object {Bubble
         translate <19, 9, 2> 
         } 
object {Bubble
         translate <19, 12, 5> 
         }
object {Bubble
         translate <16, 8, 20> 
         }          
object {Bubble
         translate <19, 12, 2> 
         }           
object {Bubble
         translate <2, 1, 3.5> 
         }
object {Bubble
         translate <3, 2.5, 10> 
         }
object {Bubble
         translate <4, 3.5, 10> 
         } 
object {Bubble
         translate <3.2, 5.5, 10> 
         }
object {Bubble
         translate <25, 10, 1> 
         } 
object {Bubble
         translate <29, 15, 3> 
         }
object {Bubble
         translate <29, 21, 8> 
         }
object {Bubble
         translate <30, 20, 5> 
         }
object {Bubble
         translate <31, 40, 10> 
         }
object {Bubble
         translate <29, 37, 21> 
         } 
object {Bubble
         translate <30, 38, 19> 
         }
object {Bubble
         translate <33, 40, 11> 
         }
object {Bubble
         translate <27, 37, 21> 
         } 
object {Bubble
         translate <35, 33, 20> 
         }
object {Bubble
         translate <31, 42, 5> 
         }
object {Bubble
         translate <29, 33, 5> 
         } 
object {Bubble
         translate <31, 38, 5> 
         }  
object {Bubble
         translate <33, 15, -5> 
         }  
object {Bubble
         translate <22, 20, 2> 
         } 
object {Bubble
         translate <22, 30, 15> 
         } 
         
         
         
         
         
         
//////BALL **********************//////////////////////////////
         
sphere { <45, 40, 20>, 7   pigment {
    gradient y
    color_map {
        [0.25 rgb <1,0,0>]
        [0.25 rgb <1,1,1>]
        [0.75 rgb <1,1,1>]
        [0.75 rgb <1,0,0>]
    } rotate <23, 0 , 4>} 
  finish {
    ambient 0.8          
    diffuse 0.9          
    brilliance 1.0       
    phong 0.5          
    phong_size 140      
    
    specular 0.9       
    roughness 0.005    
    
    reflection {
      0.0                      
      1.0                        
      fresnel on              
      falloff 1.0             
      exponent 1.0            
      metallic 1.0            
    }
    crand 0.2                  
    
  } 
   
  photons{
    target .005         
    refraction on
    reflection on
   
  }

 
}





////SUN *********//////////////////      
         
sphere { <1000, 1000, -5000>, 500  
material {
  texture {
    pigment { color rgbt <1, 1, 1, .9> }
    finish { diffuse 1 specular 1 }
  }
  interior {
    ior 1
  }
}
}           
 
/////////PLANE *******************/////////////////// 
object {Plane scale <.1, .1, .1>  rotate <-70, 90, 5> translate <250, 220, -20> 
  photons{
    target .005          
    refraction on
    reflection on
  
  }
}        
////END        
   
         



