global_settings { assumed_gamma 2.6 }

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "stones.inc"
#declare showWorld = on;
#declare showStangen = on;
#declare showPlaettchen = on;
#declare showBall = off;



//----------------------------------------------------------------------

 #declare Logo =
 box{<0,0,0>, <1, 1,.01>
           texture{pigment {
                            image_map{ png "logo.png"
                                   map_type 0 
                                   interpolate 0 
                                   once 
                            }
                        
                         //   scale <1.2,2 .7,1> // bei 4:3 Texture - Koerper anpassen
                   }
                   finish   { 
                            ambient 0.1 
                            diffuse 0.9 
                            phong 1
                   }
           }                                                                       
            scale 2
            rotate<0,90,0>
           
         }
         
#declare Linien =  
                 box {<0, 0, 0>,<13 ,7.2, 0.001  >
                         //texture {Chrome_Metal}
                        texture{ pigment { 
                        image_map{ 
                                png "4.png"
                                map_type 0 interpolate 0}
                                scale <7,13,1> 
                                rotate <0,0,-90>
                                }
                                //finish {diffuse 4.5}
                        }
                        translate <-7.5, -3.6,0>
                        rotate <90,0,0>
                }

#declare Schraube =
                difference {
                        cylinder { <0,0,0>,<0,0.01,0>, 0.02
                                texture {Chrome_Metal finish {phong 0.5 reflection 0.15}}
                                scale <1,1,1> 
                                rotate<0,0,0>}
                        box {<-0.003, 0.005, -.05>,<0.002, 0.03, .05>
                             texture {Chrome_Metal finish {phong 0.5 reflection 0.00}}}
        }
        
//-------------------------------------------------------------------------

// (following function "MUTTER" is partially from www.f-lohmueller.de - thanks)
#declare Mutter =
    #macro Schraubenmutter (N, Wire_Radius, Pyramid_R1, Pyramid_R2, Pyramid_Height, Fill_On)  
        #local RR = Wire_Radius; 
        #local RP_R  = Pyramid_R1; // base radius
        #local RP_R2 = Pyramid_R2; // top radius
        #local RP_H  = Pyramid_Height;
        #local D = 0.00001;    
        #if ( N < 3) #local N = 3; #end // 3 is minimum!!!
        #if ( RR = 0 ) #local RR = D; #end  
        #if ( RR < 0 ) #local RR = abs(RR) ; #end
        #if ( RP_R < 0 ) #local RP_R = abs(RP_R) ; #end
        #if ( RP_R2 < 0 ) #local RP_R2 = abs(RP_R2) ; #end
        #if ( RR = RP_R/2 ) #local RP_R = RP_R/2+D; #end
        #local RA = sqrt(pow(RR,2)+pow(RR*tan(radians(180/N)),2)  );
        #if (RP_R2= 0) #local RP_R2 = RA; #end
        #local P_Middle = RP_R*cos(radians(180/N));
        #local P_Middle_up = RP_R2*cos(radians(180/N));
        #local P_Side   = P_Middle*tan(radians(180/N)); 
        #local P_Side2  = P_Middle_up*tan(radians(180/N)); 
        #local P_Angle  = degrees(atan2( RP_H, (P_Middle-P_Middle_up)));
        #local RR_sin = RR*sin(radians(P_Angle)); 
        #local RR_cos = RR*cos(radians(P_Angle));
      union{
        #if (RP_R2 = RA )  sphere{< 0, RP_H, 0>,RR }   #end 
        #local Nr = 0; 
        #while (Nr< N) 
                union{ sphere{< RP_R -RA,    0, 0>,RR}                        // lower
                cylinder {< RP_R-RA, 0, 0>,< RP_R2-RA, RP_H, 0>,RR }    // sides low to up
                cylinder {< RP_R-RA, 0, 0>, vaxis_rotate(< RP_R-RA,  0, 0>,<0,1,0>,360/N),RR } // lower sides ring
                rotate<0,Nr*360/N,0>}

                #if (RP_R2 != RA )
                        union{ sphere{< RP_R2-RA, RP_H, 0>,RR}                        // upper
                        cylinder {< RP_R2-RA, 0, 0>,vaxis_rotate(< RP_R2-RA, 0, 0>,<0,1,0>,360/N),RR translate<0,RP_H,0>} // upper sides ring
                        rotate<0,Nr*360/N,0>}                       
                #end 
                #local Nr = Nr + 1;
        #end  
        union{ 
        #local Nr = 0; 
        #while (Nr< N) 
                intersection{    
                        prism { -RR ,RP_H+RR , 4 // prism y
                              < RR_sin, 0>,< P_Middle+RR_sin, P_Side>,< P_Middle+RR_sin,-P_Side>,< RR_sin, 0>
                        rotate<0,360/N/2,0>                                }
                        
                        prism{   -RP_R-D , RP_R+D, 7 // prism z 
                                < 0,-RR>,< P_Middle-RR,-RR>,
                                < P_Middle   -RR+RR_sin, RR_cos>,
                                < P_Middle_up-RR+RR_sin, RR_cos+RP_H>,
                                < RR_sin               , RP_H+RR_cos>,
                                < 0, RP_H>,< 0,-RR>
                                rotate<-90,0,0> scale<1,1,-1> rotate<0,360/N/2,0>}
                                
                        rotate<0,Nr*360/N,0>
                }
                #local Nr = Nr + 1;
        #end  
        intersection{
                #local Nr = 0; 
                #while (Nr< N) 
                        box{<-1.5*RP_R,-RR-D/100*Nr,-RP_R>,<P_Middle-RR,0, RP_R> 
                        rotate<0,(Nr+0.5)*360/N,0>}
                        #local Nr = Nr + 1;
                #end  
        }
        intersection{ 
                #local Nr = 0; 
                #while (Nr< N) 
                        box{<-1.5*RP_R,RP_H-RR,-RP_R>,<P_Middle_up-RR,RP_H+RR-D/100*Nr, RP_R> 
                        rotate<0,(Nr+0.5)*360/N,0>}
                        #local Nr = Nr + 1;
                #end  
                }
           }
        }
     #end
     // --------------- ENDE MACRO
     union {
                        cylinder { <0,0,0>,<0,0.03,0>, 0.01
                                texture {Chrome_Metal}
                                scale <1,1,1> }
                                                                  
                        object{ Schraubenmutter (8, 0.0  , 0.02,  0.02, 0.02 , 1)         
                                texture{ Chrome_Metal finish {phong 0.2 reflection 0.45 brilliance 1000 }}}
        
    }
//-------------------------------------------------------------------------

#declare Figur = 
    #declare FigTex_R =
    texture {pigment {color Red} finish {reflection 0.1 phong 1  phong_size 40}}

    #declare FigTex_B =
    texture {pigment {color Blue} finish {reflection 0.1 phong 1 phong_size 40}}
 
    # declare Hut = 
    difference {
            sphere {<0,0,0>,0.15 scale <1,1,1> translate <-0 ,0 ,0> }
            box {<-0.5, -0.2, -0.5>, <0.5, 0.075, 0.5>}
    }
    
    union {
        
        difference {
          sor{    11 ,
                < 0.00, 0.00>, 
                < 0.25, 0.00>, 
                < 0.25, 0.20>, 
                < 0.18, 0.28>, 
                < 0.18, 0.60>, 
                < 0.30, 0.70>, 
                < 0.30, 1.10>, 
                < 0.10, 1.15>,
		< 0.18, 1.40>,
		< 0.10, 1.50>,
		< 0.00, 1.60>
                //open
                sturm 
		scale <1,1,0.8>
                translate <0,0,0>
              }
	      box {<-0.5, -0.1, -0.5>, <-0.16, 1.2, 0.5>}
	      box {<0.16, -0.1, -0.5>, <0.5, 1.2, 0.5>}
              
              //Abgeschraegt am Fuss
              box {<0.06, -0.1, -0.5>, <0.3, 0.6, 0.5> rotate<0,0,-10 > }
              box {<-0.06 , -0.1, -0.5>, <-0.3, 0.6, 0.5> rotate<0,0,10 > }
       }
        

        
       
       object {Hut scale <1.35,1.12,1.12>   translate <-0.01 ,1.357,0>}
       object {Schraube scale 2.5 rotate <0,10,90> translate <-0.145 ,0.9,0>}
       object {Mutter scale 2.5 rotate <0,10,-90> translate <0.145 ,0.9,0>}
       torus {0.07 , 0.007  rotate <0,0,30> translate <-0.08,1.32,0>} // MUND
       sphere {<0,0,0>0.022 translate <-0.152 ,1.37,0.05>} // AUGE
       sphere {<0,0,0>0.022 translate <-0.152 ,1.37,-0.05>} // AUGE
}

 

#declare Ball =
         sphere {<0,0,0>,.21 
                 texture {pigment {color White}}
                          normal { bozo 4 scale 0.0010 }
                          finish { ambient 0.005 diffuse 0.9 phong 1 phong_size 10 reflection 0.1
                         }
                }


// Ball-Balkon
#declare BallBalkon =
        union {
                box {<-2.50, 0.50, 4 >,<2.50, 0.9, 3.9>   scale <1.2, 1, 1.2> }
                box {<-2.55, 0.45, 4 >,<2.55, 0.5, 3.79>  scale <1.2, 1, 1.2> }
                box {<-2.499, 0.5, 4 >,<-2.55, 0.9, 3.79> scale <1.2, 1, 1.2> }
                box {<2.499, 0.5, 4 >,<2.55, 0.9, 3.79>   scale <1.2, 1, 1.2> }

                object {Ball translate <-2.2, 0.71,4.4>}
                object {Ball translate <-1.2, 0.71,4.4>}
                object {Ball translate < 1.2, 0.71,4.4>}
                object {Ball translate < 0.7, 0.71,4.4>}
        }        
	                

#declare Stange =
    #declare Bumper=
        union {
        torus {0.2, .1 texture {pigment {color Black}} scale <1,0.7,1> rotate <0,0,0> finish {reflection 0.2 }}
        } 
    #declare  Griff = 
        sor{    6 ,
                < 0.00, 0.00>, 
                < 0.15, 0.00>, 
                < 0.15, 0.70>, 
                < 0.20, 0.95>, 
                < 0.00, 1.00>, 
                < 0.00, 1.10> 
                 //open
                sturm 
		scale <1,1,1>
                // translate <0,0,0>
                texture {pigment{color Black} 
                         normal {spotted 10.5 scale 0.005}
                         normal { bumps 1.25 scale 0.003 }

                         finish {phong 1 reflection 0.025 phong_size 30}
                         
                }
                scale <1.1,1.1,1.1>
        }
    union {
	cylinder {<0, 0, -7>   <0, 0, 7> ,0.10}
        object {Griff rotate <90,0,90>translate <0,0,6.1>}
        cylinder {<0, 0, -7.1> <0, 0, -6.9> ,0.12  texture {pigment {color Black} finish {reflection 0.15 phong_size 200 phong 1}}}
    }

#declare Stange5r =
    union{
	    object {Stange
    		texture {Chrome_Metal finish {reflection 0.15 phong .4  brilliance 1000 }}
	    	rotate <0,-0,0>
	        translate <0,0.0,0> 
	    }
	    object {Figur
    		texture {FigTex_R}
	    	rotate <0,-0,0>
	        scale 1
	        translate <0,-0.9,0> 
	    }
	    object {Figur
    		texture {FigTex_R}
	    	rotate <0,-0,0>
	        scale 1
	        translate <0,-0.9,-1.5> 
	    }
	    object {Figur
    		texture {FigTex_R}
	    	rotate <0,-0,0>
	        scale 1
	        translate <0,-0.9,-3> 
	    }
	    object {Figur
    		texture {FigTex_R}
	    	rotate <0,-0,0>
	        scale 1
	        translate <0,-0.9,1.5> 
	    }
	    object {Figur
    		texture {FigTex_R}
	    	rotate <0,-0,0>
	        scale 1
	        translate <0,-0.9,3> 
	    }
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0,-3.4> 
	    }
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0, 3.4> 
	    }
       }

#declare Stange5b =
    union{
	    object {Stange
    		texture {Chrome_Metal finish {reflection 0.15 phong .4  brilliance 1000 }}
	    	rotate <0,-180,0>
	        translate <0,0.0,0> 
	    }
	    object {Figur
    		texture {FigTex_B}
	    	rotate <0,-180,0>
	        scale 1
	        translate <0,-0.9,0> 
	    }
	    object {Figur
    		texture {FigTex_B}
	    	rotate <0,-180,0>
	        scale 1
	        translate <0,-0.9,-1.5> 
	    }
	    object {Figur
    		texture {FigTex_B}
	    	rotate <0,-180,0>
	        scale 1
	        translate <0,-0.9,-3> 
	    }
	    object {Figur
    		texture {FigTex_B}
	    	rotate <0,-180,0>
	        scale 1
	        translate <0,-0.9,1.5> 
	    }
	    object {Figur
    		texture {FigTex_B}
	    	rotate <0,-180,0>
	        scale 1
	        translate <0,-0.9,3> 
	    }
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0,-3.4> 
	    }
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0, 3.4> 
	    }
    }

#declare Stange3b =
    union{
	    object {Stange
    		texture {Chrome_Metal finish {reflection 0.15 phong .4  brilliance 1000 }}
	    	rotate <0,-180,0>
	        translate <0,0.0,0> 
	    }
	    object {Figur
    		texture {FigTex_B}
	    	rotate <0,-180,0>
	        scale 1
	        translate <0,-0.9,0> 
	    }
	    object {Figur
    		texture {FigTex_B}
	    	rotate <0,-180,0>
	        scale 1
	        translate <0,-0.9,-2> 
	    }
	    object {Figur
    		texture {FigTex_B}
	    	rotate <0,-180,0>
	        scale 1
	        translate <0,-0.9,2> 
	    }
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0,-2.4> 
	    }
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0, 2.4> 
	    }
    }
#declare Stange3r =
    union{
	    object {Stange
    		texture {Chrome_Metal finish {reflection 0.15 phong .4  brilliance 1000 }}
	    	rotate <0,-0,0>
	        translate <0,0.0,0> 
	    }
	    object {Figur
    		texture {FigTex_R}
	    	rotate <0,-0,0>
	        scale 1
	        translate <0,-0.9,0> 
	    }
	    object {Figur
    		texture {FigTex_R}
	    	rotate <0,-0,0>
	        scale 1
	        translate <0,-0.9,-2> 
	    }
	    object {Figur
    		texture {FigTex_R}
	    	rotate <0,-0,0>
	        scale 1
	        translate <0,-0.9,2> 
	    }
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0,2.4> 
	    }
    
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0,-2.4> 
	    }
    }


#declare Stange2r =
    union{
	    object {Stange
    		texture {Chrome_Metal finish {reflection 0.15 phong .4  brilliance 1000 }}
	    	rotate <0,-0,0>
	        translate <0,0.0,0> 
	    }
	    object {Figur
    		texture {FigTex_R}
	    	rotate <0,-0,0>
	        scale 1
	        translate <0,-0.9,-1.5> 
	    }
	    object {Figur
    		texture {FigTex_R}
	    	rotate <0,-0,0>
	        scale 1
	        translate <0,-0.9,1.5> 
	    }
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0,-1.9> 
	    }
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0, 1.9> 
	    }
    
    }
#declare Stange2b =
    union{
	    object {Stange
    		texture {Chrome_Metal finish {reflection 0.15 phong .4  brilliance 1000 }}
	    	rotate <0,-180,0>
	        translate <0,0.0,0> 
	    }
	    object {Figur
    		texture {FigTex_B}
	    	rotate <0,-180,0>
	        scale 1
	        translate <0,-0.9,-1.5> 
	    }
	    object {Figur
    		texture {FigTex_B}
	    	rotate <0,-180,0>
	        scale 1
	        translate <0,-0.9,1.5> 
	    }
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0,-1.9> 
	    }
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0, 1.9> 
	    }
        }

#declare Stange1r =
    union{
	    object {Stange
    		texture {Chrome_Metal finish {reflection 0.15 phong .4  brilliance 1000 }}
	    	rotate <0,-0,0>
	        translate <0,0.0,0> 
	    }
	    object {Figur
    		texture {FigTex_R}
	    	rotate <0,-0,0>
	        scale 1
	        translate <0,-0.9,0> 
	    }
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0,-.4> 
	    }
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0, .4> 
	    }
    }


#declare Stange1b =
    union{
	    object {Stange
    		texture {Chrome_Metal finish {reflection 0.15 phong .4  brilliance 1000 }}
	    	rotate <0,-180,0>
	        translate <0,0.0,0> 
	    }
	    object {Figur
    		texture {FigTex_B}
	    	rotate <0,-180,0>
	        scale 1
	        translate <0,-0.9,0> 
	    }
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0,-.4> 
	    }
            object {Bumper
    		texture {FigTex_R}
	    	rotate <90,-0,90>
	        scale 1
	        translate <0,0, .4> 
	    }
    }

#declare alleStangen =
union {
        object {Stange1r  rotate <0,0,5>   translate <7,0,-0.5>  }
        object {Stange2r  rotate <0,0,-20> translate <5,0,0.2> }
        object {Stange3b  rotate <0,0,10>  translate <3,0,0>  }
        object {Stange5r  rotate <0,0,0>   translate <1,0,0.6>}
        object {Stange5b  rotate <0,0,0>   translate <-1,-0,.2> } 
        object {Stange3r  rotate <0,0,10>  translate <-3,0,-0.8>} 
        object {Stange2b  rotate <0,0,20>  translate <-5,0,-1>} 
        object {Stange1b  rotate <0,0,0>   translate <-7,0,0> } 
}                                            

#declare ZaehlWerk =
	    #declare w1 =
	    difference {box {<-0.075, -0.075, -0.075> <0.075, 0.075, 0.075>} 
			text { ttf "arialbd.ttf", "1" 0.1 0.0 
			       texture {pigment {color White}}
                               finish {reflection .2 phong 0.4}
			       rotate <90,90,0> scale <0.15,0.12,0.13>
			       translate <-0.055,0.085,0.035>}
	    }
	    #declare w2 =
	    #difference {box {<-0.075, -0.075, -0.075> <0.075, 0.075, 0.075>} 
			text { ttf "arialbd.ttf", "2" 0.1 0.0 
			       texture {pigment {color White}}
                               finish {reflection .2 phong 0.4}
			       rotate <90,90,0> scale <0.15,0.12,0.13>
			       translate <-0.055,0.085,0.035>}
	    }
	    #declare w3 =
	    #difference {box {<-0.075, -0.075, -0.075> <0.075, 0.075, 0.075>} 
			text { ttf "arialbd.ttf", "3" 0.1 0.0 
			       texture {pigment {color White}}
                               finish {reflection .2 phong 0.4}
			       rotate <90,90,0> scale <0.15,0.12,0.13>
			       translate <-0.055,0.085,0.035>}
	    }	    
	    #declare w4 =
	    #difference {box {<-0.075, -0.075, -0.075> <0.075, 0.075, 0.075>} 
			text { ttf "arialbd.ttf", "4" 0.1 0.0 
			       texture {pigment {color White}}
                               finish {reflection .2 phong 0.4}
			       rotate <90,90,0> scale <0.15,0.12,0.13>
			       translate <-0.055,0.085,0.035>}
	    }	    
	    #declare w5 =
	    #difference {box {<-0.075, -0.075, -0.075> <0.075, 0.075, 0.075>} 
			text { ttf "arialbd.ttf", "5" 0.1 0.0 
			       texture {pigment {color White}}
                               finish {reflection .2 phong 0.4}
			       rotate <90,90,0> scale <0.15,0.12,0.13>
			       translate <-0.055,0.085,0.035>}
	    }	    
	    #declare w6 =
	    #difference {box {<-0.075, -0.075, -0.075> <0.075, 0.075, 0.075>} 
			text { ttf "arialbd.ttf", "6" 0.1 0.0 
			       texture {pigment {color White}}
                               finish {reflection .2 phong 0.4}
			       rotate <90,90,0> scale <0.15,0.12,0.13>
			       translate <-0.055,0.085,0.035>}
	    }	    
	    
	    #declare w7 =
	    #difference {box {<-0.075, -0.075, -0.075> <0.075, 0.075, 0.075>} 
			text { ttf "arialbd.ttf", "7" 0.1 0.0 
			       texture {pigment {color White}}
                               finish {reflection .2 phong 0.4}
			       rotate <90,90,0> scale <0.15,0.12,0.13>
			       translate <-0.055,0.085,0.035>}
	    }
	    #declare w8 =
	    #difference {box {<-0.075, -0.075, -0.075> <0.075, 0.075, 0.075>} 
			text { ttf "arialbd.ttf", "8" 0.1 0.0 
			       texture {pigment {color White}}
                               finish {reflection .2 phong 0.4}
			       rotate <90,90,0> scale <0.15,0.12,0.13>
			       translate <-0.055,0.085,0.035>}
	    }	    
	    #declare w9 =
	    #difference {box {<-0.075, -0.075, -0.075> <0.075, 0.075, 0.075>} 
			text { ttf "arialbd.ttf", "9" 0.1 0.0 
			       texture {pigment {color White}}
                               finish {reflection .2 phong 0.4}
			       rotate <90,90,0> scale <0.15,0.12,0.13>
			       translate <-0.055,0.085,0.035>}
	    }	    
	    #declare w10 =
    	    difference {box {<-0.075, -0.075, -0.075> <0.075, 0.075, 0.075>} 
			text { ttf "arialbd.ttf", "10" 0.1 0.0 
			       texture {pigment {color White}}
                               finish {reflection .2 phong 0.4}
			       rotate <90,90,0> scale <0.15,0.12,0.13>
			       translate <-0.055,0.085,0.07>
			    }
	    }
	union {
		cylinder {<0,0,-1>,<0,0,1.2>,0.02 texture {Chrome_Metal}}	    
		object {w1  translate <0,0,  0.54>}
		object {w2  translate <0,0,  0.38>}
		object {w3  translate <0,0,  0.22>}
		object {w4  translate <0,0,  0.06>}
		object {w5  translate <0,0, -0.10>}
		object {w6  translate <0,0, -0.26>}
		object {w7  translate <0,0, -0.42>}
		object {w8  translate <0,0, -0.58>}
		object {w9  translate <0,0, -0.74>}
		object {w10  translate<0,0, -0.9>}
	}


#declare Plaettchen =
       union {
                difference {
                                cylinder { <0,-0.2,0>,<0,0.01,0>, 0.22 
                                        texture { pigment { color Black} finish {phong 0.5 reflection 0.05}}
                                        scale <1,1,1> 
                                        rotate<0,0,0>}
                                cylinder { <0,-0.01,0>,<0,0.02,0>, 0.101
                                        texture { pigment { color Black} finish {phong 0.5 reflection 0.05}}
                                        scale <1,1,1> 
                                        rotate<0,0,0>}
                }
                object {Schraube rotate <0,-20,0>  translate <0.1,0.0051,0.12> }
                object {Schraube rotate <0, 70,0>  translate <0.1,0.0051,-0.12>}
                object {Schraube rotate <0, 97,0>  translate <-0.15,0.0051,-0> }
        }

#declare Tor_Verkleidung =
         #declare Tor_Rundung =
                        difference {
                                torus {0.1, 0.05 rotate <0,0,90>}
                                box {<-0.3 ,-0.001, -0.3><0.3,0.3,0.3>}
                                box {<-0.3 ,0.001, -0.001><0.3,-0.3,-0.3>}
                        }
         union {
                cylinder {<0, 1.25, -1.101>,<0 , 1.25,  1.101>,0.05}
                cylinder {<0, 0, 1.2>,<0 , 1.16,  1.2>,0.05}
                cylinder {<0, 0, -1.2>,<0 , 1.16,  -1.2>,0.05}
                object {Tor_Rundung  rotate <180,0,0> translate <0,1.15,-1.1>} 
                object {Tor_Rundung  rotate <-90,0,0> translate <0,1.15,1.1> } 
         }

#declare Einwurf =
      union {
            difference  {
                box{<-0.03,-0.5,-0.2><0.03,0.5,0.2>}
                box{<-0.15,-0.08,-0.01> <0.15,0.08,0.01> translate <0,0.25,0>}
                box{<-0.15,-0.08,-0.01> <0.15,0.08,0.01> translate <0,-0.2,0>}
             }
                torus {0.08, 0.01 scale <2,1.3,0.4> translate <0,-0.3,0>}
                cylinder {<0,0,0.01><0,0,0.1>,0.025 rotate <0,-90,0> translate <0,0.04,0>}
                cylinder {<0,0,0.01><0,0,0.03>,0.03 rotate <0,-90,0> translate <-0.1,0.04,0>}
                object {Schraube scale 1.3 rotate <0,10,90>  translate <-0.03, 0.45, 0.15>}
                object {Schraube scale 1.3 rotate <0,40,90>  translate <-0.03, 0.45, -0.15>}
                object {Schraube scale 1.3 rotate <0,20,90>  translate <-0.03,-0.45, 0.15>}
                object {Schraube scale 1.3 rotate <0,80,90>  translate <-0.03,-0.45,-0.15>}
      }
      
      
      
#declare Spielfeld=
   union {   
          difference {
                
                //Kasten
                box {<-7.50, 0.00, -3.8>,<7.50, 3.6, 3.8>
                     texture {pigment {color NavyBlue*0.4} finish { phong 1 reflection 0.005 phong_size 10}}                        
                     scale <1.2, 1, 1.2> }
                box {<-6.50, 2.0, -3.60>,<6.50 ,3.7, 3.60>
                     texture {pigment {color OldGold } normal { spotted 1 scale 1.015 } finish {reflection 0.005 phong 1 phong_size 220}}                         
                                //pigment {color rgb<0.9,0.75,0.15>}}
                     scale <1.2, 1, 1.2>}
                // Tore
                box {<6.40, 2.01, -1>,<7.2 ,3.2 ,  1>
                     texture {pigment {color Gray * 0.5}}                        
                     scale <1.2, 1, 1.2>}
                box {<-6.40, 2.01, -1>,<-7.2 ,3.2 ,  1>
                     texture {pigment {color Gray * 0.5}}                        
                     scale <1.2, 1, 1.2>}
	
		// Mulden fuers Zaehlwerk
                box {<-7.20, 3.3, -1.2>,<-7.55 ,3.7 ,  1.2>
                     texture {pigment {color Black}}                        
                     scale <1.2, 1, 1.2>}

                box {<7.20, 3.3, -1.2>,<7.55 ,3.7 ,  1.2>
                     texture {pigment {color Black}}                        
                     scale <1.2, 1, 1.2>}
    		
    		// Einwurf
                cylinder {<0, 3, 3.5>   <0, 3, 4> ,0.25 texture {pigment {color Black}} scale <1.2, 1, 1.2>}
         
                // Oeffnung Ball-Entnahme
	        box {<-2.50, 0.50, -1>,<2.50, 1.2, 3.9>  texture {pigment {color Grey*0.2}}  scale <1.2, 1, 1.2>}                
        } 
          	 
                // Ball-Entnahme
	        object {BallBalkon texture {pigment {color NavyBlue * 0.4} finish { phong 1 reflection 0.005 phong_size 10}}}

	        // Zaehlwerk	
		object {ZaehlWerk  texture {pigment {color Blue}} finish {reflection .25 phong .6  phong_size 140} scale <1.4,1.4,1.4> rotate <0,180,0>translate <-8.85, 3.5, 0.05>}
	        object {ZaehlWerk  texture {pigment {color Red}}  finish {reflection .25 phong .6  phong_size 140} scale <1.4,1.4,1.4> rotate <0,0,0>translate <8.85, 3.5, -0.05> }
    
    	        // LINIEN
                object {Linien scale <1.2 ,1,1.2> finish {diffuse 1 phong 1 phong_size 120} normal { spotted 1 scale 1.15 }  translate <1.2 ,2.0001, -0>}                              

                // TOR_VERKLEIDUNG	       
                object {Tor_Verkleidung translate <7.8 ,2.0001, -0> texture {pigment {color White}}}                              
                object {Tor_Verkleidung translate <-7.8 ,2.0001, -0> texture {pigment {color White}}}                              

                // LOGO
                object {Logo translate <-9.001 ,1,1>  finish { diffuse 1.5 phong 1 reflection 0.005 phong_size 10}}
                object {Logo rotate <0,180,0> translate <9.001 ,1,-1>  finish { diffuse 1.5 phong 1 reflection 0.005 phong_size 10}}
                
                // Einwurf
                object {Einwurf rotate <0,90,0> texture {Chrome_Metal finish {reflection 0.15 phong .4  brilliance 1000 }} scale 1.5 translate <-4.5,1.5,4.55>}
                
                
                
	        // PLAETTCHEN mit 3 Schrauben INNEN
	     #if (showPlaettchen)  
	       object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate<-7.00, 3.0, 4.3>}
               object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate<-5.00, 3.0, 4.3>}
               object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate<-3.00, 3.0, 4.3>}
               object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate<-1.00, 3.0, 4.3>}
               object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate< 1.00, 3.0, 4.3>}
               object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate< 3.00, 3.0, 4.3>}
               object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate< 5.00, 3.0, 4.3>}
               object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate< 7.00, 3.0, 4.3>}
               
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate<-7.00, 3.0, -4.3>}
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate<-5.00, 3.0, -4.3>}
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate<-3.00, 3.0, -4.3>}
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate<-1.00, 3.0, -4.3>}
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate< 1.00, 3.0, -4.3>}
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate< 3.00, 3.0, -4.3>}
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate< 5.00, 3.0, -4.3>}
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate< 7.00, 3.0, -4.3>}
               //AUSSEN
               object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate< -7.00, 3.0, -4.555>}
               object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate< -5.00, 3.0, -4.555>}
               object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate< -3.00, 3.0, -4.555>}
               object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate< -1.00, 3.0, -4.555>}
               object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate<  1.00, 3.0, -4.555>}
               object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate<  3.00, 3.0, -4.555>}
               object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate<  5.00, 3.0, -4.555>}
               object {Plaettchen scale <1,1,1> rotate <-90,-0 ,0> translate<  7.00, 3.0, -4.555>}
               
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate< -7.00, 3.0, 4.555>}
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate< -5.00, 3.0, 4.555>}
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate< -3.00, 3.0, 4.555>}
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate< -1.00, 3.0, 4.555>}
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate<  1.00, 3.0, 4.555>}
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate<  3.00, 3.0, 4.555>}
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate<  5.00, 3.0, 4.555>}
               object {Plaettchen scale <1,1,1> rotate <90,-0 ,0> translate<  7.00, 3.0, 4.555>}
    	     #end
       }

#declare Beine =
        union { 
                 box {<-0.35, -5.50, -0.35>,<0.30, 0.01, 0.35>   translate <-8,0,-3.8>}
                 box {<-0.35, -5.50, -0.35>,<0.30, 0.01, 0.35>   translate <-8,0,3.8> }
                 box {<-0.175, -0.175, -3.7>,<0.175, 0.175, 3.7> translate <-8,-2.5,0>}

                 box {<-0.35, -5.50, -0.35>,<0.30, 0.01, 0.35>   translate <8,0,-3.8> }
                 box {<-0.35, -5.50, -0.35>,<0.30, 0.01, 0.35>   translate <8,0,3.8>  }
                 box {<-0.175, -0.175, -3.7>,<0.175, 0.175, 3.7> translate <8,-2.5,0> }
        }

#declare Tisch1 =
        union {
                object {Spielfeld translate <0,0,0>}
                object {Beine texture {pigment {color Black} finish {phong 1 phong_size 250}}}
                
                                                                      
		#if (showStangen) 
	                object {alleStangen translate <0,3,0>}
		#end
		#if (showBall)
			object {Ball  translate <-3.6,2.2,-.4>}
    		#end
	}

