
//recursive branching 1
// very symmetrical
#macro branching1(ps,an,sc,di,re)
 union {
  cone { <0,0,0>,0.2,<0,1,0>,0.1  rotate z*an }  // left
  cone { <0,0,0>,0.2,<0,1,0>,0.1  rotate z*-an } // right
  scale sc
  translate ps
 }
 #local pl=ps+<sin( an*pi/180),cos(an*pi/180),0>*sc;
 #local pr=ps+<sin(-an*pi/180),cos(an*pi/180),0>*sc;
 #if (re>0)
  #local anl=an; #local anr=an;
  #if (di<0) #local anl=1.3*anl; #end
  #if (di>0) #local anr=1.3*anr; #end
  branching1(pl, anl,sc/2,-1,re-1) // left
  branching1(pr,-anr,sc/2, 1,re-1) // right
 #else                           
  //union {
  //sphere {0,sc/2 translate pl }
  //sphere {0,sc/2 translate pr }
  //} 
 #end // end
#end // macro 

///////////////////////////////////////////////////////////

 #macro clusters(qq,cc,aa,ca,scc)
  // quantity, area,scale
  #local ii=0; 
  #while (ii<qq)
   #local ii=ii+1;
   #local xx=(rand(rr)-0.5)*aa;
   #local yy=(rand(rr)+0.5)*aa;
   #local zz=(rand(rr)-0.5)*aa;
   #local jj=0;
   #while (jj<cc)
    #local jj=jj+1;  
    sphere { 0,1 scale <scc,scc/8,scc>
    //triangle { <-1,0,0>,<0,2,1>,<1,0,0> scale scc 
    #local xa=rand(rr)-0.5;  
    #local ya=rand(rr)-0.5;  
    #local za=rand(rr)-0.5;
    #local ra=ca/sqrt((xa*xa)+(ya*ya)+(za*za));  
    translate <xa*ra+xx,ya*ra*0.8+yy,za*ra+zz> }
    cylinder {<xx,yy,zz>,<xa*ra+xx,ya*ra+yy,za*ra+zz>,0.1*scc } // stalk
   #end //while < cc
  #end // while <qq
 #end // macro

#declare test_cluster=
 union {
  clusters( 1, 500, 0.0, 0.2, 0.025 )
  pigment { rgb <1,1,0>*0.6 }
  finish { ambient 0.3 }
  translate <0.0, 1.0, 5.0>
 } 


///////////////////////////////////////////////////////////

//recursive branching 
#macro branching(tp,pp,sc,th,dd,tl,rr,re,fl)
#local pl=<-rand(rr)-0.5, rand(rr)+tl,rand(rr)-0.5>*sc+pp;
#local pr=< rand(rr)+0.5, rand(rr)+tl,rand(rr)-0.5>*sc+pp;
#local pm=< rand(rr)-0.5, rand(rr)+tl,rand(rr)-0.5>*sc*tp+pp;
#local pd=< rand(rr)-0.5,-rand(rr)/4,rand(rr)-0.5>*sc*tp+pp;
 union {
  cone { pp,th*sc,pl,th*sc*dd }  // left
  cone { pp,th*sc,pr,th*sc*dd } // right
  #if (tp>0) cone { pp,th*sc,pd,th*sc*dd } #end // down
  #if (tp>0) cone { pp,th*sc,pm,th*sc*dd } #end // mid
  //texture { branch_tex }
 }
 #if (re>0)
  branching(tp,pl,sc*dd,th,dd,tl,rr,re-1,fl) // left
  branching(tp, pr,sc*dd,th,dd,tl,rr,re-1,fl) // right
  #if (tp>0) branching(tp,pm,sc*dd*tp,th,dd,tl,rr,re-1,fl) #end
  #if (tp>0) branching(tp,pd,sc*dd*tp,th,dd,tl,rr,re-1,fl) #end
 #else
  #local foli=1;
  #if (foli>0)
   union {                     
   // aligned foliage
   #local vt=<0,sc,0>; // vertical component
   // random cluster foliage
    #local scatter=0;
    #local spread=0.05;
    #local leaf=0.020;
    #local qty=7;
    union { clusters( 1, qty, scatter, spread, leaf ) translate pl }
    union { clusters( 1, qty, scatter, spread, leaf ) translate pr }
    #if (tp>0) union { clusters( 1, qty, scatter, spread, leaf ) translate pm } #end
    #if (tp>0) union { clusters( 1, qty, scatter, spread, leaf ) translate pd } #end
    pigment { rgb <1,1,0>*0.6 }
    finish { ambient 0.3 }
    // csg foliage
    //object { fl scale 1.0 rotate rand(rr)*360*y Point_At_Trans ( pl-pp+vt) translate pl}
    //object { fl scale 1.0 rotate rand(rr)*360*y Point_At_Trans ( pr-pp+vt) translate pr}
    //#if (tp>0) object { fl scale 1.0 rotate rand(rr)*360*y Point_At_Trans ( pm-pp+vt) translate pm} #end 
    // texture based foliage
    //object  { fl Point_At_Trans ( pl-pp+vt ) translate pl } 
    //object { fl Point_At_Trans ( pr-pp+vt ) translate pr }
    //#if (tp>0) object { fl Point_At_Trans ( pm-pp+vt ) translate pm } #end
   } // union foliage
  #end // if
 #end // if
#end // macro 


#declare rr=seed(543); // randomiser     

#declare lt=0.8;       // leaf size
#declare fs=1.2;       // foliage size
#declare tp=1.4;       // dominance of centre (0 for no centre branch)
#declare sc=0.6;       // starting scale
#declare tl=0.5;       // height growth factor
#declare th=0.12;      // branch thickness 0.14
#declare dd=0.45;      // recursive size reduction
#declare re=5;         // number of recursions 1 2 3 4


#declare leaves_tex=
texture {
pigment {
crackle
octaves 1
color_map {
 //[ 0.0 rgbt < 0.2, 0.6, 0.1,1> ]
 //[ 0.1 rgbt < 0.6, 0.9, 0.6,1> ]
 [ 0.0 0.4 color rgbt <0,0,0,1> color rgbt <0,0,0,1> ]
 [ 0.4 1.0 color rgbt <0.6,0.8,0.3,0> color rgbt <0.6,0.8,0.3,0> ] // leaf density
} // end color map
}  // end pigment
scale < 0.07, 0.14, 0.07 >*lt // adjust leaf size
finish { ambient 0.2 }
// normal { bumps 0 scale 0.001 }
} // end texture


#declare branch_tex= 
texture {
 pigment { rgb 0.5 }
 normal{ bumps 0.5 scale 0.01 }
 finish {ambient 0.4}          
} 

// foliage
#declare fl= sphere {
 0,0.1
 texture {leaves_tex} 
 translate 0.1*y scale <1.5,1,1.5>*fs 
}

// minimal foliage
#declare fln= sphere {
 0,0.1
 translate 0.1*y scale <1.5,1,1.5>*0.01 
}


#declare branching_structure=
union {
 // branching1(ps,an,sc,rr,re)=
 //branching1 ( <0,0,0>,30,1,0,4)
 cone { <0,0,0>,1.2*th*sc,<0,tl,0>,th*sc }  // trunk
 branching( tp,  <0,tl,0>, sc, th, dd, tl, rr, re, fln) // fln=null foliage
 texture { branch_tex } 
}
//
#macro make_shapes() // macro version of above
 cone { <0,0,0>,1.1*th*sc,<0,tl,0>,th*sc texture { branch_tex } }  // trunk
 branching( tp,  <0,tl,0>, sc, th, dd, tl, rr,  re, leaf )
 // texture { branch_tex } 
#end


#declare test_plant=
union {
 object { branching_structure }
 finish { ambient 0.3 }
 scale 2.5
 // rotate  10*y
 rotate -25*x
 translate <0,0,5>
}

//object { test_plant }

#declare shapes=object {branching_structure }
#declare minshapes=min_extent(shapes)*<1.1,1.0,1.1>; //with leeway
#declare maxshapes=max_extent(shapes)*<1.1,1.0,1.1>; //with leeway

//#include "collision avoidance.inc"


/////////////////////////////////////////////////////////////////////

#declare curved_brancn1=
sphere_sweep { linear_spline  2
<0.0,0,0>,0.70, <0.0,5,0>,0.45
}

#macro curved_branch (ry)
 #local ry=ry+(rand(rr)*60); // randomise branch angle
 #local ht=(rand(rr)*0.1)+0.9; // randomised length
 #local dy=radians(ry);
 sphere_sweep { linear_spline 6
  <0.0,0,0>,0.70, <0.1,ht,0>,0.65, <0.3,2*ht,0>,0.60,
  <0.6,3*ht,0>,0.55, <1.0,4*ht,0>,0.50, <1.5,5*ht,0>,0.45
  rotate ry*y
 } // sphere_sweep
  //
  #if (re<1)
   // aligned foliage
   #local vt=<0,sc,0>; // vertical component
   // random cluster foliage
   #local scatter=0;
   #local spread=5.05/sc;
   #local leaf=2.020/sc;
   #local qty=10;
   union {  clusters( 1, qty, scatter, spread, leaf ) 
   // sphere {0,2}
   translate <1.5,5*ht,0> rotate ry*y 
   pigment { rgb <1,1,0>*0.6 }
   finish { ambient 0.3 } 
   }
   #end
  //
 #if  (re>0)
  curved_branches ( < cos(dy)*1.5,5*ht,-sin(dy)*1.5>,
  (0.45/0.7),
  < cos(dy)*0.5, ht, -sin(dy)*0.5 >,
  re-1)
 #end // if
#end

#macro curved_branches(ps,sc,pt,re)
union {
 curved_branch (000)  
 curved_branch (180)
 scale sc
 Point_At_Trans (pt) translate ps
 } // union
#end // macro

#declare rr=seed(1234);

#declare curvy_tree=
object {
 curved_branches ( 0, 1, <0,1,0>, 5 ) 
 rotate 05*y
 translate <0,0,40>
}

//object { curvy_tree } 

/////////////////////////////////////////////////////////////////////