#declare paving_slab=
isosurface {
function {
 f_rounded_box (x,y,z, .02, 0.47,0.1,0.47)
  -f_wrinkles  ( x*4, y*4, z*4 )*0.05
 }
 max_gradient 1 
 open
 contained_by  { box { -2,2 } }
 texture { 
  pigment { color rgb <0.58,0.57,0.55>*1.5 }
  normal { granite 0.3 scale 0.05 }
 }
}

#macro lay_out(xq,yq,zq,ob)
 #local xi=0;
 #while (xi<xq)
  #local yi=0;
  #while (yi<yq)
   #local zi=0;
   #while (zi<zq)
    object { ob translate <xi,yi,zi> }
    #local zi=zi+1;
   #end // zz
   #local yi=yi+1;
  #end // yy
  #local xi=xi+1;
 #end // xx
#end // macro

#declare standard_panel=
union {
 difference {
  box { <0,0,-0.05>, <1,1,0.05> }
  //box { <0.05,0.05,-0.1>, <0.95,0.95,0.1> } // single pane
  box { <0.05,0.75,-0.1>, <0.95,0.95,0.1> }   // upper pane
  box { <0.05,0.27,-0.1>, <0.48,0.70,0.1> }   // lower left
  box { <0.52,0.27,-0.1>, <0.95,0.70,0.1> }   // lower right
  pigment {rgb <0.5,0.5,0.5>*2 }  
  finish { reflection 0.2 } 
  }
 //glass
 box { 0,<1,1,0.01> pigment {rgbt <0.2,0.2,0.2,0.7> }  finish { reflection 0.1 } 
 }
}


#declare stone_tex=
   texture {
   pigment { 
   crackle
   octaves 0
   turbulence 0.4 // was 0.2
   color_map {
   [ 0.0 0.1  color rgb <.8,.9,.9> color rgb <.8,.8,.8>] // mortar
   [ 0.1 1.0 color rgb <.3,.5,.5>  color rgb <.5,.4,.5>] // stones
   } // pigment
   scale 0.5
   } // pigment
   normal { crackle 5 scale .01 }
   finish { ambient 0.2 }
  } // texture

 #declare stone_wall2=
 box { <0.0, 0.0, -0.21>, <24, 2, 0.21>  
  texture {stone_tex}
 } // 

 #declare stone_wall1=
 box { <0.0, 0.0, -0.21>, <51, 2, 0.21>  
  texture {stone_tex}
 } // 


#declare  roof1=
// difference {
// cylinder { <0,0,0>,<24,0,0>,10 }
//box { <-1, -20,-20>,<51,00,20> }
isosurface {
 function { 1-                            
  sqrt((x*x)+(z*z))*0.1 // cylinder
  //-sin ( atan2(x,z)*5)*0.1 // fluting 5 wave
  -sin (y*2*pi*2)*0.005 // rings
  //-sin ( (y*2*pi*2) + (atan2(x,z)*4) ) *0.1 // normal helical
 }
 threshold 0
 contained_by { box{<-20,0,-20>,< 00, 50, 20> }  }
 open
 max_gradient 3
 rotate -90*z
 rotate -90*y
 translate <-10,8,0>
 texture { 
  pigment { color rgb <0.58,0.57,0.55>*1.2 }
  normal { granite 0.3 scale 0.05 }
 }
}

#declare roof2=
// difference {
// cylinder { <0,0,0>,<24,0,0>,10 }
//box { <-1, -20,-20>,<51,00,20> }
isosurface {
 function { 1-                            
  sqrt((x*x)+(z*z))*0.1 // cylinder
  //-sin ( atan2(x,z)*5)*0.1 // fluting 5 wave
  -sin (y*2*pi*2)*0.005 // rings
  //-sin ( (y*2*pi*2) + (atan2(x,z)*4) ) *0.1 // normal helical
 }
 threshold 0
 contained_by { box{<-20,0,-20>,< 00, 24, 20> }  }
 open
 max_gradient 3
 rotate -90*z
 translate <0,8,60>
 texture { 
  pigment { color rgb <0.58,0.57,0.55>*1.2 }
  normal { granite 0.3 scale 0.05 }
 } 
}

#declare roof2a=
union {
prism { conic_sweep linear_spline
 -1,-0.5,5
 <-1,-1>,<-1,1>, <1,1>,<1,-1>,<-1,-1>
 translate 1*y
 scale <12,10,10>
 texture { 
  pigment { color rgb <0.58,0.57,0.55>*1.2 }
  normal { granite 0.3 scale 0.5 }
 } 
}
// roof top glaze
prism { conic_sweep linear_spline
 -0.5,-0.0, 5
 <-1,-1>,<-1,1>, <1,1>,<1,-1>,<-1,-1>
 translate 1*y
 scale <12,10,10>*1.01
 texture { 
  pigment { color rgb <0.58,0.57,0.55>*0.2 transmit 0.8 }
 }
}
scale 1.2 
translate <12,8,61>
}



  

#declare building=
union {
 union { lay_out ( 05,1,50,paving_slab ) translate <0.5,0,0> } // left 
 union { lay_out ( 23,1,5,paving_slab ) translate < 0.5,0,45 > } // far
 union { lay_out ( 23,1,7,paving_slab ) translate < 0.5,0,0 > } // near
 object { stone_wall2 translate <0,0,51> }
 object { stone_wall1 rotate y*-90 translate <-0,0,0> }
 //
 //
 union { lay_out (13,1,1,standard_panel ) rotate y*-90 scale <4,8,4> translate < 0, 0, -2 > } // left

 union { lay_out ( 6,1,1,standard_panel ) scale <4,8,4> translate < 0, 0, 51 > }
 union { lay_out ( 6,1,1,standard_panel ) scale <4,8,4> translate < 0, 0, 71 > } // far side
 union { lay_out (5,1,1,standard_panel ) rotate y*-90 scale <4,8,4> translate < 00, 0, 51 > } // left
 union { lay_out (5,1,1,standard_panel ) rotate y*-90 scale <4,8,4> translate < 24, 0, 51 > } // right
 // floor
 box { <0,0,0>,<24,0.3,20>
  texture { 
   pigment { color rgb <0.58,0.57,0.55>*1.8 }
   normal { granite 0.1 scale 0.05 }
  }
  translate <0,0,51>
 }
 //
 // object { roof1 } // left
  object { roof2a } // ahead
 //
 
 #include "poser figures\woman waiting_pov.inc"
 object{ Woman_waiting scale 4.5 rotate 180*y translate <4.0,0.1,6.0> }
 translate <-8,0,0>
}


///////////////////////////////////////////////////////////////////////


#declare grass_tex=
texture {
 pigment { colour rgb <0.50,0.60,0.30> } 
 normal {
  average 
  normal_map {
   [2  bumps 0.8 scale 0.02 ]
   //[2  bumps 0.5 scale 0.20 ]
  } // normal_map
  scale <1,3,0.1>
 } // normal
 finish { ambient 0.5 }
} // texture


#declare terrain1=
isosurface {
  #declare p0=0.0001; // suppress higher frequencies
  #declare p1=1.5 ; // lacunarity 
  #declare p2=5; // 8; // octaves
  #declare p3=0.0; // base altitude
  #declare p4=0.5;// heterogeneity 0 to 1 
  #declare p5=2; // noise type 0 to 3      
 function { y-                     
  f_hetero_mf (x,0,z,p0,p1,p2,p3,p4,p5)*0.2 
 }
 threshold 0
 contained_by { box{<-100,-10,-100>,< 100, 10, 100> }  }
 open
 max_gradient 4 
 //no_shadow
 scale <30,10,30>
 texture { 
  pigment { color rgb <0.62, 0.56, 0.55> }
  normal { granite 0.3 scale 0.5 }
 }
 //texture { grass_tex }            
 translate <0,0,-10>
}

object { terrain1  }


#declare building1=
union {
 box {<-1,-2,-1>,<1,1,1>}
 prism { conic_sweep linear_spline
  -1,-0.0,5
  <-1,-1>,<-1,1>, <1,1>,<1,-1>,<-1,-1>
  scale <1.1,1,1.1>
  translate 2*y
  pigment { color rgb <0.58,0.56,0.55>*0.7 }
  normal { granite 0.2 scale 0.3 }
 } 
 texture { 
  pigment { color rgb <0.58,0.57,0.55>*1.5 }
  normal { granite 0.3 scale 0.5 }
 }            
 scale 0.4
} // union   


#declare terracing=
box {<-1,-2,-1>,<1,0.2,1> 
 texture { 
  pigment { color rgb <0.58,0.57,0.55>*1.5 }
  normal { granite 0.3 scale 0.5 }
 }            
 scale <0.5,0.2,0.2>
}


#macro plonk(obj,ter,psn)
 #local norm=<0,0,0>;
 #local inter= trace ( ter, <psn.x,20,psn.z>, <0,-10,0>, norm );
 #if (vlength(norm)=!0)
  #if (inter.y>0)
   object { obj translate inter }
  #else
   object { obj translate <psn.x,0,psn.z> }
  #end 
 #else
  object { obj translate psn   }
 #end // if norm
#end


#macro street(xx,yy,zz,qq) 
 #local ii=0;
 #while (ii<qq)           
  plonk(building1,terrain1,<xx+ii,yy,zz>) 
  #local ii=ii+1;
 #end // while
#end // macro
                
#macro terraces(xx,yy,zz,qq) 
 #local ii=0;
 #while (ii<qq)           
  plonk(terracing,terrain1,<xx+ii,yy,zz>) 
  #local ii=ii+0.5;
 #end // while
#end // macro
                
#macro trace_path(ter,psn1,psn2,wid)
 #local norm=<0,0,0>;
 #local inter= trace ( ter, <psn1.x,20,psn1.z>, <0,-40,0>, norm );
 #if (vlength(norm)=!0)
  #if (inter.y>0)
   #local psn1=inter;
   #local inter= trace ( ter, <psn2.x,20,psn2.z>, <0,-40,0>, norm );
   #if (vlength(norm)=!0) #local psn2=inter;  #end 
  #else
   #local psn1=<psn1.x,0,psn1.z>;
   #local inter= trace ( ter, <psn2.x,20,psn2.z>, <0,-40,0>, norm );
   #if (vlength(norm)=!0) #local psn2=inter;  #end 
  #end 
 #end // if norm
 <psn1.x,psn1.y*20,psn1.z>,wid
 // cylinder {psn1,psn2,0.2}
 //box {<0.0,-0.05,-wid>,
  // <sqrt(pow(psn2.z-psn1.z,2)+pow(psn2.y-psn1.y,2)),0.15,wid> 
  //rotate  z*degrees(atan2(psn2.y-psn1.y,psn2.x-psn1.x))/2
  //rotate -y*degrees(atan2(psn2.z-psn1.z,psn2.x-psn1.x))
  //rotate -x*degrees(atan2(psn2.y-psn1.y,psn2.z-psn1.z))/2
  //translate psn1 
#end

#macro contouring(ter,obj,min_height,max_height,qq,rd)
#local ii=0;
#while (ii<qq)
 #local psn1=<(rand(rr)-0.5)*20,100,(rand(rr))*20>;
 #local norm=<0,0,0>;
 #local inter= trace ( ter, psn1, <0,-101,0>, norm );
 #if (vlength(norm)=!0)
  #if (inter.y>0)
   #local psn1=inter;
  #else
   #local psn1=<psn1.x,0,psn1.z>;
  #end 
 #end // if norm
 #if (psn1.y>=min_height)
  #if (psn1.y<=max_height)
   object {obj translate psn1 }
  #end     
 #end
  #local ii=ii+1;
 #end // while
#end // macro
#declare veg=sphere { 0,0.20 scale <0.5,1,0.5> translate 0.25*y }
//contouring(terrain1,veg,0.1,0.3,100,seed(12))


#macro route (qq)
sphere_sweep { linear_spline qq*2+1
 #local ii=0;
 #while (ii<qq)           
  //trace_path(terrain1,<ii*0.5-5,0,ii>,<(ii+0.5)*0.5-5,0,ii+0.5>,0.5),
  trace_path(terrain1,<ii*0.9-10,0,ii>,<(ii+0.5)*0.9-10,0,ii+0.5>,0.5),
  //trace_path(terrain1,<ii*0.9-10,0,20>,<(ii+0.5)*0.9-10,0,20>,0.5),
  #local ii=ii+0.5;
 #end // while
 trace_path(terrain1,<ii*0.9-10,0,ii>,<(ii+0.5)*0.9-10,0,ii+0.5>,0.5)
 scale 0.05*y
  pigment { color rgb <0.55,0.56,0.58>*0.5 }
  normal { granite 0.3 scale 0.5 }
 }
#end // macro                
//route(100)

//////////////////////////////////////////////////////////////////////


#macro multistorey(ter,obj,psn1,ht,qq,rd)
#local ii=0;
#while (ii<qq)
 //#local psn1=<(rand(rr)-0.5)*20,100,(rand(rr))*20>;
 //#local psn1=<0,10,10>;
 #local norm=<0,0,0>;
 #local inter= trace ( ter, psn1, <0,-101,0>, norm );
 #if (vlength(norm)=!0)
  #if (inter.y>0)
   #local psn1=inter;
  #else
   #local psn1=<psn1.x,0,psn1.z>;
  #end 
 #end // if norm
 object {obj translate <psn1.x,psn1.y+(ht*ii),psn1.z> }
  #local ii=ii+1;
 #end // while
#end // macro
#declare floor1=
union {     
 #local ii=0;
 #while (ii<20)
  box { 0,0.1 scale <0.3,1,0.1> translate <ii*0.1, 0.1, 0.0> }
  #local ii=ii+1;
 #end
 //
 box { 0,1 scale <2,0.1,1> translate 0 }
 box { 0,1 scale <1.96,0.1,0.99> translate <0.02,0.1,0.02>  pigment {rgbt <0,0,0,0.75>} }
}
//multistorey(terrain1,floor1,<0,0,10>,0.2,20,seed(12))
//multistorey(terrain1,floor1,<-3,0,15>,0.2,20,seed(12))


#declare streets=
union {                
terraces(-4,1, 3, 8)
street(-4,1, 4, 8)
street(-5,1, 6,10)
//street(-5,1, 8,10)
//street(-5,1,10,10)
//street(-5,1,12,10)
}
//#declare block=
//union { 
// object { street rotate   0*y }
// object { street rotate -90*y }
// object { street rotate 180*y translate <7,0,7>}
// object { street rotate  90*y translate <7,0,7>}
//}
//object { block translate <0,0,10> }


////////////////////////////////////////////////////////////////////////

#declare door=
union {
difference {
box { <0.0,0.0>, <0.90,2.1,0.03> }
// front
box { <0.0,0.0,-0.013>, <0.17,0.70,0.013> translate <0.10,0.2,0 > }
box { <0.0,0.0,-0.013>, <0.17,0.70,0.013> translate <0.37,0.2,0 > }
box { <0.0,0.0,-0.013>, <0.17,0.70,0.013> translate <0.64,0.2,0 > }
box { <0.0,0.0,-0.013>, <0.17,0.70,0.013> translate <0.10,1.2,0 > }
box { <0.0,0.0,-0.013>, <0.17,0.70,0.013> translate <0.37,1.2,0 > }
box { <0.0,0.0,-0.013>, <0.17,0.70,0.013> translate <0.64,1.2,0 > }
// back
box { <0.0,0.0,-0.013>, <0.17,0.70,0.013> translate <0.10,0.2,0.03 > }
box { <0.0,0.0,-0.013>, <0.17,0.70,0.013> translate <0.37,0.2,0.03 > }
box { <0.0,0.0,-0.013>, <0.17,0.70,0.013> translate <0.64,0.2,0.03 > }
box { <0.0,0.0,-0.013>, <0.17,0.70,0.013> translate <0.10,1.2,0.03 > }
box { <0.0,0.0,-0.013>, <0.17,0.70,0.013> translate <0.37,1.2,0.03 > }
box { <0.0,0.0,-0.013>, <0.17,0.70,0.013> translate <0.64,1.2,0.03 > }
}
cylinder {<0,0,0>,<0,0.12,0>,0.01 translate <0.00,0.30,0> } // hinge lower                                                               
cylinder {<0,0,0>,<0,0.12,0>,0.01 translate <0.00,1.00,0> } // hinge middle                                                               
cylinder {<0,0,0>,<0,0.12,0>,0.01 translate <0.00,1.70,0> } // hinge upper                                                               
sphere { 0,0.05 translate <0.8,1.05,-0.05> } // knob front
sphere { 0,0.05 translate <0.8,1.05, 0.08> } // knob back
scale 3
rotate 40*y // open
}

//views (door)

//////////////////////////////////////////////////////////////////////// 

#declare french_window=
union {
difference {
 box { <0.0,0.0>, <0.90,2.1,0.030> }
 // opening
 box { <0.02,0.01,-0.04>, <0.68,0.79,0.04> translate <0.10,0.1,0 > } // lower
 box { <0.02,0.01,-0.04>, <0.68,0.79,0.04> translate <0.10,1.2,0.0 > } // upper
 // rebates
 box { <0.0,0.0,-0.010>, <0.70,0.80,0.010> translate <0.10,0.1,0 > } // lower
 box { <0.0,0.0,-0.010>, <0.70,0.80,0.010> translate <0.10,1.2,0 > } // upper
 box { <0.0,0.0,-0.010>, <0.70,0.80,0.010> translate <0.10,0.1,0.03 > } // lower
 box { <0.0,0.0,-0.010>, <0.70,0.80,0.010> translate <0.10,1.2,0.03 > } // upper
}
cylinder {<0,0,0>,<0,0.12,0>,0.01 translate <0.00,0.30,0> } // hinge lower                                                               
cylinder {<0,0,0>,<0,0.12,0>,0.01 translate <0.00,1.00,0> } // hinge middle                                                               
cylinder {<0,0,0>,<0,0.12,0>,0.01 translate <0.00,1.70,0> } // hinge upper                                                               
sphere { 0,0.05 translate <0.8,1.05,-0.05> } // knob front
sphere { 0,0.05 translate <0.8,1.05, 0.08> } // knob back
// glazing
union {
 box { <0.0,0.0,0.014>, <0.70,0.80,0.016> translate <0.10,0.1,0 > } // lower
 box { <0.0,0.0,0.014>, <0.70,0.80,0.016> translate <0.10,1.2,0 > } // upper
 pigment {rgbt <0,0,0,0.85>}
}
scale 3
//rotate 180*y // open positive
}

views (french_window)

////////////////////////////////////////////////////////////////////////

