// main.pov
// Copyright Charles E V Pegge 2004
// cevp@evemail.net
// www.cevp.freewire.co.uk

// resolution

 #declare quality=1; // 0 or 1 for soft focus
 //#if (image_width>=1024) #declare quality=1; #end

// light 

 #declare amb=0.15;
 #declare dif=0.80;
 #declare radi=0; // 0 1 or 2

// sunlight and atmospheric conditions

 #declare sunshine=1.1; // 1 to 2
 #declare sunset=0; // 0 1 2
 #declare dawn=0; // 0 or 1  
 #declare night=0; // 0 or 1
 #declare infinite_sky=1; // 0 or 1
 #declare sky_gradation=0.10; // 0 to 1 typ 0.1 0.2
 #declare cloud_area=0.50; // 0 to 1 typ 0.5
 #declare layer_spread=50; // 200
 #declare cloud_light=finish { ambient amb }
 #declare rain_cloud=0; // 0 or 1
 #declare fog_transparency=1;//0.85; // 0.65; //0.80; // ,77
 #declare fog_distance=70; // 70

// water

 #declare waters=1; //#declare sea_floor=1; // 0 or 1
  #declare millpond=0; // 0 or 1
  #declare choppy_waves=0; // 0 or 1
  #declare waves3d=0; // 0 or 1
  #declare water_clarity=0.3; // 0.8 typ

// dry land

 #declare flat_land=1; // 0 or 1
  #declare fine_grassland=0; // 0 or 1
  #declare sandy_ground=1; // 0 or 1
 #declare beach=0; // 0 or 1
 #declare middle_hills=1; // 0 or 1
 #declare middle_land=0; // 0 or 1
  #declare far_vegetation=0; // 0 or 1
 #declare undulating_ground=0; // 0 or 1 for pebbles & small plants
 #declare dunes=0; // 0 or 1 
 #declare pebbles=0; // 0 or 1
 #declare forground_rocks=0; //0 or 1  beachy rocks
 #declare scattered_rocks=0; //0 or 1  Carn Ingli type rocksy
 
// buildings
   
 #declare ht=3.1; // 0 to 4
 #declare ds=40;
 #declare gscale=6; // dome size 2.5 to 20

 #declare geodesics=0; // 0 or 1
  #declare geodesic_shell=0; // 0 or 1
  #declare geodesic_core=0; // 0 or 1
 #declare stone_tower=0; // 0 or 1 or 2
 #declare boulders=0; // 0 or 1
  
// humans and animals
 
 #declare cone_men=0; // 0 or 1 
 #declare figures=1; // 0 or 1
  #declare horses=0; // 0 or 1
 #declare RBFuller=1; // 0 or 1
 
// plants
 
 #declare slender_trees=0; // 0 or 1
 #declare wide_trees=0; // 0 or 1
 #declare tomtrees=0; // 0 or 1
 #declare cacti=0; // 0 or 1
 #declare small_plants=0; // 0 or 1 // needs undulating_ground
  #declare small_spiky_plants=1; // 0 or 1
  #declare small_cacti=0; // 0 or 1
  #declare small_scattered_flowers=0; // 0 or 1
 #declare grasses=1; // 0 or 1 
 #declare heath=0; // 0 or 1 
 #declare garden_trees=0; // 0 or 1
 #declare maketrees=1; // 0 or 1
 #declare plants_in_forground=1; // 0 or 1 

// mobile objects
 
 #declare boats=1;
 #declare vehicles=0; // 0 or 1 
  #declare dymaxion_cars=0; // 0 or 1 


////////////////////////////////////////////////////////////////////////

#include "light.inc"
#include "camera.inc"
#include "stdinc.inc"

#include "toys and games.inc"
#include "terrain.inc"
#declare landscape=1;

//////////////////////////////////////////////////////////////////////// 


#ifdef (landscape)

#include "vegetation.inc"
#if (waters>0) #include "waters.inc" #end
#if (cloud_area>0) #include "clouds.inc" #end 
 
// for murky conditions
#if (fog_transparency<1)
fog {
 fog_type 2
 fog_offset 0
 fog_alt 20
 turbulence 0.9
 turb_depth 0.1
 color rgbt<0.8, 0.8, 0.8, fog_transparency >
 distance fog_distance
}
#end

#if (figures=1)
 #include "poser figures\man waiting_pov.inc"
 //#include "poser figures\woman waiting_pov.inc"
 #include "poser figures\boy sitting_pov.inc"
 
 //object{ Woman_waiting scale 20 rotate 180*y translate <0,-8.0,-0.5> }
 //object{ Woman_waiting scale 10 rotate 180*y translate <0,-0.13,-0.5> }
 //object{ Woman_waiting scale 4.5 rotate -20*y translate <4.0,-0.1,3.5> }
 //object{ Woman_waiting scale 4.5 rotate 180*y translate <4.0,-0.01,6.0> }
 
 object{ Man_waiting scale 6 rotate 180*y translate <-13.0,0.1,150> }
 object{ Boy_sitting scale <6.3,7.0,6.3> rotate 180*y translate <6.0, 0.0, 16.0> }
 //object{ Boy_sitting scale <6.3,7.0,6.3> rotate 180*y translate <3.0, 0.0, 5.0> }

 //object{ Man_waiting scale 4.5 rotate 200*y translate <20,-0.0,119> }
 #if (horses>0)
  #include "poser figures\horse standing.inc"
  object{ Horse_standing scale 4.5 rotate 90*y translate <-36.0,-0.01,150> }
  object{ Horse_standing scale 4.5 rotate 150*y translate <3.9, -0.01, 8.5> }
 #end
#include "objects\mammals\cow_pov.inc" 
//object { Cow scale 0.5 rotate 45*y translate <7,02,90> }
object { Cow scale 0.5 rotate 45*y translate <-7,02-0.2,40> }
#end

#if (vehicles>0)
 #if (dymaxion_cars>0) #include "dymaxion car.inc" #end
#end // vehicles


#if (geodesics>0)
 #if (geodesic_shell+geodesic_core>0)
  #include "geodesic buildings.inc"
 #end
#end
#if (boulders=1)
 #include "boulders.inc"
// object { rotunda_wall scale gscale/5 translate <0,-0.3,ds>  }
 object { rotunda_wall scale gscale/5 translate <25,-0.3,99>  }
#end


#if (cone_men=1) #include "cone men.inc" #end
#if (boats>0) #include "boats.inc" #end
#if (stone_tower>0) #include "stone tower.inc" #end  
// #include "profiled panels"



#end // if minimal_landscape

//////////////////////////////////////////////////////////////////////

#if (flat_land>0)

#declare undulations=
isosurface {
 function { y
 //-(f_wrinkles(x*0.2,0,z*0.2)*1)
 -(f_wrinkles(x*0.5,0,z*0.5)*1)
 //-(f_wrinkles(x*1.0,0,z*1.0)*1)
 }
 open
 // max_gradient 1
 contained_by { sphere {0,6000}}
}

 #if (beach>0)
 union {
  object { undulations scale <1,1,1> translate -.7*y rotate 0.5*z
   pigment { colour rgb <.10,.45,.0> }
   finish { ambient 0.0 phong 0.5 }
   }
   cylinder { <0,-0.1,0>,<0,-0.2,0>,6000 }
 #else
   cylinder { <0,-0.1,0>,<0, 0.0,0>,6000 
 #end
  
   texture {
    #if (fine_grassland>0)
     pigment { colour rgb <0.50,0.60,0.30> } 
    #end
    #if (sandy_ground>0)
     pigment { colour rgb < 0.60, 0.55, 0.50 > }
    #end
    normal {
     average 
      normal_map {
      [1  bumps 0.1 scale 0.02 ]
      //[1  bumps 0.5 scale 0.05 ]
      //[1  bumps 0.5 scale 0.10 ]
      //[1  bumps 0.5 scale 0.20 ]
       } // normal_map
       #if (fine_grassland>0) 
        scale <1,3,0.1>
       #else 
        scale <1,2,0.1>
       #end        
     } // normal
   } // texture
   finish { ambient amb }
} // object


#end // flat_land



