
// meccano type components

#declare slot_hole=
union {
 cylinder {<0,-0.1, 0.1>,<0,0.2, 0.1>, 0.20}
 cylinder {<0,-0.1,-0.1>,<0,0.2,-0.1>, 0.20}
 box {<-0.2,-0.1,-0.2>,< 0.2, 0.2, 0.2>}
 }


#declare strip_form=
union {
 box { <0,0,-0.5>,<10,0.1,0.5>}
 cylinder { <0,0,0>,<0,0.1,0>,0.5 }
 cylinder { <0,0,0>,<0,0.1,0>,0.5 translate 10*x}
}

#declare strip_form1=
union {
 box { <-0.5,0,-0.5>,<10.5,0.1,0.0>}
 box { <0,0, 0.0>,<10,0.1,0.5>}
 cylinder { < 0,0,0>,< 0,0.1,0>,0.5 }
 cylinder { <10,0,0>,<10,0.1,0>,0.5 }
}

#declare plate_form=
union {
 box { < 0,0,-0.5>,<10,0.1,10.5>}
 box { < -0.5,0,0>,<0,0.1,10>}
 box { < 10,0,0>,<10.5,0.1,10>}
 cylinder { < 0,0, 0>,< 0,0.1, 0>, 0.5}
 cylinder { <10,0, 0>,<10,0.1, 0>, 0.5}
 cylinder { < 0,0,10>,< 0,0.1,10>, 0.5}
 cylinder { <10,0,10>,<10,0.1,10>, 0.5}
}


#macro strip(cc) 
difference {
 union {
  box { <0,0,-0.5>,<cc-1,0.1,0.5>}
  cylinder { <0,0,0>,<0,0.1,0>,0.5 }
  cylinder { <0,0,0>,<0,0.1,0>,0.5 translate (cc-1)*x}
 }
 #declare ii=0; #while (ii<cc)
  cylinder {<ii,-0.1, 0>,<ii,0.2,0>, 0.20}
 #declare ii=ii+1;  #end // while
}
#end


#declare strip1n=
difference {
 object {strip_form1}
 #declare ii=0; #while (ii<11)
  cylinder {<ii,-0.1, 0>,<ii,0.2,0>, 0.20}
 #declare ii=ii+1;  #end // while
}

#declare strip1r=
difference {
 object {strip_form1}
 #declare ii=0; #while (ii<11)
  object { slot_hole translate ii*x } 
 #declare ii=ii+1;  #end // while
 scale -1*z 
}

#declare strip1=
union {
object { strip1n translate 0.5*z  }
object { strip1r translate -0.5*z rotate -90*x }
cylinder {<-0.5,0, 0>,<10.5,0,0>, 0.1}
}

#declare plate1=
difference {
 object {plate_form}
  cylinder {<05,-0.1, 05>,<05,0.2, 05>, 0.20}
  cylinder {< 8,-0.1, 2>,< 8,0.2, 2>, 0.20}
  cylinder {< 2,-0.1, 2>,< 2,0.2, 2>, 0.20}
  cylinder {< 2,-0.1, 8>,< 2,0.2, 8>, 0.20}
  cylinder {< 8,-0.1, 8>,< 8,0.2, 8>, 0.20}
  //
 #declare ii=0; #while (ii<11)
  cylinder {<ii,-0.1, 0>,<ii,0.2, 0>, 0.20}
  cylinder {<ii,-0.1,10>,<ii,0.2,10>, 0.20}
  cylinder {<00,-0.1,ii>,<00,0.2,ii>, 0.20}
  cylinder {<10,-0.1,ii>,<10,0.2,ii>, 0.20}
 #declare ii=ii+1;  #end // while
}

#macro plate(xx,zz,pp)
difference {
 union {
  box { < 0,0,-0.5>,<xx-1,0.1,zz-0.5>}
  box { < -0.5,0,0>,<0,0.1,zz-1>}
  box { < xx-1,0,0>,<xx-0.5,0.1,zz-1>}
  // corners
  cylinder { < 0,0, 0>,< 0,0.1, 0>, 0.5}
  cylinder { <xx-1,0, 0>,<xx-1,0.1, 0>, 0.5}
  cylinder { < 0,0,zz-1>,< 0,0.1,zz-1>, 0.5}
  cylinder { <xx-1,0,zz-1>,<xx-1,0.1,zz-1>, 0.5}
 }
 #if (pp>=1)
  // perimeter holes
  #local ii=0; #while (ii<xx)
   cylinder {<ii,-0.1, 0>,<ii,0.2, 0>, 0.20}
   cylinder {<ii,-0.1,zz-1>,<ii,0.2,zz-1>, 0.20}
  #local ii=ii+1;  #end // while
  #local ii=0; #while (ii<zz)
   cylinder {<00,-0.1,ii>,<00,0.2,ii>, 0.20}
   cylinder {<xx-1,-0.1,ii>,<xx-1,0.2,ii>, 0.20}
  #local ii=ii+1;  #end // while
  cylinder {<(xx-1)/2,-0.1,(zz-1)/2>,<(xx-1)/2,0.2,(zz-1)/2>, 0.20} // centre
 #end
 #if (pp>=2)
  // inner holes
  #local ii=2; #while (ii<xx-2)
   cylinder {<ii,-0.1, 2>,<ii,0.2, 2>, 0.20}
   cylinder {<ii,-0.1,zz-3>,<ii,0.2,zz-3>, 0.20}
  #local ii=ii+1;  #end // while
  #local ii=2; #while (ii<zz-2)
   cylinder {<02,-0.1,ii>,<02,0.2,ii>, 0.20}
   cylinder {<xx-3,-0.1,ii>,<xx-3,0.2,ii>, 0.20}
  #local ii=ii+1;  #end // while
 #end // if
 #if (pp=0)
  // matrix of holes
  #local jj=0; #while (jj<zz)
   #local ii=0; #while (ii<xx)
    cylinder {<ii,-0.1,jj>,<ii,0.2,jj>, 0.20}
   #local ii=ii+1;  #end // while  
  #local jj=jj+1;  #end // while  
 #end
}
#end


#declare bolt=
union {
 difference {
  cylinder { <0,0.1,0><0,0.3,0>,0.3 }
  box {<-0.4,0.2,-0.05>,<0.4,0.4,0.05>} // slot
  //box {<-0.05,0.2,-0.4>,<0.05,0.4,0.4>} // cross slot
 }
 cylinder { <0,-0.4,0><0,0.1,0>,0.18 }
 pigment { rgb <0.7,0.7,0.3> } finish { metallic 0.5 } 
}


#declare nut1=
box { <-0.3,0.0,-0.3><0.3,-0.2,0.3>}
//  cylinder {<ii,-0.3,0>,<ii,0.1,0>,0.19}

#declare parts=
union {
//object { plate1 }
//object { plate(11,5,0) }
object { strip1 }
object { bolt rotate 20*y translate 0.5*z }   
object { nut1 rotate 20*y translate 0.5*z }   
rotate -20*x
rotate 0*y 
rotate 10*z
translate < -5,1,10>
} 



/////////////////////////////////////////////////////////////////////

// wheels & axles

#declare tooth_cut=
prism {
 -0.1,20, 5
 <-1.5,0>,<1.5,0>,<0.5,3>,<-0.5,3>,<-2,0>
 scale 0.1
}

#macro gear(teeth,thick)
difference {
 union {
  cylinder { <0, 0.0,0>,<0,thick,0>,teeth*3/40 }
  cylinder { <0, thick,0>,<0,thick+0.5,0>,0.4 }
 }
 cylinder { <0,-0.1,0><0,0.8,0>,0.2 }
 #declare ii=0; #while (ii<360)
 object { tooth_cut translate -teeth*3/40*z rotate ii*y }        
 #declare ii=ii+(360/teeth); #end //while  
 pigment { rgb <0.7,0.7,0.3>*0.4 } finish { metallic reflection rgb <1,1,0>*0.5 } 
}
#end // macro

#macro wheelm(rad,thick)
difference {
 union {
  cylinder { <0, 0,0>,<0,0.5,0>,0.4 } // collar first
  cylinder { <0, 0.5,0>,<0,thick+0.5,0>,rad }
 } // union
 cylinder { <0,-0.1,0><0,0.8,0>,0.2 }
 // radial holes? 
 } // difference
 //pigment { rgb <0.7,0.7,0.3>*0.4 } finish { metallic reflection rgb <1,1,0>*0.5 } 
#end // macro

#declare handle1=
union {
 sphere { 0.0,0.025 scale 4*y translate <0.15,0.5,0> pigment {rgb <1,0,0>} }
 sphere_sweep { linear_spline 4,
  <0.0,-0.01, 0>, 0.019,
  <0.0, 0.3, 0>, 0.019, 
  <0.15, 0.4, 0>, 0.019, 
  <0.15, 0.5, 0>, 0.019 
 tolerance 1.0e-4
 }
 scale 1
 pigment { rgb <0.6,0.6,0.6> } finish { phong 0.5 metallic }
}

#declare handle=
 union {
 difference {
  wheelm(2,0.2)
 cylinder {<1.7,0.7,0>,<1.7,2,0>,0.19}
 // circumf holes
 #local ii=0; #while (ii<360)  
 cylinder {<1.7,0.4,0>,<1.0,2,0>,0.19 rotate ii*y }
 #local ii=ii+45; #end  
 }
 cylinder {<0,-1,0>,<0,0.9,0>, 0.19 pigment { rgb <0.2,0.5,0.5> } finish {metallic 0.5} }
 union { //handle
  cylinder {<1.7,0.7,0>,<1.7,2,0>,0.3} // 
  sphere { <1.7,2,0>,0.3} // tip
  pigment { rgb <0.0,0.6,0> } finish { phong 0.5 metallic }
 }
 scale 0.1
 pigment { rgb <0.7,0.7,0.3>*0.4 } finish { metallic reflection rgb <1,1,0>*0.4 } 
}


//views (object{gear(30)})
//views (handle)

/////////////////////////////////////////////////////////////////////

declare spring=
isosurface {
 function {
  f_helix1 (
    x,y,z,
    1,  // number of helixes
    -8, // number of turns
    0.12, 1, // minor_radius major_radius
    1, 1, 0 ) // flattening  cross_section_type cross_section_rotation                         
 }                              
 contained_by {sphere {0,4 } }
 open
 max_gradient 5
 pigment { rgb 0.1 }
 finish { phong 0.5 }
}

///////////////////////////////////////////////////////////////////////

object {gear(50,.3) scale 0.05 translate <0,1.0,3.5> }
object {gear(20,1) rotate <-90,-45,0> translate 1.5*y scale 0.05  translate <-0.25,1,2.5> }

object { spring scale 0.05 translate <-0.2,1.0,1.25> }


// object {strip1 rotate -90*x scale 0.2 translate <-2,0.75,3> } 
 
#declare boom_pair=
union {
 object { strip(41) rotate <-90,0,0> scale 0.1  }
 object { strip(41) rotate <-90,0,0> scale 0.1 translate <0,0,0.4> }
}

#declare wheel=
union {
 cylinder {<0,0,-0.1>,<0,0,0.1>,0.2 pigment { rgb <0,0.2,0> } }
 cylinder {<0,0,-0.11>,<0,0,0.11>,0.18 pigment { rgb <0.5,0.5,0.5> } }
 scale 0.8
}

#declare axel1=
cylinder {<0,0,0>,<0,0,1>, 0.019 pigment { rgb <0.2,0.5,0.5> } finish {metallic 0.5} }


#declare turntable=
cylinder {<0,0,0>,<0,0.05,0>,0.4 pigment { rgb <0.3,0.3,1.0> } }


#declare pulley=
union {
 cylinder { <0,0,-0.02>,<0,0,-0.01>,0.18 } 
 cylinder { <0,0,-0.01>,<0,0, 0.01>,0.16 } 
 cylinder { <0,0, 0.01>,<0,0, 0.02>,0.18 }
} 

// crane 
union {
 // boom
 union {
  object { boom_pair rotate <0,0, 2.7> }
  object { boom_pair rotate <0,0,-2.7> translate 0.6*y } 
  union {
   object { plate(1,4,0) scale 0.1 translate <3.8, -0.00, 0.05> rotate <0,0, 2.7> translate -0.07*y }
   object { plate(6,4,0) scale 0.1 translate <2.0, -0.00, 0.05> rotate <0,0, 2.7> translate -0.07*y }
   object { plate(6,4,0) scale 0.1 translate <2.0,  0.00, 0.05> rotate <0,0,-2.7> translate  0.65*y }
   object { bolt rotate -90*x scale 0.1 translate <2.0, 0.-.05, -0.0> rotate <0,0,2.7> translate  0.05*y }
   object { bolt rotate -90*x scale 0.1 translate <2.5, 0.-.05, -0.0> rotate <0,0,2.7> translate  0.05*y }
   object { bolt rotate -90*x scale 0.1 translate <2.0, 0.-.05, -0.0> rotate <0,0,-2.7> translate  0.65*y }
   object { bolt rotate -90*x scale 0.1 translate <2.5, 0.-.05, -0.0> rotate <0,0,-2.7> translate  0.65*y }
   union {
    object { plate(3,3,0) rotate -90*x scale 0.1 translate <0,0,-0.02> }
    object { plate(3,3,0) rotate -90*x scale 0.1 translate <0,0, 0.42> }
    object {bolt scale 0.1 rotate -90*x translate <0.0,  0,-0.04> } 
    object {bolt scale 0.1 rotate -90*x translate <0.1,  0,-0.04> } 
    object {bolt scale 0.1 rotate -90*x translate <0.0,0.2,-0.04> } 
    object {bolt scale 0.1 rotate -90*x translate <0.1,0.2,-0.04> } 
    translate <3.9,0.2, 0>
   }
   object { pulley translate <4.1,0.3,0.22> pigment { rgb <1,1,0> } }
   object { axel1 scale <1,1,0.54> translate <4.1,0.3,-0.07> }
   union {
    object { pulley scale 0.8 }
    object { axel1 scale <1,1,0.2> translate -0.1*z }
    object { strip(3) scale 0.1 rotate <-90,00,-90> translate -0.07*z }
    object { strip(3) scale 0.1 rotate <-90,00,-90> translate  0.07*z }
    object { axel1 scale <1,1,0.2> translate < 0.0, -0.2, -0.1 > }
    translate -1.5*y rotate -40*z 
    translate <4.1, 0.3,0.22> 
    pigment { rgb <1,1,0> } 
   }
   // cable
   union { // cables
    cylinder { <0, 0, 0.02>,<0, -1.5 , 0.02>,0.010 translate < 0.14,0,0> }
    cylinder { <0, -0.4, 0.02>,<0, -1.5 , 0.02>,0.010 translate <-0.14,0,0> }
    rotate -40*z 
    translate <4.1, 0.3,0.22> 
    pigment { rgb <1,1,0.8> } 
   }   
   pigment { rgb <1,0,0> }
  }
  cylinder { <0, 0, 0.02>,<4.1, 0, 0.02>, 0.010 
   translate < 0.0, 0.45, 0.22 > 
   pigment { rgb <1,1,0.8> } 
  }
  pigment { rgb <1,1,0> }
  rotate 40*z
  translate 0.1*y  
 }
 //body
 union {
  object {plate(11,11,2) rotate -90*x scale 0.1 translate -0.10*z}
  object {plate(11,11,2) rotate -90*x scale 0.1 translate 0.50*z}
  object { handle rotate <-90,0,-45> translate <0.2,0.7,-0.1> }
  union {
   object {bolt scale 0.1 rotate -90*x translate 1.0*x }
   object {bolt scale 0.1 rotate -90*x translate 0.5*x }
   object {bolt scale 0.1 rotate -90*x }
   object {bolt scale 0.1 rotate -90*x translate -0.1*x }
   object {bolt scale 0.1 rotate -90*x translate -0.4*x }
   object {bolt scale 0.1 rotate -90*x translate 0.2*y  }
   object {bolt scale 0.1 rotate -90*x translate 0.4*y  }
   object {bolt scale 0.1 rotate -90*x translate <-0.1,0.4,0> }
   object {bolt scale 0.1 rotate -90*x translate <-0.4,0.4,0> }
   translate -0.14*z
  }
  union {
   object {bolt scale 0.1 rotate -90*x translate <0,  1,-0.12>  }
   object {bolt scale 0.1 rotate -90*x translate <0.3,1,-0.12>  }
   //
   object {bolt scale 0.1 rotate  90*x translate <0.0,1.0,0.50> }
   object {nut1 scale 0.1 rotate  90*x translate <0.0,1.0,0.50> }
   pigment {rgb 0.5}
  }
  object {plate(4,6,1) rotate -00*x scale 0.1 translate <0.0,1.06,-0.10>
   pigment {rgb <1,1,0> }
  }
  object {bolt scale 0.1 rotate -00*x translate < 0.0,1.06,-0.1> }
  object {bolt scale 0.1 rotate -00*x translate < 0.3,1.06,-0.1> }
  object {bolt scale 0.1 rotate -00*x translate < 0.0,1.06, 0.4> }
  object {bolt scale 0.1 rotate -00*x translate < 0.3,1.06, 0.4> }
  pigment {rgb <1,0,0> }
  finish { reflection rgb <0.5,0,0>}
  translate -0.5*x
 }
 //body rear
 union {
  object {plate(5,5,1) rotate -90*x scale 0.1 translate -0.12*z}
  object {plate(5,5,1) rotate -90*x scale 0.1 translate 0.52*z}
  //
  object {plate(4,6,1) rotate -00*x scale 0.1 translate <0,0.46,-0.10>}
  object {bolt scale 0.1 rotate -00*x translate < 0.0,0.46,-0.1> }
  object {bolt scale 0.1 rotate -00*x translate < 0.2,0.46,-0.1> }
  object {bolt scale 0.1 rotate -00*x translate < 0.0,0.46, 0.3> }
  object {bolt scale 0.1 rotate -00*x translate < 0.2,0.46, 0.3> }
  pigment {rgb <1,1,0> }
  translate -0.9*x
 }
 union {
  object { wheel translate <-0.5,0,-0.5> } // back
  object { wheel translate <-0.5,0, 0.5> } // back
  object { axel1 translate <-0.5,0, -0.5>} // back
  //
  object { wheel translate < 0.5,0,-0.5> } // front
  object { wheel translate < 0.5,0, 0.5> } // front
  object { axel1 translate < 0.5,0,-0.5> } // front
  translate -0.2*y
 }
 object {turntable translate -0.1*y}
 translate 0.37*y
 scale 0.5 
 rotate -30*y 
 translate <-0.75, 1.0, 2.0>
}
