

#declare float=
merge {                      
 sphere { <0,-1,0>,1 }
 sphere { <0, 1,0>,1 }
 cylinder { <0,-1,0>,<0,1,0>,1 }
 normal { granite 0 }
 scale <1.5,1.5,1.5> 
}

#declare pyramid=
 prism {
  conic_sweep
  linear_spline
  -1,0,5
  <-4,-4>,<-4,4>, <4,4>,<4,-4>,<-4,-4>
  translate 1*y
  scale <1,4,1>
 }

#declare pyramidic=
 difference {
  object {pyramid }
  object {pyramid scale 0.95 }
  box { -1,1 translate <4,0, 0> }
  box { -1,1 translate <-4,0,0> }
  box { -1,1 translate < 0,0,-4> }
  box { -1,1 translate < 0,0, 4> }
 }

#declare tiers=
union {
 box { <-4, 0.0,-4>,< 4, 0.5, 4> }
 box { <-3, 0.5,-3>,< 3, 1.0, 3> }
 box { <-2, 1.0,-2>,< 2, 1.5, 2> }
 box { <-1, 1.5,-1>,< 1, 2.0, 1> }
 object { pyramid scale 0.20 translate 2*y }
}


#declare platform=
union {
 //object { pyramidic translate 1*y }
 object { tiers translate 1*y }
 box { <-4, -1,-4>,< 4, -0.8, 4> }
 box { <-4,  1,-4>,< 4,  0.8, 4> }
 box { <-4, -0.5,-4>,< 4, 0.5, 4> }
 object {float translate <-4,0,-4> }
 object {float translate < 4,0,-4> }
 object {float translate <-4,0, 4> }
 object {float translate < 4,0, 4> }
 rotate -30*y
 translate <0,3,10>
 normal { granite 0.5 scale 0.01 }
}

//////////////////////////////////////////////////////////////

#declare lined_cylinder=
union {
 difference {    
  cylinder { <0,-1,0>,<0,1,0>, 0.9 }
  cylinder { <0,-2,0>,<0,2,0>, 0.899 }
 }
 difference {
  cylinder { <0,-1,0>,<0,1,0>, 1.0 }
  cylinder { <0,-2,0>,<0,2,0>, 0.9 }
  pigment { crackle
   color_map{
    [ 0.0,0.4  color rgb <1,0,0> color rgb <0,1,0> ]
    [ 0.4 1.0  color rgb <0,1,1> color rgb <1,1,1> ]
   }
   // color rgb <0,1,1>
   scale 0.125
  } // pigm
  finish { phong 0.2 ambient 0.3 }
 } // diff
 rotate -60*x
 scale 0.5
 translate <0,ht,0> 
}



#declare sperical_light=
light_source { <0,ht,0>
 color rgb sunshine*.85*<1.0,1.0,1.0>
 fade_distance ht fade_power 2 
 looks_like { sphere { 0,0.25 pigment { color rgb <4,4,4> } 
 }
 }
 }


//#declare helices= 
union {
 sphere { 0,0.5 translate <-0.5, 3,-0.5> }
 sphere { 0,0.5 translate <-0.5,-3, 0.5> }
 sphere { 0,0.5 translate < 0.5, 3, 0.5> }
 sphere { 0,0.5 translate < 0.5,-3,-0.5> }
isosurface {
 function {
  f_helix1 (
    x,y,z,
    2,  // number of helixes
    -4, // number of turns
    0.2, 0.5, // minor_radius major_radius
    1, 1, 0 ) // flattening  cross_section_type cross_section_rotation                         
 }                              
 contained_by {sphere {0,3 } }
 open
 max_gradient 4
 }
 pigment { crackle
  color_map{
  [ 0.0,0.4  color rgb <1,0,0> color rgb <0,1,0> ]
  [ 0.4 1.0  color rgb <0,1,1> color rgb <1,1,1> ]
  }
  // color rgb <0,1,1>
  scale 0.125
 } // pigm
 finish { phong 0.2 ambient 0.3 }
 scale 0.5 
 translate <0,ht,0>
}



#declare pip_tips=
union {
 sphere { 0,0.5 translate  1.5*y }
 sphere { 0,0.5 translate -1.5*y }
 isosurface {
  function { 1                            
   -sqrt((x*x)+(y*y)+(z*z))*1.0 // sphere
   -sqrt((x*x)+(z*z))*1.0 // cylinder
  }
  contained_by {sphere {0,1} }
  open
  max_gradient 4
 }
 pigment { crackle
  color_map{
  [ 0.0,0.4  color rgb <1,0,0> color rgb <0,1,0> ]
  [ 0.4 1.0  color rgb <0,1,1> color rgb <1,1,1> ]
  }
  // color rgb <0,1,1>
  scale 0.125
 } // pigm
 finish { phong 0.2 ambient 0.3 }
 translate <0,ht,0> 
 rotate 45*y
 rotate -00*z
}

#declare pillow=
isosurface {
 function { 1                            
  -sqrt((x*x)+(z*z))*1.0 // cylinder
  -sqrt((x*x)+(y*y))*1.0 // cylinder
 }
 contained_by {sphere {0,1}}
 open
 max_gradient 4
 scale 2
 pigment { crackle
  color_map{
  [ 0.0,0.4  color rgb <1,0,0> color rgb <0,1,0> ]
  [ 0.4 1.0  color rgb <0,1,1> color rgb <1,1,1> ]
  }
  // color rgb <0,1,1>
  scale 0.125
 } // pigm
 finish { phong 0.2 ambient 0.3 }
 rotate 45*y
 rotate -30*z
 translate <0,ht,0> 
}


#declare inflated_octagon=
isosurface {
 function { 1                            
  -sqrt((x*x)+(y*y)+(z*z))
  -sqrt((x*x))/3
  -sqrt((y*y))/3
  -sqrt((z*z))/3
 }
 contained_by {sphere {0,1} }
 open
 max_gradient 4
 scale 2
 pigment { crackle
  color_map{
  [ 0.0,0.4  color rgb <1,0,0> color rgb <0,1,0> ]
  [ 0.4 1.0  color rgb <0,1,1> color rgb <1,1,1> ]
  }
  // color rgb <0,1,1>
  scale 0.125
 } // pigm
 finish { phong 0.2 ambient 0.3 }
 translate ht*y 
 rotate 30*y
}

#declare three_tori=
union {
torus { 1,0.20  rotate 90*x translate ht*y}
torus { 1,0.20  rotate 00*x translate ht*y}
torus { 1,0.20  rotate 90*z translate ht*y}
 pigment { crackle
  color_map{
  [ 0.0,0.4  color rgb <1,0,0> color rgb <0,1,0> ]
  [ 0.4 1.0  color rgb <0,1,1> color rgb <1,1,1> ]
  }
  // color rgb <0,1,1>
  scale 0.125
 } // pigm
 finish { phong 0.2 ambient 0.3 } 
 rotate 30*y
 rotate 30*x
} // union

#declare open_sphere= 
union {
difference {
 sphere { 0, 1.0 }
 sphere { 0, 0.8 }
 box { <-0.5,-0.5,-2>,<0.5,0.5,2> }  
 box { <-2.0,-0.5,-0.5>,<2.0,0.5,0.5> }  
 box { <-0.5,-2.0,-0.5>,<0.5,2.0,0.5> }
 }  
 pigment { crackle
  //pigment{Jade}, pigment{Black_Marble}
  //color rgb <1,1,0>                     
  color_map{
  [ 0.0,0.4  color rgb <1,0,0> color rgb <0,1,0> ]
  [ 0.4 1.0  color rgb <0,1,1> color rgb <1,1,1> ]
  }
  // color rgb <0,1,1>
  scale 0.25
 } // pigm
 finish { phong 0.2 ambient 0.3 }
 //texture { checker texture{T_Wood_3A},texture{Stone12} }
 rotate 20*y
 translate <0,ht,0> 
 }                                  

//////////////////////////////////////////////////////////////////////

 
#declare body_form=
intersection {
 sphere { 0,80 translate  79*y }
 sphere_sweep {  linear_spline 2
  <0,0,0>,0.5, <1,0,0>,1  translate -0.5*x scale <3, 1.5, 1.5>
 }                  
}

#declare body_form=
merge { 
superellipsoid { <0.3,0.3> scale < 2.7,1,1 > }
superellipsoid { <0.7,0.3> translate <1.0,-0.0,0> scale < 2,1,1 > }
}

#declare body_form=
merge { 
superellipsoid { <0.3,0.3> scale < 2.7,1,1 > }
superellipsoid { <0.7,0.3> translate <1.0,-0.0,0> scale < 2,1,1 > }
cylinder {<-1.5,0,0>,< 4,0,0>,0.5 scale <1,0.2,1.5> translate <-1,-0.5,-1>}
cylinder {<-1.5,0>,< 4,0,0>,0.5 scale <1,0.2,1.5> translate <-1,-0.5, 1>}
sphere { 0,0.5 scale <1,0.2,1.5> translate <3,-0.5,-1> }
sphere { 0,0.5 scale <1,0.2,1.5> translate <3,-0.5, 1> }
}


#declare vehicle_form1=
union {
 difference { // windows
  object {body_form scale 0.97 }
  object {body_form scale 0.96 }
  pigment { rgbt <0,0,0,0.8>}
  finish { reflection 0.1 }
 }
 difference { // body with voids
  object {body_form}
  object {body_form scale 0.95 }
  box {<0,0,-2>,<2.2,2,2>}
  box {<0,0,-2>,<2.2,2,2> translate 2.3*x}
 }
 difference { // wheels back
  cylinder {<0,0,-1>,<0,0,1>,0.5}
  cylinder {<0,0,-0.8>,<0,0,0.8>,1.0}
  translate <-1,-0.80,0>
  pigment { rgbt <0.3,0,0,0> }
 }
 difference { // wheels front
  cylinder {<0,0,-1.2>,<0,0,1.2>,0.5}
  cylinder {<0,0,-1.0>,<0,0,1.0>,1.0}
  translate < 3,-0.80,0>
  pigment { rgbt <0.3,0,0,0> }
 }
} // union           


////////////////////////////////////////////////////////////////////

            
#macro views(obj)
object { obj translate <0,4,20> }
object { obj rotate  90*y translate < 10, 5,40> }
object { obj rotate -90*y translate < 10,10,40> }
object { obj rotate -90*x translate <-10, 5,40> }
object { obj rotate  90*x translate <-10,10,40> }
#end

//views(body_form1)

////////////////////////////////////////////////////////////////////////

#declare torus_bdg=
difference {
torus {2,1.00} 
torus {2,0.95}
// box { <-3,-3,-3>,<3,3,0>} // chop
#local ii=0;
#while (ii<360)
 box { -0.1,0.1 scale <1,2,1>*1.5 translate 3*x rotate ii*y } // outer
 sphere { 0,0.1 scale <3,1,1>*2 translate <2.5,1,0> rotate ii*y } // top
 sphere { 0,0.1 scale <1,2,1>*0.5 translate <1,0,0> rotate ii*y } // inner
 #local ii=ii+15;
#end // while 
pigment { rgb <0.6,0.5,0.5>*1.7 }
normal { granite 0.2 scale 0.01 }
finish { ambient 0.3 }
}


#declare fur=
union {
box {<-4,-1,-4>,<4,0,4> } 
union { // no_shadow
#local qq=100;
#local rd=seed(123);
#local xi=0;
#while (xi<qq)
 #local xi=xi+1;
 //#local yi=0;
 #local zi=0;
 #while (zi<qq)
  #local zi=zi+1;
  #local xx=rand(rd)/10+(xi/qq)*8-4.1;
  #local yy=1.0;
  #local zz=rand(rd)/10+(zi/qq)*8-4.1;
  #local bi=0;
  #while (bi<5)
   #local bi=bi+1;
   cone { <rand(rd)/10+xx,0,rand(rd)/10+zz>,0.003,
   <rand(rd)/10+xx,yy*rand(rd),rand(rd)/10+zz>,0.002}
  #end
 #end
#end
no_shadow
}
//pigment { colour rgb <0.50,0.60,0.30> } 
pigment { colour rgb <0.70,0.60,0.00> } 
finish { ambient 0.5 }
rotate -30*x 
}
//views (fur)

////////////////////////////////////////////////////////////////////////

#declare round_fur=
union {
//box {<-4,-1,-4>,<4,0,4> }
sphere { 0,1 } 
union { // no_shadow
#local qq=200;
#local rd=seed(123);
#local xi=0;
#while (xi<qq)
 #local xi=xi+1;
 //#local yi=0;
 #local zi=0;
 #while (zi<qq)
  #local zi=zi+1;
  #local xx=rand(rd)*2-1;
  #local yy=rand(rd)*2-1;
  #local zz=rand(rd)*2-1;
  #local rf=1/sqrt((xx*xx)+(yy*yy)+(zz*zz));
  #local xx=xx*rf;
  #local yy=yy*rf;
  #local zz=zz*rf;
  #local bi=0;
  #while (bi<2)
   #local bi=bi+1;
   cone { <xx,yy,zz>,0.003,
   <xx*(1.5+rand(rd)/5),yy*(1.5+rand(rd)/5),zz*(1.5+rand(rd)/5)>,0.002}
  #end
 #end
#end
no_shadow
}
scale 3
//pigment { colour rgb <0.50,0.60,0.30> } 
pigment { colour rgb <0.70,0.60,0.00> } 
finish { ambient 0.5 }
rotate -30*x 
}
//views (round_fur)

////////////////////////////////////////////////////////////////////////

#declare shape=superellipsoid { <0.3, 0.3> scale 0.9 }
#declare fitted_fur=
union {
 //box {<-4,-1,-4>,<4,0,4> }
 //sphere { 0,1 }
 object {shape  
  pigment { rgb <0.70,0.60,0.00> } 
  normal {bumps 1 scale 0.01} finish{ambient 0.3} 
 }
 union { 
 #local qq=200;
 #local rd=seed(123);
 #local xi=0;
 #while (xi<qq)
  #local xi=xi+1;
  #local zi=0;
  #while (zi<qq)
   #local zi=zi+1;
   #local xx=rand(rd)*2-1;
   #local yy=rand(rd)*2-1;
   #local zz=rand(rd)*2-1;
   #local nrm=<0,0,0>;
   #local psn=<xx,yy,zz>;
   #local srf=trace(shape,psn,-psn,nrm);
   #if (vlength(nrm)!=0)
    #local xx=psn.x;
    #local yy=psn.y;
    #local zz=psn.z;
    #local bi=0;
    #while (bi<2)
     #local bi=bi+1;
     cone { <xx,yy,zz>,0.003,
      <xx*(1.1+rand(rd)/10),yy*(1.1+rand(rd)/10),zz*(1.1+rand(rd)/10)>,0.002
      // Point_At_Trans ( nrm ) 
     }
    #end // while
   #end // if
  #end // while
 #end // while
 //no_shadow
 }
 scale 3
 pigment { colour rgb <0.70,0.60,0.00> } 
 finish { ambient 0.5 }
 rotate -30*x 
}
//views (fitted_fur)

////////////////////////////////////////////////////////////////////////
//views (fibformc)  

////////////////////////////////////////////////////////////////////////


// boxful of objects
          
#declare rd=seed(123);
#macro boxfill()          
#local i=0;
#while (i<150)
#local xx=rand(rd)-0.5;
#local yy=rand(rd)-0.5;
#local zz=rand(rd)-0.5;
union {
 cylinder { 0,1.0,0.50 } 
 cylinder { 0,1.2,0.35 } 
 rotate <rand(rd)*360,rand(rd)*360,rand(rd)*360> 
 translate <xx,yy,zz>*10
 pigment {rgb <rand(rd),rand(rd),rand(rd)>*2} 
}
 #local i=i+1;
#end // while
#end //macro

#declare boxful_of_things=
union {
union { boxfill() 
clipped_by { box {<-5,-5,-5>, <5,7,5> } }
}

difference {
 box { -5.1, 5.1} 
 box { <-5,-5,-5>, <5,6,5> }
} 
rotate -30*x
translate <0,5,40>
}


////////////////////////////////////////////////////////////////////////





////////////////////////////////////////////////////////////////////////
