// Persistence of Vision Ray Tracer Scene Description File
// File: Shuffle.pov
// Vers: 3.5
// Desc: Paused -Dealer needs to shuffle
// Date: 30th Oct, 2004
// Auth: Ewan Grant

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definition
#include "woods.inc" 
#include "glass.inc"

 camera { location  < -1, 4, -2.4 > look_at   < 0.6, 0.4, 0.7 > angle 60 }
 
// An area light (creates soft shadows)
light_source {
  0*x                 // light's position (translated below)
  color rgb 0.9       // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate < 3, 13, -3>   // <x y z> position of light
  fade_distance 14
  fade_power 10
}
 


#declare QuarterRim =  

    difference {  cylinder{ <0, 0.05, 0>  <0, -0.05, 0> 0.5 }
                     
                     cylinder{ <0, 0.06, 0>  <0, -0.06, 0> 0.4 } 
                     cylinder { < -0.51, 0.05, 0> <-0.39, 0.05, 0> 0.003  rotate -40*y }
                     cylinder { < -0.51, 0.05, 0> <-0.39, 0.05, 0> 0.003  rotate -45*y }
                     cylinder { < -0.51, 0.05, 0> <-0.39, 0.05, 0> 0.003  rotate -50*y }
                     box {  <-0.51, -0.11, -0.15> < 0.51,  0.11,  1>  }
                     box {  <-0.15, -0.11, 0.51 > < 1,  0.11, -0.51>  }
                     
                    
                   } // end QuarterRim difference
     
#declare CopperRimIn =
           
     difference {   cylinder{ <0, 0.051, 0>  <0, -0.051, 0> 0.27 }
                     
                      cylinder{ <0, 0.06, 0>  <0, -0.06, 0> 0.265 }  
                      
                   texture { pigment {  Copper  }
                             normal { ripples scale 0.005 }
                             finish {   ambient 0.2  specular 0.6  }
                           }
                } 
                
#declare CopperRimOut1 =
           
     difference {   cylinder{ <0, 0.051, 0>  <0, -0.051, 0> 0.495 }
                     
                      cylinder{ <0, 0.06, 0>  <0, -0.06, 0> 0.49 }  
                      
                   texture { pigment {  Copper  }
                             normal { ripples scale 0.005 }
                             finish {   ambient 0.2  specular 0.6  }
                           }
                }  
               
#declare CopperRimOut2 =
           
     difference {   cylinder{ <0, 0.051, 0>  <0, -0.051, 0> 0.485 }
                     
                      cylinder{ <0, 0.06, 0>  <0, -0.06, 0> 0.48 }  
                      
                   texture { pigment {  Copper  }
                             normal { ripples scale 0.005 }
                             finish {   ambient 0.2  specular 0.6  }
                           }
                }   

            
           
#declare OuterQ5   = object { QuarterRim pigment { color rgb < 0.3, 0.3, 0.6> } normal { wrinkles scale 0.015 } finish { ambient 0.4 } } 
#declare OuterQ10  = object { QuarterRim pigment { color rgb < 0.1, 0.6, 0.6> } normal { wrinkles scale 0.015 } finish { ambient 0.4 } } 
#declare OuterQ25  = object { QuarterRim pigment { color rgb < 0.6, 0.3, 0.3> } normal { wrinkles scale 0.015 } finish { ambient 0.4 } } 
#declare OuterQ50  = object { QuarterRim pigment { color rgb < 0.6, 0.1, 0.6> } normal { wrinkles scale 0.015 } finish { ambient 0.4 } }


         
#declare Centre5   =    cylinder{ <0, 0.05, 0>  <0, -0.05, 0> 0.275 pigment { color rgb <0.3, 0.3, 0.6> } normal { wrinkles scale 0.015 } finish { ambient 0.4 } }
#declare Centre10  =    cylinder{ <0, 0.05, 0>  <0, -0.05, 0> 0.275 pigment { color rgb <0.1, 0.6, 0.6> } normal { wrinkles scale 0.015 } finish { ambient 0.4 } }
#declare Centre25  =    cylinder{ <0, 0.05, 0>  <0, -0.05, 0> 0.275 pigment { color rgb <0.6, 0.3, 0.3> } normal { wrinkles scale 0.015 } finish { ambient 0.4 } }
#declare Centre50  =    cylinder{ <0, 0.05, 0>  <0, -0.05, 0> 0.275 pigment { color rgb <0.6, 0.1, 0.6> } normal { wrinkles scale 0.015 } finish { ambient 0.4 } }
                  

     

#declare MainBody =  cylinder{ <0, 0.0499, 0>  <0, -0.0499, 0> 0.499 
                                pigment { color rgb <0.9, 0.9, 0.7> }
                                normal { dents scale 0.005 } 
                                finish { ambient 0.3 } 
                             }
                             
#declare ChipValue5 = text { ttf   "timesi.ttf",  "5",  0.1,  0 
                           
                           texture { pigment {  Silver  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.6  }
                                   }
                                scale 0.2
                                rotate 90*x
                                translate < -0.06, 0.0501, -0.075 >
                             } 

#declare ChipValue10 = text { ttf   "timesi.ttf",  "10",  0.1,  0 
                           
                           texture { pigment {  Silver  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.6  }
                                   }
                                scale 0.2
                                rotate 90*x
                                translate < -0.12, 0.0501, -0.075 >
                             }
                             
#declare ChipValue25 = text { ttf   "timesi.ttf",  "25",  0.1,  0 
                           
                           texture { pigment {  Silver  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.6  }
                                   }
                                scale 0.2
                                rotate 90*x
                                translate < -0.12, 0.0501, -0.075 >
                             }
                             
#declare ChipValue50 = text { ttf   "timesi.ttf",  "50",  0.1,  0 
                           
                           texture { pigment {  Silver  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.6  }
                                   }
                                scale 0.2
                                rotate 90*x
                                translate < -0.12, 0.0501, -0.075 >
                             }

      
#declare ChipLogo =  


             union {
                     text { ttf "comic.ttf", "C", 0.1, 0 
                            
                            texture { pigment {  Copper  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.2  }
                                   }
                                scale 0.15
                                rotate 90*x
                                translate < -0.15, 0.055, -0.075 >
                                translate 0.343*z 
                                rotate -45*y
                             } 
                             
                     text { ttf "comic.ttf", "u", 0.1, 0 
                            
                            texture { pigment {  Copper  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.2  }
                                   }
                                scale 0.15
                                rotate 90*x
                                translate < -0.05, 0.055, -0.075 >
                                translate 0.351*z 
                                rotate -45*y
                             }
                             
                     text { ttf "comic.ttf", "t", 0.1, 0 
                            
                            texture { pigment {  Copper  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.2  }
                                   }
                                scale 0.16
                                rotate 90*x
                                translate < -0.06, 0.055, -0.075 >
                                translate 0.36*z 
                                rotate -28*y
                             }
                             
                     text { ttf "comic.ttf", "e", 0.1, 0 
                            
                            texture { pigment {  Copper  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.2  }
                                   }
                                scale 0.16
                                rotate 90*x
                                translate < -0.03, 0.055, -0.075 >
                                translate 0.348*z 
                                rotate -20*y
                             }
                             
                     text { ttf "comic.ttf", "C", 0.1, 0 
                            
                            texture { pigment {  Copper  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.2  }
                                   }
                                scale 0.15
                                rotate 90*x
                                rotate 2.5*y
                                translate <-0.03, 0.055, -0.075 >
                                translate 0.355*z 
                                rotate  15*y
                             }
                             
                     text { ttf "comic.ttf", "a", 0.1, 0 
                            
                            texture { pigment {  Copper  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.2  }
                                   }
                                scale 0.15
                                rotate 90*x
                                rotate 2.5*y
                                translate < 0.01, 0.055, -0.075 >
                                translate 0.37*z 
                                rotate  25*y
                             }
                             
                     text { ttf "comic.ttf", "t", 0.1, 0 
                            
                            texture { pigment {  Copper  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.2  }
                                   }
                                scale 0.16
                                rotate 90*x
                                rotate 5*y
                                translate < 0.01, 0.055, -0.075 >
                                translate 0.37*z 
                                rotate  38*y
                             }
                             
                     text { ttf "comic.ttf", "C", 0.1, 0 
                            
                            texture { pigment {  Copper  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.2  }
                                   }
                                scale 0.13
                                rotate 90*x
                                translate <-0.17, 0.055, -0.075 >
                                translate -0.29*z 
                                rotate  5*y
                             }
                             
                     text { ttf "comic.ttf", "a", 0.1, 0 
                            
                            texture { pigment {  Copper  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.2  }
                                   }
                                scale 0.14
                                rotate 90*x
                                translate <-0.09, 0.055, -0.075 >
                                translate -0.29*z 
                                rotate 5*y
                             }
                             
                     text { ttf "comic.ttf", "s", 0.1, 0 
                            
                            texture { pigment {  Copper  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.2  }
                                   }
                                scale 0.14
                                rotate 90*x
                                translate <-0.045, 0.055, -0.075 >
                                translate -0.298*z 
                                rotate  2*y
                             } 
                             
                      text { ttf "comic.ttf", "i", 0.1, 0 
                            
                            texture { pigment {  Copper  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.2  }
                                   }
                                scale 0.14
                                rotate 90*x
                                translate <-0.01, 0.055, -0.075 >
                                translate -0.299*z
                                rotate -4*y 
                             } 
                      
                      text { ttf "comic.ttf", "n", 0.1, 0 
                            
                            texture { pigment {  Copper  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.2  }
                                   }
                                scale 0.14
                                rotate 90*x
                                translate <-0.05, 0.055, -0.075 >
                                translate -0.285*z 
                                rotate  -15*y
                             }
                             
                      text { ttf "comic.ttf", "o", 0.1, 0 
                            
                            texture { pigment {  Copper  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.2  }
                                   }
                                scale 0.14
                                rotate 90*x
                                translate <-0.01, 0.055, -0.075 >
                                translate -0.289*z 
                                rotate  -20*y
                             } 
                      
                      text { ttf "comic.ttf", "s", 0.1, 0 
                            
                            texture { pigment {  Copper  }
                                     normal { ripples scale 0.005 }
                                     finish {   ambient 0.2  specular 0.2  }
                                   }
                                scale 0.15
                                rotate 90*x
                                translate < 0.03, 0.055, -0.075 >
                                translate -0.285*z 
                                rotate  -25*y
                             }
                             
                   } //end union ChipLogo



#declare Value5Chip=

union{
       object { OuterQ5 } 
       object { OuterQ5 rotate 90*y}
       object { OuterQ5 rotate 180*y}
       object { OuterQ5 rotate 270*y}
       object { MainBody }
       object { CopperRimIn }
       object { CopperRimOut1 }
       object { CopperRimOut2 }
       object { Centre5 } 
       object { ChipValue5 } 
       object { ChipLogo }
       
       scale < 1, 0.6, 1 >
     }
     
#declare Value10Chip=

union{
       object { OuterQ10 } 
       object { OuterQ10 rotate 90*y}
       object { OuterQ10 rotate 180*y}
       object { OuterQ10 rotate 270*y}
       object { MainBody }
       object { CopperRimIn }
       object { CopperRimOut1 }
       object { CopperRimOut2 }
       object { Centre10 } 
       object { ChipValue10 } 
       object { ChipLogo }
       
       scale < 1, 0.6, 1 >
     }

    
#declare Value25Chip= 

union{
       object { OuterQ25 } 
       object { OuterQ25 rotate 90*y}
       object { OuterQ25 rotate 180*y}
       object { OuterQ25 rotate 270*y}
       object { MainBody }
       object { CopperRimIn }
       object { CopperRimOut1 }
       object { CopperRimOut2 }
       object { Centre25 } 
       object { ChipValue25 } 
       object { ChipLogo }
       
       scale < 1, 0.6, 1 >
     }
     
#declare Value50Chip=

union{
       object { OuterQ50 } 
       object { OuterQ50 rotate 90*y}
       object { OuterQ50 rotate 180*y}
       object { OuterQ50 rotate 270*y}
       object { MainBody }
       object { CopperRimIn }
       object { CopperRimOut1 }
       object { CopperRimOut2 }
       object { Centre50 } 
       object { ChipValue50 } 
       object { ChipLogo }
       
       scale < 1, 0.6, 1 >
     }    



#declare AceTex =  
 
 texture{
     pigment { 
           image_map {  jpeg "A-club.jpg" 
                        map_type 0        
                        interpolate 2     
                     } 
              }
      finish { ambient 0.4 }
         }  
         
#declare KingTex =  
 
 texture{
     pigment { 
           image_map {  jpeg "K-heart.jpg" 
                        map_type 0        
                        interpolate 2     
                     } 
              } 
      finish { ambient 0.4 }
         }
         
#declare QueenTex =  
 
 texture{
     pigment { 
           image_map {  jpeg "Q-diam1.jpg" 
                        map_type 0        
                        interpolate 2     
                     } 
              }
      finish { ambient 0.4 }
         }
         
#declare JackTex =  
 
 texture{
     pigment { 
           image_map {  jpeg "J-spade.jpg" 
                        map_type 0        
                        interpolate 2     
                     } 
              }
     finish { ambient 0.4 }
         }
         
#declare BackTex =  
 
 texture{
     pigment { 
           image_map {  jpeg "back.jpg" 
                        map_type 0        
                        interpolate 2     
                     } 
              }
      finish { ambient 0.4 }
         }
      
#declare JokerTex =  
 
 texture{
     pigment { 
           image_map {  jpeg "joker.jpg" 
                        map_type 0        
                        interpolate 2     
                     } 
              }
     finish { ambient 0.4 }
         }


#declare CornerClip =  

    difference {  box { < -0.1, -0.02, -0.1 > < 0, 0.02, 0 > }
                     
                  cylinder{ <0, 0.1, 0>  <0, -0.1, 0> 0.11 } 
               }
               
#declare BaseCard =
               
difference { 

 box { < -0.5, -0.01, -0.5 > < 0.5, 0, 0.5 >  }
 
 object { CornerClip translate < -0.41, 0, -0.41 > }    
 object { CornerClip rotate 90*y translate  <-0.41, 0, 0.41 > }
 object { CornerClip rotate 180*y translate < 0.41, 0, 0.41 > }
 object { CornerClip rotate 270*y translate < 0.41, 0,-0.41 > }
     
            }


#declare AceCard =          
         
         
          object { BaseCard 
                    texture { AceTex 
                              rotate 90*x 
                              translate -0.5*x
                              translate 0.5*z
                            }
                              
                 } 
                 
#declare KingCard =          
         
         
          object { BaseCard 
                    texture { KingTex 
                              rotate 90*x 
                              translate -0.5*x
                              translate 0.5*z
                            }
                              
                 } 
                 
#declare QueenCard =          
         
         
          object { BaseCard 
                    texture { QueenTex 
                              rotate 90*x 
                              translate -0.5*x
                              translate 0.5*z
                            }
                              
                 } 
                 
#declare JackCard =          
         
         
          object { BaseCard 
                    texture { JackTex 
                              rotate 90*x 
                              translate -0.5*x
                              translate 0.5*z
                            }
                              
                 } 
                 
#declare JokerCard =          
         
         
          object { BaseCard 
                    texture { JokerTex 
                              rotate 90*x 
                              translate -0.5*x
                              translate 0.5*z
                            }
                              
                 }
                 
#declare BackCard =          
         
         
          object { BaseCard 
                    texture { BackTex 
                              rotate 90*x 
                              translate -0.5*x
                              translate 0.5*z
                            }
                              
                 }    
          

#declare TableBase =  

    difference {
            cylinder { < 0, 0, 0 > < 0, -0.5, 0 > 10 }
          
               box { < 11, 1,  11 > <-11, -2, 0 > }
                
          texture {
                   pigment { color rgb < 0.4, 0.4, 0.9 > }
                   finish { ambient 0.1 diffuse 0.5 crand 0.1 }
                  } 
               } 

//------------ 
              
#declare WoodA = 
color_map { 
    [0.0, 0.5 color rgb <0.60, 0.35, 0.20>
              color rgb <0.60, 0.20, 0.16>]
    [0.5, 0.7 color rgb <0.60, 0.20, 0.12>
              color rgb <0.30, 0.10, 0.12>]
    [0.7, 1.0 color rgb <0.50, 0.20, 0.16>
              color rgb <0.70, 0.35, 0.20>]
}
#declare WoodB = 
color_map { 
    [0.0, 0.5 color rgbt <0.60, 0.40, 0.20, 1.00>
              color rgbt <0.50, 0.30, 0.06, 0.40>]
    [0.5, 0.7 color rgbt <0.40, 0.30, 0.06, 0.40>
              color rgbt <0.30, 0.13, 0.13, 0.30>]
    [0.7, 1.0 color rgbt <0.50, 0.30, 0.06, 0.40>
              color rgbt <0.40, 0.40, 0.25, 1.00>]
}
               
#declare BurlWood   =         
    texture { pigment { P_WoodGrain9A  color_map { WoodA }}}
    texture { pigment { P_WoodGrain9B  color_map { WoodB }}} 
    
//---------------
    
#declare TableRim =

    difference {
            torus { 9.8, 0.5 }
            
              box { < 11, 3,  11 > <-11, -3, 0 > }
              box { < 11, 3,  11 > <-11, 0.4, -11 > }
         cylinder { < 0, 1, 0 > < 0, -1, 0 > 9.7 }
               
         texture { BurlWood scale 0.8 rotate -18*x}
         
                }
                
#declare InsurancePlaceA =

difference {
             cylinder { < 0, 0, 0 > < 0, 0.01, 0 > 18 } 
             
             cylinder { < 0,-0.1, 0 > < 0, 0.1, 0 > 17 }
             box { < -19, -1, -2 > < 19, 1, 19 > } 
             box { < -2, -1, -19 > < 19, 1, 19 > }
           } 
           
#declare InsurancePlaceB =

difference {
             cylinder { < 0,-0.1, 0 > < 0, 0.15, 0 > 17.95 } 
             
             cylinder { < 0,-0.2, 0 > < 0, 0.2, 0 > 17.05 }
             box { < -19, -1, -1.9 > < 19, 1, 19 > } 
             box { < -1.9, -1, -19 > < 19, 1, 19 > }
           }
           
#declare InsuranceBand =
     
difference {   
       object { InsurancePlaceA rotate -45*y translate 21*z } 
     
       object { InsurancePlaceB rotate -45*y translate 21*z }
     
     texture {
              pigment { color rgb < 1, 0.9, 0.0 > }
              normal { dents }
              finish { ambient 0.5 diffuse 0.1 crand 0.08 }
             }
           }
           
#declare Insurance =  


             union {
                     text { ttf "BookOS.ttf", "I", 0.1, 0 
                            
                            texture { 
                                      pigment {  Red  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                rotate 5*y
                                translate < -2.45, -0.02, 3.3 >
                                
                           }
                           
                     text { ttf "BookOS.ttf", "N", 0.1, 0 
                            
                            texture { 
                                      pigment {  Red  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                rotate 3*y
                                translate < -2.05, -0.02, 3.21 >
                                 
                           }
                           
                      text { ttf "BookOS.ttf", "S", 0.1, 0 
                            
                            texture { 
                                      pigment {  Red  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                rotate 2*y
                                translate < -1.41, -0.02, 3.19 >
                                 
                           }
                      
                      text { ttf "BookOS.ttf", "U", 0.1, 0 
                            
                            texture { 
                                      pigment {  Red  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                translate < -0.9, -0.02, 3.15 >
                                
                           }
                           
                      text { ttf "BookOS.ttf", "R", 0.1, 0 
                            
                            texture { 
                                      pigment {  Red  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                translate < -0.3, -0.02, 3.15 >
                                 
                           }
                           
                      text { ttf "BookOS.ttf", "A", 0.1, 0 
                            
                            texture { 
                                      pigment {  Red  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                translate < 0.28, -0.02, 3.16 >
                                 
                           }
                           
                      text { ttf "BookOS.ttf", "N", 0.1, 0 
                            
                            texture { 
                                      pigment {  Red  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                translate < 0.86, -0.02, 3.18 >
                                
                           }
                           
                      text { ttf "BookOS.ttf", "C", 0.1, 0 
                            
                            texture { 
                                      pigment {  Red  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                translate < 1.45, -0.02, 3.23 >
                                 
                           }
                           
                       text { ttf "BookOS.ttf", "E", 0.1, 0 
                            
                            texture { 
                                      pigment {  Red  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                rotate -8*y
                                translate < 2.07, -0.02, 3.28 >
                                 
                           } 
                       
                       text { ttf "BookOS.ttf", "2-1", 0.1, 0 
                            
                            texture { 
                                      pigment {  Green  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.7
                                rotate 90*x
                                rotate -14*y
                                translate < 3.6, -0.02, 3.575 >
                                 
                           } 
                           
                       text { ttf "BookOS.ttf", "2-1", 0.1, 0 
                            
                            texture { 
                                      pigment {  Green  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.7
                                rotate 90*x
                                rotate 14*y
                                translate < -4.6, -0.02, 3.8 >
                                 
                           }
                             
                     
                             
                   } 
                   
#declare BlJaPays =  


             union {
                     text { ttf "BookOS.ttf", "B", 0.1, 0 
                            
                            texture { 
                                      pigment {  Green  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                rotate 5*y
                                translate < -2.4, -0.02, 4.7 >
                                
                           }
                           
                     text { ttf "BookOS.ttf", "L", 0.1, 0 
                            
                            texture { 
                                      pigment {  Green  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                rotate 3*y
                                translate < -1.8, -0.02, 4.7 >
                                 
                           }
                           
                      text { ttf "BookOS.ttf", "A", 0.1, 0 
                            
                            texture { 
                                      pigment {  Green  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                rotate 2*y
                                translate < -1.35, -0.02, 4.69 >
                                 
                           }
                      
                      text { ttf "BookOS.ttf", "C", 0.1, 0 
                            
                            texture { 
                                      pigment { Green }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                translate < -0.8, -0.02, 4.65 >
                                
                           }
                           
                      text { ttf "BookOS.ttf", "K", 0.1, 0 
                            
                            texture { 
                                      pigment { Green  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                translate < -0.225, -0.02, 4.65 >
                                 
                           }
                           
                      text { ttf "BookOS.ttf", "J", 0.1, 0 
                            
                            texture { 
                                      pigment {  Green  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                translate < 0.315, -0.02, 4.66 >
                                 
                           }
                           
                      text { ttf "BookOS.ttf", "A", 0.1, 0 
                            
                            texture { 
                                      pigment { Green }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                translate < 0.72, -0.02, 4.68 >
                                
                           }
                           
                      text { ttf "BookOS.ttf", "C", 0.1, 0 
                            
                            texture { 
                                      pigment {  Green  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                translate < 1.3, -0.02, 4.73 >
                                 
                           }
                           
                       text { ttf "BookOS.ttf", "K", 0.1, 0 
                            
                            texture { 
                                      pigment {  Green  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                rotate -8*y
                                translate < 1.9, -0.02, 4.78 >
                                 
                           } 
                       
                       text { ttf "BookOS.ttf", "3-2", 0.1, 0 
                            
                            texture { 
                                      pigment {  Yellow  }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.8
                                rotate 90*x
                                rotate -14*y
                                translate < 2.9, -0.02, 4.975 >
                                 
                           } 
                           
                       text { ttf "BookOS.ttf", "3-2", 0.1, 0 
                            
                            texture { 
                                      pigment {  Yellow }
                                      normal { dents }
                                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                                    }
                                   
                                scale 0.7
                                rotate 90*x
                                rotate 14*y
                                translate < -4.6, -0.02, 4.8 >
                                 
                           }
                             
                     
                             
                   }
     
                
#declare CardPlace =

 difference { 
          
          object { BaseCard scale 1.05 }
          
          object { BaseCard scale < 1, 5, 1 > translate 0.01*y }
          
              }
              

#declare CardSetting =         
   
   object { CardPlace
            texture {
                      pigment { color rgb < 1, 0.9, 0.0 > }
                      normal { dents }
                      finish { ambient 0.5 diffuse 0.1 crand 0.08 }
                    }  
            scale 2 
           }
            
                
#declare GlassNeg = 
          
    
          union{
             
             cone { <0, 1.3, 0>, 0.58, <0, 0.4, 0>, 0.56  } 
           sphere { 0.8*y, 0.56 scale < 1, 0.5, 1 >  }
            
              } 
               
#declare GlassPos = 

         cone { <0, 1.2, 0>, 0.59, <0, 0, 0>, 0.58   }  
         

#declare Glass =
 
 difference {
            object { GlassPos }
      
            object { GlassNeg pigment { Clear }  } 
         
texture {

   pigment { color rgbf < 1, 1, 1, 1> } 
      
  finish { F_Glass8 }
        
        } 
        
    interior { ior 1.5
               fade_distance 1.0
               fade_power 2
             } 
            } // end difference Glass
              
                
#declare Malt = 
          
    
      union{
             
             cone { <0, 1.5, 0>, 0.56, <0, 0.4, 0>, 0.56  } 
           sphere { 0.8*y, 0.56 scale < 1, 0.5, 1 >  }
           
      texture {
                 pigment { color rgbf < 0.9, 0.4, 0, 1 > } 
                 finish { specular 0.5
                          roughness 0.06
                          ambient 0.8
                          diffuse 0.4
                        }
              }
                     
         interior { ior 1.2  } 
     scale < 1, 0.5, 1 >  
     translate < 2, 0, 0 > 
        
            }  

#declare IceCube = 
  

     superellipsoid { < 0.2, 0.2 > 
                      texture{
                           pigment { color rgbf < 1, 0.89, 0.59, 0.9 > }
                           normal { waves scale 0.15 turbulence 0.9 }
                           finish { specular 0.8
                                    roughness 0.1
                                    ambient 0.9
                                    diffuse 0.9
                                  }
                              }
                      interior { ior 1.2 }
                      scale 0.21 
                      translate < 2.1, 0.457, 0 >
                     }
            
                
#declare Drink = 
union {

 object { Glass translate < 2, 0.03, 0 > } 
 object { Malt }
 object { IceCube }
 
      }
      
      
 object { BackCard  scale < 1, 1, 1.4 > translate < 0.15, 0, 7.3 > }
 object { BackCard  scale < 1, 1, 1.4 > rotate -1*x translate < -0.35, 0.01, 7.3 > }
 object { BackCard  scale < 1, 1, 1.4 > rotate -1*x translate < -0.75, 0.01, 7.3 > }
 object { BackCard  scale < 1, 1, 1.4 > rotate -1*x translate < -1.15, 0.01, 7.3 > }
 object { BackCard  scale < 1, 1, 1.4 > rotate -1*x translate < -1.55, 0.01, 7.3 > }
 object { JokerCard  scale < 1.3, 5, 1.3 > translate < 1.7, 0, -0.2 > } // Placemat for drink 
 object { JokerCard  scale < 1.2, 5, 1.2 > translate < -2.2, 0, 0.4 > } // Placemat        
 object { AceCard  scale < 1, 1, 1.4 > translate < -0.35, -0.03, 0.9 > }
 object { JackCard scale < 1, 1, 1.4 > rotate-25*y translate <  0.45, -0.02, 1.4 > }
 object { KingCard  scale < 1, 1, 1.4 > rotate-10*y translate < 5.65, -0.02, 1.4 > }
 object { QueenCard  scale < 1, 1, 1.4 > rotate-20*y translate < 6.05, -0.03, 1.9 > }
 object { Value25Chip rotate 24*y  scale 0.6 translate < 5.48, 0.00, 2.85> }
 object { Value25Chip rotate 11*y  scale 0.6 translate < 5.68, 0.06, 2.85> }
 object { Value25Chip rotate 21*y  scale 0.6 translate < 5.48, 0.12, 2.85> } 
 object { Value5Chip  rotate 34*y  scale 0.6 translate < 4.15, -0.03,  0.40> }  
 object { Value10Chip rotate 54*y  scale 0.6 translate < 3.55, -0.03, -0.10> } 
 object { Value10Chip rotate 24*y  scale 0.6 translate < 3.65,  0.00, -0.10> }
 object { Value25Chip rotate 74*y  scale 0.6 translate < 3.55, -0.03,  0.75> }
 object { Value50Chip              scale 0.6 translate <-0.1, 0,-0.80> } 
 object { Value50Chip rotate 64*y  scale 0.6 translate <-1.00, -0.03, 2.00> } 
 object { Value50Chip              scale 0.6 translate <-0.98, 0.06, 2.04> }
 object { Value50Chip rotate -33*y scale 0.6 translate <-0.95, 0.12, 2.03> }
 object { Value50Chip              scale 0.6 translate <-0.93, 0.18, 2.05> }
 object { Value50Chip rotate 94*y  scale 0.6 translate < 0.50, -0.03,-1.00> }
 object { Value50Chip              scale 0.6 translate < 0.50, 0.06,-1.00> }
 object { Value50Chip rotate 44*y  scale 0.6 translate < 0.50, 0.12,-1.00> }
 object { Value50Chip rotate 14*y  scale 0.6 translate < 0.50, 0.18,-1.00> }
 object { Value50Chip rotate 29*y  scale 0.6 translate < 0.50, 0.24,-1.00> }
 object { Value50Chip              scale 0.6 translate < 0.50, 0.30,-1.00> }
 object { Value50Chip rotate 14*y  scale 0.6 translate < 0.50, 0.36,-1.00> }
 object { Value50Chip              scale 0.6 translate < 0.50, 0.42,-1.00> }
 object { Value50Chip rotate 38*y  scale 0.6 translate < 0.60, 0.48,-1.00> }
  

  object { TableBase scale 2 translate < 0, -0.04, 18 > }
  object { TableRim scale 2 translate < 0, -0.04, 18 > }
  
  

  object { Drink scale 0.95 translate < -0.1, 0, -0.3 > }
  object { Glass scale 0.8 translate < -2.1, 0.03, 0.4 > }

   object { CardSetting translate <0, -0.039, 1 > }
   object { CardSetting  rotate -18*y translate < 6,-0.039, 1.8 > }
   object { CardSetting  rotate 18*y translate < -6,-0.039, 1.8 > } 
     
   object { InsuranceBand translate -0.0495}
   object { Insurance }
   object { BlJaPays }  
     
  