// Persistence of Vision Ray Tracer Scene Description File
// File: AllRouterBits.pov
// Vers: 3.5
// Desc: Shows all the bits in SS_RouterBits (version 1.0)
// Date: 05/26/2004
// Auth: Copyright  2004 by Sherry K. Shaw


//------------------------------------------------------------------------------
// Initialization
//------------------------------------------------------------------------------

global_settings {
  assumed_gamma 1.0
}

#include "SS_RouterBits.inc"


//------------------------------------------------------------------------------
// A couple of textures
//------------------------------------------------------------------------------

#declare RED_PLASTIC_TEX =
texture {
  pigment {
    color rgb < 1, 0, 0 >
  }
  finish {
    ambient 0.3
    diffuse 0.6
    specular 1.0
    roughness 0.05
  }
}

#declare CHECKER_TEX =
texture {
  pigment {
    checker
    color rgb < 0.6, 0.8, 1.0 >,
    color rgb < 0.9, 1.0, 0.5 >
  }
  finish {
    ambient 0.4
    diffuse 0.6
  }
}


//------------------------------------------------------------------------------
// The scene
//------------------------------------------------------------------------------

camera {
  orthographic
  location < 0.0, 3.0, -8.0 >
  look_at  < 0.0, 3.0,  0.0 >
}

light_source {
  < -1500, 1000, -1500 >
  color rgb 1
}

plane {
  z, 0.5
  texture {
    CHECKER_TEX
  }
}

// Top row (objects)
object {
  RB_00_OBJ
  texture {
    RED_PLASTIC_TEX
  }
  translate < -5.0, 6, 0 >
}

object {
  RB_01_OBJ
  texture {
    RED_PLASTIC_TEX
  }
  translate < -3.0, 6, 0 >
}

object {
  RB_02_OBJ
  texture {
    RED_PLASTIC_TEX
  }
  translate < -1.0, 6, 0 >
}

object {
  RB_03_OBJ
  texture {
    RED_PLASTIC_TEX
  }
  translate < 1.0, 6, 0 >
}

object {
  RB_04_OBJ
  texture {
    RED_PLASTIC_TEX
  }
  translate < 3.0, 6, 0 >
}

// Top row (text)
text {
  ttf "arialbd.ttf"
  "RB_00_OBJ"
  0.5, 0
  scale 0.25
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < -5.0, 6.125, 0 >
}

text {
  ttf "arialbd.ttf"
  "RB_01_OBJ"
  0.5, 0
  scale 0.25
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < -3.0, 6.125, 0 >
}

text {
  ttf "arialbd.ttf"
  "RB_02_OBJ"
  0.5, 0
  scale 0.25
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < -1.0, 6.125, 0 >
}

text {
  ttf "arialbd.ttf"
  "RB_03_OBJ"
  0.5, 0
  scale 0.25
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < 1.0, 6.125, 0 >
}

text {
  ttf "arialbd.ttf"
  "RB_04_OBJ"
  0.5, 0
  scale 0.25
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < 3.0, 6.125, 0 >
}

// Middle row (objects)
object {
  RB_05_OBJ
  texture {
    RED_PLASTIC_TEX
  }
  translate < -5.0, 4, 0 >
}

object {
  RB_06_OBJ
  texture {
    RED_PLASTIC_TEX
  }
  translate < -3.0, 4, 0 >
}

object {
  RB_07_OBJ
  texture {
    RED_PLASTIC_TEX
  }
  translate < -1.0, 4, 0 >
}

object {
  RB_08_OBJ
  texture {
    RED_PLASTIC_TEX
  }
  translate < 1.0, 4, 0 >
}

object {
  RB_09_OBJ
  texture {
    RED_PLASTIC_TEX
  }
  translate < 3.0, 4, 0 >
}

// Middle row (text)
text {
  ttf "arialbd.ttf"
  "RB_05_OBJ"
  0.5, 0
  scale 0.25
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < -5.0, 4.125, 0 >
}

text {
  ttf "arialbd.ttf"
  "RB_06_OBJ"
  0.5, 0
  scale 0.25
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < -3.0, 4.125, 0 >
}

text {
  ttf "arialbd.ttf"
  "RB_07_OBJ"
  0.5, 0
  scale 0.25
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < -1.0, 4.125, 0 >
}

text {
  ttf "arialbd.ttf"
  "RB_08_OBJ"
  0.5, 0
  scale 0.25
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < 1.0, 4.125, 0 >
}

text {
  ttf "arialbd.ttf"
  "RB_09_OBJ"
  0.5, 0
  scale 0.25
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < 3.0, 4.125, 0 >
}

// Bottom row (objects)
object {
  RB_10_OBJ
  texture {
    RED_PLASTIC_TEX
  }
  translate < -5.0, 2, 0 >
}

object {
  RB_11_OBJ
  texture {
    RED_PLASTIC_TEX
  }
  translate < -3.0, 2, 0 >
}

object {
  RB_12_OBJ
  texture {
    RED_PLASTIC_TEX
  }
  translate < -1.0, 2, 0 >
}

object {
  RB_13_OBJ
  texture {
    RED_PLASTIC_TEX
  }
  translate < 1.0, 2, 0 >
}

object {
  RB_14_OBJ
  texture {
    RED_PLASTIC_TEX
  }
  translate < 3.0, 2, 0 >
}

// Bottom row (text)
text {
  ttf "arialbd.ttf"
  "RB_10_OBJ"
  0.5, 0
  scale 0.25
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < -5.0, 2.125, 0 >
}

text {
  ttf "arialbd.ttf"
  "RB_11_OBJ"
  0.5, 0
  scale 0.25
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < -3.0, 2.125, 0 >
}

text {
  ttf "arialbd.ttf"
  "RB_12_OBJ"
  0.5, 0
  scale 0.25
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < -1.0, 2.125, 0 >
}

text {
  ttf "arialbd.ttf"
  "RB_13_OBJ"
  0.5, 0
  scale 0.25
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < 1.0, 2.125, 0 >
}

text {
  ttf "arialbd.ttf"
  "RB_14_OBJ"
  0.5, 0
  scale 0.25
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < 3.0, 2.125, 0 >
}

// More text
text {
  ttf "arialbd.ttf"
  "AllRouterBits.pov (using SS_RouterBits.inc v. 1.0)"
  0.5, 0
  scale 0.375
  texture {
    RED_PLASTIC_TEX
  }
  no_shadow
  translate < -4.5, 0.0, 0 >
}
