// Persistence of Vision Ray Tracer Scene Description File
// File: RouterBits.pov
// Vers: 3.5
// Desc: Example of the use of SS_RouterBits.inc (version 1.0)
// Date: 05/26/2004
// Auth: Copyright  2004 by Sherry K. Shaw


//------------------------------------------------------------------------------
// Initialization
//------------------------------------------------------------------------------

global_settings {
  assumed_gamma 1.0
}

#include "SS_RouterBits.inc"
#include "textures.inc"


//------------------------------------------------------------------------------
// A shiny red texture
//------------------------------------------------------------------------------

#declare RED_PLASTIC_TEX =
texture {
  pigment {
    color rgb < 1, 0, 0 >
  }
  finish {
    ambient 0.3
    diffuse 0.6
    specular 1.0
    roughness 0.05
  }
}

#declare CHECKER_TEX =
texture {
  pigment {
    checker
    color rgb < 0.6, 0.8, 1.0 >,
    color rgb < 0.9, 1.0, 0.5 >
  }
  finish {
    ambient 0.4
    diffuse 0.6
  }
}


//------------------------------------------------------------------------------
// A couple of table tops
//------------------------------------------------------------------------------

#declare TABLE_WIDTH = 16 ;
#declare HALF_TABLE_WIDTH = TABLE_WIDTH * 0.5 ;
#declare TABLE_THICKNESS = 1.5 ;

#declare TABLE_TOP_OBJ =
box {
  < -HALF_TABLE_WIDTH, -TABLE_THICKNESS, -HALF_TABLE_WIDTH >,
  <  HALF_TABLE_WIDTH,  0,                HALF_TABLE_WIDTH >
}

// A simple table top, with the top edge cut by a router bit
#declare TABLE_ROUTER_BIT_OBJ =
object {                                       // Notice that the router bit object is scaled
  RB_11_OBJ                                    // slightly longer in the z-dimension than the
  scale < 0.75, 0.75, ( TABLE_WIDTH + 0.1 ) >  // object that it's going to be used to cut.
}

#declare SIMPLE_TABLE_TOP_SHAPE_OBJ =
difference {
  object {                                                    // The "smidgen" translations are
    TABLE_TOP_OBJ                                             // added to prevent coincident surface
  }                                                           // problems.  (Default value of
  union {                                                     // RB_SMIDGEN = 0.01)
    object {                            // Left edge
      TABLE_ROUTER_BIT_OBJ
      translate < -( HALF_TABLE_WIDTH + RB_SMIDGEN ), 0, 0 >
    }
    object {                            // Back edge
      TABLE_ROUTER_BIT_OBJ
      rotate y*90
      translate < 0, 0, ( HALF_TABLE_WIDTH + RB_SMIDGEN ) >
    }
    object {                            // Right edge
      TABLE_ROUTER_BIT_OBJ
      rotate y*180
      translate < ( HALF_TABLE_WIDTH + RB_SMIDGEN ), 0, 0 >
    }
    object {                            // Front edge
      TABLE_ROUTER_BIT_OBJ
      rotate y*270
      translate < 0, 0, -( HALF_TABLE_WIDTH + RB_SMIDGEN ) >
    }
    translate < 0, RB_SMIDGEN, 0 >
  }
}

#declare SIMPLE_RED_TABLE_TOP_OBJ =
object {
  SIMPLE_TABLE_TOP_SHAPE_OBJ
  texture {
    RED_PLASTIC_TEX
  }
}

#declare SIMPLE_WOOD_TABLE_TOP_OBJ =
object {
  SIMPLE_TABLE_TOP_SHAPE_OBJ
  texture {
    DMFDarkOak
    scale 0.5
    finish {
      specular 0.5
      roughness 0.03
    }
  }
}

// A fancier table top, with the edge cut by a macEdgeCutter object

// First we #declare the variables used to set up the "stack" of router bit objects
#declare RB_EC_TOP_OBJ = RB_04_OBJ
#declare RB_EC_TOP_SCALE = < 0.75, 0.75 > ;
#declare RB_EC_TOP_INV = false ;

#declare RB_EC_NUM_MIDDLE_BITS = 3 ;

#declare RB_EC_MIDDLE_OBJ = array[ 3 ]
#declare RB_EC_MIDDLE_OBJ[ 0 ] = RB_13_OBJ
#declare RB_EC_MIDDLE_OBJ[ 1 ] = RB_13_OBJ
#declare RB_EC_MIDDLE_OBJ[ 2 ] = RB_13_OBJ

#declare RB_EC_MIDDLE_SCALE = array[ 3 ]
#declare RB_EC_MIDDLE_SCALE[ 0 ] = < 0.0625, 0.125 > ;
#declare RB_EC_MIDDLE_SCALE[ 1 ] = < 0.0625, 0.125 > ;
#declare RB_EC_MIDDLE_SCALE[ 2 ] = < 0.0625, 0.125 > ;

#declare RB_EC_MIDDLE_INV = array[ 3 ]
#declare RB_EC_MIDDLE_INV[ 0 ] = false ;
#declare RB_EC_MIDDLE_INV[ 1 ] = false ;
#declare RB_EC_MIDDLE_INV[ 2 ] = false ;

#declare RB_EC_MIDDLE_Y_OFF = array[ 3 ]
#declare RB_EC_MIDDLE_Y_OFF[ 0 ] = 0.1 ;
#declare RB_EC_MIDDLE_Y_OFF[ 1 ] = -0.05 ;
#declare RB_EC_MIDDLE_Y_OFF[ 2 ] = -0.2 ;

#declare RB_EC_BOTTOM_OBJ = RB_02_OBJ
#declare RB_EC_BOTTOM_SCALE = < 0.125, 0.125 > ;
#declare RB_EC_BOTTOM_INV = true ;

// Then we build the edge cutter object, using:
//    macEdgeCutter( Thickness, Width, CutTop, CutMiddle, CutBottom, AddSpacer, Smidgen )

#declare TABLE_EDGE_CUTTER_OBJ =
object {
  macEdgeCutter( TABLE_THICKNESS, ( TABLE_WIDTH + RB_SMIDGEN ), true, true, true, false, 0.01 )
}

// Finally we build the table top
#declare FANCY_TABLE_TOP_SHAPE_OBJ =
difference {
  object {
    TABLE_TOP_OBJ
  }
  union {
    object {                            // Left edge
      TABLE_EDGE_CUTTER_OBJ
      translate < -( HALF_TABLE_WIDTH + RB_SMIDGEN ), 0, 0 >
    }
    object {                            // Back edge
      TABLE_EDGE_CUTTER_OBJ
      rotate y*90
      translate < 0, 0, ( HALF_TABLE_WIDTH + RB_SMIDGEN ) >
    }
    object {                            // Right edge
      TABLE_EDGE_CUTTER_OBJ
      rotate y*180
      translate < ( HALF_TABLE_WIDTH + RB_SMIDGEN ), 0, 0 >
    }
    object {                            // Front edge
      TABLE_EDGE_CUTTER_OBJ
      rotate y*270
      translate < 0, 0, -( HALF_TABLE_WIDTH + RB_SMIDGEN ) >
    }
    translate < 0, RB_SMIDGEN, 0 >
  }
}

#declare FANCY_RED_TABLE_TOP_OBJ =
object {
  FANCY_TABLE_TOP_SHAPE_OBJ
  texture {
    RED_PLASTIC_TEX
  }
}

#declare FANCY_WOOD_TABLE_TOP_OBJ =
object {
  FANCY_TABLE_TOP_SHAPE_OBJ
  texture {
    DMFDarkOak
    scale 0.5
    finish {
      specular 0.5
      roughness 0.03
    }
  }
}


//------------------------------------------------------------------------------
// The scene
//------------------------------------------------------------------------------

camera {
  right x*image_width/image_height
  location < 0.0, 16.0, -28.0 >
  look_at  < 0.0, 16.0,   0.0 >
}

light_source {
  < -1500, 1000, -1500 >
  color rgb 1
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [ 0.5 color rgb < 0.3, 0.4, 1.0 > ]
      [ 1.0 color rgb < 0.0, 0.0, 0.4 > ]
    }
    scale 2
    translate -1
  }
  pigment {
    spotted
    turbulence 3.5
    color_map {
      [ 0.5 color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
      [ 1.0 color rgbf < 1.0, 1.0, 1.0, 0.2 > ]
    }
    scale < 0.8, 0.1, 0.8 >
  }
}

object {
  FANCY_WOOD_TABLE_TOP_OBJ
  rotate y*30
  rotate x*-25
  translate < -8, 22, 0 >
}

object {
  SIMPLE_WOOD_TABLE_TOP_OBJ
  rotate y*30
  rotate x*-25
  translate < 12, 22, 0 >
}

object {
  FANCY_RED_TABLE_TOP_OBJ
  rotate y*30
  rotate x*-15
  translate < -8, 12, 0 >
}

object {
  SIMPLE_RED_TABLE_TOP_OBJ
  rotate y*30
  rotate x*-15
  translate < 12, 12, 0 >
}


