// Persistence of Vision Ray Tracer Scene Description File
// File: Towers.pov
// Vers: 3.6
// Desc: A game for irtc ( deadline 10 hours from project start :D )
// Date: 10/31/04          
// Auth: Kevin Stock
//

#version 3.6;

#include "colors.inc"
#include "woods.inc"
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions

#declare Seed = seed(1);


#declare Ring1 = torus { 
   3.6,.55
   texture { T_Wood19  rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
   translate .5*y
}

#declare Ring2 = torus { 
   3.3,.55
   texture { T_Wood19  rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
   translate .5*y
}

#declare Ring3 = torus { 
   3,.55                 
   texture { T_Wood19  rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
   translate .5*y
}

#declare Ring4 = torus { 
   2.7,.55              
   texture { T_Wood19  rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
   translate .5*y
}

#declare Ring5 = torus { 
   2.4,.55                  
   texture { T_Wood19  rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
   translate .5*y
}

#declare Ring6 = torus { 
   2.1,.55              
   texture { T_Wood19  rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
   translate .5*y
}

#declare Ring7 = torus { 
   1.8,.55                  
   texture { T_Wood19  rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
   translate .5*y
}

#declare Ring8 = torus { 
   1.5,.55              
   texture { T_Wood19  rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
   translate .5*y
}

global_settings {
  assumed_gamma 1.0
  // used in global_settings, sets the maximum ray tracing intersection depth (1 or more) [64]
 max_intersections 100
 // used in global_settings, sets the maximum ray tracing bounce depth (1 or more) [5]
  max_trace_level 10
  


}

// ----------------------------------------

camera {
  location  <-20, 3, -10>
  //direction 1.5*z
  right     x*image_width/image_height
  look_at   <-5,5,0>
  //rotate 180*y
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

plane {
  y, 0
  texture { T_Wood1 rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
}


#declare hanoi = union {
cylinder {
  <0,0,0>,<0,8,0>, 1
  texture { T_Wood8 rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
}
cylinder {
  <-8,0,0>,<-8,8,0>, 1
  texture { T_Wood8 rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
}
cylinder {
  <8,0,0>,<8,8,0>, 1
  texture { T_Wood8 rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
}

cylinder {
  <0,8,0>,<0,8.3,0>, 1
  texture { T_Wood19 rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
}
cylinder {
  <-8,8,0>,<-8,8.3,0>, 1
  texture { T_Wood19 rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
}
cylinder {
  <8,8,0>,<8,8.3,0>, 1
  texture { T_Wood19 rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
}


object { Ring1 translate <-8,0,0> }
object { Ring2 translate <-8,1,0> }
object { Ring3 translate <-8,2,0> }
object { Ring4 translate < 0,0,0> }
object { Ring5 translate < 0,1,0> }
object { Ring6 translate < 8,0,0> }
object { Ring7 translate < 8,1,0> }
object { Ring8 translate < 8,2,0> }
}




      box { <-13,0,-5> <13,2,5>
         texture { T_Wood8 rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
      }
      
      union {
         box { <-13-.001,0+.001,-5-.001> <13+.001,.2+.001,-4.8-.001> }
         box { <-13-.001,0+.001,5+.001> <13+.001,.2+.001,4.8+.001> }
         box { <-13-.001,1.8+.001,-5-.001> <13+.001,2+.001,-4.8-.001> }
         box { <-13-.001,1.8+.001,5+.001> <13+.001,2+.001,4.8+.001> }
      
         box { <-13-.001,0+.001,-5-.001> <-12.8-.001,.2+.001,5+.001> }
         box { <-13-.001,1.8+.001,-5-.001> <-12.8-.001,2+.001,5+.001> }
         box { <13+.001,0+.001,-5-.001> <12.8+.001,.2+.001,5+.001> }
         box { <13+.001,1.8+.001,-5-.001> <12.8+.001,2+.001,5+.001> }
         
         box { <-13-.001,0+.001,-5-.001> <-12.8-.001,2+.001,-4.8-.001> }
         box { <-13-.001,0+.001,5+.001> <-12.8-.001,2+.001,4.8+.001> }
         box { <13+.001,0+.001,-5-.001> <12.8+.001,2+.001,-4.8-.001> }
         box { <13+.001,0+.001,5+.001> <12.8+.001,2+.001,4.8+.001> }
         
         texture { T_Wood19 rotate <360*rand(Seed),360*rand(Seed),360*rand(Seed)>}
      }
  
   
object { hanoi translate 2*y } 

// Create an infinite sphere around scene and allow any pigment on it
sky_sphere {
  pigment {
    gradient y
    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
  }
}

fog {
  fog_type   2
  distance   20
  color      rgb 1 // gray
  fog_offset 0.1
  fog_alt    0.2
  turbulence 0.8
}








