//  YOYOFLY.POV - Main file
//
//  Entry for IRTC contest sep/oct 2004 - Toys and Games
//  
//  Antonio Sanhueza Bahamonde
//
//  Date : 10/31/2004    (31.10.2004)
//
//Render with +KF1 +KFF3 +SF1 +EF1 
//

#version unofficial megapov 1.1;

//*****************************************************************************
//Settings

#declare con_yoyo = true;
#declare con_movimiento = true;
#declare con_fotones = true;                                                                               
#declare con_vidrio = true;
                                                                             
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 128
  max_trace_level 15
  number_of_waves 10
  noise_generator 2
  charset ascii   
  #if (con_fotones)
  photons {
        spacing 0.02
        autostop 0
        jitter 0
        max_trace_level 3
  }                
  #end
  #if (con_movimiento)
  motion_blur 6, 0.10 //0.1     //motion_blur SAMPLES, SHUTTER-TIME
  #end
}

//*****************************************************************************
//Includes

#include "colors.inc"
#include "glass.inc"
#include "skies.inc"
#include "logo.inc"

//*****************************************************************************
//Scene

camera {  //  Camera Camera01
  location  <     -7.160,      -6.951,      -7.371>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    0.74133,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         23.91881    // Vertical      31.892
  look_at   <     -0.886,      -0.007,      -1.290>
}

//*****************************************************************************
//Lights

light_source {   // Arealight Arealight002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.2000
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 2, 2
  adaptive 1
  orient
  circular
  fade_distance  20.0
  fade_power 2.0
  translate  <-3.319, -0.339, -10.64>
}


light_source {   // Arealight Arealight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  orient
  circular
  fade_distance  20.0
  fade_power 2.0
  translate  <3.266, -5.111, 8.859>  
  photons {reflection on refraction on}
}



//*****************************************************************************
//Textures

#include "yoyofly.inc"
  
//*****************************************************************************
//Objects  

#if (con_yoyo)
  
// Include file contains 'RotSweep001'
#include "yoyofly-mesh.inc"
#declare RotSweep001 = object {
  RotSweep001_Raw
  scale <1.0, 1.0, 0.8>
  translate  0.119*z
}          

#declare Tapa = union {
  disc { // Disc001
    <0,0,0>, <0,0,1>, 1.0
    scale <1.798, 1.798, 1.0>
    translate  0.60001*z
  }
  object { RotSweep001 }
  #if (con_vidrio)
    material { Glass  }
  #end
  photons { target reflection on refraction on }
}       

#declare Cuerpo = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <1.9300, 1.9300, 0.3000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <2.0000, 2.0000, 0.1600> translate 0.0700*z }
  torus { 1.9300, 0.0700  rotate -x*90 translate  0.2300*z bounded_by { box { <-2.0014, -2.0014, 0.1586>, <2.0014, 2.0014, 0.3014> } } }
  torus { 1.9300, 0.0700  rotate -x*90 translate  0.0700*z bounded_by { box { <-2.0014, -2.0014, -0.0014>, <2.0014, 2.0014, 0.1414> } } }
  material { Texture_Systo  }
  translate  0.3*z
}  

#declare Mitad1 = union {
  object { Tapa }
  object { Cuerpo }
  translate  -0.24*z
}   

#declare Letras = union {
  text {   // T_P
    ttf      "C:\WINDOWS\Fonts\Impact.ttf",  "P",  0.15,  <0.0,     0.0, 0.0> 
    translate  <-0.154, 0.761, 0.6>
  }

  text {   // T_O
    ttf      "C:\WINDOWS\Fonts\Impact.ttf",  "O",  0.15,  <0.0,     0.0, 0.0> 
    rotate -30.0*z
    translate  <0.175, 0.74, 0.6>
  }

  text {   // T_V
    ttf      "C:\WINDOWS\Fonts\Impact.ttf",  "V",  0.15,  <0.0,     0.0, 0.0> 
    rotate -60.0*z
    translate  <0.576, 0.586, 0.6>
  }

  text {   // T_guion
    ttf      "C:\WINDOWS\Fonts\Impact.ttf",  "-",  0.15,  <0.0,     0.0, 0.0> 
    rotate -90.0*z
    translate  <0.936, 0.144, 0.6>
  }

  text {   // T_R
    ttf      "C:\WINDOWS\Fonts\Impact.ttf",  "R",  0.15,  <0.0,     0.0, 0.0> 
    rotate -120.0*z
    translate  <0.829, -0.09, 0.6>
  }

  text {   // T_a
    ttf      "C:\WINDOWS\Fonts\Impact.ttf",  "a",  0.15,  <0.0,     0.0, 0.0> 
    rotate -150.0*z
    translate  <0.613, -0.584, 0.6>
  }

  text {   // T_y
    ttf      "C:\WINDOWS\Fonts\Impact.ttf",  "y",  0.15,  <0.0,     0.0, 0.0> 
    rotate 180.0*z
    translate  <0.252, -0.794, 0.6>
  }
  material { CromoLightTexture  }
  rotate 62.0*z
  translate  -0.04*z
}

#declare DiscoAdorno = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.2300, 1.2300, 0.1000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.1700, 1.1700, 0.1020> translate -0.0010*z }
  }                                           
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.2500, 1.2500, 0.0600> translate 0.0200*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.1500, 1.1500, 0.1020> translate -0.0190*z }
  }
  torus { 1.2300, 0.0200  rotate -x*90 translate  0.0800*z bounded_by { box { <-1.2504, -1.2504, 0.0596>, <1.2504, 1.2504, 0.1004> } } }
  torus { 1.2300, 0.0200  rotate -x*90 translate  0.0200*z bounded_by { box { <-1.2504, -1.2504, -0.0004>, <1.2504, 1.2504, 0.0404> } } }
  torus { 1.1700, 0.0200  rotate -x*90 translate  0.0800*z bounded_by { box { <-1.1904, -1.1904, 0.0596>, <1.1904, 1.1904, 0.1004> } } }
  torus { 1.1700, 0.0200  rotate -x*90 translate  0.0200*z bounded_by { box { <-1.1704, -1.1704, -0.0004>, <1.1704, 1.1704, 0.0204> } } }
  translate  0.6*z
}   

#declare Adorno = intersection {
  object { DiscoAdorno }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 0.2>
    rotate -27.0*z
    translate  <-0.655, -1.172, 0.585>
  }
  material { CromoLightTexture  }
}

#if (con_movimiento)
motion_blur {
  type 0            
    cylinder { // Cuerda
      <0,0,1>, <0,0,0>, 1 
      scale <0.03, 0.03, 50.0>
      material { Pitilla } 
      rotate -150*y
      translate <-25, 0, -43.3012702>
      rotate clock*y
      translate <25, 0, 43.3012702>
    }
}

#declare avance = 20;                        
       
motion_blur { 
  type 0
  union { // Yoyo
    object { Mitad1 }
    object { // Mitad2 -> Mitad1
      Mitad1
      scale -1.0
      rotate 180.0*z
    }
    object { Adorno }
    object { Letras }
    object { // Letras1 -> Letras
      Letras
      scale -1.0
    }          
    object {
     Povray_Logo
     translate <-0.1,-0.4,0.4>
     material { ChromeTexture }
    }  
    rotate 90*x
    matrix < cos(clock/180*pi)*cos(avance*clock/180*pi)-sin(clock/180*pi)*sin(avance*clock/180*pi), 0, cos(clock/180*pi)*sin(avance*clock/180*pi)+sin(clock/180*pi)*cos(avance*clock/180*pi), 
             0, 1, 0,
             -sin(clock/180*pi)*cos(avance*clock/180*pi)-cos(clock/180*pi)*sin(avance*clock/180*pi), 0, -sin(clock/180*pi)*sin(avance*clock/180*pi)+cos(clock/180*pi)*cos(avance*clock/180*pi),
             cos(clock/180*pi)*-25+sin(clock/180*pi)*-43.3012702 - -25, 0, -sin(clock/180*pi)*0+cos(clock/180*pi)*-43.3012702 - -43.3012702 >
  }
}
#else
  cylinder { // Cuerda
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 50.0>
    material { Pitilla } 
    rotate -150*y
    translate <-25, 0, -43.3012702>
    rotate clock*y
    translate <25, 0, 43.3012702>
  }  
                        
  #declare avance = 20;                        
                        
  union { // Yoyo
    object { Mitad1 }
    object { // Mitad2 -> Mitad1
      Mitad1
      scale -1.0
      rotate 180.0*z
    }
    object { Adorno }
    object { Letras }
    object { // Letras1 -> Letras
      Letras
      scale -1.0
    }          
    object {
     Povray_Logo
     translate <-0.1,-0.4,0.4>
     material { ChromeTexture }
    }  
    rotate 90*x
    matrix < cos(clock/180*pi)*cos(avance*clock/180*pi)-sin(clock/180*pi)*sin(avance*clock/180*pi), 0, cos(clock/180*pi)*sin(avance*clock/180*pi)+sin(clock/180*pi)*cos(avance*clock/180*pi), 
             0, 1, 0,
             -sin(clock/180*pi)*cos(avance*clock/180*pi)-cos(clock/180*pi)*sin(avance*clock/180*pi), 0, -sin(clock/180*pi)*sin(avance*clock/180*pi)+cos(clock/180*pi)*cos(avance*clock/180*pi),
             cos(clock/180*pi)*-25+sin(clock/180*pi)*-43.3012702 - -25, 0, -sin(clock/180*pi)*0+cos(clock/180*pi)*-43.3012702 - -43.3012702 >
  }   
#end        

#end


 sky_sphere { 
   S_Cloud2 
   //scale 0.1
   //rotate 90*x+20*y
   rotate 30*x
 }

object {  //floor
  disc { <0, 0, -20>  z, 40000 }
  texture { pigment { color rgb <0,0.6,0> } }
}                   

