#ifndef (I_MUSEUM_CORNELL)
#declare I_MUSEUM_CORNELL = 1;
///////////////////////////////////////////////////////////////////////////////
// POVRay SDL Include file
//
// IRTC Entry: Museum (The National Museum of Raytracing)
//
// Object: Cornell Box

// Necessary Include files

#declare DEBUG_OBJECT = 0;      // Set to 1 for a "debug" scene

#include "mjr_constants.inc"
#include "functions.inc"
#include "materials.inc"

#local obj = box { <-.5, 0, -.5>, <.5, 1, .5> }

#declare Cornell_Box = union
{
    box {<-10*cm-0.01*mm, 0, -10*cm>,<-10*cm-3*mm, 20*cm, 10*cm>}
    box {<-10*cm-3*mm, 0, 10*cm+0.01*mm>,<10*cm+3*mm, 20*cm, 10*cm+3*mm>}
    box {<10*cm+0.01*mm, 0, -10*cm>,<10*cm+3*mm, 20*cm, 10*cm>}
    box {<-10*cm-3*mm, -0.01*mm, -10*cm>, <10*cm+3*mm, -3*mm, 10*cm+3*mm> }

    difference
    {
        box {<-10*cm-3*mm, 20*cm+0.01*mm, -10*cm>, <10*cm+3*mm, 20*cm+3*mm, 10*cm+3*mm> }
        box {<-2*cm, 19.999*cm, -1.5*cm>, <2*cm, 20.001*cm+3*mm, 1.5*cm> }
    }
    
    // These are the thin layers of paint:
    union
    {
        box {<-10*cm-3*mm, 0, -10*cm>, <10*cm+3*mm, -0.01*mm, 10*cm+3*mm> }
        box {<-10*cm-3*mm, 0, 10*cm>,<10*cm+3*mm, 20*cm, 10*cm+0.01*mm>}

        difference
        {
            box {<-10*cm-3*mm, 20*cm, -10*cm>, <10*cm+3*mm, 20*cm+0.01*mm, 10*cm+3*mm> }
            box {<-2*cm, 19.999*cm, -1.5*cm>, <2*cm, 20.001*cm+3*mm, 1.5*cm> }
        }
        
        texture { T_OffWhiteFlatPaint }
    }
        
    box {
        <-10*cm, 0, -10*cm>,<-10*cm-0.01*mm, 20*cm, 10*cm>
        texture { T_RedFlatPaint } 
    }
    box {
        <10*cm, 0, -10*cm>,<10*cm+0.01*mm, 20*cm, 10*cm>
        texture { T_BlueFlatPaint }
    }
        
        
    // Box Contents, 2 simple boxes
    object {obj scale <4*cm, 7*cm, 4*cm> rotate y*28 translate <6.321*cm, 0, 2.98*cm> texture { T_OffWhiteFlatPaint }}
    object {obj scale <5*cm, 8*cm, 5*cm> rotate y*54 translate <-2.43897*cm, 0, -3.932847*cm> texture { T_OffWhiteFlatPaint }}
    
    translate y*2.9999*mm
    texture { T_BrownCardboard }
    //box {<-15*cm, 0, -15*cm>,<-15*cm+3*mm, 15*cm, 15*cm>}
}


// Camera & Setup for debugging
#if(DEBUG_OBJECT)

object { Cornell_Box rotate y*20}

camera { location -z*5.0*ft+y*2*ft+x*0*ft look_at y*10*cm  angle 14}

light_source { <10*ft, 8*ft, -10*ft> color rgb 1 }
light_source { <0*ft, -3*ft, -10*ft> color rgb 1 }

#end

#end

