#ifndef (I_MUSEUM_LAMP)
#declare I_MUSEM_LAMP = 1;
///////////////////////////////////////////////////////////////////////////////
// POVRay SDL Include file
//
// IRTC Entry: Museum (The National Museum of Raytracing)
//
// Object: Lamp

// Necessary Include files

#declare DEBUG_OBJECT = 0;      // Set to 1 for a "debug" scene

#include "mjr_constants.inc"
#include "functions.inc"
#include "materials.inc"

#local lamp_shape = 
union {

    sphere { <0, 0, 0>, 5*cm scale <1,0.5,1> translate y*15*cm }
    cylinder { <0, 0*cm, 0>, <0, 15*cm, 0>, 5*cm }
    torus { 5*cm, 3*cm translate y*3*cm }
    cone { <0, 5*cm, 0>, 5*cm+sqrt(pow(3*cm,2)-pow(2*cm,2)), <0, 8*cm, 0>, 5*cm }
    cylinder { <0, 3*cm, 0>, <0, 0, 0>, 8*cm } 
    
}

#local Nut =
difference
{
    intersection
    {
        cylinder { <0, 0, -0.75*cm>, <0, 0, 0.75*cm> 1*cm scale <1, .19, 1.01>}
        cylinder { <0, 0, -0.75*cm>, <0, 0, 0.75*cm> 1*cm scale <1, .19, 1.01> rotate y*(180/3)}
        cylinder { <0, 0, -0.75*cm>, <0, 0, 0.75*cm> 1*cm scale <1, .19, 1.01> rotate y*2*(180/3)}
        cylinder { <0, -0.125, 0>, <0, 0.125*cm, 0> 0.9*cm  rotate y*2*(180/3)}
        
    }
    
    cylinder { <0, 1*cm, 0>, <0, -1*cm, 0>, 0.5*cm }
}
    

#local Bolt = 
difference
{
    union {
        isosurface
        {
            function { f_helix1(x,y,z,1,50,0.5*mm,0.5*cm,1,0,45) }
            max_gradient 1
            contained_by { box { <-.5*cm-1*mm, 0, -.5*cm-1*mm>, <.5*cm+1*mm, 1*cm, .5*cm+1*mm> }  }
        }
        cylinder { <0, 0, 0>, <0, 1.0*cm, 0>, 0.5*cm }
    }
    cylinder { <0, 0, 0>, <0, 1.1*cm, 0>, 0.4*cm }
}

#local Switch =
union {
    cylinder { <0,0,0>, <0, 0.5*cm, 0>, 0.4*cm }
    cylinder { <0,0,0>, <0, 1.7*cm, 0>, 0.39*cm }
    
    #declare n = 0;
    
    #while(n < 30)
    
        cylinder { <0,0,-0.39*cm>, <0, 1.7*cm, -0.39*cm>, 0.03*cm rotate y*n*(360/30)}
        
        #declare n = n + 1;
    #end        
    
}
    

#local Light_Housing =
union
{
    difference
    {
        object { lamp_shape translate y*-7.5*cm }
        union { 
            object { lamp_shape translate y*-7.5*cm scale 0.97 } 
            cylinder { <0, -7.5*cm*0.8, 0>, <0, -7.5*cm-0.9, 0>, 8*cm*0.97} 
            
            #local n = 0;
            union
            {
                #while(n < 360)
                    union
                    {
                        cylinder { <0,13*cm,-5.5*cm>, <0,13*cm,4.5*cm>, 0.25*cm }
                        box { <-.25*cm,13*cm,-5.5*cm>, <.25*cm,10*cm,4.5*cm> }
                        cylinder { <0,10*cm,-5.5*cm>, <0,10*cm,4.5*cm>, 0.25*cm }
                        
                        bounded_by { box { <-.27*cm,14*cm,-6.5*cm>, <.27*cm,9*cm,3.5*cm> } }

                                        
                        rotate y*n
                     }                        
                    #declare n = n + 360/20;
                #end
                translate y*-7.5
            }            
        }
    
        translate y*7.5*cm
        
        material { M_WhiteEnamel }
    }
   light_source { <0, 7.5*cm, 0>, color rgb 2 
    area_light x*5*cm,y*5*cm,6,6 adaptive 3 jitter circular orient 
    spotlight point_at <0, -1, 0>
    
   }

    object { Bolt translate y*17.0*cm material { M_Steel }}
    object { Nut translate y*17.6*cm material { M_Steel }}
    object { Switch translate y*17.5*cm material { M_BlackPlastic} }
    bounded_by { box { <-8*cm, 0, -8*cm>, <8*cm, 19*cm, 8*cm> } }
}
    
#local Cable_Track = 
union
{
    #declare n = 0;
    
    #while(n < 88)
        
        intersection 
        {
            cylinder { <0, -.25*cm, 0>, <0, .25*cm, 0>, 1.5*cm}
            sphere { <0, 0, 0>, 1*cm }
            translate y*n*.25*cm
         }
        
        #declare n = n + 1;
    #end
    
    #declare n = 0;
    #while(n < 20)
        
        intersection 
        {
            cylinder { <0.25*cm, 32*cm, 0>, <-0.25*cm, 32*cm, 0>, 1.5*cm}
            sphere { <0, 32*cm, 0>, 1*cm }
            translate x*(n*.25*cm-14*cm)
         }
        
        #declare n = n + 1;
    #end
        
    #declare n = 0;
    union
    {
        #while(n < 60)
            intersection
            {
                plane{-y,0.25*cm rotate 0*90/60*z}
                plane{y,0 rotate (1)*90/60*z}
                sphere{<10*cm,0,0>,1*cm} 
                //translate x*10*cm
                rotate n*90/60*z
            }
            #declare n = n + 1;
        #end
        translate <-10*cm, 22.00*cm, 0>
    }
    
}

#local Base = 
union
{
    sphere { <0, 0, 0>, 1 scale <8*cm, 1*cm, 8*cm> translate y*1*cm}
    cylinder { <0, 0, 0>, <0, 1*cm, 0>, 8*cm }
}

#declare Cornell_Lamp = 
union
{
    object{ Light_Housing  scale 0.75 translate <-17.75*cm, 21.5*cm, 0>}
    object{ Cable_Track material { M_Crome} }
    object{ Base material { M_WhiteEnamel} }
}

// Camera & Setup for debugging
#if(DEBUG_OBJECT)

object { Cornell_Lamp translate x*10 rotate x*-00 }

camera { location -z*1.1*ft+y*30*cm look_at y*10*cm  angle 60

    blur_samples 25
    focal_point y*10*cm+x*10+z*-10
    aperture 3
    confidence 0.999999
    variance 1/256


}

light_source { <10*ft, 8*ft, -10*ft> color rgb 1 }
light_source { <0*ft, 3*ft, -15*ft> color rgb .5 }

#end

#end

