#ifndef (I_MUSEUM_MATERIALS)
#declare I_MUSEUM_MATERIALS = 1;
///////////////////////////////////////////////////////////////////////////////
// POVRay SDL Include file
//
// IRTC Entry: Museum (The National Museum of Raytracing)
//
// Object: Cornell Box

// Necessary Include files

#declare DEBUG_MATERIALS = 0;      // Set to 1 for a "debug" scene
#declare ALTERNATE_OBJECT = 0;

default {finish { ambient 0 diffuse 0.7 }}

#if(DEBUG_MATERIALS)


global_settings
{
    radiosity { }
}

#end

#include "mjr_constants.inc"
#include "functions.inc"

#declare F_Flat = 
finish { 
    diffuse 1 
}


#declare T_RedFlatPaint =
texture
{
    pigment { color rgb <1, 0.2, 0.3> }
    finish { F_Flat }
}

#declare T_BlueFlatPaint = 
texture
{
    pigment { color rgb <0.2, 0.5, 1> }
    finish { F_Flat }
}

#declare T_BlackFlatPaint = 
texture
{
    pigment { color rgb <0.1, 0.02, 0.01> }
    finish { F_Flat }
}


#declare T_OffWhiteFlatPaint = 
texture
{
    pigment { color rgb <1,0.98,0.92> }
    finish { F_Flat }
}

#declare T_BrownCardboard = 
texture
{
    pigment { 
        granite 
        
        color_map
        {
            [0 color rgb <0.5, 0.4, 0.3>]
            [1 color rgb <0.7, 0.6, 0.5>]
        }
        scale 0.01
            
    }

    finish
    {
        diffuse 0.8
    }
}

#declare C_DarkWood = 
color_map
{
    [0.00 rgb <0.30,0.05,0.12>]
    [0.30 rgb <0.40,0.10,0.02>]
    [1.00 rgb <0.50,0.20,0.12>]
}

#declare C_LightWood = 
color_map
{
    [0.00 rgb <0.6,0.3,0.05>]
    [0.50 rgb <0.7,0.4,0.10>]
    [1.00 rgb <0.8,0.45,0.10>]
}

#declare F_Varnished = 
finish {
    specular 0.8 roughness 0.001
    reflection {0.1, 0.7 fresnel on } 
}

#declare T_DarkWood =
texture {
    pigment { wood 
    
        turbulence 0.07

        color_map { C_DarkWood }
    
        scale .05
        rotate x*-2
    }
    
    finish { F_Varnished }
}

#declare T_LightWood =
texture {
    pigment { wood 
    
        turbulence 0.07

        color_map { C_LightWood }
    
        scale .05
        rotate x*-2
    }
    
    finish { F_Varnished }
}

#declare M_WhiteEnamel = 
material 
{
    texture {
        pigment { color rgb 1 }
        finish { 
            reflection { 0.1, 0.5 fresnel on }
            specular 0.5 
            diffuse 0.7
            roughness 0.0001
            conserve_energy
        }
    }
            
    interior {
        ior 1.5
    }
}

#declare T_BlackEnamel = 
texture {
    pigment { color rgb <0.1, 0.02, 0.01> }
    finish { 
        reflection { 0.1, 0.5 fresnel on }
        specular 0.5 
        diffuse 0.7
        roughness 0.0001
        conserve_energy
    }
}

#declare M_BlackPlastic = 
material 
{
    texture {
        pigment { color rgb <0.02, 0.01, 0.001> }
        finish { 
            reflection { 0.1, 1 fresnel on }
            specular 0.8 
            diffuse 0.8
            roughness 0.001
            conserve_energy
        }
    }
            
    interior {
        ior 1.5
    }
}

#declare M_BrownPlastic = 
material 
{
    texture {
        pigment { color rgb <0.2, 0.1, 0.01> }
        finish { 
            reflection { 0.1, 1 fresnel on }
            specular 0.8 
            diffuse 0.8
            roughness 0.001
            conserve_energy
        }
    }
            
    interior {
        ior 1.5
    }
}

#declare M_Crome = 
material 
{
    texture {
        pigment { color rgb <1, 1, 0.98> }
        finish { 
            reflection { 1, 1 metallic}
            specular 0.8 
            diffuse 0.1
            roughness 0.001
            conserve_energy
            metallic
        }
        normal
        {
            bozo turbulence 1 scale <0.1, 0.1, 0.1>
            
            normal_map
            {
                [0.0 granite 0]
                [0.1 granite 0]
                [1.0 granite 0.1 scale <.01, .01, .01>]
            }
        }
    }
            
    interior {
        ior 1.5
    }
}

#declare M_Steel = 
material 
{
    texture {
        pigment { color rgb <1, 0.95, 0.80> }
        finish { 
            reflection { 1, 1 metallic}
            specular 0.8 
            diffuse 0.0
            roughness 0.001
            conserve_energy
            metallic
        }
        normal
        {
            granite 0.2 scale 0.01
        }
    }
            
    interior {
        ior 1.5
    }
}

#declare C_Brass = rgb <1, 0.95, 0.30> ;

#declare M_BrassMachined = 
material 
{
    texture {
        pigment { color C_Brass }
        finish { 
            reflection { 1, 1 metallic}
            specular 1 
            diffuse 0.01
            roughness 0.001
            conserve_energy
            metallic
        }
        normal
        {
            bozo 0.0001 scale <100, .0005, 100>
        }
    }
            
    interior {
        ior 1.5
    }
}

#declare M_Brass= 
material 
{
    texture {
        pigment { color C_Brass }
        finish { 
            reflection { 1, 1 metallic}
            specular 1 
            diffuse 0.01
            roughness 0.001
            conserve_energy
            metallic
        }
        normal
        {
            bozo 0.000001 scale <10, .0005, 10>
        }
       
    }
            
    interior {
        ior 1.5
    }
}

// Camera & Setup for debugging
#if(DEBUG_MATERIALS)

#if(!ALTERNATE_OBJECT)

#declare dbg_mat = 
material
{ 
    M_Brass
   //texture { T_BlackFlatPaint }
    //interior
    //{
     //   ior 1.5 
    //}
}


box { <-1, -2, -1>, <1, 0, 1> 
    material { dbg_mat rotate x*0 translate y*-1}
    rotate y*29
}

sphere { <0, 1, 0>, 1 
    material { dbg_mat translate y*3}
    rotate y*29
}

plane { y, -2 
    pigment { checker  rgb <0.5, 0.7, 1>*.5 rgb  <0.5, 0.7, 1>*1 }
}
light_source { <10*ft, 8*ft, -10*ft> color rgb 1 }
light_source { <0*ft, -3*ft, -10*ft> color rgb 1 }


#else
plane { y, 0 
    pigment { checker  rgb <0.5, 0.7, 1>*.5 rgb  <0.5, 0.7, 1>*1 }
}
#end



background { color rgb <0.4, 0.41, 0.42> }

camera { location -z*1*ft+y*.25*ft+x*0*ft look_at 0  angle 10
    blur_samples 256
    focal_point 0
    aperture 0.01

}

#end

#end

