#ifndef (I_MUSEUM_PEDISTAL)
#declare I_MUSEUM_PEDISTAL = 1;
///////////////////////////////////////////////////////////////////////////////
// POVRay SDL Include file
//
// IRTC Entry: Museum (The National Museum of Raytracing)
//
// Object: Pedistal

// Necessary Include files

#declare DEBUG_OBJECT = 0;      // Set to 1 for a "debug" scene

#include "mjr_constants.inc"
#include "functions.inc"
#include "materials.inc"

#local Top_Board = 
difference
{
    box { <8*in, -1*in, 2*in>, <-8*in, 0, 0*in> }
    plane {-x,0 rotate y*-45 translate x*8*in}
    plane {x,0 rotate y*45 translate -x*8*in}
    
    texture { T_LightWood scale 1*in rotate y*90 translate z*1*in+y*-1*in} 
    
    translate z*-2*in
}

#local side = 2*in*cos(radians(45));
#local top = 2*in*sin(radians(45));

#local Top_Base_Board=
difference
{
    box { <6*in, -2*in, 1*in>,<-6*in,2*in,0*in> rotate -x*45 }
   
    plane { -y,-top }
    plane { -z,-side }
    plane {-x,0 rotate y*-45 translate z*-side translate x*6*in}
    plane {x,0 rotate y*45 translate z*-side translate -x*6*in}

    texture { T_DarkWood scale 1*in rotate <90,0,90> translate z*-2*in rotate -x*45}
    
    translate z*side
    translate y*-top
    
}

#local Top_Base =
union
{
    object {Top_Base_Board translate z*-6.01*in}
    object {Top_Base_Board rotate y*180 translate z*6.01*in}
    object {Top_Base_Board rotate y*90 translate x*-6.01*in}
    object {Top_Base_Board rotate y*-90 translate x*6.01*in}
}   

//box { <6*in, -2*in, 1*in>,<-6*in,2*in,0*in> rotate -x*45 pigment { color red 1}rotate y*00}

#local side_len = sin(radians(45))*(6*in);

#local Top_Wedge =
intersection 
{
  box { <-6*in, -1*in, 0*in>, <6*in, 0, 6*in> }
  box { <side_len, -1*in, side_len>, <-side_len, 0.1, -side_len> rotate y*45 translate z*6*in}
  texture { T_DarkWood scale 2*in translate y*-.1*in}
}
 

#local Pedistal_Top =
union {
    object { Top_Board translate z*-6.01*in}
    object { Top_Board rotate y*180 translate z*6.01*in}
    object { Top_Board rotate y*90 translate x*-6.01*in}
    object { Top_Board rotate y*-90 translate x*6.01*in}
    object { Top_Base  translate y*-1*in}
    
    union
    {
        object { Top_Wedge }
        object { Top_Wedge rotate y*90}
        object { Top_Wedge rotate y*180}
        object { Top_Wedge rotate y*-90}
    }
}

#local Pedistal_Column = 
union
{
    box { <-(6*in - side*2), -1*in, -(6*in -  side*2)>, <(6*in -  side*2), -4*ft, 6*in -  side*2> texture { T_DarkWood scale 1*in rotate x*90 }}
    object { Top_Base rotate x*180 translate y*-4*ft }
    box { <-8*in, -4*ft, -8*in>, <8*in, -(4*ft+1*in), 8*in> texture { T_LightWood rotate y*90 scale 1*in} }
}

#declare Pedistal = 
union {
    object {Pedistal_Top}
    object {Pedistal_Column}
}    

// Camera & Setup for debugging
#if(DEBUG_OBJECT)

object {Pedistal translate y*4*ft+1*in rotate x*00 pigment { color rgb 1.0 }}

camera { location -z*18.0*ft+y*7*ft+x*2*ft look_at y*4*ft  angle 36}

light_source { <10*ft, 8*ft, -10*ft> color rgb 1 }
light_source { <0*ft, 12*ft, -10*ft> color rgb 1 }

#end

#end

