#ifndef (I_MUSEUM_PICTUREFRAME)
#declare I_MUSEUM_PICTUREFRAME = 1;
///////////////////////////////////////////////////////////////////////////////
// POVRay SDL Include file
//
// IRTC Entry: Museum (The National Museum of Raytracing)
//
// Object: Picture Frame

// Necessary Include files

#declare DEBUG_OBJECT = 1;      // Set to 1 for a "debug" scene

#include "mjr_constants.inc"
#include "functions.inc"
#include "materials.inc"

#declare Moulding =
difference
{
    union
    {
        difference 
        {
            union
            {
                cylinder { <0, 0, 0>, <0, 0, 1>, 1*cm }
                box { <0, 1*cm, 0>, <1.5*cm, 0, 1> }
                cylinder { <1.5*cm, -1*cm, 0>, <1.5*cm, -1*cm, 1>, 2*cm }
                box { <2*cm, 0.5*cm, 0>, <3.5*cm,0, 1> } 
                cylinder { <4*cm, 0, 0>, <4*cm, 0, 1>, 1*cm }
                cylinder { <4.5*cm, -1*cm, 0>, <4.5*cm, -1*cm, 1>, 2*cm }
                cylinder { <6.3*cm, 0, 0>, <6.3*cm, 0, 1>, 0.25*cm }
            }
            union
            {
                box { <-1*cm, 0, -0.001>, <6.6*cm, -10*cm, 1.001> }
                cylinder { <2.97*cm, 0.65*cm, -0.001>, <2.97*cm, 0.65*cm, 1.001>, .2*cm  }
            }
        }
        box { <-1*cm, 0, 0>, <6.55*cm, -1*cm, 1> }
        translate -x*6.55*cm
        rotate -z*8
    }
    box { <-1.5*cm, 0.15*cm, -0.001>, <6.6*cm, -10*cm, 1.001> translate -x*6.6*cm}
    texture { T_LightWood }
}
    
#macro Picture_Frame(w,h)

#local Cut_W_Moulding = 
difference 
{
    object { Moulding translate z*-0.5 scale z*(w+6.55*cm*2.25) }
    plane { z,0 rotate -45*y translate z*-w/2 }
    plane { -z,0 rotate 45*y translate z*w/2 }
}
    
#local Cut_H_Moulding =
difference 
{
    object { Moulding translate z*-0.5 scale z*(h+6.55*cm*2.25) }
    plane { z,0 rotate -45*y translate z*-h/2 }
    plane { -z,0 rotate 45*y translate z*h/2 }
}

union
{
    //object { Moulding translate z*-0.5 scale z*(w+6.55*cm*2.25)  translate x*(-h/2) rotate y*90 }
    //object { Moulding translate z*-0.5 scale z*(w+6.55*cm*2.25)  translate x*(-h/2) rotate y*-90}

    //object { Moulding translate z*-0.5 scale z*(h+6.55*cm*2.25)  translate x*(-w/2) rotate y*180 }
    //object { Moulding translate z*-0.5 scale z*(h+6.55*cm*2.25)  translate x*(-w/2) rotate y*0}

    object { Cut_W_Moulding translate x*(-h/2-0.01*in) rotate y*90 }
    object { Cut_W_Moulding translate x*(-h/2-0.01*in) rotate y*-90}

    object { Cut_H_Moulding translate x*(-w/2-0.01*in) rotate y*180 }
    object { Cut_H_Moulding translate x*(-w/2-0.01*in) rotate y*0}

    
    rotate x*-90
    
}
#end 


// Camera & Setup for debugging
#if(DEBUG_OBJECT)

object { Picture_Frame(3*ft,4*ft) rotate x*0}

camera { location -z*10.0*ft+y*0*ft+x*0*ft look_at 0  angle 34}

light_source { <10*ft, 8*ft, -10*ft> color rgb 1 }
light_source { <0*ft, -3*ft, -10*ft> color rgb 1 }

#end

#end

