#ifndef (I_MUSEUM_PLAQUE)
#declare I_MUSEUM_PLAQUE = 1;
///////////////////////////////////////////////////////////////////////////////
// POVRay SDL Include file
//
// IRTC Entry: Museum (The National Museum of Raytracing)
//
// Object: Picture Frame

// Necessary Include files

#declare DEBUG_OBJECT = 0;      // Set to 1 for a "debug" scene

#include "mjr_constants.inc"
#include "functions.inc"
#include "materials.inc"

#macro Plaque(txt,fnt)
    #local o_tx = text { ttf fnt txt 1,0 translate z*-1 material { M_BrassMachined }}
    #local o_tx_size = max_extent(o_tx)-min_extent(o_tx);

    difference
    {
        box { <-0.75*cm, -0.75*cm, 1*mm>, <o_tx_size.x+0.75*cm, o_tx_size.y+0.75*cm, 0> }
            
        object { o_tx translate z*0.5*mm}
        
        cylinder { <-0.75*cm, -0.75*cm, 1.1*mm>, <-0.75*cm, -0.75*cm, -0.1*mm>, 0.5*cm }
        cylinder { <-0.75*cm, o_tx_size.y+0.75*cm, 1.1*mm>, <-0.75*cm, o_tx_size.y+0.75*cm, -0.1*mm>, 0.5*cm }
        cylinder { <o_tx_size.x+0.75*cm, -0.75*cm, 1.1*mm>, <o_tx_size.x+0.75*cm, -0.75*cm, -0.1*mm>, 0.5*cm }
        cylinder { <o_tx_size.x+0.75*cm, o_tx_size.y+0.75*cm, 1.1*mm>, <o_tx_size.x+0.75*cm, o_tx_size.y+0.75*cm, -0.1*mm>, 0.5*cm }
        
        translate -x*o_tx_size.x/2
        
        material { M_Brass }
        
    }

#end

// Camera & Setup for debugging
#if(DEBUG_OBJECT)

box { <-5*cm, 7*cm, 1*mm>, <5*cm, 13*cm, 2*in> texture { T_DarkWood scale 1 rotate x*90 rotate z*90 translate <0, 10*cm, 2*in>} }
object { Plaque("The Wet Bird", "georgiab.ttf") translate y*10*cm rotate y*00}

camera { location <0, 10*cm, -1*ft> look_at y*10*cm  angle 21
 blur_samples 256
    focal_point <0, 10*cm, 0>
    aperture 2
    confidence 0.999999
    variance 1/256
}

light_source { <10*ft, 8*ft, -10*ft> color rgb .5 }
light_source { <-1*ft, 1*ft, -.3*ft> color rgb 2 }

#end

#end

