#ifndef (I_MUSEUM_ROOM)
#declare I_MUSEUM_ROOM = 1
;///////////////////////////////////////////////////////////////////////////////
// POVRay SDL Include file
//
// IRTC Entry: Museum (The National Museum of Raytracing)
//
// The Room. 
//
// This is the room where the exhibits will be kept. The exhibits, camera and other objects will not be kept here.

// Necessary Include Files
#include "mjr_constants.inc"
#include "materials.inc"

// Floor

#declare DEBUG_OBJECT = 0;
#declare ALTERNATE_CAMERA = 0;
#declare ROOM_LIGHT = 0;
#ifndef(SEE_LAYOUT) #declare SEE_LAYOUT = 0;#end

#macro baseboard(s, e)

    union
    {
         cylinder { <s,2*in,0>, <e,2*in,0>, 0.5*in }
         box { <s,2*in,0>, <e,0,-.5*in> }
    }

#end

global_settings
{


}
#if (SEE_LAYOUT)
    
    default { finish { ambient 1.0 } }
    
#else

    default { finish { ambient 0.0 } }

#end

#local f1 = pigment {
    gradient z
        color_map
        {
            [0.0  rgb 0]
            [1-((.75*in)/(2*ft)) rgb 0]
            [1-((.75*in)/(2*ft)) rgb 1]
            [1.0 rgb 1]
        }
 }

#local f3 = pigment {
    gradient z
        color_map
        {
            [0.0  rgb 0]
            [1-((.25*in)/(18*in)) rgb 0]
            [1-((.25*in)/(18*in)) rgb 1]
            [1.0 rgb 1]
        }
 }

#local f2 = pigment {
    gradient x
        color_map
        {
            [0.0  rgb 0]
            [1-((.75*in)/(4*ft)) rgb 0]
            [1-((.75*in)/(4*ft)) rgb 1]
            [1.0 rgb 1]
        }
    scale 2
}

#local f4 = pigment {
    gradient x
        color_map
        {
            [0.0  rgb 0]
            [1-((.25*in)/(18*in)) rgb 0]
            [1-((.25*in)/(18*in)) rgb 1]
            [1.0 rgb 1]
        }
}

#local P_Tiles = function {  
    pigment
    {
        average
        
        pigment_map
        {
         [1 f1]
         [1 f2]
        }
    }
}

#local P_Tiles2 = function {  
    pigment
    {
        average
        
        pigment_map
        {
         [1 f3]
         [1 f4]
        }
    }
}


  
    
#local gb =
pigment
{
    granite
    
    color_map
    {
        [0 rgb <0.01, 0.1, 0.01>]
        [1 rgb <0.9, 0.9, 0.9>]
    }
    
    scale 0.25
}

#local rs = seed(1);

#local g1 = pigment { gb translate <rand(rs)*1,rand(rs)*1,rand(rs)*1> rotate y*90}
#local g2 = pigment { gb translate <rand(rs)*1,rand(rs)*1,rand(rs)*1> }
#local g3 = pigment { gb translate <rand(rs)*1,rand(rs)*1,rand(rs)*1> rotate y*90}
#local g4 = pigment { gb translate <rand(rs)*1,rand(rs)*1,rand(rs)*1> }
#local g5 = pigment { gb translate <rand(rs)*1,rand(rs)*1,rand(rs)*1> }
#local g6 = pigment { gb translate <rand(rs)*1,rand(rs)*1,rand(rs)*1> }
#local g7 = pigment { gb translate <rand(rs)*1,rand(rs)*1,rand(rs)*1> rotate y*90}
#local g8 = pigment { gb translate <rand(rs)*1,rand(rs)*1,rand(rs)*1> rotate y*90}
#local g9 = pigment { gb translate <rand(rs)*1,rand(rs)*1,rand(rs)*1> }
#local g10 = pigment { gb translate <rand(rs)*1,rand(rs)*1,rand(rs)*1> rotate y*90}

#local p_black =
pigment {
color rgb 0
    
}

        #local p_stones = pigment 
            {
                cells
                pigment_map
                {
                    [0.0 g1]
                    [0.1 g1]
                    [0.1 g2]
                    [0.2 g2]
                    [0.2 g3]
                    [0.3 g3]
                    [0.3 g4]
                    [0.4 g4]
                    [0.4 g5]
                    [0.5 g5]
                    [0.5 g6]
                    [0.6 g6]
                    [0.6 g7]
                    [0.7 g7]
                    [0.7 g8]
                    [0.8 g8]
                    [0.8 g9]
                    [0.9 g9]
                    [0.9 g10]
                    [1.0 g10]
                }
           
            //scale 18*in 
            }

plane { y,0 
    material
    {

        texture
        {
         
        pigment 
        { 
            function { P_Tiles2(x,y,z).x }  scale 18*in  
            pigment_map
            {
                [0.0  p_stones]
                [0.25 p_stones]
                [0.25 p_black]
                [1    p_black]
            }
        }           
            finish
            {
                reflection {0.1, 0.5 fresnel on }
            }
        }
        interior { ior 1.5 }    
    }
}
    
#local Ceiling = 
box 
{
    <-5*in, 12*ft, 20*ft-16.5*ft-5*in>, <25*ft+5*in, 12*ft+5*in, 20*ft+5*in> 
    
    texture { function { P_Tiles(x,y,z).x }  scale 2*ft  
        texture_map
        {
            [0.0  T_BlackFlatPaint]
            [0.25 T_BlackFlatPaint]
            [0.25 T_BlackEnamel]
            [1    T_BlackEnamel]
        }
    }
    
}

#local Walls = union
{
    box { <-5*in, 0, 20*ft>, <25*ft, 12*ft, 20*ft+5*in> } 
    box { <-5*in, 0, 20*ft-16.5*ft>, <0*ft, 12*ft, 20*ft> } 
    box { <25*ft, 0, 20*ft-16.5*ft>, <25*ft+6*in, 12*ft, 20*ft+5*in> } 

    box { <4*ft, 0, 20*ft-16.5*ft>, <21*ft, 12*ft, 20*ft-16.5*ft-5*in>} 
    
    box { <-5*in, 7*ft, 20*ft-16.5*ft>, <4*ft, 12*ft, 20*ft-16.5*ft-5*in>} 
    box { <21*ft, 7*ft, 20*ft-16.5*ft>, <25*ft+5*in, 12*ft, 20*ft-16.5*ft-5*in>} 
    
    box { <-5*in, 0*ft, 20*ft-16.5*ft>, <0, 12*ft, 20*ft-16.5*ft-5*in>} 
    box { <25*ft, 0*ft, 20*ft-16.5*ft>, <25*ft+5*in, 12*ft, 20*ft-16.5*ft-5*in>} 
    
    material
    {
        texture
        {
            T_OffWhiteFlatPaint
            
            normal
            {
                agate 0.05
                scale 2
            }
        }
        interior
        {
            ior 1.5
        }   
    }
}

#declare Room = 
union
{
    object {Ceiling }
    object {Walls}

    object { baseboard(0,25*ft) texture { T_DarkWood } translate z*20*ft}
    object { baseboard(-4*ft,-21*ft) texture { T_DarkWood } rotate y*180 translate z*(20*ft-16.5*ft)}
    object { baseboard(-20*ft+16.5*ft+5*in,-20*ft) texture { T_DarkWood } rotate y*90 translate x*25*ft}
    object { baseboard(20*ft-16.5*ft-5*in,20*ft) texture { T_DarkWood } rotate y*-90 translate x*0*ft}
}
    
#if(DEBUG_OBJECT)

    #if(SEE_LAYOUT)
    camera 
    { 
        orthographic
        location <10*ft*(4/3),13*ft,10.5*ft> 
        direction <0, -1, 0>
        up <0, 0, 21*ft>
        right <21*ft*(4/3), 0, 0>
    }
    #else

    global_settings
    {
        radiosity
        {
        }
    }
        
    
    // Hint: This will likely be the camera used in the scene!
    #if(ALTERNATE_CAMERA=0)
    camera
    {
        location <3*ft,5*ft+11*in,4.51*ft>
        look_at <12.5*ft, 5*ft, 20*ft>
        right x*(image_width/image_height)
    }
    #else
    camera
    {
        location <13*ft,5*ft+11*in,15.51*ft>
        look_at <0*ft, 0*ft, 10*ft>
        right x*(image_width/image_height)
    }

    #end
    
    //light_source { <0,20*ft,0> rgb 1 }    
    #if(ROOM_LIGHT)
       light_source { <12.5*ft,5.9999*ft,5*ft> rgb .5}    
    #end
    #end
        

#end

#end