#include "room.inc"
#include "pedistal.inc"
#include "track_lights.inc"
#include "pictureframe.inc"
#include "cornell.inc"
#include "lamp.inc"
#include "plaque.inc"

camera
{
    location <3*ft,5*ft+11*in,4.51*ft>
    look_at <12.5*ft, 7*ft, 13*ft>
    angle 50
    
    focal_point <12.5*ft, 7*ft, 13*ft>
    blur_samples 1024
    confidence .99
    variance 1/256
    aperture 0.01
    
    //look_at <8*ft+4*ft, 4*ft+1*in, 20*ft-1*ft> 
    //angle 5    
    right x*(image_width/image_height)
    
}

global_settings
{
    radiosity
    {
        pretrace_start 0.05
        pretrace_end 0.005
        count 100
        low_error_factor 0.5
        error_bound 0.1
        nearest_count 20
        minimum_reuse 0.001
        normal on
    }
    assumed_gamma 2.2
}

object { Room }

union
{
    object { Pedistal }
    object { Plaque("Reflective Sphere Over Checkered Plane", "georgiab.ttf")  scale <.35*in,.35*in,1> translate <0, -.55*in, -9*in> }
    
    sphere { <0, 3*in+3*mm, 0>, 3*in material { M_Crome } }
    box { <-6*in, 0, -6*in>, <6*in, 3*mm, 6*in> 
        material
        {
            texture
            {
                pigment { checker color rgb <0.2, 0.5, 1>*.5 color rgb <1, 0.2, 0.3>*.5 }
                finish { F_Varnished }
                scale 1*in
            }
            
            interior
            {
                ior 1.5 
            }
         }
    }
    
    
    translate <8*ft+4*ft, 4*ft+1*in, 20*ft-1*ft> 
}

union
{

    julia_fractal
    {
        <-0.083,0.0,-0.83,-0.025>
        quaternion
        sqr
        max_iteration 8
        precision 40
        material { M_Steel }
        translate y*1
        scale 4*in
        rotate y*45
    }
        

    object { Pedistal }
    object { Plaque("Julia Fractal", "georgiab.ttf")  scale <.35*in,.35*in,1> translate <0, -.55*in, -9*in> }
    translate <8*ft+8*ft, 4*ft+1*in, 20*ft-1*ft> 
}

union
{

    object { Cornell_Box rotate y*30 translate <-2.5*in,0, 3*in> }
    object { Cornell_Lamp translate <5*in, 0, 3*in> rotate y*10}
    object { Pedistal }
    object { Plaque("Cornell Box", "georgiab.ttf")  scale <.35*in,.35*in,1> translate <0, -.55*in, -9*in> }
    translate <8*ft+12*ft, 4*ft+1*in, 20*ft-1*ft> 
}

union
{
    box { <0, 0, 0>, <1, 1, 0.0000001> 
        pigment { image_map { jpeg "mouille_big.jpg" interpolate 2 } }
        scale <.65, 1, 1> 
        scale 7*ft
    }
    
    object { Picture_Frame(7*ft*0.65, 7*ft*1) translate <7*ft*0.65*0.5, 7*ft*1*0.5, 0> }
    
    object { Plaque("The Wet Bird", "georgiab.ttf") scale 2*in translate <7*ft*0.65*0.5, -9*in,0> }
    
    rotate y*90
    translate <25*ft-.0001, 4*ft, 17*ft>   
}

intersection
{
    text 
    {
        ttf "arialbd.ttf" "Raytracing History"  2 0
        material { M_Steel }
        //translate z*-1
        scale 1*ft
    }
    plane { z, 1*in pigment { rgb <0.05, 0.3, 1.0> } finish { ambient 2 }}
    translate <12*ft,8*ft,20*ft-3.5*in>
}

///////////////////////////////////////////////////////////////////////////////
// Lighting
union 
{
    object { lighting_track(16*ft) }
    object { track_lamp(65,50,10,15,60) translate x*-4*ft }
    object { track_lamp(65,55,10,15,60) translate x*0*ft }
    object { track_lamp(65,55,10,15,60) translate x*4*ft }
    object { track_lamp(34,110,30,45,10) translate x*8*ft }
    translate <13*ft, 11.92*ft, 16.5*ft>
}


light_source { <3*ft, 5*ft+11*in, 4.51*ft> color rgb .2 }