#ifndef (I_MUSEUM_TRACKLIGHTS)
#declare I_MUSEM_TRACKLIGHTS = 1;
///////////////////////////////////////////////////////////////////////////////
// POVRay SDL Include file
//
// IRTC Entry: Museum (The National Museum of Raytracing)
//
// Object: Track Lighting

// Necessary Include files

#declare DEBUG_OBJECT = 0;      // Set to 1 for a "debug" scene

#include "mjr_constants.inc"
#include "functions.inc"
#include "Materials.inc"

#macro track_lamp(xdeg,ydeg,r,f,ti)

#local light_shell =
difference 
{
    intersection
    {
        sphere {<0, 0, 0>, 1 scale <15*cm,5*cm,5*cm>}
        plane { -x,0 }
        texture { T_BlackFlatPaint }
    }
    
    light_source { <0, 0, 0 > color rgb 2 spotlight
        radius r falloff f tightness ti point_at <-1, 0, 0>
        area_light x*10*cm, y*10*cm, 6, 6 jitter adaptive 3 circular orient
    }
    sphere {<0, 0, 0>, 1 scale <15*cm-3*mm,5*cm-3*mm,5*cm-3*mm> material { M_WhiteEnamel} }
}

#local hanger_base = 
difference
{
    union
    {
        sphere { <0, 2*cm, 0>, 0.5*cm }
        cylinder { <0, 0, 0>, <0, 2*cm, 0>, 0.5*cm }
    }
    
    box { <-1*mm,2.6*cm, -.6*cm>, <1*mm, 1.75*cm,.6*cm> }
    
    translate y*-2*cm
    material { M_Steel }
}
    
#local articulator =
difference 
{
    union
    {
        box { <-.8*mm, 0, -0.5*cm>, <.8*mm, 1.5*cm, 0.5*cm> }
        cylinder { <-.8*mm, 0, 0>, <.8*mm, 0, 0>, 0.5*cm }
    }
    
    cylinder { <-1.1*mm, 0, 0>, <1.1*mm, 0, 0>, 2*mm }
    material { M_Steel }
}

union
{
    union
    {
        union
        {
            object {light_shell translate <-12*cm,-4.5*cm,0> rotate y*90 }
            object {hanger_base }
            rotate x*xdeg
        }
            
        object {articulator}
        
        rotate y*ydeg
    }
    
    box { <-1*cm, 15*mm, -1.5*cm>, <1*cm, 16*mm, 1.5*cm>  material { M_Steel }}
}
#end

#macro lighting_track(length)
union { 
    // Top
    box { <-(length/2), 17*mm, -1.6*cm>,  <(length/2), 18*mm, 1.6*cm> material { M_Steel } }
    
    // Left Side
    box { <-(length/2), 14*mm, -1.7*cm>,  <(length/2), 18*mm, -1.6*cm> texture { T_BlackFlatPaint } }
    box { <-(length/2), 15*mm, -1.7*cm>,  <(length/2), 14*mm, -1.5*cm> texture { T_BlackFlatPaint }}

    // Right Side
    box { <-(length/2), 14*mm, 1.7*cm>,  <(length/2), 18*mm, 1.6*cm> texture { T_BlackFlatPaint }}
    box { <-(length/2), 15*mm, 1.7*cm>,  <(length/2), 14*mm, 1.5*cm> texture { T_BlackFlatPaint }}
    
    // End Caps
    union
    {
        box { <-((length/2)+1*mm),18*mm,1.8*cm>,<-(length/2),13*mm,-1.8*cm>} 
        box { <-((length/2)+1*mm),18*mm,-1.7*cm>,<-((length/2)-3*mm),13*mm,-1.8*cm>} 
        box { <-((length/2)+1*mm),18*mm,1.7*cm>,<-((length/2)-3*mm),13*mm,1.8*cm>} 
        box { <-((length/2)+1*mm),14*mm,-1.8*cm>,<-((length/2)-3*mm),13*mm,1.8*cm>} 
    
        box { <((length/2)+1*mm),18*mm,1.8*cm>,<(length/2),13*mm,-1.8*cm>} 
        box { <((length/2)+1*mm),18*mm,-1.7*cm>,<((length/2)-3*mm),13*mm,-1.8*cm>} 
        box { <((length/2)+1*mm),18*mm,1.7*cm>,<((length/2)-3*mm),13*mm,1.8*cm>} 
        box { <((length/2)+1*mm),14*mm,-1.8*cm>,<((length/2)-3*mm),13*mm,1.8*cm>} 
       
       material { M_BrownPlastic }
    }
    
}
#end

// Camera & Setup for debugging
#if(DEBUG_OBJECT)

object { track_lamp(30,-0) translate x*0+y*1*ft rotate y*90 }
object { lighting_track(16*cm) translate x*0+y*1*ft rotate y*90 }

camera { location -z*2.0*ft+y*0.5*ft+x*1*ft look_at <0, 0.85*ft, 0> angle 20
    blur_samples 256
    focal_point <0, 0.85*ft, 0>
    aperture 1
    confidence 0.999999
    variance 1/256
}

light_source { <10*ft, 8*ft, -10*ft> color rgb 1 }
light_source { <0*ft, -3*ft, -10*ft> color rgb 1 }

#end

#end

