/*
    Easy as 1-2-3:
    Render Hard7PassOne.ini, then Hard7PassTwo.ini and then Hard7PassThree.ini.
    Or the .POVs, in the same order.
*/

/*
    includes
*/

#include "rand.inc"     // random number generation macros
                        // used RdmA for manipulation of dice

#include "colors.inc"   // standard pre-defined colors

//----------------------------------------------------------------------------------------------------------------------------------------

/*
    declares
*/

//
// quality switch
// --------------
//
// intended use:
//
// 0 = Draft
// 1 = Dummy-osity (Radiosity with Dummies)
// 2 = Dummy-tons (Photons with Dummies)
// 3 = Competition
//

#declare Quality = 2;

//
//  camera parameters
//

#declare CamPos = <-2,5,-6>;
#declare Focus = <0,0,0>;

//
// textures
//

#declare WhiteIvory =
    #switch(Quality)
    #case(2)
        texture
        {
            pigment{color rgb<1,1,.75>}
            finish
            {
                specular .9
                roughness 0.0001
                reflection 0.2
            }
        }
    #break
    #case(3)
        texture
        {
            pigment
            {
                marble
                turbulence .75
                color_map
                {
                    [0 color rgb<1,1,.75>]
                    [.4 color rgb <1,1,.85>]
                    [.5 color White]
                    [.6 color rgb <1,1,.85>]
                    [.9 color rgb <1,1,.75>]
                    [1 color rgb <1,1,.5>]
                }
                rotate -45
                scale .5
            }
            finish
            {
                specular .9
                roughness 0.0001
                reflection 0.2
            }
        }
    #break
    
    
    
    #else
        texture{pigment{color rgb<1,1,.75>}}
    #break

#end

#declare BlackIvory =
    #switch(Quality)
    
    #range(2,3)
        texture
        {
            pigment{color Black}
            finish
            {
                specular .9
                roughness 0.0001
                reflection 0.2
            }
        }
    #break
    
    #else
        texture{pigment{color Black}}
    #break

#end

#declare MagicTransparent =
    #switch(Quality)
    
    #case(0)
        texture
        {
            pigment{color rgbt<1,1,1,1>}
            finish{reflection .1}
        }
    #break
    
    #case(1)
        texture
        {
            pigment{color rgbt <1,1,1,1>}
        }
    #break
    
    #else
        texture
        {
            pigment{color rgbt<1,1,1,.995>}
            finish{reflection .075}
        }
    #break
#end

#declare WoolBlue =
    #switch(Quality)
        
    #case(1)
        texture{pigment{color Navy}}    
    #break
    
    #case(2)
        texture
        {
            pigment{color(Blue)}
            normal
            {
                #local Quilt = normal{quilted .2 turbulence .2 scale .1}
                #local MicroNoise = normal{bozo 5 turbulence .75 scale .005}
                
                average
                normal_map
                {
                   [Quilt]
                   [MicroNoise]                    
                }
            }
            
            finish
            {
                diffuse .8
                brilliance .75
            }
        }
    #break
    
    #case(3)
        texture
        {
            pigment
            {
                quilted
                turbulence .2
                color_map
                {
                    [0 color Black]
                    [.35 color Navy]
                    [.5 color Navy]
                    [1 color Blue]
                }
                scale .05
            }
            normal
            {
                #local Quilt = normal{quilted 1 turbulence .2 scale .05}
                #local MicroNoise = normal{bozo 10 turbulence 1 scale .01}
                
                average
                normal_map
                {
                   [Quilt]
                   [MicroNoise]                    
                }
            }
            
            finish
            {
                diffuse .8
                brilliance .75
            }
        }  
    #break
    
    #else
        texture
        {
            pigment
            {
                quilted
                turbulence .2
                color_map
                {
                    [0 color Black]
                    [.35 color Navy]
                    [.5 color Navy]
                    [1 color Blue]
                }
                scale .05
            }
            finish
            {
                diffuse .8
                brilliance .75
            }
        }
    #break
    
    #end

#declare RadiantRed = texture{pigment{color rgb<100,0,0>}};
#declare RadiantGreen = texture{pigment{color rgb<0,200,0>}};

//
// positioning constants
//

// positions of the dice showing 0 and 7

#declare MagicDie0Pos = <-2,0,1>;
#declare MagicDie7Pos = <1,0,-2>;

//----------------------------------------------------------------------------------------------------------------------------------------

/*
    cam & lighting
*/

global_settings
{
    max_trace_level 25
    #if(Quality>0)
        ambient_light 0
    #end
  
    #if(Quality=1 | Quality=3)
        radiosity
        {
            pretrace_start 1            // start pretrace at this size
            pretrace_end   0.01         // end pretrace at this size
            count 1500                  // higher -> higher quality (1..1600) [35]
            nearest_count 8             // higher -> higher quality (1..10) [5]
            error_bound 1               // higher -> smoother, less accurate [1.8]
            recursion_limit 3           // how much interreflections are calculated (1..5+) [3]
            low_error_factor .5         // reduce error_bound during last pretrace step
            gray_threshold 0.0          // increase for weakening colors (0..1) [0]
            minimum_reuse 0.0075        // reuse of old radiosity samples [0.015]
            always_sample off           // turn sampling in final trace off [on]
            adc_bailout 0.01/400
            #if(Quality=1)              
                brightness 1            // brightness of radiosity effects (0..1) [1]
                save_file "Hard7.rad"   // save radiosity data
            #end
            #if(Quality=3)
                brightness 2            // brightness of radiosity effects (0..1) [1]
                load_file "Hard7.rad"   // load saved radiosity data
            #end
  
        }
    #end
    
    #if(Quality>1)
    photons
    {
        spacing 0.005                   // specify the density of photons
        //count 100000                  // alternatively use a total number of photons
    
        jitter 1.0                      // jitter phor photon rays
        max_trace_level 5               // optional separate max_trace_level
        adc_bailout 1/65025             // see global adc_bailout
        autostop 0                      // photon autostop option
        
        #if(Quality=2)
            save_file "Hard7.ph"        // save photons to file
        #end
        #if(Quality=3)
            load_file "Hard7.ph"        // load photons from file
        #end     
    }
    #end
}



//
// camera
//

camera
{  
    location CamPos
    look_at Focus
    
    up y
    right 4/3*x
}

//
// lighting
//

#switch(Quality)
    
    #case(0)
        light_source
        {
            // work light
            CamPos,White*2
        }
    #break
    
    #case(1)
        //DO NOT LIGHT! THIS IS JUST FOR GENERATING THE .RAD FILE!
    #break
    
    #case(2)
        light_source
        {
            <-.5,10,0>,Red
            photons
            {
                refraction on
                reflection on
            }
        }
        light_source
        {
            <-.4,10,0>,(Red+Orange)/2
            photons
            {
                refraction on
                reflection on
            }
        }
        light_source
        {
            <-.3,10,0>,Orange
            photons
            {
                refraction on
                reflection on
            }
        }
        light_source
        {
            <-.2,10,0>,(Yellow+Orange)/2
            photons
            {
                refraction on
                reflection on
            }
        }
        light_source
        {
            <-.1,10,0>,Yellow
            photons
            {
                refraction on
                reflection on
            }
        }
        light_source
        {
            <0,10,0>,(Yellow+Green)/2
            photons
            {
                refraction on
                reflection on
            }
        }
        light_source
        {
            <.1,10,0>,Green
            photons
            {
                refraction on
                reflection on
            }
        }
        light_source
        {
            <.2,10,0>,(Blue+Green)/2
            photons
            {
                refraction on
                reflection on
            }
        }
        light_source
        {
            <.3,10,0>,Blue
            photons
            {
                refraction on
                reflection on
            }
        }
        light_source
        {
            <.4,10,0>,(Violet+Green)/2
            photons
            {
                refraction on
                reflection on
            }
        }
        light_source
        {
            <.5,10,0>,Violet
            photons
            {
                refraction on
                reflection on
            }
        }
    #break
    
    #case(3)
        light_source
        {
            <0,10,0>,Gray65
        }
    #break
    
    #else
        light_source
        {
            CamPos,White
        }
    #break

#end

//----------------------------------------------------------------------------------------------------------------------------------------

/*
    modelling & composition
*/

//
// environment
//

sky_sphere
{
    #switch(Quality)
    
        #range(0,2)
            pigment{color Orange/2}
        #break
        
        #case(3)
            pigment{color Orange/4}
        #break
        
        #else
        #break
        
    #end
}

plane
{
    y,0
    texture{WoolBlue}
}

//
// objects
//

// dice

// dice generator
// --------------
// generates a die of specified textures for corpus and eyes with specified face up,
// rotated about the y-axis in steps of 90 degrees at random standing at the origin of the x-z-plane with lower face y=0.
//
// intended use:
//
// FaceUp:          Specify which number faces up.
//                  Any float is legal, though only 1,2,3,4,5 and 6 evaluate to a corresponding number of eyes.
//                  Every other float gives a 5.
// CorpusTexture:   This texture is used for everything of the die except the eyes.
// EyeTexture:      This texture is used for the eyes only.
// Magic:           This float specifies where "magic" is used on the die.
//                  0 erases the eye from the 1-face. 7 adds an additional eye to th 6-face. Nothing else has an effect.
//
  
#macro Die(FaceUp,CorpusTexture,EyeTexture,Magic)
    difference
    {
        // corpus
        intersection
        {
            box{-.5,.5}
            sphere{0,sqrt(2)/2} 
        }
       
        // eyes
        union
        {
            // "1" = magic 0
            #if (Magic=0)
                // DO NOTHING! 0 EYES TO CARVE!
            #else
                sphere{<0,0,-.5>,.1}
            #end
            
            // "6" = magic 7
            #local I = 0;
            #while(I<3)
                #local J = 0;
                #while(J<2)    
                    sphere{<((J*(2/3))-1/3)*.75,((I*(1/3))-1/3)*.75,.5>,.1}
                    #local J=J+1;
                #end
                #local I = I+1;
            #end
            
            #if (Magic=7)
                sphere{<0,0,.5>,.1}
            #end
                       
            // 4
            #local I = 0;
            #while(I<2)
                #local J = 0;
                #while(J<2)    
                    sphere{<-.5,((J*(2/3))-1/3)*.75,((I*(2/3))-1/3)*.75>,.1}
                    #local J = J+1;
                #end
                #local I = I+1;
            #end
            
            // 3
            #local I = 0;
            #while(I<3)
                sphere{<.5,((I*(1/3))-1/3)*.75,((I*(1/3))-1/3)*.75>,.1}
                #local I = I+1;
            #end
                
            // 2
            #local I = 0;
            #while(I<2)
                sphere{<((I*(2/3))-1/3)*.75,-.5,((I*(2/3))-1/3)*.75>,.1}
                #local I = I+1;
            #end    
        
            // 5
            sphere{<0,.5,0>,.1}
            #local I = 0;
            #while(I<2)
                #local J = 0;
                #while(J<2)    
                    sphere{<((J*(2/3))-1/3)*.75,.5,((I*(2/3))-1/3)*.75>,.1}
                    #local J = J+1;
                #end
                #local I = I+1;
            #end
        
            texture{EyeTexture}
        }
        
        texture{CorpusTexture}
        
        // Which face up? And the sides?
        #switch(FaceUp)
            #case(1)
                rotate 90*x
            #break
            
            #case(2)
                rotate 180*x
            #break
            
            #case(3)
                rotate 90*z
            #break
            
            #case(4)
                rotate -90*z
            #break
            
            #case(5)
            #break
            
            #case(6)
                rotate -90*x
            #break
            
            #else
            #break
        #end
        rotate floor(RRand(0,4,RdmA))*90*y
                
        // Behave like a good die and lie on the floor, not half in it!
        translate .5*y
    }
#end

// magic dice

object
{
    #if(Quality=1)
        sphere{<0,.5,0>,.5 texture{RadiantRed}}
    #else
        Die(1,WhiteIvory,BlackIvory,0)
        photons
        {
            target 1.0   
            refraction on
            reflection on
        }
    #end
    
    rotate RRand(-45,45,RdmA)*y
    translate MagicDie0Pos
}

object
{
    #if(Quality=1)
        sphere{<0,.5,0>,.5 texture{RadiantGreen}}
    #else
    Die(6,WhiteIvory,BlackIvory,7)
    photons
    {
        target 1.0   
        refraction on
        reflection on
    }
    #end
    
    rotate RRand(-45,45,RdmA)*y
    translate MagicDie7Pos
}

// tranparent effect dice

#if(Quality!=1)
    #declare RingOffset = RRand(0,45,RdmA);
    #local I = 0;
    #while(I<8)
        #declare Face = ceil(RRand(0,6,RdmA));
        object
        {
            Die(Face,MagicTransparent,MagicTransparent,Face)
            photons
            {
                target 1.0   
                refraction on
                reflection on
            }
            no_shadow
            #if(Quality=2)
                interior
                {
                    ior 2.47
                }
            #end
            #if(Quality=1)
                no_reflection
                no_image
            #end
            translate <0,-.5,0>
            scale .5
            rotate RRand(0,360,RdmA)*x
            translate <sqrt(2),.5,0>
            rotate ((45*I)+RingOffset)*y
            translate MagicDie0Pos
        }
        #local I = I+1;
    #end
    
    #declare RingOffset = RRand(0,45,RdmA);
    #local I = 0;
    #while(I<8)
        #declare Face = ceil(RRand(0,6,RdmA));
        object
        {
            Die(Face,MagicTransparent,MagicTransparent,Face)
            photons
            {
                target 1.0   
                refraction on
                reflection on
            }
            no_shadow
            #if(Quality=1)
                no_reflection
                no_image
            #end
            #if(Quality=2)
                interior
                {
                    ior 2.47
                }
            #end
            translate <0,-.5,0>
            scale .5
            rotate RRand(0,360,RdmA)*x
            translate <sqrt(2),.5,0>
            rotate ((45*I)+RingOffset)*y
            translate MagicDie7Pos
            #local I = I+1;
        }
    #end
#end

// lampshade

#if(Quality=3)
    difference
    {
        cylinder{<0,5,0>,<0,15.01,0>,5}
        sphere{<0,5,0>,5.01}
        texture
        {
            pigment{color White}
            finish{reflection .5}
        }
    }
#end