//==================================================
//POV-Ray Main scene file
// topic IRTC : Out of place 
// Martial Rameaux http://cathemline.org
//==================================================
//Files needed to run the POV-Ray scene:
//COCHON_big.inc" //Geometry 
//COCHON_oeil_pov.inc" //Geometry
//COCHON_oeil_int_pov.inc" //Geometry
//COCHON_ptit.inc //Geometry petit cochon

//map needed:  
//Cochon_big_map.jpg
//Cochon_ptit_map.jpg
//oeild2_png; oeilg2_png

//piece1.png piece1nb.png; piece2.png piece2nb.png; piece3.png piece3nb.png
//piece5.png piece5nb.png; piece6.png piece6nb.png; piece7.png piece7nb.png 
//piece8.png piece8nb.png; piece9.png piece9nb.png; piece10.png piece10nb.png 
//piece12.png piece12nb.png; piece14.png piece14nb.png; piece15.png piece15nb.png 
//piece16.png piece16nb.png; piece17.png piece17nb.png 

//paille.inc" macro by Bouffartigue http://tofbouf.free.fr/
//HDRI map from http://www.debevec.org/

//tools used :
//Wings3d http://www.wings3d.com/
//PoseRay v3.8.2.327 http://user.txcyber.com/~sgalls/
//ColorPicker http://www.geocities.com/jamisbuck/downloads.html
//PaintShopPro for colored map for cochon_big and cochon_ptit and piece 
//Irfanview http://irfanview.tuwien.ac.at/index.htm for work-view and  convert map to jpeg 

//==================================================
#version unofficial  mlpov 0.83;
//#version unofficial megapov 1.1;
#include "colors.inc"
#include "textures.inc"
#include "functions.inc"
#include "paille.inc"
//--------------------------------------------------SWITCH_WORK
#declare use_radiosity =0; //2 save 1 load 
#declare rad_sFilename ="26020523h00" //load save rad file
#declare use_grosCochon=1;
#declare use_ptitCochon=1;
#declare use_paillee   =1;
#declare use_Auge      =1;
#declare use_Eau       =1;
#declare use_Piece     =1;
#declare use_allTexture=1;
//--------------------------------------------------GeometrieCochonS
#if(use_grosCochon)
    #include "COCHON_big.inc" //Geometry
    #include "COCHON_oeil_pov.inc" //Geometry
    #include "COCHON_oeil_int_pov.inc" //Geometry
#end

#if(use_ptitCochon)
    #include "COCHON_ptit.inc" //Geometry and texure
#end
//--------------------------------------------------GLOBAL_SETTINGS
#declare rad_brightness=1;
global_settings{
 max_trace_level 6
 assumed_gamma 2.2
 #if (use_radiosity)
  radiosity{
   #if (use_radiosity=2)
    // save settigns
    pretrace_start .05 pretrace_end .01
    count 200 nearest_count 20 error_bound .25
    recursion_limit 1
    normal on
    brightness rad_brightness
    save_file rad_sFilename
   #else
    // load settings
    pretrace_start 1 pretrace_end 1                                            
    always_sample off
    error_bound .25
    recursion_limit 1
    normal on
    brightness rad_brightness
    load_file rad_sFilename
   #end
  }
 #end
}  

//--------------------------------------------------CAMERA
camera {
        perspective
        up <0,1,0>
        right -x*image_width/image_height
        location <-1.301043E-17,-4.4365E-7,10.02974>
        look_at <-1.301043E-17,-4.4365E-7,9.02974>
        angle 29.9519 // horizontal FOV angle
      // aperture 0.2679885 blur_samples 100 focal_point<0,0,0>
        rotate <0,0,1.211713> //roll
        rotate <-29.7444,0,0> //pitch
        rotate <0,31.80852,0> //yaw
        translate <0.00109521,1.248959,0.2467103>
}
//----------------------------------------------------ENVIRONNEMENT_hdri_map
#declare imHDR="c04/kitchen_pano.hdr"//
sphere{0,1 
texture{
        pigment{image_map{hdr imHDR map_type 1 interpolate 2 } } 
        finish{diffuse 0 ambient .3}
       }
  rotate y*45 
  scale <1,1,2>*250    
  hollow
}

//Ground
#declare Ground= plane{y,0 
                       pigment{bozo color_map{[0 rgb .8][.6 rgb 1]}}// rgb<0.8313725,0.8156863,0.7843137> }
                       finish{ambient 0}
                       }
//-------------------------------------------------PIECE_DE_MONAIE
#macro Piece(fileMap,Coef)
#local Lg=strlen(fileMap);
#local tmpfilename=substr(fileMap,1,Lg)
#local NbMap=concat(tmpfilename,"nb.png")
//#debug concat("nameMap : ",NbMap,"\n")
#local Ctemp=pigment{image_map {png fileMap}}
#local pic_Color=eval_pigment (Ctemp,<.1,.5,.1>);
//#debug concat("Eval_Pigment  : <",str(pic_Color.x,0,2),",",str(pic_Color.y,0,2),",",str(pic_Color.z,0,2)">\n")

#local T_Pieceh=texture{ 
        pigment{image_map{png fileMap map_type 0 }scale 2 rotate x*-90 translate <1,0,1>} 
        finish{phong .1 metallic ambient .2 diffuse 1 reflection{0,.1}}
        normal{bump_map {png NbMap} bump_size 3 rotate x*-90 translate <1,0,1>}
        }
#local T_Pieceb=texture{ 
                 pigment{pic_Color}
                 finish{phong .1 metallic ambient .2 diffuse 1 reflection{0,.1}}
                   }
        union{
        cylinder{y*0,y*.1,1 texture{T_Pieceh} scale .5 }
        torus{1,0.011 texture{T_Pieceb} scale <1,9,1> scale .5 }
        scale <Coef,1,Coef>
        }  
#end
//-------------------------------------------------PAILLE (Bouffartigue)
#if(use_paillee)
// Paille_brin(dep, fin, larg, turb, sturb,nbs, st)
#declare m_paille =Paille_mesh(<-1,-.01, -1>,<1,0.00,1>,40,.008,.05,1,10,seed(35))
#declare Paille =object {
        //Paille_tapis(coin1, coin2, nbx, nbz, m_paille, st)
        Paille_tapis(<-10,0.01,-15>,<20,0.00,5>,50,60, m_paille,seed(30))
        texture {
                pigment {
                        spotted
                        turbulence .4 octaves 2
                        scale <.2,.005,.2>
                        color_map {
                                [.2 color rgb<1,.95,.3>]
                                [.5 color rgb<.9,.7,.4>]
                                [.8 color rgb<.9,.7,.1>]
                        }
                }
        }
}
#end
//--------------------------------------------------MATERIALS_TEXTURES
#if(use_allTexture)


#declare T_temp=
texture{pigment{Orange} normal{bozo 10 scale .01 bump_size 10}}
texture{pigment{bozo color_map{[0 Orange*.3] [1 Clear]}warp{turbulence .5}} scale .1}
texture{pigment{bozo color_map{[.5 Clear] [1 Orange*2]}warp{turbulence .5}} scale .3}
texture{pigment{bozo color_map{[0 Black] [.5 Clear]} warp{turbulence .5} scale .02}}

#declare T_Haut=texture{gradient y texture_map{[0 T_temp][.9 T_temp][.9 pigment{Clear}]} 
warp{turbulence 2}
warp{repeat x*20}
warp{turbulence 2}
}

#declare T_Auge=
    texture{gradient y texture_map{[0 T_temp][.95 T_temp][.95 T_Haut][1.2 T_Haut]}}

#declare T_Augint=texture{crackle
                        texture_map{[0 T_temp][.4 T_temp][.4 pigment{Clear}]}
                        warp{turbulence 2}
                        }
                        
#declare M_EauAuge=material{
                               texture{
                                pigment{rgbt 1}
                                finish{ambient 0 diffuse 1 reflection {0,.1 fresnel } conserve_energy}
                                normal{ripples 40 scale <.1,.02,.1> warp{repeat x*2} warp{turbulence .2}}
                                }
                                
                            interior{ ior 1.4
                                      media{ emission 5 absorption <3,3,2.9> 
                                      density {cylindrical 
                                      color_map {
                                                [0.0 rgb .5]
                                                [0.5 rgb .8]
                                                [1.0 rgb .6]
                                                 }
                                                 turbulence 2
                                                 scale .1
                                                }
                                                }
                                          }                    
                                      }

#else
#declare T_Augint=texture{pigment{bozo color_map{[0 Orange][.7 Orange][.7 Clear]} warp{turbulence .5} scale .2}}
#declare T_Auge=texture{pigment{Orange*.5}}
                
#declare M_EauAuge=material{texture{pigment{rgb <.9,.9,1>}}}
#end
//--------------------------------------------------
#declare Auge_Pied=intersection{
        cylinder{-x*.05, x*.05,.5 translate y*-1}
        cylinder{-x*.11, x*.11,.4 translate y*-1.01 inverse }
        box{<-1,0,-1><1,-1,1> translate y*-1 inverse}
        cylinder{-x,x,.6 inverse}
}

#declare Eau_Pattern=pigment{function{f_ripples(x,y,z)*.1}}
#declare isof=
function{
 pigment{
  Eau_Pattern
  color_map{
   [0 rgb 0] 
   [.6 rgb .5]
   [1 rgb 1]
  }
  scale <.2,.01,.2> warp{repeat x*2} warp{turbulence .1}
 }
}

#declare Eau_=
 isosurface{
   function{y -isof(x,0,z).gray } 
   max_gradient 1
   translate y*-.2  
 } 
    
#declare Eau=object{Eau_ clipped_by{cylinder{x,-x,.5}} material {M_EauAuge}hollow}
//------------


#declare Auge=union{
intersection{
        cylinder{-x,x,.5}
        cylinder{-x*.99,x*.99,.47 texture{T_Augint} inverse}
        box{<-2,0,-1><2,1,1> pigment {Clear}inverse }
}
object{Auge_Pied translate  x*.8}
object{Auge_Pied translate -x*.8}
#if(use_Eau)object{Eau}#end
texture{T_Auge} 
}

//-----------------------------------------------------AFFICHAGE
light_group{    
#if(!use_radiosity)light_source{<50,170,30> 1 } #end
light_source{<50,170,30> .2  parallel point_at 0}  // area_light z*15,x*15,7,7

object{Ground} 
  
#if(use_Piece )
    object{Piece("piece1",.60) translate <1,0,0>} //*
    object{Piece("piece2",.50) translate <1.2,0,1>}//* 
    object{Piece("piece3",.40) translate <.8,0,-1>} //* 
    object{Piece("piece5",.40) translate <1.6,0,.3>}
    object{Piece("piece6",.50) translate <2,0,.05>}
    object{Piece("piece7",.65) translate <1.8,0,-1.2>}
    object{Piece("piece8",.60) translate <1.0,0,-3.0>}
    object{Piece("piece9",.50) rotate y*190 translate <0.5,0,-2.5>}
    object{Piece("piece10",.35) translate <0.0,0,-2.5>}
    object{Piece("piece12",.45) translate <1.5,0,-2.8>}  //*
    object{Piece("piece14",.50) translate <0.2,0,-2.0>}
    object{Piece("piece15",.70) translate <2.1,0,0.9>}
    object{Piece("piece16",.45) scale <1,.5,1> translate <1.8,0,-2.2>} //* 
    object{Piece("piece17",.50) rotate y*190 translate <1.1,0,-2>}
#end

#if(use_paillee)object{Paille}#end
  
#if(use_Auge)object{ Auge  translate <-.2,1,2.5>} #end

#if(use_grosCochon)
union{
    object{COCHON_big_ }
    object{COCHON_oeil_ }
    object{COCHON_oeil_int_ }
}
#end

#if(use_ptitCochon)
    object{ COCHON_ptit scale .3 rotate y*20 translate <1,0,.2>}
#end
}
//==================================================
