// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc"
#include "functions.inc"
#include "golds.inc"
#include "metals.inc"
#include "rad_def.inc"
#include "woods.inc"
#include "transforms.inc"
#declare WITHPEOPLE=true;
#declare WITHTREE=true;
#declare MANYTREES=true;
#declare USEMEDIA=true;
//#declare WITHRADIOSITY=true;
#declare USEAREASUN=true;
//#declare USEPHOTON=true;
#declare MAINAREALIGHT=true;
#declare DISCONNECTED=true;
//#declare WITHFRESQUE=true;  //don't use this one : use disconnected
//#declare WITHHUMIDITY=true;
//#declare WITHHUMIDITYPLANE1=true;
#declare WITHHUMIDITYPLANE2=true;
//#declare GENFOG=true;
//#declare GRNFOG=true;
// set a color of the background (sky)
background { color rgb <0.1, 0.3, 0.8> }

// set global atmospheric fog effect in the scene.
// at the fog distance, there will be 63% visibility
#ifdef(GENFOG)
fog {
  fog_type 1               // 1=constant, 2=ground_fog
  distance 1500
  color 0.9               // can also have 'filter' and 'transmit'
  // (---turbulence---)
  turbulence <50, 50, 100>
  turb_depth 5
  omega 0.5
  lambda 2.0
  octaves 6
  // (---ground fog---)
}             
#end
#ifdef(GRNFOG)
// set global atmospheric fog effect in the scene.
// at the fog distance, there will be 63% visibility
fog {
  fog_type 2               // 1=constant, 2=ground_fog
  distance 1
  color 1 transmit 0.8              // can also have 'filter' and 'transmit'
  // (---turbulence---)
  //turbulence <0.5, 0.5, 1.0>
  //turb_depth 0.5
  //omega 0.5
  //lambda 2.0
  //octaves 6
  // (---ground fog---)
  fog_offset 0         // height of constant fog
  fog_alt 1           // at fog_offset+fog_alt: density=25%
}             
#end


global_settings {
  assumed_gamma 1.2
  ambient_light 0.5
  max_trace_level 6
  #ifdef(WITHRADIOSITY)
    radiosity {
      Rad_Settings(Radiosity_OutdoorLQ, off, off)  
      brightness 0.5
    }
  #end
  #ifdef (USEPHOTON)          // global photon block
    photons {
      //spacing 0.5                 // specify the density of photons
      count 1000000               // alternatively use a total number of photons

      //gather min, max            // amount of photons gathered during render [20, 100]
      //media max_steps [,factor]  // media photons
      jitter 1.0                 // jitter phor photon rays
      max_trace_level 10          // optional separate max_trace_level
      adc_bailout 1/255          // see global adc_bailout
      save_file "filename"       // save photons to file
      //load_file "filename"       // load photons from file
      //autostop 0                 // photon autostop option
      //radius 10                  // manually specified search radius
      // (---Adaptive Search Radius---)
      //steps 1
      //expand_thresholds 0.2, 40
    }
  #end

}


// ----------------------------------------

#declare C_MainCam=camera {
  //location  <0.0, 160, -1300.0>
  location  <-28.0, 115, -1045.0>
  //direction 1.5*z
  //right     x*image_width/image_height
  look_at   <50.0, 0.0,  0.0>
  //angle 45
  angle 60
}                

#declare C_Mic1Cam = camera {location 100*y look_at <0,0,300> rotate -30*y angle 30}
#declare C_Mic1CamS = camera {location <150,52,350> look_at <0,0,300> rotate -30*y angle 45}
#declare C_Inside = camera {location <0,52,-900> look_at <0,0,300>  angle 30}
#declare C_Mic3Cam = camera {location <900,100,900> look_at <0,150,1000> angle 30}
#declare C_FenCam = camera {location <0,100,0> look_at <0,150,1000> angle 30}
#declare C_PlafCam = camera {location <0,1,0> look_at <0,2,0> angle 130}

#declare C_Height = 1000; //hauteur sous plafond               

#declare CurrentCam=C_MainCam;               
camera {CurrentCam}

#declare L_Soleil = 
light_source {
  <-170, 270, 1000> *1000           // light's position (translated below)
  color rgb <1, 1, 0>  // light's color
  //translate <0, 499, 0>
  #ifdef (USEAREASUN)
    area_light <1000,0,0>,<0,1000,0> 10,10
    adaptive 1
    circular
  #end
  #ifdef(USEPHOTON)
    photons {           // photon block for a light source
      refraction on
      reflection on
    }
  #end
 
}                   

light_source {
  L_Soleil  
}

/*light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>*0  // light's color
  translate <0, 499, 0>
} */
#ifdef (MAINAREALIGHT)
  //swimming_pool area light
  light_source {
    0*x                 // light's position (translated below)
    color rgb 1.0       // light's color
    area_light
    <900, 0, 0>, <0, 0, 900> // lights spread out across this distance (x * z)
    10, 10                // total number of lights in grid (4x*4z = 16 lights)
    adaptive 1          // 0,1,2,3...
    jitter              // adds random softening of light
    //circular            // make the shape of the light circular
    //orient              // orient light
    translate <0, C_Height-10, 0>   // <x y z> position of light
    #ifdef(USEPHOTON)
      photons {           // photon block for a light source
        refraction on
        reflection on
      }
    #end
  }   
#else        
  #debug "making lights\n"
  #declare NbLights = 64;
  #declare X=-900;
  #while(X<900)
    #declare Z=-900;
    #while(Z<900)
      light_source {
        <X,C_Height-1,Z>
        color rgb 1/NbLights*2
        looks_like {
          sphere {
            <X,C_Height-1,Z>,100
            texture {
              pigment {
                color rgb 1  
              }            
            }  
            finish {
              ambient 1
              diffuse 0  
            }
          }  
        }  
        #ifdef(USEPHOTON)
        photons {           // photon block for a light source
          refraction on
          reflection on
        }
        #end
      }     
      sphere {<0,0,0>,25 scale <1,0.5,1> translate <X,C_Height-1,Z> pigment {color White} finish {ambient 1 diffuse 0} no_shadow}
      #declare Z=Z+(1800/(sqrt(NbLights)-1));
    #end               
    #declare X=X+(1800/(sqrt(NbLights)-1));    
  #end
#end

//corridor area light
light_source {
  0*x                 // light's position (translated below)
  color rgb 1.0       // light's color
  area_light
  <-400, 0, 0> <0, 0, 100> // lights spread out across this distance (x * z)
  4, 2                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  //circular            // make the shape of the light circular
  //orient              // orient light
  translate <0, C_Height-10, -1200>   // <x y z> position of light
  fade_power 1
  fade_distance C_Height
} 

/*light_source {
  <0,160,-1300>
  color rgb <1,1,1>  
} */

//---------------------------------------------------------------------------------------------------------------------
// TTT EEE X X TTT U U RRR EEE  SS
//  T  E   X X  T  U U R R E   S 
//  T  EE   X   T  U U RRR EE   S
//  T  E   X X  T  U U RR  E     S
//  T  EEE X X  T  UUU R R EEE SS
#declare T_Colonne = texture {
    pigment {
      marble
      color_map {
        //[0.0     color DarkGreen ] 
        [0.8     color DarkGreen ]     
        //[0.9     color Green     ]
        //[0.9     color White     ]
        [1       color White     ]
      }
      turbulence 0.5
    }                             
    finish {        
      ambient 0.2
      phong 0.8
      phong_size 120
      diffuse 0.7
      reflection 0.05
    }       
    rotate 39*z
    scale 20
    scale 2
}
#declare T_Colonne = texture {
    pigment {
      marble
      color_map {
        [0.25     color rgb <161,186,182>/255 ] 
        [0.3     color rgb <223,232,215>/255 ]     
        [0.5     color rgb <161,186,182>/255]
        [0.7     color rgb <38,42,53>/255]
        [1       color rgb <161,186,182>/255]
      }
      turbulence 0.5
    }                             
    finish {        
      ambient 0.2
      phong 0.8
      phong_size 120
      diffuse 0.7
      reflection 0.05
    }       
    rotate 39*z
    scale 20
    scale 2
}
                                                                                         
                     
#declare T_Porte = 
    texture { pigment { P_WoodGrain1A color_map { M_Wood15A }}}
    texture { pigment { P_WoodGrain1B color_map { M_Wood15B }}}

     
                 
#declare T_Eau = texture {
  pigment {
    color <0.5,0.9,1> filter 0.8 
  }                 
  finish {
    reflection {
      0 0.8
      fresnel on
    }
  }
}   
#declare Water =
texture {
    pigment{ rgbf <0.95, 0.95, 1.0, 0.9> }
    finish {
        reflection {0.5, 1 fresnel exponent 0.5}
        conserve_energy
    }
}

/*#declare T_EauClaire = texture {
  pigment {
    color <0.95,0.95,1> filter 0.99  
  }                 
  finish {
    reflection {
      0.5 1
      fresnel                    
    }
    conserve_energy
    phong_size 50
    phong 1
    brilliance 5
    
  }   
} */        
#declare T_EauClaire=texture{Water};


#declare T_Sol3 = texture {
  pigment {image_map{jpeg "C:\Temp\016marbre"} } 
  scale 180
  rotate 90*x
  rotate 23*y
  finish {
    reflection 0.1  
  }
}
#declare T_Sol2 = texture {
  pigment {
    marble
    color_map {
      [ 0.0  color White*0.9 ]
      [ 0.9  color White*0.9 ]
      [ 0.9  color White*0.5 ]
      [ 1.0  color White*0.5 ]
    }
    turbulence 0.6//0.5
    frequency 2
    lambda 1.5
    rotate 25*y
    scale 50
  }
  finish {
    reflection 0.1
    phong 0.5
    phong_size 125  
  }
  normal {
    bump_map {
      png "heightfield.png" 
      bump_size 10
    }  
    //scale <0.01,10,0.0*1>
  }
} 
#declare T_Sol = texture {
        pigment{
            boxed
            color_map{
                [1/100 Black]
                [1/100  rgbt 1]
            }
            translate (x+z)*0.98 //was 0.95
            warp{repeat x*2}
            warp{repeat z*2}
            scale 30
        }

}
#declare T_Piece = texture {
  pigment {
    color White
  }
  normal {
    dents
      
  }
}                         

#declare T_Piscine = texture {
  pigment {
    radial
    color_map {
      [0.1 White]
      [0.1 rgb <0.8,0.8,0.8>]  
    }  
    frequency 30
  }
}

#declare T_Fenetre = texture {
  pigment {
    color White filter 1  
  }                     
  normal {
    dents 
    scale 0.01 
  }
  finish {
    reflection 0.1
    phong 0.1
    phong_size 1
  }
}

#declare T_Vitre = texture {
  pigment {
    color White filter 0.6  
  }                     
  normal {
    dents 
    scale 0.01 
  }
  finish {
    reflection 0.1
    phong 0.1
    phong_size 1
  }
}

#declare T_DecoFen = texture {
  T_Gold_2B
  normal {
    dents
    scale 0.01  
  }           
  finish {
    reflection 0.1
    phong 0.5
    phong_size 100  
  }
}

#declare T_Banc = texture { pigment { P_WoodGrain1A color_map { M_Wood10A }}}
                  texture { pigment { P_WoodGrain1B color_map { M_Wood10B }}}


#declare T_Plaque = texture {T_Gold_2B}
#declare T_Jupe=texture {
  pigment {
    image_map {
      gif "jupe"  
      once 
      filter all 1 
      filter 0,0
    } 
    translate <-0.5,-0.5,0>
    scale <10,20,1> 
    turbulence 0.05 
  }
}

// ----------------------------------------
// OOO BB  JJJ EEE CCC TTT  SS
// O O B B  J  E   C    T  S
// O O BB   J  EE  C    T   S
// O O B B  J  E   C    T    S
// OOO BB  J   EEE CCC  T  SS


#declare O_Piscine_Interieur = cylinder {
  <0,-99,0>,<0,11,0>,330  
}

#declare T = transform {
      translate <-50,00,50>
      rotate 30*x
      translate <0,50,10>  
}              
#declare CT = vtransform (<0,0,0>,T);
#declare O_DemiEchelle = union {
  cylinder {
    <0,-1,0>,<0,50,0>, 3
  }                      
  intersection {
    torus { 10, 3 
      rotate 90*z 
      translate <0,50,10>
    }  
    plane { -y, 0 
      translate 50*y+10*z
    }
    plane { -y, 0
      rotate -60*x
      translate 50*y+10*z
    }
  }         
  
  cylinder {
     <0,10,0>,<0,10,50>,3
     rotate 30*x
     translate <0,50,10>
  }            
  intersection {
    
    torus {
      10, 3
      rotate 90*z
      translate <0,00,50>
      rotate 30*x
      translate <0,50,10>  
    }                  
    plane {
      -y, 0
      rotate 90*x
      translate <0,0,CT.z>  
    }                    
    plane {
      -y,0
      rotate 120*x
      translate <0,CT.y,CT.z>  
    }
  }
  cylinder {
    <0, CT.y-10,0>,<0,CT.y-10,CT.z>,3
     
  }
}



#declare O_Eau = isosurface {
  function { y-f_noise3d(x/10,0,z/10) }
  contained_by {box{<-330,-99,-330>,<330,11,330>}}
  clipped_by {O_Piscine_Interieur}
  texture {
    T_Eau
  }      
  interior {
    ior 1.33  
  }                     
  #ifdef(USEPHOTON)
    photons {
      target 1.0
      refraction off
      reflection on  
    }              
  #end
}

#declare O_Fenetre = intersection {
  cylinder {
    <0,150,999>,<0,150,1011>,300
  }                             
  box {
    <-301,150,998>,<301,451,1012>  
  }
}  

#declare O_DecoFen = union {
  difference {
    cylinder {
      <0,150,998.9>,<0,150,1011.1>,50    
    }                                
    cylinder {
      <0,150,998.8>,<0,150,1011.2>,45  
    }                                
  }                                  
  difference {
    cylinder {
      <0,150,998.9>,<0,150,1011.1>,300    
    }                                
    cylinder {
      <0,150,998.8>,<0,150,1011.2>,295  
    }                                
  }                                   
  
  #declare R=0;
  #while(R<181)
    box {
      <46,-2.5,998.9>,<299,2.5,1011.1>
      rotate R*z
      translate <0,150,0>
    }                    
    #declare R=R+30;
  #end    
  box {
    <-300,150,998.9>,<300,155,1011.1>  
  }

  clipped_by {
    box {
      <-301,150,998>,<301,451,1012>  
    }
  }
  
}
//la pice                 
#declare O_Piece = difference {
  box {
    <-1010,-1,-1010>,<1010,C_Height+10,1010>
  } 
  union {                  
    box {
      <-1000,-0.5,-1000>,<1000,C_Height,1000>  
    }
    // porte // door
    box {
      <-75,-2,-1011>,<75,250,-999>    
    }                             
    // fenetre // window
    object {O_Piscine_Interieur scale 1.01}
    object {O_Fenetre}
  }
}


#declare O_Colonne = cylinder {
  <0,0,0>,<0,C_Height,0>,50
  }
                
/*#declare O_Reseau = union {
  #declare X=-1000;
  #declare Spacing=30;
  #while(X<1000)
    cylinder {
      <X,0,-1000>,<X,0,1000>,0.12*2
    }                       
    cylinder {
      <-1000,0,X>,<1000,0,X>,0.12*2 
    }
    #declare X=X+Spacing;
  #end
} */
#declare O_Sol = difference {
  box {
    <-1000,-10,-1000>,<1000,0,1000> 
  }   
  object {O_Piscine_Interieur scale 1.01}
}

#declare O_Plafond = box {
  <-1000,C_Height-0.1,-1000>,<1000,C_Height-0.05,1000>  
}                                
#declare ColDist = 500; //500
#declare O_Colonnes = union {
  object { O_Colonne translate ColDist*x rotate 45*y }
  object { O_Colonne translate ColDist*x rotate 135*y }
  object { O_Colonne translate ColDist*x rotate 225*y }
  object { O_Colonne translate ColDist*x rotate 315*y }
  
}

#declare O_Piscine = difference {
  cylinder {
    <0,-100,0>,<0,10,0>,350
  }                    
  object {O_Piscine_Interieur}        
}
/*#declare O_Sol = difference {
  object {O_Sol}
  object {O_Reseau texture{pigment{color Black}}}
  texture {
    T_Sol
  }
} */
//object {O_Reseau texture{pigment{color Green}}}

#declare O_Porte = difference {
  box {
    //<0,0,-2>,<75,250,2>
    <0,0,-2>,<55,250,2>    
  } 
  box {
    //<20,30,-3>,<55,220,3>
    <20,30,-3>,<40,220,3>    
  }
}
#declare O_PorteVitre = box {
//  <20,30,-2>,<55,220,2>   //was -3,3
  <20,30,-2>,<40,220,2.5>   //was -3,3
}               

#declare O_Media = cone {
  <-170, 270, 1000> *1000, 0.01,<0,150,1000>,320
  translate <170,-270,-1000>*1000
  scale 2
  translate <-170,270,1000>*1000
  clipped_by {
    box {-1000,1000}  
  }
  texture {
    pigment {
      color rgbt 1
      
    }  
  }
   interior {
      media { 
         scattering { 2, rgb 0.1 }
         method 2
         samples 1,10
         variance 1/256
         confidence 0.95
         density {  
            bozo
            scale 10
            color_map {
               [ 0 rgb 0 ]
               [ 1 rgb 0.001 ]
            }
         }
      }
   }
  hollow
}
#declare O_Media = box {
  <-1000,-1,-1000>,<1000,1000,1000>
  texture {
    pigment {
      color rgbt 1
      
    }                            
  }
   interior {
      media { 
         scattering { 2, rgb 0.1 }
         density {  
            bozo
            scale 10
            color_map {
               [ 0 rgb 0 ]
               [ 1 rgb 0.001 ]
            }
         }
      }
   }
  hollow
}
   
#declare O_Banc = box {
  <-100,40,950>,<150,45,1000>
}

#declare O_Corridor = difference {
  box {
    <-1000,-10,-1200>,<1000,C_Height+10,-1000>  
  }                                  
  box {
    <-990,0,-1190>,<990,C_Height,-990>  
  }                         
}


#declare O_Plaque = 
  union {
    box {<-5,-10,-0.1>,<5,10,0.1>}  
    cylinder {<-5,-10,0>,<5,-10,0>,0.1}
    cylinder {<-5, 10,0>,<5, 10,0>,0.1}
    cylinder {<-5,-10,0>,<-5,10,0>,0.1}
    cylinder {< 5,-10,0>,<5,10,0>,0.1}
    sphere {<-5,-10,0>,0.1}
    sphere {<5,-10,0>,0.1}
    sphere {<-5,10,0>,0.1}
    sphere {<5,10,0>,0.1}
  } 

#declare R=0.75;
#declare O_Bonhomme = union {
  sphere {<0,6,0>,2}  //tte
  cylinder {<0,6,0>,<0,-4,0>,R} //cou
  cylinder {<-3,2,0>,<3,2,0>,R}//paules
  cylinder {<-3,2,0>,<-3,-2,0>,R}  //bras
  cylinder {< 3,2,0>,< 3,-2,0>,R}        
  sphere {<-3,2,0>,R}              //epaules
  sphere {<3,2,0>,R}                        
  sphere {<0,-4,0>,R}              //entrejambes
  cylinder {<0,0,0>,<0,-5,0>,R rotate 20*z translate -4*y}
  cylinder {<0,0,0>,<0,-5,0>,R rotate -20*z translate -4*y}
 
}








//mise en place des objets
object {O_Piece texture {T_Piece}}
object {O_Sol     
  texture {
    T_Sol3  
  }
  texture {                      
    T_Sol
  }            
  
}     

object {O_Colonnes texture {T_Colonne}}

#declare A_Porte=-70;
object {O_Porte texture {T_Porte scale 20 rotate <10,15,12>} rotate A_Porte*y translate <-75,0,-1000> }
object {O_PorteVitre texture {T_Vitre} interior { ior 1.5 } rotate A_Porte*y translate <-75,0,-1000>}

object {O_Piscine texture {T_Piscine}}
object {O_Banc texture {T_Banc}}
object {O_Fenetre texture {T_Fenetre}}

object {O_Eau}

object {O_DecoFen texture {T_DecoFen}}
object {O_Corridor texture {pigment {color rgb 0.5}}}
//object {O_Plafond texture {normal {bumps scale 1 bump_size 0.1} finish {reflection 0.25}}texture {T_Sol translate 500*y} }

#ifdef(USEMEDIA)
  #debug "using media\n"
  light_group {
    light_source {L_Soleil}
    object {O_Media}    
    global_lights off
  }
#end
object {
  O_DemiEchelle
  translate -25*x  
  translate -355*z
  rotate -30*y
  texture { 
    T_Chrome_5B   
  }
}
object {
  O_DemiEchelle
  translate 25*x  
  translate -355*z
  rotate -30*y
  texture { 
    T_Chrome_5B   
  }
}
  
#ifdef(WITHPEOPLE)
  #debug "including people ...\n"
  #debug "   victoria\n"
  #include "victoria piscine_pov.inc"
  object {Victoria_piscine 
    scale 170/0.75
    scale <-1,1,1>
    translate <10,0,-1000>
  } 
  #debug "   mic\n"
  #debug "      1\n"
  #include "c:\temp\mic1\mic1_pov.inc"
  object {Mic1 
    scale 170/0.75
    rotate 180*y
    translate -122*y
    translate 317*z
    rotate -30*y
  }

  #debug "      2\n"
  #include "c:\temp\mic2\mic2_pov.inc"
  object {
    mic2_
    //scale <-1,1,1>
    scale 190/0.75
    translate -400*z
    rotate -110*y
  }
  
  #debug "      3\n"
  #include "c:\temp\mic3\mic3_pov.inc"
  object {
    mic3_
    scale <-1,1,1>
    scale 185/0.75
    rotate 180*y
    translate 970*z
   
  }
  #debug "      5\n"
  #include "c:\temp\mic5\mic5_pov.inc"
  object {
    mic5_
    scale 185/0.75
    rotate 180*y
    translate -128*y
   
  }
/*  #include "c:\temp\mic6\mic6_pov.inc"
  object {
    mic6_
    scale 180/0.75
    rotate 135*y
    translate <-100,0,-850>
   
  }*/
  
#end
/*#declare MySphere = object {
  sphere {
    0,0.5  
  }  
} */
#undef WITHFRESQUE
#ifdef(DISCONNECTED)
  #declare MySphere = object {box{<-0.49,-0.49,0.1>,<0.49,0.49,0.1>}}
  #include "maketile.pov"
//  MakeTileFromImage2("fresque2.jpg",200,50,"MySphere","tiling.out","scale 10 translate 250*y+998*z")
  //MakeTileFromImage2("fresque5p.jpg",200,50,"MySphere","tiling.out","scale 10 translate C_Height*y/2+998*z")
  MakeTileFromImage2("fresque6p.jpg",200,C_Height/10,"MySphere","tiling.out","scale 10 translate C_Height*y/2+998*z")
  #include "tiling.out"
                     
                     
/////////////////////////////test de clipping sur la partie pri-fentre                     
  #declare O_BackWall = object { 
    difference {
      union {
        #include "tiling.out.ex"
      //scale 10
      //translate <0,250,0>
      }                       
      intersection {
        cylinder {
          <0,150,-1.5>,<0,150,1.5>,300
        }                             
        box {
          <-301,150,-2>,<301,451,2>  
        }
        translate 998*z
      }  
    }
  }
  object {
    O_BackWall
    //translate <0,0,998> 
    finish {
      reflection 0.2
      phong 0.5
      phong_size 150  
    }
  }
/////////////////////////////test de clipping sur la partie pri-fentre                     

#end


#ifdef(WITHFRESQUE)
  #declare MySphere = object {box{<-0.49,-0.49,0.1>,<0.49,0.49,0.1>}}
  #include "maketile.pov"
  MakeTileFromImage("fresque2.jpg",200,50,"MySphere","tiling.out")
  #declare O_BackWall = object { difference {
    union {
      #include "tiling.out"
      scale 10
      translate <0,250,0>
    }                       
    intersection {
      cylinder {
        <0,150,-1.5>,<0,150,1.5>,300
      }                             
      box {
        <-301,150,-2>,<301,451,2>  
      }
    }  
  }}
  #declare TESTFRESQUE=true;
#ifdef(TESTFRESQUE)
  object {
    O_BackWall
    translate <0,0,998> 
    finish {
      reflection 0.2
      phong 0.5
      phong_size 150  
    }
  clipped_by {
    box {
      <-1000,0,997>,<-300,500,1003>  
    } 
  }
  }  
  object {
    O_BackWall
    translate <0,0,998> 
    finish {
      reflection 0.2
      phong 0.5
      phong_size 150  
    }
  clipped_by {
    box {
      <300,0,997>,<1000,500,1003>  
    } 
  }
  }  
  object {
    O_BackWall
    translate <0,0,998> 
    finish {
      reflection 0.2
      phong 0.5
      phong_size 150  
    }
  clipped_by {
    box {
      <-300,0,997>,<300,500,1003>  
    } 
  }
  }  
#else
  object {
    O_BackWall
    translate <0,0,998> 
    finish {
      reflection 0.2
      phong 0.5
      phong_size 150  
    }
  }  
#end
#end

#ifdef(WITHHUMIDITY)
  #declare NbComp=1000;
  blob {   
    #declare i=0;
    #declare Rnd=seed(01312338);
    #while(i<NbComp)  
      #declare StartPoint=<rand(Rnd)*2000-1000,0,rand(Rnd)*2000-1000>;
      #if(vlength(StartPoint)>350)
        #declare j=0;
        #declare Mj=rand(Rnd)*NbComp;
        #while(j<Mj)
          sphere {
            #declare Dist=rand(Rnd)*15;
            #declare Angle=rand(Rnd)*360;
            <0,0,Dist>,2,1 scale <1,0.5,1> rotate Angle*y translate StartPoint 
            //StartPoint+rand(Rnd)*10*x+rand(Rnd)*10*z,1,1
          }                                               
        #declare j=j+1;
        #end //while
      #end //if
      #declare i=i+1;
    #end             
    threshold 0.1
    texture {
      T_EauClaire
    }
    interior {
       ior 4/3  
    }
    
  }
#end
#ifdef(WITHHUMIDITYPLANE1)
  plane {
    y,0.01
    texture {
      T_EauClaire  
    }            
    normal {
      bumps 
      bump_size 0.1 
      scale 100
    }
    interior {
      ior 4/3
      caustics 2  
    }
    clipped_by
    {
      box { -1000,1000}  
    }                  
  } 
#end
#ifdef(WITHHUMIDITYPLANE2)
  #declare GF= function {
    pigment {
      bumps       
      scale 25
      color_map{[0 rgb 0][1 rgb 1]}   
    }
  }                                                                         
  #debug "making ground height field\n"
  #declare HF=height_field { function 5000,5000 { GF(x*1000,y*1000,0).gray} water_level 0.0 smooth}
  #debug concat("min_extent = <", vstr(3,min_extent(HF),",",0,-1),">\n")
  #debug concat("max_extent = <", vstr(3,max_extent(HF),",",0,-1),">\n")
  #debug "done\n"
  #declare _HF=object {
    HF                
    translate <-0.5,-(max_extent(HF).y+min_extent(HF).y)/2,-0.5>
    scale <2000,1,2000>
    //translate <-1000,0,-1000>
  }
  object {
    difference {
      object {_HF}
      cylinder {
        <0,-1,0>,<0,5,0>,340
      }
    }
    texture {
      T_EauClaire  
    } 
    normal {
      bumps 
      bump_size 0.1 
      scale 100
    } 
      interior {
        ior 4/3
        caustics 2  
      }
      
    
  }            

  
#end

//  object {O_Bonhomme pigment {color Red} translate y}
//  object {O_Plaque texture {T_Plaque}}
difference {
  object {O_Plaque} 
  object {O_Bonhomme translate y}  
  texture {T_Plaque} 
  texture {T_Jupe}
  translate <47.5,100,-2>
  rotate A_Porte*y     
  translate <-75,0,-1000>
}

#ifdef(WITHTREE)                
  #debug "including tree\n"
  #include "c:\temp\povtree.inc"
  #debug concat("min_extent = <", vstr(3,min_extent(TREE),",",0,-1),">\n")
  #debug concat("max_extent = <", vstr(3,max_extent(TREE),",",0,-1),">\n")
  
  object {
    TREE
    scale 600
    translate 2000*z+200*x
  }
  #ifdef(MANYTREES)
    #declare i=0;
    #declare Rnd=seed(15);
    #while(i<10)
      object {
        
        TREE
        rotate rand(Rnd)*360*y
        scale rand(Rnd)*500+200
        translate <200,0,2000>+<(rand(Rnd)-0.5)*1000,0,(rand(Rnd)-0.5)*100>
      }                                             
      #declare i=i+1;
    #end
  #end
#end

