#include "tma_textures.inc"

///////////////// Stuhl /////////////////////////////////////////////////////////////////////////////////////

#declare Seite =
union{
//Sitzen
        cylinder{<-0.76,0,0>,<0.8,0,0>,0.03 rotate <0,0,-2>}
//Senkrechte 
        cylinder{<-1,-1.5,0>,<-1,-0.2,0>,0.03}
//Fuss
        difference{
                torus{15,0.03 rotate <-90,0,0> translate <0.125,-16.7,0>}
                plane{x,0 translate <-0.76,-1.7,0> rotate<0,0,2>}
                plane{-x,0 translate <1,-1.7,0> rotate<0,0,2>} translate <-0.06225,0,0>}
//Lehne
        difference{
                torus{10,0.03 rotate<-90,0,0> translate<10.966,1,0> rotate<0,0,-8>}                  
                plane{y,0 translate <0.9735,0.2,0>} 
                plane{-y,0 translate <1,2,0> rotate<0,0,-6>}}
//Verbindung Sitzen-Senkrechte
        difference{
                torus{0.25,0.03 rotate<-90,0,0> translate<-0.75,-0.225,0>}
                plane{-x,0 translate<-0.76,0.03,0>}   
                plane{y,0 translate<-1.01,-0.2,0>}}
//Verbindung Senkrechte-Fuss
        difference{
                torus{0.25,0.03 rotate<-90,0,0> translate<-0.75,-1.472,0>}
                plane{-x,0 translate<-0.76,-1.7,0>}
                plane{-y,0 translate<-1,-1.45,0>}}
//Verbindung Lehne
        difference{
                torus{0.25,0.03 rotate<-90,0,0> translate<0.775,0.224,0>}
                plane{x,0 translate<0.76,0.03,0>} 
                plane{-y,0 translate<1,0.23,0>}}} 

#declare ZweiSeiten =
        union{
                object{Seite translate<0,0,-1>} 
                object{Seite translate<0,0,1>}} 
                
#declare Verbindung =                
        union{                    
//Verbinungsmitte
                cylinder{<0,0,-0.75>,<0,0,0.75>,0.03 translate<1.25,-1.73,0> 
                rotate<0,90,0> rotate<-90,0,0> 
                translate<0,0,-1>}                
//die beiden runden Verbindungen                
                difference{                
                        torus{0.25,0.03 rotate<-90,0,0> translate<-0.6175,-0.831,0> 
                        translate<-0.13,-0.17,0.725>}
                        plane{-x,0 translate<-0.72,0,0>}
                        plane{-x,0 translate<-1,0,0> rotate<0,0,90>}}                    
                difference{                
                        torus{0.25,0.03 rotate<-90,0,0> translate<0.6175,-0.831,0> 
                        translate<0.13,-0.17,0.725>}
                        plane{x,0 translate<0.72,0,0>}
                        plane{-x,0 translate<-1,0,0> rotate<0,0,90>}}                     
                rotate<0,90,0> rotate<0,0,90> translate<0,-2.45,0>} 
                
#declare Stuhlgestell =
union{
        object{ZweiSeiten}
        object{Verbindung}
        texture{Chrom5E}}                
              
#declare Sitz =
        prism {
                cubic_spline
                15, 0, 17,
                <0,0>,<-10,1>,<-9,1.1>,<-6,1.9>,<0,2>,<6,1.9>,
                <9,1.1>,<10,1>,<10,0.8>,<9,0.9>,<6,1.7>,
                <0,1.8>,<-6,1.7>,<-9,0.9>,<-10,0.8>,<-10,1>,<0,0>
                scale 0.1 
                rotate<-270,0,0> translate<0,0.1,0> rotate<90,0,0> 
                translate<0.03,0.75,0.02> rotate<-2,0,0> rotate<-90,-90,0> 
                pigment{Stuhlstoff}}

#declare Lehne =
prism {
                cubic_spline
                40,1,21,
                <0,0>,<-20,1>,<-15,1.4><-10,1.65>,<-5,1.85>,
                <0,1.9>,<5,1.85>,<10,1.65><15,1.4>,<20,1>,
                <20,0>,<15,0.4>,<10,0.65><5,0.85>,<0,0.9>,
                <-5,0.85>,<-10,0.65>,<-15,0.4><-20,0>,<-20,1>,<0,0>
                scale <0.03,0.052,0.03> translate<0.03,-0.525,0> scale <1,1,0.5>
                translate<0,-0.55,0> rotate<0,0,90> rotate<0,-90,0>  
                rotate<0,0,-10> translate<1.17,1.2,0>
                pigment{Stuhlstoff}}
                
#declare Stuhl =
union{
        object{Stuhlgestell}
        object{Sitz}
        object{Lehne}}
        
/////////////// Tisch //////////////////////////////////////////////////////////////////////////////////////

#declare Gestellteil =
union{
//tragende Stange oben
        difference{
                cylinder{<-0.8,0,0>,<0.8,0,0>,0.03}
                plane{x,0 translate<-0.37,0,0>}  
                plane{-x,0 translate<0.37,0,0>}}
//Fsse
difference{
        cylinder{<-0.7045,-2.05,0>,<-0.7045,0,0>,0.03 rotate<0,0,-9>}
        plane{-y,0 translate<0,-0.44,0> rotate<0,0,-9>}}
difference{
        cylinder{<0.7045,0,0>,<0.7045,-2.05,0>,0.03 rotate<0,0,9>}
        plane{-y,0 translate<0,-0.44,0> rotate<0,0,9>}}
//Fsschen
cylinder {<-0.7045,-1.92,0>,<-0.7045,-1.898,0>,0.044 translate <-0.3079,0,0>} 
cylinder {< 0.7045,-1.92,0>,< 0.7045,-1.898,0>,0.044 translate < 0.3079,0,0>}
//runde Verbindungsstcke
difference{
        torus{0.4,0.03 rotate <-90,0,0> translate <-0.37,-0.4,0>} 
        plane{-x,0 translate<-0.37,0,0>}     
        plane{y,0 translate<-0.37,-0.44,0> rotate<0,0,-9>}}
difference{
        torus{0.4,0.03 rotate <-90,0,0> translate <0.37,-0.4,0>}
        plane{x,0 translate <0.37,0,0> } 
        plane{y,0 translate<0.37,-0.44,0> rotate<0,0,9>}}}
//ganzes Gestell

#declare Gestell =
union{
//2 Gestellteile
        object{Gestellteil translate<0,0,1.5>}
        object{Gestellteil translate<0,0,-1.5>}
//Querstangen
        cylinder{<0,0,-1.5>,<0,0,1.5>,0.03 translate<-0.36,0,0> }  
        cylinder{<0,0,-1.5>,<0,0,1.5>,0.03 translate< 0.36,0,0> }
        rotate<0,0,0> rotate<0,0,0>texture{Chrom5E}}
//Platte

#declare Platte =
superellipsoid {<0.05,0.05> scale<1.05,0.033,(144/89)*1.05> translate<0,0.065,0>
        pigment{Weiss}}

#declare Tisch =
union{
        object{Gestell}
        object{Platte}
        scale 1}

#declare Tischensemble =
union{
        object {Tisch scale 1.2 translate <0,0.295,0>}
        object {Stuhl rotate <0,2,0> scale 0.75 translate <1,-0.69,-0.9>} 
        object {Stuhl rotate <0,-2,0> scale 0.75 translate <1,-0.69,0.9>}     
        object {Stuhl rotate <0,3,0> scale 0.75 translate <1,-0.69,-0.9> rotate<0,180,0>} 
        object {Stuhl rotate <0,1,0> scale 0.75 translate <1,-0.69,0.9> rotate<0,180,0>}  
        rotate<0,45,0>}

/////////////// Rundtisch //////////////////////////////////////////////////////////////////////////////

#declare Rundtisch = sor {
  19,
  < 9   ,-2   >
  < 9   , 0   >
  < 8.75, 0.5 >
  < 6   , 0.51 >
  < 3.2 , 1   >
  < 1.6 , 2   >
  < 0.9 , 3   >
  < 0.5 , 5   >
  < 0.5 ,19   >
  < 0.6 ,21   >
  < 0.9 ,23   >
  < 1.4 ,25   >
  < 1.7 ,26   >
  < 2.3 ,27   >
  < 3.7 ,28 >  
  < 5.5,28.25>
  <19   ,28.5 >
  <19   ,29   >
  <19   ,31   >
  sturm
  pigment{Weiss}} 

#declare Rundtischensemble =
union{
        object{Rundtisch scale <1,1.1,1>*0.09 translate<0,-11.96,20>}
        object {Stuhl rotate <0,4,0> rotate<0, 40,0>  translate<2,-10.25,18.5>} 
        object {Stuhl rotate <0,-1,0> rotate<0,160,0> translate<-2.25,-10.25,19.25>} 
        object {Stuhl rotate <0,2,0> rotate<0,280,0> translate<0.5,-10.25,22>}}

///////////// Aschenbecher /////////////////////////////////////////////////////////////////////////// 

#declare Aschenbecher =
difference{
        cylinder{<0,-0.3,0>,<0,0.3,0>,1}
        cylinder{<0,-0.25,0>,<0,0.31,0>,0.85} 
        cylinder{<-1.1,0.3,0>,<1.1,0.3,0>,0.1} 
        cylinder{<0,0.3,-1.1>,<0,0.3,1.1>,0.1}scale 0.166 rotate<0,0,0>
        texture {Aschenbecherfarbe} translate<1.12,-10.15,-14.13>}        
        
       
